package xpath;

import org.w3c.dom.Node;

import parser.ASTIdentifier;
import parser.ASTStringLiteral;
import parser.SimpleNode;
import parser.XQueryParser;
import parser.XQueryParserTreeConstants;

import common.DOMPrinter;
import common.FunctionLib;
import common.ResultList;

public class XPathProcessor implements XQueryParserTreeConstants {

	ResultList result;

	public XPathProcessor(String xqfile) {
		SimpleNode root = XQueryParser.parse(xqfile);
		result = new ResultList();
		result = evaluate(root, result);
	}

	public ResultList getResults() {
		return result;
	}

	public ResultList evaluate(SimpleNode jjtNode, ResultList inResult) {

		ResultList outResult = new ResultList();

		switch (jjtNode.getId()) {

		case JJTSTART:
			outResult = evaluate((SimpleNode) jjtNode.jjtGetChild(0), inResult);
			break;

		case JJTAP:
			outResult = evaluateAP(jjtNode, inResult);
			break;

		default:
			System.out.println("Unknown AST node type: " + jjtNode.getId());
		}

		return outResult;
	}

	public ResultList evaluateAP(SimpleNode jjtNode, ResultList inResult) {

		ResultList outResult = new ResultList();

		switch (jjtNode.getId()) {

		case JJTAP:
			outResult = evaluateAP((SimpleNode) jjtNode.jjtGetChild(0),
					inResult);

			if (((SimpleNode) jjtNode.jjtGetChild(1)).getId() == JJTSLASH)
				outResult = evaluateRP((SimpleNode) jjtNode.jjtGetChild(2),
						outResult);

			break;

		case JJTDOCFILE:
			String xqfile = ((ASTStringLiteral) jjtNode.jjtGetChild(0))
					.toString();

			outResult.add(FunctionLib.root(xqfile));

			break;

		default:
			System.out.println("Unknown AST node type: " + jjtNode.getId());
		}

		return outResult;
	}

	public ResultList evaluateRP(SimpleNode jjtNode, ResultList inResult) {

		ResultList outResult = new ResultList();

		switch (jjtNode.getId()) {

		case JJTTAGNAME:
			Node xmlNode;
			Node xmlChild;
			ResultList temp;

			String elmName = ((ASTIdentifier) jjtNode.jjtGetChild(0))
					.toString();
			for (int i = 0; i < inResult.getLength(); i++) {
				xmlNode = inResult.get(i);
				temp = FunctionLib.children(xmlNode);
				for (int j = 0; j < temp.getLength(); j++) {
					xmlChild = temp.get(j);
					if (FunctionLib.tag(xmlChild).equals(elmName))
						outResult.add(xmlChild);
				}
			}

			break;

		default:
			System.out.println("Unknown AST node type: " + jjtNode.getId());
		}

		return outResult;
	}

	public static void main(String args[]) {
		XPathProcessor proc = new XPathProcessor(args[0]);
		ResultList result = proc.getResults();
		try {
			for (int i = 0; i < result.getLength(); i++)
				System.out.print(DOMPrinter.printXML(result.get(i)));
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
