/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava;

import edu.rice.cs.drjava.DrJavaRoot;
import edu.rice.cs.drjava.RemoteControlClient;
import edu.rice.cs.drjava.config.FileConfiguration;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.drjava.ui.SplashScreen;
import edu.rice.cs.util.ArgumentTokenizer;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.newjvm.ExecJVM;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;

public class DrJava {
    private static volatile Log _log = new Log("DrJava.txt", false);
    private static final String DEFAULT_MAX_HEAP_SIZE_ARG = "-Xmx128M";
    private static final ArrayList<String> _filesToOpen = new ArrayList();
    private static final ArrayList<String> _jvmArgs = new ArrayList();
    static volatile boolean _showDebugConsole = false;
    static volatile boolean _forceNewInstance = false;
    private static final int WAIT_BEFORE_DECLARING_SUCCESS = 5000;
    public static final File DEFAULT_PROPERTIES_FILE;
    private static volatile File _propertiesFile;
    private static volatile FileConfiguration _config;

    public static File getPropertiesFile() {
        return _propertiesFile;
    }

    public static FileConfiguration getConfig() {
        return _config;
    }

    public static String[] getFilesToOpen() {
        return _filesToOpen.toArray(new String[0]);
    }

    public static boolean getShowDebugConsole() {
        return _showDebugConsole;
    }

    public static void main(String[] args) {
        if (DrJava.handleCommandLineArgs(args)) {
            PlatformFactory.ONLY.beforeUISetup();
            if (!_forceNewInstance && DrJava.getConfig().getSetting(OptionConstants.REMOTE_CONTROL_ENABLED).booleanValue() && _filesToOpen.size() > 0) {
                if (!RemoteControlClient.isServerRunning()) {
                    new SplashScreen().flash();
                }
            } else {
                new SplashScreen().flash();
            }
            DrJava.configureAndLoadDrJavaRoot(args);
        }
    }

    public static void configureAndLoadDrJavaRoot(String[] args) {
        try {
            if (!_forceNewInstance && DrJava.getConfig().getSetting(OptionConstants.REMOTE_CONTROL_ENABLED).booleanValue() && _filesToOpen.size() > 0) {
                try {
                    RemoteControlClient.openFile(null);
                    if (RemoteControlClient.isServerRunning()) {
                        for (int i = 0; i < _filesToOpen.size(); ++i) {
                            RemoteControlClient.openFile(new File(_filesToOpen.get(i)));
                        }
                        System.exit(0);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            for (int failCount = 0; failCount < 2; ++failCount) {
                boolean restart = DrJava.getConfig().getSetting(OptionConstants.MASTER_JVM_ARGS).length() > 0 || !"".equals(DrJava.getConfig().getSetting(OptionConstants.MASTER_JVM_XMX).trim()) && !OptionConstants.heapSizeChoices.get(0).equals(DrJava.getConfig().getSetting(OptionConstants.MASTER_JVM_XMX).trim());
                LinkedList<String> classArgsList = new LinkedList<String>();
                classArgsList.addAll(_filesToOpen);
                if (_showDebugConsole) {
                    classArgsList.addFirst("-debugConsole");
                }
                if (!_propertiesFile.equals(DEFAULT_PROPERTIES_FILE)) {
                    classArgsList.addFirst(_propertiesFile.getAbsolutePath());
                    classArgsList.addFirst("-config");
                }
                String[] classArgs = classArgsList.toArray(new String[0]);
                if (restart) {
                    String classPath = System.getProperty("java.class.path");
                    try {
                        Process p = ExecJVM.runJVM("edu.rice.cs.drjava.DrJavaRoot", classArgs, classPath, _jvmArgs.toArray(new String[0]), null);
                        final Thread mainThread = Thread.currentThread();
                        Thread sleepThread = new Thread(new Runnable(){

                            public void run() {
                                try {
                                    Thread.sleep(5000L);
                                    mainThread.interrupt();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        });
                        sleepThread.setDaemon(true);
                        sleepThread.start();
                        try {
                            p.waitFor();
                            sleepThread.interrupt();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        try {
                            if (p.exitValue() == 0) break;
                            if (failCount > 0) {
                                JOptionPane.showMessageDialog(null, "DrJava was unable to start, and resetting your configuration\ndid not help. Please file a support request at\nhttps://sourceforge.net/projects/drjava/", "Could Not Start DrJava", 0);
                                System.exit(0);
                                break;
                            }
                            int result = JOptionPane.showConfirmDialog(null, "DrJava was unable to start. Your configuration file (.drjava)\nmight be corrupt. Do you want to reset your configuration?", "Could Not Start DrJava", 0);
                            if (result != 0) {
                                System.exit(0);
                            }
                            DrJava.getConfig().resetToDefaults();
                            DrJava.getConfig().saveConfiguration();
                            if (DrJava.handleCommandLineArgs(args)) continue;
                            System.exit(0);
                            continue;
                        }
                        catch (IllegalThreadStateException e) {
                        }
                    }
                    catch (IOException ioe) {
                        String[] text = new String[]{"DrJava was unable to load its compiler and debugger.  Would you ", "like to start DrJava without a compiler and debugger?", "\nReason: " + ioe.toString()};
                        int result = JOptionPane.showConfirmDialog(null, text, "Could Not Load Compiler and Debugger", 0);
                        if (result != 0) {
                            System.exit(0);
                        }
                        break;
                    }
                }
                DrJavaRoot.main(classArgs);
                break;
            }
        }
        catch (Throwable t) {
            System.out.println(t.getClass().getName() + ": " + t.getMessage());
            t.printStackTrace(System.err);
            System.out.println("error thrown");
            new DrJavaErrorHandler().handle(t);
        }
    }

    static boolean handleCommandLineArgs(String[] args) {
        String iconLoc;
        boolean heapSizeGiven = false;
        int argIndex = 0;
        int len = args.length;
        _filesToOpen.clear();
        while (argIndex < len) {
            String arg;
            if ((arg = args[argIndex++]).equals("-config")) {
                if (len == argIndex) {
                    return true;
                }
                DrJava.setPropertiesFile(args[argIndex++]);
                _config = DrJava._initConfig();
                continue;
            }
            if (arg.startsWith("-X") || arg.startsWith("-D")) {
                if (arg.startsWith("-Xmx")) {
                    heapSizeGiven = true;
                }
                _jvmArgs.add(arg);
                continue;
            }
            if (arg.equals("-debugConsole")) {
                _showDebugConsole = true;
                continue;
            }
            if (arg.equals("-new")) {
                _forceNewInstance = true;
                continue;
            }
            if (arg.equals("-help") || arg.equals("-?")) {
                DrJava.displayUsage();
                return false;
            }
            --argIndex;
            break;
        }
        if (!"".equals(DrJava.getConfig().getSetting(OptionConstants.MASTER_JVM_XMX)) && !OptionConstants.heapSizeChoices.get(0).equals(DrJava.getConfig().getSetting(OptionConstants.MASTER_JVM_XMX))) {
            _jvmArgs.add("-Xmx" + DrJava.getConfig().getSetting(OptionConstants.MASTER_JVM_XMX).trim() + "M");
            heapSizeGiven = true;
        }
        List<String> configArgs = ArgumentTokenizer.tokenize(DrJava.getConfig().getSetting(OptionConstants.MASTER_JVM_ARGS));
        for (String arg : configArgs) {
            if (arg.startsWith("-Xmx")) {
                heapSizeGiven = true;
            }
            _jvmArgs.add(arg);
        }
        if (PlatformFactory.ONLY.isMacPlatform() && (iconLoc = System.getProperty("edu.rice.cs.drjava.icon")) != null) {
            _jvmArgs.add("-Xdock:name=DrJava");
            _jvmArgs.add("-Xdock:icon=" + iconLoc);
        }
        if (!heapSizeGiven) {
            _jvmArgs.add(DEFAULT_MAX_HEAP_SIZE_ARG);
        }
        _log.log("_jvmArgs = " + _jvmArgs);
        for (int i = argIndex; i < len; ++i) {
            _filesToOpen.add(args[i]);
        }
        return true;
    }

    static void displayUsage() {
        System.out.println("Usage: java -jar drjava.jar [OPTIONS] [FILES]\n");
        System.out.println("where options include:");
        System.out.println("  -config [FILE]        use a custom config file");
        System.out.println("  -new                  force the creation of a new DrJava instance;");
        System.out.println("                        do not connect to existing instance");
        System.out.println("  -help | -?            print this help message");
        System.out.println("  -X<jvmOption>         specify a JVM configuration option for the master DrJava JVM");
        System.out.println("  -D<name>[=<value>]    set a Java property for the master DrJava JVM");
    }

    static void setPropertiesFile(String fileName) {
        if (!fileName.endsWith(".java")) {
            _propertiesFile = new File(fileName);
        }
    }

    static FileConfiguration _initConfig() throws IllegalStateException {
        File propFile = _propertiesFile;
        try {
            propFile.createNewFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        FileConfiguration config = new FileConfiguration(propFile);
        try {
            config.loadConfiguration();
        }
        catch (Exception e) {
            config.resetToDefaults();
            config.storeStartupException(e);
        }
        _config = config;
        return config;
    }

    protected static void _saveConfig() {
        try {
            DrJava.getConfig().saveConfiguration();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Could not save the location of tools.jar in \nthe '.drjava' file in your home directory. \nAnother process may be using the file.\n\n" + e, "Could Not Save Changes", 0);
            DrJavaErrorHandler.record(new UnexpectedException(e, "Could not save the location of tools.jar in \nthe '.drjava' file in your home directory. \nAnother process may be using the file.\n\n"));
        }
    }

    public static void cleanUp() {
        _filesToOpen.clear();
        _jvmArgs.clear();
    }

    static {
        _propertiesFile = DEFAULT_PROPERTIES_FILE = new File(System.getProperty("user.home"), ".drjava");
        _config = DrJava._initConfig();
    }
}

