/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.DrJavaRoot;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.AlreadyOpenException;
import edu.rice.cs.drjava.model.BrowserDocumentRegion;
import edu.rice.cs.drjava.model.BrowserHistoryManager;
import edu.rice.cs.drjava.model.ClipboardHistoryModel;
import edu.rice.cs.drjava.model.ConcreteRegionManager;
import edu.rice.cs.drjava.model.FileGroupingState;
import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.model.FileRegion;
import edu.rice.cs.drjava.model.FileSaveSelector;
import edu.rice.cs.drjava.model.FinalizationListener;
import edu.rice.cs.drjava.model.GlobalEventNotifier;
import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.drjava.model.GlobalModelListener;
import edu.rice.cs.drjava.model.MovingDocumentRegion;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.RegionManager;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.model.cache.DCacheAdapter;
import edu.rice.cs.drjava.model.cache.DDReconstructor;
import edu.rice.cs.drjava.model.cache.DocumentCache;
import edu.rice.cs.drjava.model.compiler.CompilerModel;
import edu.rice.cs.drjava.model.debug.Breakpoint;
import edu.rice.cs.drjava.model.debug.DebugBreakpointData;
import edu.rice.cs.drjava.model.debug.DebugException;
import edu.rice.cs.drjava.model.debug.DebugWatchData;
import edu.rice.cs.drjava.model.debug.Debugger;
import edu.rice.cs.drjava.model.debug.NoDebuggerAvailable;
import edu.rice.cs.drjava.model.definitions.ClassNameNotFoundException;
import edu.rice.cs.drjava.model.definitions.CompoundUndoManager;
import edu.rice.cs.drjava.model.definitions.DefinitionsDocument;
import edu.rice.cs.drjava.model.definitions.DefinitionsEditorKit;
import edu.rice.cs.drjava.model.definitions.DocumentUIListener;
import edu.rice.cs.drjava.model.definitions.InvalidPackageException;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.drjava.model.definitions.reducedmodel.HighlightStatus;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelControl;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.drjava.model.javadoc.JavadocModel;
import edu.rice.cs.drjava.model.junit.JUnitModel;
import edu.rice.cs.drjava.model.print.DrJavaBook;
import edu.rice.cs.drjava.model.repl.DefaultInteractionsModel;
import edu.rice.cs.drjava.model.repl.InteractionsDJDocument;
import edu.rice.cs.drjava.model.repl.InteractionsDocument;
import edu.rice.cs.drjava.model.repl.InteractionsScriptModel;
import edu.rice.cs.drjava.project.DocFile;
import edu.rice.cs.drjava.project.DocumentInfoGetter;
import edu.rice.cs.drjava.project.MalformedProjectFileException;
import edu.rice.cs.drjava.project.ProjectFileIR;
import edu.rice.cs.drjava.project.ProjectFileParserFacade;
import edu.rice.cs.drjava.project.ProjectProfile;
import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.FileOpenSelector;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.NullFile;
import edu.rice.cs.util.OperationCanceledException;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.docnavigation.AWTContainerNavigatorFactory;
import edu.rice.cs.util.docnavigation.IDocumentNavigator;
import edu.rice.cs.util.docnavigation.INavigationListener;
import edu.rice.cs.util.docnavigation.INavigatorItem;
import edu.rice.cs.util.docnavigation.INavigatorItemFilter;
import edu.rice.cs.util.docnavigation.JTreeSortNavigator;
import edu.rice.cs.util.docnavigation.NodeData;
import edu.rice.cs.util.docnavigation.NodeDataVisitor;
import edu.rice.cs.util.swing.AsyncCompletionArgs;
import edu.rice.cs.util.swing.AsyncTask;
import edu.rice.cs.util.swing.DocumentIterator;
import edu.rice.cs.util.swing.IAsyncProgress;
import edu.rice.cs.util.swing.Utilities;
import edu.rice.cs.util.text.AbstractDocumentInterface;
import edu.rice.cs.util.text.ConsoleDocument;
import java.awt.Color;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.ProgressMonitor;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.Style;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractGlobalModel
implements SingleDisplayModel,
OptionConstants,
DocumentIterator {
    public static final Log _log = new Log("GlobalModel.txt", false);
    public static final int DIFF_THRESHOLD = 5;
    protected DocumentCache _cache;
    static final String DOCUMENT_OUT_OF_SYNC_MSG = "Current document is out of sync with the Interactions Pane and should be recompiled!\n";
    static final String CLASSPATH_OUT_OF_SYNC_MSG = "Interactions Pane is out of sync with the current classpath and should be reset!\n";
    public final GlobalEventNotifier _notifier = new GlobalEventNotifier();
    protected final DefinitionsEditorKit _editorKit = new DefinitionsEditorKit(this._notifier);
    private final AbstractMap<File, OpenDefinitionsDocument> _documentsRepos = new LinkedHashMap<File, OpenDefinitionsDocument>();
    protected final ConsoleDocument _consoleDoc;
    protected final InteractionsDJDocument _consoleDocAdapter;
    public static final int WRITE_DELAY = 50;
    protected volatile PageFormat _pageFormat = new PageFormat();
    private volatile OpenDefinitionsDocument _activeDocument;
    private volatile File _activeDirectory;
    private volatile boolean classPathChanged = false;
    protected volatile IDocumentNavigator<OpenDefinitionsDocument> _documentNavigator = new AWTContainerNavigatorFactory().makeListNavigator();
    protected final ConcreteRegionManager<Breakpoint> _breakpointManager;
    protected final ConcreteRegionManager<MovingDocumentRegion> _bookmarkManager;
    protected final LinkedList<RegionManager<MovingDocumentRegion>> _findResultsManagers;
    protected final BrowserHistoryManager _browserHistoryManager;
    protected volatile FileGroupingState _state;

    @Override
    public void addAuxiliaryFile(OpenDefinitionsDocument doc) {
        this._state.addAuxFile(doc.getRawFile());
    }

    @Override
    public void removeAuxiliaryFile(OpenDefinitionsDocument doc) {
        this._state.remAuxFile(doc.getRawFile());
    }

    @Override
    public GlobalEventNotifier getNotifier() {
        return this._notifier;
    }

    @Override
    public RegionManager<Breakpoint> getBreakpointManager() {
        return this._breakpointManager;
    }

    @Override
    public RegionManager<MovingDocumentRegion> getBookmarkManager() {
        return this._bookmarkManager;
    }

    public List<RegionManager<MovingDocumentRegion>> getFindResultsManagers() {
        return new LinkedList<RegionManager<MovingDocumentRegion>>(this._findResultsManagers);
    }

    @Override
    public RegionManager<MovingDocumentRegion> createFindResultsManager() {
        ConcreteRegionManager<MovingDocumentRegion> rm = new ConcreteRegionManager<MovingDocumentRegion>();
        this._findResultsManagers.add(rm);
        return rm;
    }

    @Override
    public void removeFindResultsManager(RegionManager<MovingDocumentRegion> rm) {
        this._findResultsManagers.remove(rm);
    }

    @Override
    public BrowserHistoryManager getBrowserHistoryManager() {
        return this._browserHistoryManager;
    }

    public AbstractGlobalModel() {
        this._cache = new DocumentCache();
        this._consoleDocAdapter = new InteractionsDJDocument();
        this._consoleDoc = new ConsoleDocument(this._consoleDocAdapter);
        this._bookmarkManager = new ConcreteRegionManager();
        this._findResultsManagers = new LinkedList();
        this._browserHistoryManager = new BrowserHistoryManager();
        this._breakpointManager = new ConcreteRegionManager();
        this._registerOptionListeners();
        this.setFileGroupingState(this.makeFlatFileGroupingState());
        Utilities.invokeLater(new Runnable(){

            public void run() {
                AbstractGlobalModel.this._notifier.projectRunnableChanged();
            }
        });
        this._init();
    }

    private void _init() {
        final NodeDataVisitor<OpenDefinitionsDocument, Boolean> _gainVisitor = new NodeDataVisitor<OpenDefinitionsDocument, Boolean>(){

            @Override
            public Boolean itemCase(OpenDefinitionsDocument doc, Object ... p) {
                AbstractGlobalModel.this._setActiveDoc(doc);
                File oldDir = AbstractGlobalModel.this._activeDirectory;
                File dir = doc.getParentDirectory();
                if (dir != null && !dir.equals(oldDir)) {
                    AbstractGlobalModel.this._activeDirectory = dir;
                    AbstractGlobalModel.this._notifier.currentDirectoryChanged(AbstractGlobalModel.this._activeDirectory);
                }
                return true;
            }

            @Override
            public Boolean fileCase(File f, Object ... p) {
                if (!f.isAbsolute()) {
                    File root = AbstractGlobalModel.this._state.getProjectFile().getParentFile().getAbsoluteFile();
                    f = new File(root, f.getPath());
                }
                AbstractGlobalModel.this._activeDirectory = f;
                AbstractGlobalModel.this._notifier.currentDirectoryChanged(f);
                return true;
            }

            @Override
            public Boolean stringCase(String s, Object ... p) {
                return false;
            }
        };
        this._documentNavigator.addNavigationListener(new INavigationListener<OpenDefinitionsDocument>(){

            @Override
            public void gainedSelection(NodeData<? extends OpenDefinitionsDocument> dat, boolean modelInitiated) {
                dat.execute(_gainVisitor, modelInitiated);
            }

            @Override
            public void lostSelection(NodeData<? extends OpenDefinitionsDocument> dat, boolean modelInitiated) {
            }
        });
        this._documentNavigator.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                Utilities.invokeLater(new Runnable(){

                    public void run() {
                        AbstractGlobalModel.this._notifier.focusOnDefinitionsPane();
                    }
                });
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this._ensureNotEmpty();
        this.setActiveFirstDocument();
        OptionListener<Integer> clipboardHistorySizeListener = new OptionListener<Integer>(){

            @Override
            public void optionChanged(OptionEvent<Integer> oce) {
                ClipboardHistoryModel.singleton().resize((Integer)oce.value);
            }
        };
        DrJava.getConfig().addOptionListener(CLIPBOARD_HISTORY_SIZE, clipboardHistorySizeListener);
        ClipboardHistoryModel.singleton().resize(DrJava.getConfig().getSetting(CLIPBOARD_HISTORY_SIZE));
        OptionListener<Integer> browserHistoryMaxSizeListener = new OptionListener<Integer>(){

            @Override
            public void optionChanged(OptionEvent<Integer> oce) {
                AbstractGlobalModel.this.getBrowserHistoryManager().setMaximumSize((Integer)oce.value);
            }
        };
        DrJava.getConfig().addOptionListener(BROWSER_HISTORY_MAX_SIZE, browserHistoryMaxSizeListener);
        this.getBrowserHistoryManager().setMaximumSize(DrJava.getConfig().getSetting(BROWSER_HISTORY_MAX_SIZE));
    }

    public void setFileGroupingState(FileGroupingState state) {
        this._state = state;
        this._notifier.projectRunnableChanged();
        this._notifier.projectBuildDirChanged();
        this._notifier.projectWorkDirChanged();
    }

    protected FileGroupingState makeProjectFileGroupingState(File pr, File main, File bd, File wd, File project, File[] srcFiles, File[] auxFiles, File[] excludedFiles, Iterable<File> cp, File cjf, int cjflags, boolean refresh) {
        return new ProjectFileGroupingState(pr, main, bd, wd, project, srcFiles, auxFiles, excludedFiles, cp, cjf, cjflags, refresh);
    }

    public boolean isClassPathChanged() {
        return this.classPathChanged;
    }

    public void setClassPathChanged(boolean changed) {
        this.classPathChanged = changed;
    }

    @Override
    public void setProjectChanged(boolean changed) {
        this._state.setProjectChanged(changed);
    }

    @Override
    public boolean isProjectChanged() {
        return this._state.isProjectChanged();
    }

    @Override
    public boolean isProjectActive() {
        return this._state.isProjectActive();
    }

    @Override
    public File getProjectFile() {
        return this._state.getProjectFile();
    }

    @Override
    public File[] getProjectFiles() {
        return this._state.getProjectFiles();
    }

    @Override
    public boolean inProject(File f) {
        return this._state.inProject(f);
    }

    @Override
    public boolean inProjectPath(OpenDefinitionsDocument doc) {
        return this._state.inProjectPath(doc);
    }

    @Override
    public void setMainClass(File f) {
        this._state.setMainClass(f);
        this._notifier.projectRunnableChanged();
        this.setProjectChanged(true);
    }

    @Override
    public File getMainClass() {
        return this._state.getMainClass();
    }

    @Override
    public void setCreateJarFile(File f) {
        this._state.setCreateJarFile(f);
        this.setProjectChanged(true);
    }

    @Override
    public File getCreateJarFile() {
        return this._state.getCreateJarFile();
    }

    @Override
    public void setCreateJarFlags(int f) {
        this._state.setCreateJarFlags(f);
        this.setProjectChanged(true);
    }

    @Override
    public int getCreateJarFlags() {
        return this._state.getCreateJarFlags();
    }

    @Override
    public File getProjectRoot() {
        return this._state.getProjectRoot();
    }

    @Override
    public void setProjectRoot(File f) {
        this._state.setProjectRoot(f);
        this.setProjectChanged(true);
    }

    @Override
    public void setProjectFile(File f) {
        this._state.setProjectFile(f);
    }

    @Override
    public File getBuildDirectory() {
        return this._state.getBuildDirectory();
    }

    @Override
    public void setBuildDirectory(File f) {
        this._state.setBuildDirectory(f);
        this._notifier.projectBuildDirChanged();
        this.setProjectChanged(true);
    }

    @Override
    public boolean getAutoRefreshStatus() {
        return this._state.getAutoRefreshStatus();
    }

    @Override
    public void setAutoRefreshStatus(boolean status) {
        this._state.setAutoRefreshStatus(status);
    }

    @Override
    public File getMasterWorkingDirectory() {
        File file;
        try {
            file = FileOps.getValidDirectory(DrJava.getConfig().getSetting(LAST_DIRECTORY));
        }
        catch (RuntimeException e) {
            DrJava.getConfig().setSetting(LAST_DIRECTORY, FileOps.NULL_FILE);
            file = FileOps.getValidDirectory(new File(System.getProperty("user.home", ".")));
        }
        DrJava.getConfig().setSetting(LAST_DIRECTORY, file);
        return file;
    }

    @Override
    public File getWorkingDirectory() {
        return this._state.getWorkingDirectory();
    }

    @Override
    public void setWorkingDirectory(File f) {
        this._state.setWorkingDirectory(f);
        this._notifier.projectWorkDirChanged();
        this.setProjectChanged(true);
        DrJava.getConfig().setSetting(LAST_INTERACTIONS_DIRECTORY, this._state.getWorkingDirectory());
    }

    @Override
    public void cleanBuildDirectory() {
        this._state.cleanBuildDirectory();
    }

    @Override
    public List<File> getClassFiles() {
        return this._state.getClassFiles();
    }

    protected static String getPackageName(String classname) {
        int index = classname.lastIndexOf(".");
        if (index != -1) {
            return classname.substring(0, index);
        }
        return "";
    }

    protected FileGroupingState makeFlatFileGroupingState() {
        return new FlatFileGroupingState();
    }

    @Override
    public String getSourceBinTitle() {
        return "[ Source Files ]";
    }

    @Override
    public String getExternalBinTitle() {
        return "[ External Files ]";
    }

    @Override
    public String getAuxiliaryBinTitle() {
        return "[ Included External Files ]";
    }

    @Override
    public void addListener(GlobalModelListener listener) {
        this._notifier.addListener(listener);
    }

    @Override
    public void removeListener(GlobalModelListener listener) {
        this._notifier.removeListener(listener);
    }

    @Override
    public DefinitionsEditorKit getEditorKit() {
        return this._editorKit;
    }

    @Override
    public DefaultInteractionsModel getInteractionsModel() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interaction");
    }

    @Override
    public InteractionsDJDocument getSwingInteractionsDocument() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interaction");
    }

    @Override
    public InteractionsDocument getInteractionsDocument() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interaction");
    }

    @Override
    public ConsoleDocument getConsoleDocument() {
        return this._consoleDoc;
    }

    @Override
    public InteractionsDJDocument getSwingConsoleDocument() {
        return this._consoleDocAdapter;
    }

    @Override
    public PageFormat getPageFormat() {
        return this._pageFormat;
    }

    @Override
    public void setPageFormat(PageFormat format) {
        this._pageFormat = format;
    }

    @Override
    public CompilerModel getCompilerModel() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support compilation");
    }

    @Override
    public int getNumCompErrors() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support compilation");
    }

    @Override
    public void setNumCompErrors(int num) {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support compilation");
    }

    @Override
    public JUnitModel getJUnitModel() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support unit testing");
    }

    @Override
    public JavadocModel getJavadocModel() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support javadoc");
    }

    @Override
    public IDocumentNavigator<OpenDefinitionsDocument> getDocumentNavigator() {
        return this._documentNavigator;
    }

    @Override
    public void setDocumentNavigator(IDocumentNavigator<OpenDefinitionsDocument> newnav) {
        this._documentNavigator = newnav;
    }

    public void toggleBookmark(int pos1, int pos2) {
        this._toggleBookmark(pos1, pos2);
    }

    public void _toggleBookmark(int pos1, int pos2) {
        Collection conflictingRegions;
        assert (EventQueue.isDispatchThread());
        OpenDefinitionsDocument doc = this.getActiveDocument();
        int startSel = Math.min(pos1, pos2);
        int endSel = Math.max(pos1, pos2);
        ConcreteRegionManager<MovingDocumentRegion> bm = this._bookmarkManager;
        if (startSel == endSel) {
            endSel = doc._getLineEndPos(startSel);
            startSel = doc._getLineStartPos(startSel);
        }
        if ((conflictingRegions = bm.getRegionsOverlapping(doc, startSel, endSel)).size() > 0) {
            for (MovingDocumentRegion cr : conflictingRegions) {
                bm.removeRegion(cr);
            }
        } else {
            MovingDocumentRegion newR = new MovingDocumentRegion(doc, startSel, endSel, doc._getLineStartPos(startSel), doc._getLineEndPos(endSel));
            bm.addRegion(newR);
        }
    }

    public OpenDefinitionsDocument newFile(File parentDir) {
        ConcreteOpenDefDoc doc = this._createOpenDefinitionsDocument(new NullFile());
        doc.setParentDirectory(parentDir);
        this.addDocToNavigator(doc);
        this._notifier.newFileCreated(doc);
        return doc;
    }

    @Override
    public OpenDefinitionsDocument newFile() {
        File dir = this._activeDirectory;
        if (dir == null) {
            dir = this.getMasterWorkingDirectory();
        }
        OpenDefinitionsDocument doc = this.newFile(dir);
        this.setActiveDocument(doc);
        return doc;
    }

    @Override
    public OpenDefinitionsDocument newTestCase(String name, boolean makeSetUp, boolean makeTearDown) {
        boolean elementary = DrJava.getConfig().getSetting(LANGUAGE_LEVEL) == 1;
        StringBuilder buf = new StringBuilder();
        if (!elementary) {
            buf.append("import junit.framework.TestCase;\n\n");
        }
        buf.append("/**\n");
        buf.append("* A JUnit test case class.\n");
        buf.append("* Every method starting with the word \"test\" will be called when running\n");
        buf.append("* the test with JUnit.\n");
        buf.append("*/\n");
        if (!elementary) {
            buf.append("public ");
        }
        buf.append("class ");
        buf.append(name);
        buf.append(" extends TestCase {\n\n");
        if (makeSetUp) {
            buf.append("/**\n");
            buf.append("* This method is called before each test method, to perform any common\n");
            buf.append("* setup if necessary.\n");
            buf.append("*/\n");
            if (!elementary) {
                buf.append("public ");
            }
            buf.append("void setUp() throws Exception {\n}\n\n");
        }
        if (makeTearDown) {
            buf.append("/**\n");
            buf.append("* This method is called after each test method, to perform any common\n");
            buf.append("* clean-up if necessary.\n");
            buf.append("*/\n");
            if (!elementary) {
                buf.append("public ");
            }
            buf.append("void tearDown() throws Exception {\n}\n\n");
        }
        buf.append("/**\n");
        buf.append("* A test method.\n");
        buf.append("* (Replace \"X\" with a name describing the test.  You may write as\n");
        buf.append("* many \"testSomething\" methods in this class as you wish, and each\n");
        buf.append("* one will be called when running JUnit over this class.)\n");
        buf.append("*/\n");
        if (!elementary) {
            buf.append("public ");
        }
        buf.append("void testX() {\n}\n\n");
        buf.append("}\n");
        String test = buf.toString();
        OpenDefinitionsDocument openDoc = this.newFile();
        try {
            openDoc.insertString(0, test, null);
            openDoc.indentLines(0, test.length());
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
        return openDoc;
    }

    public DocumentCache getDocumentCache() {
        return this._cache;
    }

    @Override
    public OpenDefinitionsDocument openFile(FileOpenSelector com) throws IOException, OperationCanceledException, AlreadyOpenException {
        boolean closeUntitled = this._hasOneEmptyDocument();
        if (!closeUntitled) {
            this.addToBrowserHistory();
        }
        OpenDefinitionsDocument oldDoc = this._activeDocument;
        OpenDefinitionsDocument openedDoc = this.openFileHelper(com);
        if (closeUntitled) {
            this.closeFileHelper(oldDoc);
        }
        this.setActiveDocument(openedDoc);
        this.setProjectChanged(true);
        return openedDoc;
    }

    protected OpenDefinitionsDocument openFileHelper(FileOpenSelector com) throws IOException, OperationCanceledException, AlreadyOpenException {
        File file = com.getFiles()[0].getCanonicalFile();
        OpenDefinitionsDocument odd = this._openFile(file);
        this.addDocToClassPath(odd);
        this.setClassPathChanged(true);
        return odd;
    }

    @Override
    public OpenDefinitionsDocument[] openFiles(FileOpenSelector com) throws IOException, OperationCanceledException, AlreadyOpenException {
        boolean closeUntitled = this._hasOneEmptyDocument();
        if (!closeUntitled) {
            this.addToBrowserHistory();
        }
        OpenDefinitionsDocument oldDoc = this._activeDocument;
        OpenDefinitionsDocument[] openedDocs = this.openFilesHelper(com);
        if (openedDocs.length > 0) {
            if (closeUntitled) {
                this.closeFileHelper(oldDoc);
            }
            this.setActiveDocument(openedDocs[0]);
        }
        return openedDocs;
    }

    protected OpenDefinitionsDocument[] openFilesHelper(FileOpenSelector com) throws IOException, OperationCanceledException, AlreadyOpenException {
        File[] files = com.getFiles();
        if (files == null) {
            throw new IOException("No Files returned from FileSelector");
        }
        OpenDefinitionsDocument[] docs = this._openFiles(files);
        return docs;
    }

    private OpenDefinitionsDocument[] _openFiles(File[] files) throws IOException, OperationCanceledException, AlreadyOpenException {
        ArrayList<OpenDefinitionsDocument> alreadyOpenDocuments = new ArrayList<OpenDefinitionsDocument>();
        ArrayList<OpenDefinitionsDocument> retDocs = new ArrayList<OpenDefinitionsDocument>();
        LinkedList<File> filesNotFound = new LinkedList<File>();
        LinkedList<OpenDefinitionsDocument> filesOpened = new LinkedList<OpenDefinitionsDocument>();
        for (File f : files) {
            if (f == null) {
                throw new IOException("File name returned from FileSelector is null");
            }
            try {
                OpenDefinitionsDocument d = this._rawOpenFile(IOUtil.attemptCanonicalFile(f));
                retDocs.add(d);
                filesOpened.add(d);
                if (!this._state.isExcludedFile(f)) continue;
                this._state.removeExcludedFile(f);
            }
            catch (AlreadyOpenException aoe) {
                OpenDefinitionsDocument d = aoe.getOpenDocument();
                retDocs.add(d);
                alreadyOpenDocuments.add(d);
            }
            catch (FileNotFoundException e) {
                filesNotFound.add(f);
            }
        }
        for (OpenDefinitionsDocument d : filesOpened) {
            this._completeOpenFile(d);
        }
        if (filesNotFound.size() > 0) {
            this._notifier.filesNotFound(filesNotFound.toArray(new File[filesNotFound.size()]));
        }
        if (!alreadyOpenDocuments.isEmpty()) {
            for (OpenDefinitionsDocument d : alreadyOpenDocuments) {
                this._notifier.handleAlreadyOpenDocument(d);
                this._notifier.fileOpened(d);
            }
        }
        if (retDocs != null) {
            return retDocs.toArray(new OpenDefinitionsDocument[0]);
        }
        throw new OperationCanceledException();
    }

    @Override
    public void openFolder(File dir, boolean rec) throws IOException, OperationCanceledException, AlreadyOpenException {
        DebugUtil.debug.logStart();
        final File[] sfiles = this.getFilesInFolder(dir, rec);
        if (sfiles == null) {
            return;
        }
        this.openFiles(new FileOpenSelector(){

            public File[] getFiles() {
                return sfiles;
            }
        });
        if (sfiles.length > 0 && this._state.inProjectPath(dir)) {
            this.setProjectChanged(true);
        }
        DebugUtil.debug.logEnd();
    }

    public File[] getFilesInFolder(File dir, boolean rec) throws IOException, OperationCanceledException, AlreadyOpenException {
        if (dir == null || !dir.isDirectory()) {
            return null;
        }
        String extension = DrJavaRoot.LANGUAGE_LEVEL_EXTENSIONS[DrJava.getConfig().getSetting(LANGUAGE_LEVEL)];
        Predicate<File> match = LambdaUtil.and(IOUtil.IS_FILE, IOUtil.extensionFilePredicate(extension));
        SizedIterable<File> filesIterable = rec ? IOUtil.listFilesRecursively(dir, match) : IOUtil.attemptListFilesAsIterable(dir, match);
        List<File> files = CollectUtil.makeList(filesIterable);
        if (this.isProjectActive()) {
            Collections.sort(files, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return -o1.getAbsolutePath().compareTo(o2.getAbsolutePath());
                }
            });
        } else {
            Collections.sort(files, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return -o1.getName().compareTo(o2.getName());
                }
            });
        }
        int ct = files.size();
        return files.toArray(new File[ct]);
    }

    public File[] getNewFilesInProject() {
        File[] allFiles;
        ArrayList<File> files = new ArrayList<File>();
        File projRoot = this._state.getProjectRoot();
        if (projRoot == null) {
            return null;
        }
        try {
            allFiles = this.getFilesInFolder(projRoot, true);
        }
        catch (IOException e) {
            return null;
        }
        catch (OperationCanceledException e) {
            return null;
        }
        catch (AlreadyOpenException e) {
            return null;
        }
        for (File f : allFiles) {
            if (this.isAlreadyOpen(f) || this._state.isExcludedFile(f)) continue;
            files.add(f);
        }
        return files.toArray(new File[files.size()]);
    }

    public void openNewFilesInProject() {
        File[] newFiles = this.getNewFilesInProject();
        if (newFiles == null) {
            return;
        }
        try {
            this._openFiles(newFiles);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void saveAllFiles(FileSaveSelector com) throws IOException {
        this.saveAllFilesHelper(com);
        this.refreshActiveDocument();
    }

    protected void saveAllFilesHelper(FileSaveSelector com) throws IOException {
        boolean first = true;
        boolean isProjActive = this.isProjectActive();
        List<OpenDefinitionsDocument> docsToWrite = this.getOpenDefinitionsDocuments();
        while (docsToWrite.size() > 0) {
            ArrayList<OpenDefinitionsDocument> readOnlyDocs = new ArrayList<OpenDefinitionsDocument>();
            for (OpenDefinitionsDocument doc : docsToWrite) {
                if (doc.isUntitled() && (isProjActive || !doc.isModifiedSinceSave())) continue;
                try {
                    File docFile = doc.getFile();
                    if (docFile == null || !docFile.exists() || docFile.canWrite()) {
                        this.aboutToSaveFromSaveAll(doc);
                        doc.saveFile(com);
                        continue;
                    }
                    if (!first) continue;
                    readOnlyDocs.add(doc);
                }
                catch (FileMovedException fme) {
                    this.aboutToSaveFromSaveAll(doc);
                    doc.saveFile(com);
                }
            }
            docsToWrite.clear();
            if (readOnlyDocs.size() > 0) {
                ArrayList<File> files = new ArrayList<File>();
                for (OpenDefinitionsDocument odd : readOnlyDocs) {
                    try {
                        File roFile = odd.getFile();
                        files.add(roFile);
                    }
                    catch (FileMovedException fme) {}
                }
                File[] res = this._notifier.filesReadOnly(files.toArray(new File[files.size()]));
                HashSet<File> rewriteFiles = new HashSet<File>(Arrays.asList(res));
                for (OpenDefinitionsDocument odd : readOnlyDocs) {
                    File roFile = odd.getFile();
                    if (!rewriteFiles.contains(roFile)) continue;
                    docsToWrite.add(odd);
                    FileOps.makeWritable(roFile);
                }
            }
            first = false;
        }
    }

    @Override
    public void createNewProject(File projFile) {
        this.setFileGroupingState(new ProjectFileGroupingState(projFile));
    }

    @Override
    public void configNewProject() throws IOException {
        assert (EventQueue.isDispatchThread());
        File projFile = this.getProjectFile();
        ProjectProfile builder = new ProjectProfile(projFile);
        File projectRoot = builder.getProjectRoot();
        for (OpenDefinitionsDocument doc : this.getOpenDefinitionsDocuments()) {
            DocFile file;
            File f = doc.getFile();
            if (doc.isUntitled()) continue;
            if (IOUtil.isMember(f, projectRoot)) {
                file = new DocFile(f);
                file.setPackage(doc.getPackageName());
                builder.addSourceFile(file);
                continue;
            }
            if (!doc.isAuxiliaryFile()) continue;
            file = new DocFile(f);
            file.setPackage(doc.getPackageName());
            builder.addAuxiliaryFile(new DocFile(f));
        }
        builder.write();
        this._loadProject(builder);
    }

    public ProjectProfile _makeProjectProfile(File file, HashMap<OpenDefinitionsDocument, DocumentInfoGetter> info) throws IOException {
        int createJarFlags;
        File createJarFile;
        File mainClass;
        File wd;
        File bd;
        Iterable<File> exCp;
        ProjectProfile builder = new ProjectProfile(file);
        File pr = this.getProjectRoot();
        if (pr != null) {
            builder.setProjectRoot(pr);
        }
        for (OpenDefinitionsDocument doc : this.getOpenDefinitionsDocuments()) {
            DocumentInfoGetter g;
            if (doc.inProjectPath()) {
                g = info.get(doc);
                builder.addSourceFile(g);
                continue;
            }
            if (!doc.isAuxiliaryFile()) continue;
            g = info.get(doc);
            builder.addAuxiliaryFile(g);
        }
        if (this._documentNavigator instanceof JTreeSortNavigator) {
            String[] paths;
            for (String s : paths = ((JTreeSortNavigator)this._documentNavigator).getCollapsedPaths()) {
                builder.addCollapsedPath(s);
            }
        }
        if ((exCp = this.getExtraClassPath()) != null) {
            for (File f : exCp) {
                builder.addClassPathFile(f);
            }
        }
        if ((bd = this.getBuildDirectory()) != FileOps.NULL_FILE) {
            builder.setBuildDirectory(bd);
        }
        if ((wd = this.getWorkingDirectory()) != FileOps.NULL_FILE) {
            builder.setWorkingDirectory(wd);
        }
        if ((mainClass = this.getMainClass()) != null) {
            builder.setMainClass(mainClass);
        }
        if ((createJarFile = this.getCreateJarFile()) != null) {
            builder.setCreateJarFile(createJarFile);
        }
        if ((createJarFlags = this.getCreateJarFlags()) != 0) {
            builder.setCreateJarFlags(createJarFlags);
        }
        ArrayList<Breakpoint> l = new ArrayList<Breakpoint>();
        for (OpenDefinitionsDocument odd : this._breakpointManager.getDocuments()) {
            for (Breakpoint bp : this._breakpointManager.getRegions(odd)) {
                l.add(bp);
            }
        }
        builder.setBreakpoints(l);
        try {
            builder.setWatches(this.getDebugger().getWatches());
        }
        catch (DebugException de) {
            // empty catch block
        }
        builder.setBookmarks(this._bookmarkManager.getFileRegions());
        builder.setAutoRefreshStatus(this._state.getAutoRefreshStatus());
        for (File f : this._state.getExclFiles()) {
            builder.addExcludedFile(f);
        }
        return builder;
    }

    @Override
    public void saveProject(File file, HashMap<OpenDefinitionsDocument, DocumentInfoGetter> info) throws IOException {
        if (file.exists() && !file.canWrite()) {
            File[] res;
            for (File roFile : res = this._notifier.filesReadOnly(file)) {
                FileOps.makeWritable(roFile);
            }
            if (res.length == 0) {
                return;
            }
        }
        ProjectProfile builder = this._makeProjectProfile(file, info);
        builder.write();
        this.setFileGroupingState(this.makeProjectFileGroupingState(builder.getProjectRoot(), builder.getMainClass(), builder.getBuildDirectory(), builder.getWorkingDirectory(), file, builder.getSourceFiles(), builder.getAuxiliaryFiles(), builder.getExcludedFiles(), builder.getClassPaths(), builder.getCreateJarFile(), builder.getCreateJarFlags(), builder.getAutoRefreshStatus()));
    }

    public void exportOldProject(File file, HashMap<OpenDefinitionsDocument, DocumentInfoGetter> info) throws IOException {
        ProjectProfile builder = this._makeProjectProfile(file, info);
        builder.writeOld();
        this.setFileGroupingState(this.makeProjectFileGroupingState(builder.getProjectRoot(), builder.getMainClass(), builder.getBuildDirectory(), builder.getWorkingDirectory(), file, builder.getSourceFiles(), builder.getAuxiliaryFiles(), builder.getExcludedFiles(), builder.getClassPaths(), builder.getCreateJarFile(), builder.getCreateJarFlags(), builder.getAutoRefreshStatus()));
    }

    @Override
    public void reloadProject(File file, HashMap<OpenDefinitionsDocument, DocumentInfoGetter> info) throws IOException {
        boolean projChanged = this.isProjectChanged();
        ProjectProfile builder = this._makeProjectProfile(file, info);
        this._loadProject(builder);
        this.setProjectChanged(projChanged);
    }

    @Override
    public void openProject(File projectFile) throws IOException, MalformedProjectFileException {
        this._loadProject(ProjectFileParserFacade.ONLY.parse(projectFile));
    }

    private void _loadProject(ProjectFileIR ir) throws IOException {
        File f;
        assert (EventQueue.isDispatchThread());
        File[] srcFiles = ir.getSourceFiles();
        File[] auxFiles = ir.getAuxiliaryFiles();
        File[] excludedFiles = ir.getExcludedFiles();
        File projectFile = ir.getProjectFile();
        File pr = ir.getProjectRoot();
        try {
            pr = pr.getCanonicalFile();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        File projectRoot = pr;
        File buildDir = ir.getBuildDirectory();
        File workDir = ir.getWorkingDirectory();
        File mainClass = ir.getMainClass();
        Iterable<File> projectClassPaths = ir.getClassPaths();
        File createJarFile = ir.getCreateJarFile();
        int createJarFlags = ir.getCreateJarFlags();
        boolean autoRefresh = ir.getAutoRefreshStatus();
        if (!this._browserHistoryManager.getRegions().isEmpty()) {
            this._browserHistoryManager.clearBrowserRegions();
        }
        if (!this._breakpointManager.getDocuments().isEmpty()) {
            this._breakpointManager.clearRegions();
        }
        if (!this._bookmarkManager.getDocuments().isEmpty()) {
            this._bookmarkManager.clearRegions();
        }
        String projfilepath = projectRoot.getCanonicalPath();
        LinkedList l = new LinkedList();
        INavigatorItemFilter<OpenDefinitionsDocument> navItem1 = new INavigatorItemFilter<OpenDefinitionsDocument>(){

            @Override
            public boolean accept(OpenDefinitionsDocument d) {
                return d.inProjectPath();
            }
        };
        l.add(new Pair<String, 10>(this.getSourceBinTitle(), navItem1));
        INavigatorItemFilter<OpenDefinitionsDocument> navItem2 = new INavigatorItemFilter<OpenDefinitionsDocument>(){

            @Override
            public boolean accept(OpenDefinitionsDocument d) {
                return d.isAuxiliaryFile();
            }
        };
        l.add(new Pair<String, 11>(this.getAuxiliaryBinTitle(), navItem2));
        INavigatorItemFilter<OpenDefinitionsDocument> navItem3 = new INavigatorItemFilter<OpenDefinitionsDocument>(){

            @Override
            public boolean accept(OpenDefinitionsDocument d) {
                return !d.inProject() && !d.isAuxiliaryFile() || d.isUntitled();
            }
        };
        l.add(new Pair<String, 12>(this.getExternalBinTitle(), navItem3));
        IDocumentNavigator<OpenDefinitionsDocument> newNav = new AWTContainerNavigatorFactory<OpenDefinitionsDocument>().makeTreeNavigator(projfilepath, this.getDocumentNavigator(), l);
        this.setDocumentNavigator(newNav);
        this.setFileGroupingState(this.makeProjectFileGroupingState(projectRoot, mainClass, buildDir, workDir, projectFile, srcFiles, auxFiles, excludedFiles, projectClassPaths, createJarFile, createJarFlags, autoRefresh));
        this.resetInteractions(this.getWorkingDirectory());
        ArrayList<File> projFiles = new ArrayList<File>();
        File active = null;
        ArrayList<File> modifiedFiles = new ArrayList<File>();
        for (File f2 : srcFiles) {
            if (f2.lastModified() > ((DocFile)f2).getSavedModDate()) {
                modifiedFiles.add(f2);
                ((DocFile)f2).setSavedModDate(f2.lastModified());
            }
            if (((DocFile)f2).isActive()) {
                active = f2;
            }
            projFiles.add(f2);
        }
        for (File f2 : auxFiles) {
            if (f2.lastModified() > ((DocFile)f2).getSavedModDate()) {
                modifiedFiles.add(f2);
                ((DocFile)f2).setSavedModDate(f2.lastModified());
            }
            if (((DocFile)f2).isActive()) {
                active = f2;
            }
            projFiles.add(f2);
        }
        List<OpenDefinitionsDocument> projDocs = this.getProjectDocuments();
        if (!projDocs.isEmpty()) {
            for (OpenDefinitionsDocument d : projDocs) {
                try {
                    String path = this.fixPathForNavigator(d.getFile().getCanonicalPath());
                    this._documentNavigator.refreshDocument(d, path);
                }
                catch (IOException e) {}
            }
        }
        final DocFile[] filesToOpen = projFiles.toArray(new DocFile[projFiles.size()]);
        this._notifier.openProject(projectFile, new FileOpenSelector(){

            public File[] getFiles() {
                return filesToOpen;
            }
        });
        for (DebugBreakpointData dbd : ir.getBreakpoints()) {
            try {
                f = dbd.getFile();
                if (modifiedFiles.contains(f)) continue;
                int lnr = dbd.getLineNumber();
                OpenDefinitionsDocument odd = this.getDocumentForFile(f);
                this.getDebugger().toggleBreakpoint(odd, odd._getOffset(lnr), lnr, dbd.isEnabled());
            }
            catch (DebugException de) {
                // empty catch block
            }
        }
        if (active != null) {
            this.setActiveDocument(this.getDocumentForFile(active));
        }
        try {
            this.getDebugger().removeAllWatches();
        }
        catch (DebugException de) {
            // empty catch block
        }
        for (DebugWatchData dwd : ir.getWatches()) {
            try {
                this.getDebugger().addWatch(dwd.getName());
            }
            catch (DebugException de) {
                // empty catch block
            }
        }
        for (FileRegion bm : ir.getBookmarks()) {
            f = bm.getFile();
            if (modifiedFiles.contains(f)) continue;
            OpenDefinitionsDocument odd = this.getDocumentForFile(f);
            int start = bm.getStartOffset();
            int end = bm.getEndOffset();
            if (!this.getOpenDefinitionsDocuments().contains(odd) || this._bookmarkManager.getRegionsOverlapping(odd, start, end).size() != 0) continue;
            try {
                int lineStart = odd._getLineStartPos(start);
                int lineEnd = odd._getLineEndPos(end);
                this._bookmarkManager.addRegion(new MovingDocumentRegion(odd, start, end, lineStart, lineEnd));
            }
            catch (Exception e) {
                DrJavaErrorHandler.record(e);
            }
        }
        if (this._documentNavigator instanceof JTreeSortNavigator) {
            ((JTreeSortNavigator)this._documentNavigator).collapsePaths(ir.getCollapsedPaths());
        }
        if (this._state.getAutoRefreshStatus()) {
            this.openNewFilesInProject();
        }
    }

    public void autoRefreshProject() {
        this.openNewFilesInProject();
    }

    @Override
    public void closeProject(boolean suppressReset) {
        this.setDocumentNavigator(new AWTContainerNavigatorFactory<OpenDefinitionsDocument>().makeListNavigator(this.getDocumentNavigator()));
        this.setFileGroupingState(this.makeFlatFileGroupingState());
        if (!suppressReset) {
            this.resetInteractions(this.getWorkingDirectory());
        }
        this._notifier.projectClosed();
    }

    public void aboutToSaveFromSaveAll(OpenDefinitionsDocument doc) {
        if (doc.isUntitled()) {
            this.setActiveDocument(doc);
        }
    }

    @Override
    public boolean closeFile(OpenDefinitionsDocument doc) {
        LinkedList<OpenDefinitionsDocument> list = new LinkedList<OpenDefinitionsDocument>();
        list.add(doc);
        return this.closeFiles(list);
    }

    @Override
    public boolean closeAllFiles() {
        List<OpenDefinitionsDocument> docs = this.getOpenDefinitionsDocuments();
        boolean res = this.closeFiles(docs);
        if (res) {
            this.resetInteractions(this.getWorkingDirectory());
        }
        return res;
    }

    @Override
    public boolean closeFiles(List<OpenDefinitionsDocument> docs) {
        if (docs.size() == 0) {
            return true;
        }
        _log.log("closeFiles(" + docs + ") called");
        for (OpenDefinitionsDocument doc : docs) {
            if (doc.canAbandonFile()) continue;
            return false;
        }
        if (docs.size() == this.getDocumentCount()) {
            this.newFile();
        }
        this._ensureNotActive(docs);
        for (OpenDefinitionsDocument doc : docs) {
            this.closeFileWithoutPrompt(doc);
        }
        return true;
    }

    protected boolean closeFileHelper(OpenDefinitionsDocument doc) {
        boolean canClose = doc.canAbandonFile();
        if (canClose) {
            return this.closeFileWithoutPrompt(doc);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closeFileWithoutPrompt(OpenDefinitionsDocument doc) {
        RegionManager[] managers;
        boolean found;
        _log.log("closeFileWithoutPrompt(" + doc + ") called; getRawFile() = " + doc.getRawFile());
        _log.log("_documentsRepos = " + this._documentsRepos);
        AbstractMap<File, OpenDefinitionsDocument> abstractMap = this._documentsRepos;
        synchronized (abstractMap) {
            found = this._documentsRepos.remove(doc.getRawFile()) != null;
        }
        if (!found) {
            _log.log("Cannot close " + doc + "; not found!");
            return false;
        }
        this._breakpointManager.clearRegions();
        this._bookmarkManager.clearRegions();
        for (RegionManager rm : managers = this._findResultsManagers.toArray(new RegionManager[0])) {
            rm.removeRegions(doc);
        }
        doc.clearBrowserRegions();
        if (doc.isAuxiliaryFile()) {
            this.removeAuxiliaryFile(doc);
        }
        this._documentNavigator.removeDocument(doc);
        this._notifier.fileClosed(doc);
        doc.close();
        return true;
    }

    @Override
    public boolean closeAllFilesOnQuit() {
        List<OpenDefinitionsDocument> docs = this.getOpenDefinitionsDocuments();
        for (OpenDefinitionsDocument doc : docs) {
            if (doc.canAbandonFile()) continue;
            return false;
        }
        this.newFile();
        this._ensureNotActive(docs);
        for (OpenDefinitionsDocument doc : docs) {
            this.closeFileWithoutPrompt(doc);
        }
        return true;
    }

    @Override
    public void quit() {
        this.quit(false);
    }

    @Override
    public void forceQuit() {
        this.quit(true);
    }

    private void quit(boolean force) {
        try {
            if (!force && !this.closeAllFilesOnQuit()) {
                this.refreshActiveDocument();
                return;
            }
            this.shutdown(force);
        }
        catch (Throwable t) {
            this.shutdown(true);
        }
    }

    private void shutdown(boolean force) {
        if (force) {
            Runtime.getRuntime().halt(0);
        }
        this.dispose();
        if (DrJava.getConfig().getSetting(OptionConstants.DRJAVA_USE_FORCE_QUIT).booleanValue()) {
            Runtime.getRuntime().halt(0);
        }
        Thread monitor = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Runtime.getRuntime().halt(0);
            }
        });
        monitor.setDaemon(true);
        monitor.start();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        AbstractMap<File, OpenDefinitionsDocument> abstractMap = this._documentsRepos;
        synchronized (abstractMap) {
            this.closeAllFiles();
            this._documentsRepos.clear();
        }
        Utilities.invokeLater(new Runnable(){

            public void run() {
                AbstractGlobalModel.this._documentNavigator.clear();
            }
        });
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                AbstractGlobalModel.this._notifier.removeAllListeners();
            }
        });
    }

    @Override
    public void disposeExternalResources() {
    }

    @Override
    public OpenDefinitionsDocument getDocumentForFile(File file) throws IOException {
        OpenDefinitionsDocument doc = this._getOpenDocument(file);
        if (doc == null) {
            final File f = file;
            FileOpenSelector selector = new FileOpenSelector(){

                public File[] getFiles() {
                    return new File[]{f};
                }
            };
            try {
                doc = this.openFile(selector);
            }
            catch (AlreadyOpenException e) {
                doc = e.getOpenDocument();
            }
            catch (OperationCanceledException e) {
                throw new UnexpectedException(e);
            }
        }
        return doc;
    }

    public boolean isAlreadyOpen(File file) {
        return this._getOpenDocument(file) != null;
    }

    @Override
    public OpenDefinitionsDocument getODDForDocument(AbstractDocumentInterface doc) {
        if (doc instanceof OpenDefinitionsDocument) {
            return (OpenDefinitionsDocument)doc;
        }
        if (doc instanceof DefinitionsDocument) {
            return ((DefinitionsDocument)doc).getOpenDefDoc();
        }
        throw new IllegalStateException("Could not get the OpenDefinitionsDocument for Document: " + doc);
    }

    @Override
    public DocumentIterator getDocumentIterator() {
        return this;
    }

    @Override
    public OpenDefinitionsDocument getNextDocument(OpenDefinitionsDocument d) {
        OpenDefinitionsDocument nextdoc = null;
        OpenDefinitionsDocument doc = this.getODDForDocument(d);
        nextdoc = this._documentNavigator.getNext(doc);
        if (nextdoc == doc) {
            nextdoc = this._documentNavigator.getFirst();
        }
        OpenDefinitionsDocument res = this.getNextDocHelper(nextdoc);
        return res;
    }

    private OpenDefinitionsDocument getNextDocHelper(OpenDefinitionsDocument nextdoc) {
        if (nextdoc.isUntitled() || nextdoc.verifyExists()) {
            return nextdoc;
        }
        return this.getNextDocument(nextdoc);
    }

    @Override
    public OpenDefinitionsDocument getPrevDocument(OpenDefinitionsDocument d) {
        OpenDefinitionsDocument prevdoc = null;
        OpenDefinitionsDocument doc = this.getODDForDocument(d);
        prevdoc = this._documentNavigator.getPrevious(doc);
        if (prevdoc == doc) {
            prevdoc = this._documentNavigator.getLast();
        }
        return this.getPrevDocHelper(prevdoc);
    }

    private OpenDefinitionsDocument getPrevDocHelper(OpenDefinitionsDocument prevdoc) {
        if (prevdoc.isUntitled() || prevdoc.verifyExists()) {
            return prevdoc;
        }
        return this.getPrevDocument(prevdoc);
    }

    @Override
    public int getDocumentCount() {
        return this._documentsRepos.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OpenDefinitionsDocument> getOpenDefinitionsDocuments() {
        AbstractMap<File, OpenDefinitionsDocument> abstractMap = this._documentsRepos;
        synchronized (abstractMap) {
            ArrayList<OpenDefinitionsDocument> docs = new ArrayList<OpenDefinitionsDocument>(this._documentsRepos.size());
            for (OpenDefinitionsDocument doc : this._documentsRepos.values()) {
                docs.add(doc);
            }
            return docs;
        }
    }

    public List<OpenDefinitionsDocument> getSortedOpenDefinitionsDocuments() {
        return this.getOpenDefinitionsDocuments();
    }

    @Override
    public boolean hasOutOfSyncDocuments() {
        return this.hasOutOfSyncDocuments(this.getOpenDefinitionsDocuments());
    }

    @Override
    public boolean hasOutOfSyncDocuments(List<OpenDefinitionsDocument> lod) {
        for (OpenDefinitionsDocument doc : lod) {
            if (!doc.isSourceFile() || this.isProjectActive() && !doc.inProjectPath() && !doc.isAuxiliaryFile() || doc.checkIfClassFileInSync()) continue;
            return true;
        }
        return false;
    }

    void setDefinitionsIndent(int indent) {
        for (OpenDefinitionsDocument doc : this.getOpenDefinitionsDocuments()) {
            doc.setIndent(indent);
        }
    }

    @Override
    public void resetInteractions(File wd) {
    }

    @Override
    public void resetInteractions(File wd, boolean forceReset) {
    }

    @Override
    public void resetConsole() {
        this._consoleDoc.reset("");
        Utilities.invokeLater(new Runnable(){

            public void run() {
                AbstractGlobalModel.this._notifier.consoleReset();
            }
        });
    }

    @Override
    public void interpretCurrentInteraction() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public void loadHistory(FileOpenSelector selector) throws IOException {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public InteractionsScriptModel loadHistoryAsScript(FileOpenSelector selector) throws IOException, OperationCanceledException {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public void clearHistory() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public void saveHistory(FileSaveSelector selector) throws IOException {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public void saveHistory(FileSaveSelector selector, String editedVersion) throws IOException {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public String getHistoryAsStringWithSemicolons() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public String getHistoryAsString() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    private void _registerOptionListeners() {
    }

    protected void _docAppend(final ConsoleDocument doc, final String s, final String style) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                doc.insertBeforeLastPrompt(s, style);
            }
        });
    }

    @Override
    public void systemOutPrint(String s) {
        this._docAppend(this._consoleDoc, s, "System.out");
    }

    @Override
    public void systemErrPrint(String s) {
        this._docAppend(this._consoleDoc, s, "System.err");
    }

    @Override
    public void systemInEcho(String s) {
        this._docAppend(this._consoleDoc, s, "System.in");
    }

    @Override
    public void printDebugMessage(String s) {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support debugging");
    }

    @Override
    public void waitForInterpreter() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public Iterable<File> getInteractionsClassPath() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public Iterable<File> getExtraClassPath() {
        return this._state.getExtraClassPath();
    }

    @Override
    public void setExtraClassPath(Iterable<File> cp) {
        this._state.setExtraClassPath(cp);
        this.setClassPathChanged(true);
    }

    @Override
    public File[] getExclFiles() {
        return this._state.getExclFiles();
    }

    @Override
    public void setExcludedFiles(File[] fs) {
        this._state.setExcludedFiles(fs);
    }

    @Override
    public Iterable<File> getSourceRootSet() {
        LinkedHashSet<File> roots = new LinkedHashSet<File>();
        for (OpenDefinitionsDocument doc : this.getOpenDefinitionsDocuments()) {
            try {
                File root;
                if (doc.isUntitled() || (root = doc.getSourceRoot()) == null) continue;
                roots.add(root);
            }
            catch (InvalidPackageException e) {}
        }
        return roots;
    }

    @Override
    public Debugger getDebugger() {
        return NoDebuggerAvailable.ONLY;
    }

    @Override
    public int getDebugPort() throws IOException {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support debugging");
    }

    @Override
    public boolean hasModifiedDocuments() {
        return this.hasModifiedDocuments(this.getOpenDefinitionsDocuments());
    }

    @Override
    public boolean hasModifiedDocuments(List<OpenDefinitionsDocument> lod) {
        for (OpenDefinitionsDocument doc : lod) {
            if (!doc.isModifiedSinceSave()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasUntitledDocuments() {
        for (OpenDefinitionsDocument doc : this.getOpenDefinitionsDocuments()) {
            if (!doc.isUntitled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public File getSourceFile(String fileName) {
        Iterable<File> sourceRoots = this.getSourceRootSet();
        for (File s : sourceRoots) {
            File f = this._getSourceFileFromPath(fileName, s);
            if (f == null) continue;
            return f;
        }
        Vector sourcepath = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.DEBUG_SOURCEPATH));
        return this.findFileInPaths(fileName, sourcepath);
    }

    @Override
    public File findFileInPaths(String fileName, Iterable<File> paths) {
        for (File p : paths) {
            File f = this._getSourceFileFromPath(fileName, p);
            if (f == null) continue;
            return f;
        }
        return FileOps.NULL_FILE;
    }

    private File _getSourceFileFromPath(String fileName, File path) {
        String root = path.getAbsolutePath();
        File f = new File(root + System.getProperty("file.separator") + fileName);
        return f.exists() ? f : FileOps.NULL_FILE;
    }

    @Override
    public void addToBrowserHistory() {
        OpenDefinitionsDocument doc = this.getActiveDocument();
        Position startPos = null;
        Position endPos = null;
        try {
            int currentLineNum;
            int lineNum;
            OpenDefinitionsDocument currentDoc;
            int pos = doc.getCurrentLocation();
            BrowserDocumentRegion current = this._browserHistoryManager.getCurrentRegion();
            if (current != null && doc == (currentDoc = current.getDocument()) && Math.abs((lineNum = doc.getLineOfOffset(pos)) - (currentLineNum = currentDoc.getLineOfOffset(current.getStartOffset()))) <= 5) {
                return;
            }
            endPos = startPos = doc.createPosition(pos);
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
        this._browserHistoryManager.addBrowserRegion(new BrowserDocumentRegion(doc, startPos, endPos), this._notifier);
    }

    @Override
    public Iterable<File> getClassPath() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support class paths");
    }

    public static boolean isUntitled(File f) {
        return f == null || f instanceof NullFile;
    }

    protected ConcreteOpenDefDoc _createOpenDefinitionsDocument(NullFile f) {
        return new ConcreteOpenDefDoc(f);
    }

    protected ConcreteOpenDefDoc _createOpenDefinitionsDocument(File f) throws IOException {
        if (!f.exists()) {
            throw new FileNotFoundException("file " + f + " cannot be found");
        }
        return new ConcreteOpenDefDoc(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OpenDefinitionsDocument _getOpenDocument(File file) {
        AbstractMap<File, OpenDefinitionsDocument> abstractMap = this._documentsRepos;
        synchronized (abstractMap) {
            return this._documentsRepos.get(file);
        }
    }

    @Override
    public List<OpenDefinitionsDocument> getNonProjectDocuments() {
        List<OpenDefinitionsDocument> allDocs = this.getOpenDefinitionsDocuments();
        LinkedList<OpenDefinitionsDocument> selectedDocs = new LinkedList<OpenDefinitionsDocument>();
        for (OpenDefinitionsDocument d : allDocs) {
            if (d.inProjectPath() || d.isAuxiliaryFile()) continue;
            selectedDocs.add(d);
        }
        return selectedDocs;
    }

    @Override
    public List<OpenDefinitionsDocument> getAuxiliaryDocuments() {
        List<OpenDefinitionsDocument> allDocs = this.getOpenDefinitionsDocuments();
        LinkedList<OpenDefinitionsDocument> selectedDocs = new LinkedList<OpenDefinitionsDocument>();
        for (OpenDefinitionsDocument d : allDocs) {
            if (!d.isAuxiliaryFile()) continue;
            selectedDocs.add(d);
        }
        return selectedDocs;
    }

    @Override
    public List<OpenDefinitionsDocument> getProjectDocuments() {
        List<OpenDefinitionsDocument> allDocs = this.getOpenDefinitionsDocuments();
        LinkedList<OpenDefinitionsDocument> projectDocs = new LinkedList<OpenDefinitionsDocument>();
        for (OpenDefinitionsDocument d : allDocs) {
            if (!d.inProjectPath() && !d.isAuxiliaryFile()) continue;
            projectDocs.add(d);
        }
        return projectDocs;
    }

    @Override
    public String fixPathForNavigator(String path) throws IOException {
        String rootPath;
        String parent = path.substring(0, path.lastIndexOf(File.separator));
        if (!parent.equals(rootPath = this.getProjectRoot().getCanonicalPath()) && !parent.startsWith(rootPath + File.separator)) {
            return "";
        }
        return parent.substring(rootPath.length());
    }

    private OpenDefinitionsDocument _rawOpenFile(File file) throws IOException, AlreadyOpenException {
        OpenDefinitionsDocument openDoc = this._getOpenDocument(file);
        if (openDoc != null) {
            throw new AlreadyOpenException(openDoc);
        }
        ConcreteOpenDefDoc doc = this._createOpenDefinitionsDocument(file);
        if (file instanceof DocFile) {
            DocFile df = (DocFile)file;
            Pair<Integer, Integer> scroll = df.getScroll();
            Pair<Integer, Integer> sel = df.getSelection();
            String pkg = df.getPackage();
            doc.setPackage(pkg);
            doc.setInitialVScroll(scroll.first());
            doc.setInitialHScroll(scroll.second());
            doc.setInitialSelStart(sel.first());
            doc.setInitialSelEnd(sel.second());
        } else {
            doc.setPackage(doc.getPackageNameFromDocument());
        }
        return doc;
    }

    protected static <T> T pop(ArrayList<T> stack) {
        return stack.remove(stack.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDocToNavigator(OpenDefinitionsDocument doc) {
        try {
            if (doc.isUntitled()) {
                this._documentNavigator.addDocument(doc);
            } else {
                String path = doc.getFile().getCanonicalPath();
                this._documentNavigator.addDocument(doc, this.fixPathForNavigator(path));
            }
        }
        catch (IOException e) {
            this._documentNavigator.addDocument(doc);
        }
        AbstractMap<File, OpenDefinitionsDocument> abstractMap = this._documentsRepos;
        synchronized (abstractMap) {
            this._documentsRepos.put(doc.getRawFile(), doc);
        }
    }

    protected void addDocToClassPath(OpenDefinitionsDocument doc) {
    }

    public OpenDefinitionsDocument _openFile(File file) throws IOException, AlreadyOpenException {
        OpenDefinitionsDocument doc = this._rawOpenFile(file);
        this._completeOpenFile(doc);
        return doc;
    }

    private void _completeOpenFile(OpenDefinitionsDocument d) {
        this.addDocToNavigator(d);
        this.addDocToClassPath(d);
        try {
            File f = d.getFile();
            if (!this.inProject(f) && this.inProjectPath(d)) {
                this.setProjectChanged(true);
            }
        }
        catch (FileMovedException fileMovedException) {
            // empty catch block
        }
        this._notifier.fileOpened(d);
    }

    @Override
    public OpenDefinitionsDocument getActiveDocument() {
        return this._activeDocument;
    }

    @Override
    public void setActiveDocument(final OpenDefinitionsDocument doc) {
        try {
            Utilities.invokeAndWait(new Runnable(){

                public void run() {
                    AbstractGlobalModel.this._documentNavigator.setNextChangeModelInitiated(true);
                    AbstractGlobalModel.this._documentNavigator.selectDocument(doc);
                }
            });
        }
        catch (Exception e) {
            throw new UnexpectedException(e);
        }
    }

    @Override
    public Container getDocCollectionWidget() {
        return this._documentNavigator.asContainer();
    }

    @Override
    public void setActiveNextDocument() {
        OpenDefinitionsDocument key = this._activeDocument;
        OpenDefinitionsDocument nextKey = this._documentNavigator.getNext(key);
        if (key != nextKey) {
            this.setActiveDocument(nextKey);
        } else {
            this.setActiveDocument(this._documentNavigator.getFirst());
        }
    }

    @Override
    public void setActivePreviousDocument() {
        OpenDefinitionsDocument key = this._activeDocument;
        OpenDefinitionsDocument prevKey = this._documentNavigator.getPrevious(key);
        if (key != prevKey) {
            this.setActiveDocument(prevKey);
        } else {
            this.setActiveDocument(this._documentNavigator.getLast());
        }
    }

    private boolean _hasOneEmptyDocument() {
        return this.getDocumentCount() == 1 && this._activeDocument.isUntitled() && !this._activeDocument.isModifiedSinceSave();
    }

    private void _ensureNotEmpty() {
        if (this.getDocumentCount() == 0) {
            this.newFile(this.getMasterWorkingDirectory());
        }
    }

    private void _ensureNotActive(List<OpenDefinitionsDocument> docs) {
        if (docs.contains(this.getActiveDocument())) {
            OpenDefinitionsDocument item;
            IDocumentNavigator<OpenDefinitionsDocument> nav = this.getDocumentNavigator();
            OpenDefinitionsDocument nextActive = nav.getNext(item = docs.get(docs.size() - 1));
            if (!nextActive.equals(item)) {
                this.setActiveDocument(nextActive);
                return;
            }
            item = docs.get(0);
            nextActive = nav.getPrevious(item);
            if (!nextActive.equals(item)) {
                this.setActiveDocument(nextActive);
                return;
            }
            throw new RuntimeException("No document to set active before closing");
        }
    }

    @Override
    public void setActiveFirstDocument() {
        this.setActiveDocument(this.getOpenDefinitionsDocuments().get(0));
    }

    private void _setActiveDoc(INavigatorItem idoc) {
        this._activeDocument = (OpenDefinitionsDocument)idoc;
        this.installActiveDocument();
    }

    public void installActiveDocument() {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                AbstractGlobalModel.this._notifier.activeDocumentChanged(AbstractGlobalModel.this._activeDocument);
            }
        });
    }

    @Override
    public void refreshActiveDocument() {
        this._documentNavigator.selectDocument(this._activeDocument);
        Utilities.invokeLater(new Runnable(){

            public void run() {
                AbstractGlobalModel.this._notifier.activeDocumentRefreshed(AbstractGlobalModel.this._activeDocument);
            }
        });
    }

    private static class TrivialFSS
    implements FileSaveSelector {
        private File _file;

        private TrivialFSS(File file) {
            this._file = file;
        }

        public File getFile() throws OperationCanceledException {
            return this._file;
        }

        public boolean warnFileOpen(File f) {
            return true;
        }

        public boolean verifyOverwrite() {
            return true;
        }

        public boolean shouldSaveAfterFileMoved(OpenDefinitionsDocument doc, File oldFile) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConcreteOpenDefDoc
    implements OpenDefinitionsDocument {
        private volatile String _image;
        private volatile File _file;
        private volatile long _timestamp;
        private volatile File _parentDir;
        private volatile File _classFile;
        private volatile boolean _classFileInSync = false;
        protected volatile String _packageName = "";
        protected volatile String _lexiName = "";
        private volatile DCacheAdapter _cacheAdapter;
        protected final Set<BrowserDocumentRegion> _browserRegions;
        private volatile int _initVScroll;
        private volatile int _initHScroll;
        private volatile int _initSelStart;
        private volatile int _initSelEnd;
        private volatile DrJavaBook _book;

        @Override
        public void addBrowserRegion(BrowserDocumentRegion r) {
            this._browserRegions.add(r);
        }

        @Override
        public void removeBrowserRegion(BrowserDocumentRegion r) {
            this._browserRegions.remove(r);
        }

        ConcreteOpenDefDoc(File f) {
            this(f, f.getParentFile(), f.lastModified());
        }

        ConcreteOpenDefDoc(NullFile f) {
            this(f, null, 0L);
        }

        private ConcreteOpenDefDoc(File f, File dir, long stamp) {
            this._file = f;
            this._parentDir = dir;
            this._classFile = FileOps.NULL_FILE;
            this._timestamp = stamp;
            this._image = null;
            this._lexiName = this._file instanceof NullFile ? ((NullFile)this._file).getLexiName() : this._file.getPath().replace(File.separatorChar, ' ');
            try {
                DDReconstructor ddr = this.makeReconstructor();
                this._cacheAdapter = AbstractGlobalModel.this._cache.register(this, ddr);
            }
            catch (IllegalStateException e) {
                throw new UnexpectedException(e);
            }
            this._browserRegions = new HashSet<BrowserDocumentRegion>();
        }

        @Override
        public File getRawFile() {
            return this._file;
        }

        @Override
        public File getFile() throws FileMovedException {
            File f = this._file;
            if (AbstractGlobalModel.isUntitled(f)) {
                return null;
            }
            if (f.exists()) {
                return f;
            }
            throw new FileMovedException(f, "This document's file has been moved or deleted.");
        }

        @Override
        public synchronized void setFile(File file) {
            this._file = file;
            this._timestamp = !AbstractGlobalModel.isUntitled(file) ? file.lastModified() : 0L;
        }

        @Override
        public long getTimestamp() {
            return this._timestamp;
        }

        @Override
        public void setClassFileInSync(boolean inSync) {
            this._classFileInSync = inSync;
        }

        @Override
        public boolean getClassFileInSync() {
            return this._classFileInSync;
        }

        @Override
        public void setCachedClassFile(File classFile) {
            this._classFile = classFile;
        }

        @Override
        public File getCachedClassFile() {
            return this._classFile;
        }

        @Override
        public synchronized void resetModification() {
            this.getDocument().resetModification();
            File f = this._file;
            if (!AbstractGlobalModel.isUntitled(f)) {
                this._timestamp = f.lastModified();
            }
        }

        @Override
        public File getParentDirectory() {
            return this._parentDir;
        }

        public synchronized void setParentDirectory(File pd) {
            if (!AbstractGlobalModel.isUntitled(this._file)) {
                throw new IllegalArgumentException("The parent directory can only be set for untitled documents");
            }
            this._parentDir = pd;
        }

        @Override
        public int getInitialVerticalScroll() {
            return this._initVScroll;
        }

        @Override
        public int getInitialHorizontalScroll() {
            return this._initHScroll;
        }

        @Override
        public int getInitialSelectionStart() {
            return this._initSelStart;
        }

        @Override
        public int getInitialSelectionEnd() {
            return this._initSelEnd;
        }

        void setInitialVScroll(int i) {
            this._initVScroll = i;
        }

        void setInitialHScroll(int i) {
            this._initHScroll = i;
        }

        void setInitialSelStart(int i) {
            this._initSelStart = i;
        }

        void setInitialSelEnd(int i) {
            this._initSelEnd = i;
        }

        @Override
        public DefinitionsDocument getDocument() {
            try {
                return this._cacheAdapter.getDocument();
            }
            catch (IOException ioe) {
                try {
                    AbstractGlobalModel.this._notifier.documentNotFound(this, this._file);
                    String path = AbstractGlobalModel.this.fixPathForNavigator(this.getFile().getCanonicalFile().getCanonicalPath());
                    AbstractGlobalModel.this._documentNavigator.refreshDocument(this, path);
                    return this._cacheAdapter.getDocument();
                }
                catch (Throwable t) {
                    throw new UnexpectedException(t);
                }
            }
        }

        @Override
        public String getFirstTopLevelClassName() throws ClassNameNotFoundException {
            return this.getDocument().getFirstTopLevelClassName();
        }

        public String getMainClassName() throws ClassNameNotFoundException {
            return this.getDocument().getMainClassName();
        }

        @Override
        public String getFileName() {
            if (this._file == null) {
                return "(Untitled)";
            }
            return this._file.getName();
        }

        @Override
        public String getName() {
            String fileName = this.getFileName();
            fileName = this.isModifiedSinceSave() ? fileName + "*" : fileName + "  ";
            return fileName;
        }

        @Override
        public String getCanonicalPath() {
            if (this.isUntitled()) {
                return "(Untitled)";
            }
            return IOUtil.attemptCanonicalFile(this.getRawFile()).getPath();
        }

        @Override
        public String getCompletePath() {
            String path = this.getCanonicalPath();
            if (this.isModifiedSinceSave()) {
                path = path + " *";
            }
            return path;
        }

        @Override
        public File getSourceRoot() throws InvalidPackageException {
            if (this.isUntitled()) {
                throw new InvalidPackageException(-1, "Can not get source root for unsaved file. Please save.");
            }
            try {
                String[] packages = this._packageName.split("\\.");
                if (packages.length == 1 && packages[0].equals("")) {
                    packages = new String[]{};
                }
                File dir = this.getFile().getParentFile();
                for (String p : IterUtil.reverse(IterUtil.asIterable(packages))) {
                    if (dir == null || !dir.getName().equals(p)) {
                        String m = "File is in the wrong directory or is declared part of the wrong package.  Directory name " + (dir == null ? "(root)" : "'" + dir.getName() + "'") + " does not match package name '" + p + "'.";
                        throw new InvalidPackageException(-1, m);
                    }
                    dir = dir.getParentFile();
                }
                if (dir == null) {
                    throw new InvalidPackageException(-1, "File is in a directory tree with a null root");
                }
                return dir;
            }
            catch (FileMovedException fme) {
                throw new InvalidPackageException(-1, "File has been moved or deleted from its previous location. Please save.");
            }
        }

        @Override
        public String getPackageName() {
            return this._packageName;
        }

        @Override
        public void setPackage(String name) {
            this._packageName = name;
        }

        @Override
        public String getPackageNameFromDocument() {
            return this.getDocument().getPackageName();
        }

        @Override
        public void updateModifiedSinceSave() {
            this.getDocument().updateModifiedSinceSave();
        }

        @Override
        public String getLexiName() {
            return this._lexiName;
        }

        @Override
        public Pageable getPageable() throws IllegalStateException {
            return this._book;
        }

        @Override
        public void cleanUpPrintJob() {
            this._book = null;
        }

        @Override
        public boolean inProjectPath() {
            return AbstractGlobalModel.this._state.inProjectPath(this);
        }

        @Override
        public boolean inNewProjectPath(File projRoot) {
            try {
                return !this.isUntitled() && IOUtil.isMember(this.getFile(), projRoot);
            }
            catch (FileMovedException e) {
                return false;
            }
        }

        @Override
        public boolean inProject() {
            return !this.isUntitled() && AbstractGlobalModel.this._state.inProject(this._file);
        }

        @Override
        public boolean isEmpty() {
            return this.getLength() == 0;
        }

        @Override
        public boolean isAuxiliaryFile() {
            return !this.isUntitled() && AbstractGlobalModel.this._state.isAuxiliaryFile(this._file);
        }

        @Override
        public boolean isSourceFile() {
            if (this.isUntitled()) {
                return false;
            }
            String name = this._file.getName();
            for (String ext : CompilerModel.EXTENSIONS) {
                if (!name.endsWith(ext)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isUntitled() {
            return AbstractGlobalModel.isUntitled(this._file);
        }

        public boolean isUntitledAndEmpty() {
            return this.isUntitled() && this.getLength() == 0;
        }

        @Override
        public boolean fileExists() {
            File f = this._file;
            return !AbstractGlobalModel.isUntitled(f) && f.exists();
        }

        @Override
        public boolean verifyExists() {
            if (this.fileExists()) {
                return true;
            }
            try {
                AbstractGlobalModel.this._notifier.documentNotFound(this, this._file);
                if (this.isUntitled()) {
                    return false;
                }
                String path = AbstractGlobalModel.this.fixPathForNavigator(this.getFile().getCanonicalPath());
                AbstractGlobalModel.this._documentNavigator.refreshDocument(this, path);
                return true;
            }
            catch (FileMovedException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }

        protected DDReconstructor makeReconstructor() {
            return new DDReconstructor(){
                private volatile int _loc = 0;
                private volatile DocumentListener[] _list = new DocumentListener[0];
                private volatile List<FinalizationListener<DefinitionsDocument>> _finalListeners = new LinkedList<FinalizationListener<DefinitionsDocument>>();
                private volatile WeakHashMap<DefinitionsDocument.WrappedPosition, Integer> _positions = new WeakHashMap();

                public String getText() {
                    String image = ConcreteOpenDefDoc.this._image;
                    if (image != null) {
                        return image;
                    }
                    try {
                        image = FileOps.readFileAsSwingText(ConcreteOpenDefDoc.this._file);
                    }
                    catch (IOException e) {
                        image = "";
                    }
                    ConcreteOpenDefDoc.this._image = image;
                    return ConcreteOpenDefDoc.this._image;
                }

                public DefinitionsDocument make() throws IOException, BadLocationException, FileMovedException {
                    DefinitionsDocument newDefDoc = new DefinitionsDocument(AbstractGlobalModel.this._notifier);
                    newDefDoc.setOpenDefDoc(ConcreteOpenDefDoc.this);
                    String image = this.getText();
                    assert (image != null);
                    AbstractGlobalModel.this._editorKit.read(new StringReader(image), (Document)newDefDoc, 0);
                    newDefDoc.putProperty("__EndOfLine__", StringOps.EOL);
                    _log.log("Reading from image for " + ConcreteOpenDefDoc.this._file + " containing " + ConcreteOpenDefDoc.this._image.length() + " chars");
                    this._loc = Math.min(this._loc, image.length());
                    this._loc = Math.max(this._loc, 0);
                    newDefDoc.setCurrentLocation(this._loc);
                    for (DocumentListener d : this._list) {
                        if (!(d instanceof DocumentUIListener)) continue;
                        newDefDoc.addDocumentListener(d);
                    }
                    for (FinalizationListener<DefinitionsDocument> l : this._finalListeners) {
                        newDefDoc.addFinalizationListener(l);
                    }
                    newDefDoc.setWrappedPositionOffsets(this._positions);
                    newDefDoc.resetModification();
                    assert (!newDefDoc.isModifiedSinceSave());
                    ConcreteOpenDefDoc.this._packageName = newDefDoc.getPackageName();
                    return newDefDoc;
                }

                public void saveDocInfo(DefinitionsDocument doc) {
                    String text = doc.getText();
                    if (text.length() > 0) {
                        ConcreteOpenDefDoc.this._image = text;
                    }
                    this._loc = doc.getCurrentLocation();
                    this._list = doc.getDocumentListeners();
                    this._finalListeners = doc.getFinalizationListeners();
                    this._positions.clear();
                    this._positions = doc.getWrappedPositionOffsets();
                }

                public void addDocumentListener(DocumentListener dl) {
                    ArrayList<DocumentListener> tmp = new ArrayList<DocumentListener>();
                    for (DocumentListener l : this._list) {
                        if (dl == l) continue;
                        tmp.add(l);
                    }
                    tmp.add(dl);
                    this._list = tmp.toArray(new DocumentListener[tmp.size()]);
                }

                public String toString() {
                    return ConcreteOpenDefDoc.this.toString();
                }
            };
        }

        @Override
        public boolean saveFile(FileSaveSelector com) throws IOException {
            if (!this.isModifiedSinceSave()) {
                return true;
            }
            if (this.isUntitled()) {
                return this.saveFileAs(com);
            }
            this._packageName = this.getDocument().getPackageName();
            FileSaveSelector realCommand = com;
            try {
                File file = this.getFile();
                if (!this.isUntitled()) {
                    realCommand = new TrivialFSS(file);
                }
            }
            catch (FileMovedException fme) {
                if (com.shouldSaveAfterFileMoved(this, fme.getFile())) {
                    realCommand = com;
                }
                return false;
            }
            return this.saveFileAs(realCommand);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean saveFileAs(FileSaveSelector com) throws IOException {
            assert (EventQueue.isDispatchThread());
            File oldFile = this.getRawFile();
            this._packageName = this.getDocument().getPackageName();
            try {
                boolean shouldOverwrite;
                boolean openInOtherDoc;
                ConcreteOpenDefDoc openDoc = this;
                File file = com.getFile().getCanonicalFile();
                _log.log("saveFileAs called on " + file);
                OpenDefinitionsDocument otherDoc = AbstractGlobalModel.this._getOpenDocument(file);
                boolean bl = openInOtherDoc = otherDoc != null && openDoc != otherDoc;
                if (openInOtherDoc && !(shouldOverwrite = com.warnFileOpen(file))) {
                    return true;
                }
                if (!file.exists() || com.verifyOverwrite()) {
                    if (!file.getCanonicalFile().getName().equals(file.getName())) {
                        file.renameTo(file);
                    }
                    if (file.getAbsolutePath().indexOf("#") != -1) {
                        AbstractGlobalModel.this._notifier.filePathContainsPound();
                    }
                    if (file.exists() && !file.canWrite()) {
                        File[] res;
                        for (File roFile : res = AbstractGlobalModel.this._notifier.filesReadOnly(file)) {
                            FileOps.makeWritable(roFile);
                        }
                        if (res.length == 0) {
                            return false;
                        }
                    }
                    FileOps.saveFile(new FileOps.DefaultFileSaver(file){

                        public void saveTo(OutputStream os) throws IOException {
                            DefinitionsDocument dd = ConcreteOpenDefDoc.this.getDocument();
                            try {
                                AbstractGlobalModel.this._editorKit.write(os, (Document)dd, 0, dd.getLength());
                            }
                            catch (BadLocationException docFailed) {
                                throw new UnexpectedException(docFailed);
                            }
                        }
                    });
                    this.resetModification();
                    if (!oldFile.equals(file)) {
                        this.removeFromDebugger();
                        AbstractGlobalModel.this._breakpointManager.removeRegions(this);
                        AbstractGlobalModel.this._bookmarkManager.removeRegions(this);
                        for (RegionManager<MovingDocumentRegion> rm : AbstractGlobalModel.this.getFindResultsManagers()) {
                            rm.removeRegions(this);
                        }
                        this.clearBrowserRegions();
                    }
                    AbstractMap abstractMap = AbstractGlobalModel.this._documentsRepos;
                    synchronized (abstractMap) {
                        File f = this.getRawFile();
                        AbstractGlobalModel.this._documentsRepos.remove(f);
                        AbstractGlobalModel.this._documentsRepos.put(file, this);
                    }
                    this.setFile(file);
                    this.setCachedClassFile(FileOps.NULL_FILE);
                    this.checkIfClassFileInSync();
                    AbstractGlobalModel.this._notifier.fileSaved(openDoc);
                    AbstractGlobalModel.this.addDocToClassPath(this);
                    AbstractGlobalModel.this._documentNavigator.refreshDocument(this, AbstractGlobalModel.this.fixPathForNavigator(file.getCanonicalPath()));
                    AbstractGlobalModel.this.setProjectChanged(true);
                }
                return true;
            }
            catch (OperationCanceledException oce) {
                return false;
            }
        }

        @Override
        public void preparePrintJob() throws BadLocationException, FileMovedException {
            String fileName = "(Untitled)";
            File sourceFile = this.getFile();
            if (!AbstractGlobalModel.isUntitled(sourceFile)) {
                fileName = sourceFile.getAbsolutePath();
            }
            this._book = new DrJavaBook(this.getDocument().getText(), fileName, AbstractGlobalModel.this._pageFormat);
        }

        @Override
        public void print() throws PrinterException, BadLocationException, FileMovedException {
            this.preparePrintJob();
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setPageable(this._book);
            if (printJob.printDialog()) {
                printJob.print();
            }
            this.cleanUpPrintJob();
        }

        @Override
        public void startCompile() throws IOException {
            throw new UnsupportedOperationException("AbstractGlobalModel does not support compilation");
        }

        @Override
        public void runMain() throws IOException, ClassNameNotFoundException {
            throw new UnsupportedOperationException("AbstractGlobalModel does not support running");
        }

        @Override
        public void startJUnit() throws IOException, ClassNotFoundException {
            throw new UnsupportedOperationException("AbstractGlobalModel does not support unit testing");
        }

        @Override
        public void generateJavadoc(FileSaveSelector saver) throws IOException {
            throw new UnsupportedOperationException("AbstractGlobalModel does not support javadoc");
        }

        @Override
        public boolean isReady() {
            return this._cacheAdapter != null && this._cacheAdapter.isReady();
        }

        @Override
        public boolean isModifiedSinceSave() {
            if (this.isReady()) {
                return this.getDocument().isModifiedSinceSave();
            }
            return false;
        }

        @Override
        public void documentSaved() {
            this._cacheAdapter.documentSaved();
        }

        @Override
        public void documentModified() {
            this._cacheAdapter.documentModified();
            this._classFileInSync = false;
        }

        @Override
        public void documentReset() {
            this._cacheAdapter.documentReset();
        }

        @Override
        public boolean modifiedOnDisk() {
            boolean ret = false;
            File f = this._file;
            if (!AbstractGlobalModel.isUntitled(f)) {
                ret = f.lastModified() > this._timestamp;
            }
            return ret;
        }

        @Override
        public boolean checkIfClassFileInSync() {
            File sourceFile;
            _log.log("checkIfClassFileInSync() called for " + this);
            if (this.isEmpty()) {
                return true;
            }
            if (this.isModifiedSinceSave()) {
                this.setClassFileInSync(false);
                _log.log("checkIfClassFileInSync = false because isModifiedSinceSave()");
                return false;
            }
            File classFile = this.getCachedClassFile();
            _log.log("In checkIfClassFileInSync cacched value of classFile = " + classFile);
            if (classFile == FileOps.NULL_FILE) {
                classFile = this._locateClassFile();
                _log.log(this + ": in checkIfClassFileInSync _locateClassFile() = " + classFile);
                this.setCachedClassFile(classFile);
                if (classFile == FileOps.NULL_FILE || !classFile.exists()) {
                    _log.log(this + ": Could not find class file");
                    this.setClassFileInSync(false);
                    return false;
                }
            }
            try {
                sourceFile = this.getFile();
            }
            catch (FileMovedException fme) {
                this.setClassFileInSync(false);
                _log.log(this + ": File moved");
                return false;
            }
            if (sourceFile != null) {
                _log.log(sourceFile + " has timestamp " + sourceFile.lastModified());
                _log.log(classFile + " has timestamp " + classFile.lastModified());
            }
            if (sourceFile == null || sourceFile.lastModified() > classFile.lastModified()) {
                this.setClassFileInSync(false);
                _log.log(this + ": date stamps indicate modification");
                return false;
            }
            this.setClassFileInSync(true);
            return true;
        }

        private File _locateClassFile() {
            ArrayList<File> roots;
            String fileName;
            block12: {
                String className;
                if (this.isUntitled()) {
                    return FileOps.NULL_FILE;
                }
                try {
                    className = this.getDocument().getQualifiedClassName();
                }
                catch (ClassNameNotFoundException cnnfe) {
                    _log.log("_locateClassFile() failed for " + this + " because getQualifedClassName returned ClassNotFound");
                    return FileOps.NULL_FILE;
                }
                String ps = System.getProperty("file.separator");
                className = StringOps.replace(className, ".", ps);
                fileName = className + ".class";
                roots = new ArrayList<File>();
                if (AbstractGlobalModel.this.getBuildDirectory() != FileOps.NULL_FILE) {
                    roots.add(AbstractGlobalModel.this.getBuildDirectory());
                }
                try {
                    File root = this.getSourceRoot();
                    roots.add(root);
                }
                catch (InvalidPackageException ipe) {
                    try {
                        File root = this.getFile().getParentFile();
                        if (root != FileOps.NULL_FILE) {
                            roots.add(root);
                        }
                    }
                    catch (NullPointerException e) {
                        throw new UnexpectedException(e);
                    }
                    catch (FileMovedException fme) {
                        _log.log("File for " + this + "has moved; adding parent directory to list of roots");
                        File root = fme.getFile().getParentFile();
                        if (root == FileOps.NULL_FILE) break block12;
                        roots.add(root);
                    }
                }
            }
            File classFile = AbstractGlobalModel.this.findFileInPaths(fileName, roots);
            if (classFile != FileOps.NULL_FILE) {
                return classFile;
            }
            classFile = AbstractGlobalModel.this.findFileInPaths(fileName, GlobalModel.RUNTIME_CLASS_PATH);
            if (classFile != FileOps.NULL_FILE) {
                return classFile;
            }
            Vector cpSetting = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTRA_CLASSPATH));
            return AbstractGlobalModel.this.findFileInPaths(fileName, cpSetting);
        }

        @Override
        public boolean revertIfModifiedOnDisk() throws IOException {
            ConcreteOpenDefDoc doc = this;
            if (this.modifiedOnDisk()) {
                boolean shouldRevert = AbstractGlobalModel.this._notifier.shouldRevertFile(doc);
                if (shouldRevert) {
                    doc.revertFile();
                }
                return shouldRevert;
            }
            return false;
        }

        @Override
        public void close() {
            this.removeFromDebugger();
            this._cacheAdapter.close();
        }

        @Override
        public void revertFile() throws IOException {
            ConcreteOpenDefDoc doc = this;
            if (doc.isUntitled()) {
                throw new UnexpectedException("Cannot revert an Untitled file!");
            }
            this.removeFromDebugger();
            AbstractGlobalModel.this._breakpointManager.removeRegions(this);
            AbstractGlobalModel.this._bookmarkManager.removeRegions(this);
            for (RegionManager<MovingDocumentRegion> rm : AbstractGlobalModel.this.getFindResultsManagers()) {
                rm.removeRegions(this);
            }
            doc.clearBrowserRegions();
            try {
                File file = doc.getFile();
                FileReader reader = new FileReader(file);
                doc.clear();
                AbstractGlobalModel.this._editorKit.read(reader, (Document)doc, 0);
                reader.close();
                this.resetModification();
                doc.checkIfClassFileInSync();
                this.setCurrentLocation(0);
                AbstractGlobalModel.this._notifier.fileReverted(doc);
            }
            catch (BadLocationException e) {
                throw new UnexpectedException(e);
            }
        }

        @Override
        public boolean canAbandonFile() {
            if (this.isUntitledAndEmpty()) {
                return true;
            }
            File f = this._file;
            if (this.isModifiedSinceSave() || !AbstractGlobalModel.isUntitled(f) && !f.exists() && this._cacheAdapter.isReady()) {
                return AbstractGlobalModel.this._notifier.canAbandonFile(this);
            }
            return true;
        }

        @Override
        public boolean quitFile() {
            assert (EventQueue.isDispatchThread());
            File f = this._file;
            if (this.isModifiedSinceSave() || f != null && !f.exists() && this._cacheAdapter.isReady()) {
                return AbstractGlobalModel.this._notifier.quitFile(this);
            }
            return true;
        }

        @Override
        public int gotoLine(int line) {
            int offset = this.getOffsetOfLine(line - 1);
            this.setCurrentLocation(offset);
            return offset;
        }

        @Override
        public void setCurrentLocation(int location) {
            this.getDocument().setCurrentLocation(location);
        }

        @Override
        public int getCurrentLocation() {
            return this.getDocument().getCurrentLocation();
        }

        @Override
        public int balanceBackward() {
            return this.getDocument().balanceBackward();
        }

        @Override
        public int balanceForward() {
            return this.getDocument().balanceForward();
        }

        @Override
        public RegionManager<Breakpoint> getBreakpointManager() {
            return AbstractGlobalModel.this._breakpointManager;
        }

        @Override
        public RegionManager<MovingDocumentRegion> getBookmarkManager() {
            return AbstractGlobalModel.this._bookmarkManager;
        }

        @Override
        public void clearBrowserRegions() {
            BrowserDocumentRegion[] regions;
            for (BrowserDocumentRegion r : regions = this._browserRegions.toArray(new BrowserDocumentRegion[0])) {
                AbstractGlobalModel.this._browserHistoryManager.remove(r);
            }
            this._browserRegions.clear();
        }

        @Override
        public void removeFromDebugger() {
        }

        public String toString() {
            return this.getFileName();
        }

        @Override
        public int compareTo(OpenDefinitionsDocument o) {
            int diff = this.hashCode() - o.hashCode();
            if (diff != 0) {
                return diff;
            }
            return this._lexiName.compareTo(o.getLexiName());
        }

        @Override
        public void addDocumentListener(DocumentListener listener) {
            if (this._cacheAdapter.isReady()) {
                this.getDocument().addDocumentListener(listener);
            } else {
                this._cacheAdapter.addDocumentListener(listener);
            }
        }

        @Override
        public void addUndoableEditListener(UndoableEditListener listener) {
            this.getDocument().addUndoableEditListener(listener);
        }

        @Override
        public void removeUndoableEditListener(UndoableEditListener listener) {
            this.getDocument().removeUndoableEditListener(listener);
        }

        @Override
        public UndoableEditListener[] getUndoableEditListeners() {
            return this.getDocument().getUndoableEditListeners();
        }

        @Override
        public Position createUnwrappedPosition(int offs) throws BadLocationException {
            return this.getDocument().createUnwrappedPosition(offs);
        }

        @Override
        public Position createPosition(int offs) throws BadLocationException {
            return this.getDocument().createPosition(offs);
        }

        @Override
        public Element getDefaultRootElement() {
            return this.getDocument().getDefaultRootElement();
        }

        @Override
        public Position getStartPosition() {
            throw new UnsupportedOperationException("ConcreteOpenDefDoc does not support getStartPosition()");
        }

        @Override
        public Position getEndPosition() {
            throw new UnsupportedOperationException("ConcreteOpenDefDoc does not support getEndPosition()");
        }

        @Override
        public int getLength() {
            return this._cacheAdapter.getLength();
        }

        @Override
        public Object getProperty(Object key) {
            return this.getDocument().getProperty(key);
        }

        @Override
        public Element[] getRootElements() {
            return this.getDocument().getRootElements();
        }

        @Override
        public String getText() {
            return this._cacheAdapter.getText();
        }

        @Override
        public String getText(int offset, int length) throws BadLocationException {
            return this._cacheAdapter.getText(offset, length);
        }

        @Override
        public void getText(int offset, int length, Segment txt) throws BadLocationException {
            this.getDocument().getText(offset, length, txt);
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            this.getDocument().insertString(offset, str, a);
        }

        @Override
        public void append(String str, AttributeSet set) {
            this.getDocument().append(str, set);
        }

        public void append(String str, Style style) {
            this.getDocument().append(str, style);
        }

        public void append(String str) {
            this.getDocument().append(str);
        }

        @Override
        public void putProperty(Object key, Object value) {
            this.getDocument().putProperty(key, value);
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            this.getDocument().remove(offs, len);
        }

        @Override
        public void removeDocumentListener(DocumentListener listener) {
            this.getDocument().removeDocumentListener(listener);
        }

        @Override
        public void render(Runnable r) {
            this.getDocument().render(r);
        }

        @Override
        public boolean undoManagerCanUndo() {
            return this._cacheAdapter.isReady() && this.getUndoManager().canUndo();
        }

        @Override
        public boolean undoManagerCanRedo() {
            return this._cacheAdapter.isReady() && this.getUndoManager().canRedo();
        }

        @Override
        public CompoundUndoManager getUndoManager() {
            return this.getDocument().getUndoManager();
        }

        @Override
        public int _getLineStartPos(int pos) {
            DefinitionsDocument doc = this.getDocument();
            return doc._getLineStartPos(pos);
        }

        @Override
        public int _getLineEndPos(int pos) {
            DefinitionsDocument doc = this.getDocument();
            return doc._getLineEndPos(pos);
        }

        @Override
        public int commentLines(int selStart, int selEnd) {
            return this.getDocument().commentLines(selStart, selEnd);
        }

        @Override
        public int uncommentLines(int selStart, int selEnd) {
            return this.getDocument().uncommentLines(selStart, selEnd);
        }

        @Override
        public void indentLines(int selStart, int selEnd) {
            DefinitionsDocument doc = this.getDocument();
            doc.indentLines(selStart, selEnd);
        }

        @Override
        public void indentLines(int selStart, int selEnd, Indenter.IndentReason reason, ProgressMonitor pm) throws OperationCanceledException {
            DefinitionsDocument doc = this.getDocument();
            doc.indentLines(selStart, selEnd, reason, pm);
        }

        @Override
        public int getCurrentLine() {
            return this.getDocument().getCurrentLine();
        }

        @Override
        public int getCurrentCol() {
            return this.getDocument().getCurrentCol();
        }

        @Override
        public int getIntelligentBeginLinePos(int currPos) throws BadLocationException {
            return this.getDocument().getIntelligentBeginLinePos(currPos);
        }

        @Override
        public int _getOffset(int lineNum) {
            return this.getDocument()._getOffset(lineNum);
        }

        @Override
        public String getQualifiedClassName() throws ClassNameNotFoundException {
            return this.getDocument().getQualifiedClassName();
        }

        @Override
        public String getQualifiedClassName(int pos) throws ClassNameNotFoundException {
            return this.getDocument().getQualifiedClassName(pos);
        }

        @Override
        public ReducedModelState getStateAtCurrent() {
            return this.getDocument().getStateAtCurrent();
        }

        @Override
        public void resetUndoManager() {
            if (this._cacheAdapter.isReady()) {
                this.getDocument().resetUndoManager();
            }
        }

        @Override
        public DocumentListener[] getDocumentListeners() {
            return this.getDocument().getDocumentListeners();
        }

        @Override
        public String getEnclosingClassName(int pos, boolean fullyQualified) throws BadLocationException, ClassNameNotFoundException {
            return this.getDocument().getEnclosingClassName(pos, fullyQualified);
        }

        @Override
        public int findPrevEnclosingBrace(int pos, char opening, char closing) throws BadLocationException {
            return this.getDocument().findPrevEnclosingBrace(pos, opening, closing);
        }

        @Override
        public int findNextEnclosingBrace(int pos, char opening, char closing) throws BadLocationException {
            return this.getDocument().findNextEnclosingBrace(pos, opening, closing);
        }

        @Override
        public int getFirstNonWSCharPos(int pos) throws BadLocationException {
            return this.getDocument().getFirstNonWSCharPos(pos);
        }

        @Override
        public int getFirstNonWSCharPos(int pos, boolean acceptComments) throws BadLocationException {
            return this.getDocument().getFirstNonWSCharPos(pos, acceptComments);
        }

        @Override
        public int getFirstNonWSCharPos(int pos, char[] whitespace, boolean acceptComments) throws BadLocationException {
            return this.getDocument().getFirstNonWSCharPos(pos, whitespace, acceptComments);
        }

        @Override
        public int _getLineFirstCharPos(int pos) throws BadLocationException {
            return this.getDocument()._getLineFirstCharPos(pos);
        }

        @Override
        public int findCharOnLine(int pos, char findChar) {
            return this.getDocument().findCharOnLine(pos, findChar);
        }

        @Override
        public int _getIndentOfCurrStmt(int pos) throws BadLocationException {
            return this.getDocument()._getIndentOfCurrStmt(pos);
        }

        @Override
        public int _getIndentOfCurrStmt(int pos, char[] delims) throws BadLocationException {
            return this.getDocument()._getIndentOfCurrStmt(pos, delims);
        }

        @Override
        public int _getIndentOfCurrStmt(int pos, char[] delims, char[] whitespace) throws BadLocationException {
            return this.getDocument()._getIndentOfCurrStmt(pos, delims, whitespace);
        }

        @Override
        public int findPrevDelimiter(int pos, char[] delims) throws BadLocationException {
            return this.getDocument().findPrevDelimiter(pos, delims);
        }

        @Override
        public int findPrevDelimiter(int pos, char[] delims, boolean skipParenPhrases) throws BadLocationException {
            return this.getDocument().findPrevDelimiter(pos, delims, skipParenPhrases);
        }

        @Override
        public void move(int dist) {
            this.getDocument().move(dist);
        }

        @Override
        public ArrayList<HighlightStatus> getHighlightStatus(int start, int end) {
            return this.getDocument().getHighlightStatus(start, end);
        }

        @Override
        public void setIndent(int indent) {
            this.getDocument().setIndent(indent);
        }

        @Override
        public int getIndent() {
            return this.getDocument().getIndent();
        }

        @Override
        public void addFinalizationListener(FinalizationListener<DefinitionsDocument> fl) {
            this.getDocument().addFinalizationListener(fl);
        }

        @Override
        public List<FinalizationListener<DefinitionsDocument>> getFinalizationListeners() {
            return this.getDocument().getFinalizationListeners();
        }

        @Override
        public Font getFont(AttributeSet attr) {
            return this.getDocument().getFont(attr);
        }

        @Override
        public Color getBackground(AttributeSet attr) {
            return this.getDocument().getBackground(attr);
        }

        @Override
        public Color getForeground(AttributeSet attr) {
            return this.getDocument().getForeground(attr);
        }

        @Override
        public Element getCharacterElement(int pos) {
            return this.getDocument().getCharacterElement(pos);
        }

        @Override
        public Element getParagraphElement(int pos) {
            return this.getDocument().getParagraphElement(pos);
        }

        @Override
        public Style getLogicalStyle(int p) {
            return this.getDocument().getLogicalStyle(p);
        }

        @Override
        public void setLogicalStyle(int pos, Style s) {
            this.getDocument().setLogicalStyle(pos, s);
        }

        @Override
        public void setCharacterAttributes(int offset, int length, AttributeSet s, boolean replace) {
            this.getDocument().setCharacterAttributes(offset, length, s, replace);
        }

        @Override
        public void setParagraphAttributes(int offset, int length, AttributeSet s, boolean replace) {
            this.getDocument().setParagraphAttributes(offset, length, s, replace);
        }

        @Override
        public Style getStyle(String nm) {
            return this.getDocument().getStyle(nm);
        }

        @Override
        public void removeStyle(String nm) {
            this.getDocument().removeStyle(nm);
        }

        @Override
        public Style addStyle(String nm, Style parent) {
            return this.getDocument().addStyle(nm, parent);
        }

        @Override
        public void clear() {
            this.getDocument().clear();
        }

        @Override
        public ReducedModelControl getReduced() {
            return this.getDocument().getReduced();
        }

        @Override
        public int getNumberOfLines() {
            return this.getLineOfOffset(this.getLength());
        }

        @Override
        public boolean isShadowed(int pos) {
            return this.getDocument().isShadowed(pos);
        }

        @Override
        public int getLineOfOffset(int offset) {
            return this.getDefaultRootElement().getElementIndex(offset);
        }

        @Override
        public int getOffsetOfLine(int line) {
            int count = this.getDefaultRootElement().getElementCount();
            if (line >= count) {
                line = count - 1;
            }
            return this.getDefaultRootElement().getElement(line).getStartOffset();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FlatFileGroupingState
    implements FileGroupingState {
        FlatFileGroupingState() {
        }

        @Override
        public File getBuildDirectory() {
            return FileOps.NULL_FILE;
        }

        @Override
        public File getProjectRoot() {
            return this.getWorkingDirectory();
        }

        @Override
        public File getWorkingDirectory() {
            Iterable<File> roots = AbstractGlobalModel.this.getSourceRootSet();
            if (!IterUtil.isEmpty(roots)) {
                return IterUtil.first(roots);
            }
            File file = FileOps.NULL_FILE;
            if (DrJava.getConfig().getSetting(OptionConstants.STICKY_INTERACTIONS_DIRECTORY).booleanValue()) {
                try {
                    file = FileOps.getValidDirectory(DrJava.getConfig().getSetting(OptionConstants.LAST_INTERACTIONS_DIRECTORY));
                }
                catch (RuntimeException e) {
                    file = FileOps.NULL_FILE;
                }
            }
            if (file == FileOps.NULL_FILE) {
                file = FileOps.getValidDirectory(new File(System.getProperty("user.home", ".")));
            }
            DrJava.getConfig().setSetting(OptionConstants.LAST_INTERACTIONS_DIRECTORY, file);
            return file;
        }

        @Override
        public boolean isProjectActive() {
            return false;
        }

        @Override
        public boolean inProjectPath(OpenDefinitionsDocument doc) {
            return false;
        }

        @Override
        public boolean inProjectPath(File f) {
            return false;
        }

        @Override
        public File getProjectFile() {
            return FileOps.NULL_FILE;
        }

        @Override
        public void setBuildDirectory(File f) {
        }

        @Override
        public void setProjectFile(File f) {
        }

        @Override
        public void setProjectRoot(File f) {
        }

        @Override
        public void addAuxFile(File f) {
        }

        @Override
        public void remAuxFile(File f) {
        }

        @Override
        public void setWorkingDirectory(File f) {
        }

        @Override
        public File[] getProjectFiles() {
            return new File[0];
        }

        @Override
        public boolean inProject(File f) {
            return false;
        }

        @Override
        public File getMainClass() {
            return null;
        }

        @Override
        public void setMainClass(File f) {
        }

        @Override
        public void setCreateJarFile(File f) {
        }

        @Override
        public File getCreateJarFile() {
            return FileOps.NULL_FILE;
        }

        @Override
        public void setCreateJarFlags(int f) {
        }

        @Override
        public int getCreateJarFlags() {
            return 0;
        }

        @Override
        public Iterable<File> getExtraClassPath() {
            return IterUtil.empty();
        }

        @Override
        public void setExtraClassPath(Iterable<File> cp) {
        }

        @Override
        public boolean isProjectChanged() {
            return false;
        }

        @Override
        public void setProjectChanged(boolean changed) {
        }

        @Override
        public boolean isAuxiliaryFile(File f) {
            return false;
        }

        @Override
        public boolean isExcludedFile(File f) {
            return false;
        }

        @Override
        public File[] getExclFiles() {
            return null;
        }

        @Override
        public void addExcludedFile(File f) {
        }

        @Override
        public void removeExcludedFile(File f) {
        }

        @Override
        public void setExcludedFiles(File[] fs) {
        }

        @Override
        public boolean getAutoRefreshStatus() {
            return false;
        }

        @Override
        public void setAutoRefreshStatus(boolean b) {
        }

        @Override
        public void cleanBuildDirectory() {
        }

        @Override
        public List<File> getClassFiles() {
            return new LinkedList<File>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProjectFileGroupingState
    implements FileGroupingState {
        volatile File _projRoot;
        volatile File _mainFile;
        volatile File _buildDir;
        volatile File _workDir;
        volatile File _projectFile;
        final File[] _projectFiles;
        volatile ArrayList<File> _auxFiles;
        private volatile ArrayList<File> _exclFiles;
        volatile Iterable<File> _projExtraClassPath;
        private boolean _isProjectChanged = false;
        volatile File _createJarFile;
        volatile int _createJarFlags;
        volatile boolean _autoRefreshStatus;
        HashSet<String> _projFilePaths = new HashSet();
        private AsyncTask<File, List<File>> _findFilesToCleanTask = new AsyncTask<File, List<File>>("Find Files to Clean"){
            private FilenameFilter _filter;
            {
                this._filter = new FilenameFilter(){

                    public boolean accept(File parent, String name) {
                        return new File(parent, name).isDirectory() || name.endsWith(".class");
                    }
                };
            }

            @Override
            public List<File> runAsync(File buildDir, IAsyncProgress monitor) throws Exception {
                LinkedList<File> accumulator = new LinkedList<File>();
                this.helper(buildDir, accumulator);
                return accumulator;
            }

            @Override
            public void complete(AsyncCompletionArgs<List<File>> args) {
                AbstractGlobalModel.this._notifier.executeAsyncTask(ProjectFileGroupingState.this._deleteFilesTask, args.getResult(), true, true);
            }

            @Override
            public String getDiscriptionMessage() {
                return "Finding files to delete...";
            }

            private void helper(File file, List<File> accumulator) {
                if (file.isDirectory()) {
                    File[] children;
                    for (File child : children = file.listFiles(this._filter)) {
                        this.helper(child, accumulator);
                        accumulator.add(file);
                    }
                } else if (file.getName().endsWith(".class")) {
                    accumulator.add(file);
                }
            }
        };
        private AsyncTask<List<File>, List<File>> _deleteFilesTask = new AsyncTask<List<File>, List<File>>("Delete Files"){

            @Override
            public List<File> runAsync(List<File> filesToDelete, IAsyncProgress monitor) throws Exception {
                ArrayList<File> undeletableFiles = new ArrayList<File>();
                monitor.setMinimum(0);
                monitor.setMaximum(filesToDelete.size());
                int progress = 1;
                for (File file : filesToDelete) {
                    if (monitor.isCanceled()) break;
                    monitor.setNote(file.getName());
                    boolean could = file.delete();
                    if (!could) {
                        undeletableFiles.add(file);
                    }
                    monitor.setProgress(progress++);
                }
                return undeletableFiles;
            }

            @Override
            public void complete(AsyncCompletionArgs<List<File>> args) {
            }

            @Override
            public String getDiscriptionMessage() {
                return "Deleting files...";
            }
        };

        ProjectFileGroupingState(File project) {
            this(project.getParentFile(), null, null, null, project, new File[0], new File[0], new File[0], IterUtil.empty(), null, 0, false);
        }

        ProjectFileGroupingState(File pr, File main, File bd, File wd, File project, File[] srcFiles, File[] auxFiles, File[] excludedFiles, Iterable<File> cp, File cjf, int cjflags, boolean refreshStatus) {
            this._projRoot = pr;
            this._mainFile = main;
            this._buildDir = bd;
            this._workDir = wd;
            this._projectFile = project;
            this._projectFiles = srcFiles;
            this._auxFiles = new ArrayList(auxFiles.length);
            for (File f : auxFiles) {
                this._auxFiles.add(f);
            }
            this._exclFiles = new ArrayList(excludedFiles.length);
            for (File f : excludedFiles) {
                this._exclFiles.add(f);
            }
            this._projExtraClassPath = cp;
            if (this._projectFiles != null) {
                try {
                    for (File file : this._projectFiles) {
                        this._projFilePaths.add(file.getCanonicalPath());
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            this._createJarFile = cjf;
            this._createJarFlags = cjflags;
            this._autoRefreshStatus = refreshStatus;
        }

        @Override
        public boolean isProjectActive() {
            return true;
        }

        @Override
        public boolean inProjectPath(OpenDefinitionsDocument doc) {
            File f;
            if (doc.isUntitled()) {
                return false;
            }
            try {
                f = doc.getFile();
            }
            catch (FileMovedException fme) {
                f = fme.getFile();
            }
            return this.inProjectPath(f);
        }

        @Override
        public boolean inProjectPath(File f) {
            return IOUtil.isMember(f, this.getProjectRoot());
        }

        @Override
        public File getProjectFile() {
            return this._projectFile;
        }

        @Override
        public boolean inProject(File f) {
            if (AbstractGlobalModel.isUntitled(f) || !this.inProjectPath(f)) {
                return false;
            }
            try {
                String path = f.getCanonicalPath();
                return this._projFilePaths.contains(path);
            }
            catch (IOException ioe) {
                return false;
            }
        }

        @Override
        public File[] getProjectFiles() {
            return this._projectFiles;
        }

        @Override
        public File getProjectRoot() {
            if (this._projRoot == null || this._projRoot.equals(FileOps.NULL_FILE)) {
                return this._projectFile.getParentFile();
            }
            return this._projRoot;
        }

        @Override
        public File getBuildDirectory() {
            return this._buildDir;
        }

        @Override
        public File getWorkingDirectory() {
            try {
                if (this._workDir == null || this._workDir == FileOps.NULL_FILE) {
                    File parentDir = this._projectFile.getParentFile();
                    if (parentDir != null) {
                        return parentDir.getCanonicalFile();
                    }
                    return new File(System.getProperty("user.dir"));
                }
                return this._workDir.getCanonicalFile();
            }
            catch (IOException iOException) {
                return this._workDir.getAbsoluteFile();
            }
        }

        @Override
        public void setProjectFile(File f) {
            this._projectFile = f;
        }

        @Override
        public void setProjectRoot(File f) {
            this._projRoot = f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addAuxFile(File f) {
            ArrayList<File> arrayList = this._auxFiles;
            synchronized (arrayList) {
                if (this._auxFiles.add(f)) {
                    this.setProjectChanged(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remAuxFile(File file) {
            ArrayList<File> arrayList = this._auxFiles;
            synchronized (arrayList) {
                if (this._auxFiles.remove(file)) {
                    this.setProjectChanged(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addExcludedFile(File f) {
            if (f == null) {
                return;
            }
            if (AbstractGlobalModel.this.isAlreadyOpen(f)) {
                return;
            }
            ArrayList<File> arrayList = this._exclFiles;
            synchronized (arrayList) {
                if (this._exclFiles.add(f)) {
                    this.setProjectChanged(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeExcludedFile(File f) {
            ArrayList<File> arrayList = this._exclFiles;
            synchronized (arrayList) {
                for (int i = 0; i < this._exclFiles.size(); ++i) {
                    try {
                        if (!this._exclFiles.get(i).getCanonicalPath().equals(f.getCanonicalPath())) continue;
                        this._exclFiles.remove(i);
                        this.setProjectChanged(true);
                        continue;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public File[] getExclFiles() {
            return this._exclFiles.toArray(new File[this._exclFiles.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setExcludedFiles(File[] fs) {
            if (fs == null) {
                return;
            }
            ArrayList<File> arrayList = this._exclFiles;
            synchronized (arrayList) {
                this._exclFiles.clear();
                for (File f : fs) {
                    this.addExcludedFile(f);
                }
                this.setProjectChanged(true);
            }
        }

        @Override
        public void setBuildDirectory(File f) {
            this._buildDir = f;
        }

        @Override
        public void setWorkingDirectory(File f) {
            this._workDir = f;
        }

        @Override
        public File getMainClass() {
            return this._mainFile;
        }

        @Override
        public void setMainClass(File f) {
            this._mainFile = f;
        }

        @Override
        public void setCreateJarFile(File f) {
            this._createJarFile = f;
        }

        @Override
        public File getCreateJarFile() {
            return this._createJarFile;
        }

        @Override
        public void setCreateJarFlags(int f) {
            this._createJarFlags = f;
        }

        @Override
        public int getCreateJarFlags() {
            return this._createJarFlags;
        }

        @Override
        public boolean isProjectChanged() {
            return this._isProjectChanged;
        }

        @Override
        public void setProjectChanged(boolean changed) {
            this._isProjectChanged = changed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isAuxiliaryFile(File f) {
            String path;
            if (AbstractGlobalModel.isUntitled(f)) {
                return false;
            }
            try {
                path = f.getCanonicalPath();
            }
            catch (IOException ioe) {
                return false;
            }
            ArrayList<File> arrayList = this._auxFiles;
            synchronized (arrayList) {
                for (File file : this._auxFiles) {
                    try {
                        if (!file.getCanonicalPath().equals(path)) continue;
                        return true;
                    }
                    catch (IOException ioe) {
                    }
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isExcludedFile(File f) {
            String path;
            if (AbstractGlobalModel.isUntitled(f)) {
                return false;
            }
            try {
                path = f.getCanonicalPath();
            }
            catch (IOException ioe) {
                return false;
            }
            ArrayList<File> arrayList = this._exclFiles;
            synchronized (arrayList) {
                for (File file : this._exclFiles) {
                    try {
                        if (!file.getCanonicalPath().equals(path)) continue;
                        return true;
                    }
                    catch (IOException ioe) {
                    }
                }
                return false;
            }
        }

        @Override
        public boolean getAutoRefreshStatus() {
            return this._autoRefreshStatus;
        }

        @Override
        public void setAutoRefreshStatus(boolean status) {
            this._autoRefreshStatus = status;
        }

        @Override
        public void cleanBuildDirectory() {
            File dir = this.getBuildDirectory();
            AbstractGlobalModel.this._notifier.executeAsyncTask(this._findFilesToCleanTask, dir, false, true);
        }

        @Override
        public List<File> getClassFiles() {
            File dir = this.getBuildDirectory();
            LinkedList<File> acc = new LinkedList<File>();
            this.getClassFilesHelper(dir, acc);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return acc;
        }

        private void getClassFilesHelper(File f, LinkedList<File> acc) {
            if (f.isDirectory()) {
                File[] fs = f.listFiles(new FilenameFilter(){

                    public boolean accept(File parent, String name) {
                        return new File(parent, name).isDirectory() || name.endsWith(".class");
                    }
                });
                if (fs != null) {
                    for (File kid : fs) {
                        this.getClassFilesHelper(kid, acc);
                    }
                }
            } else if (f.getName().endsWith(".class")) {
                acc.add(f);
            }
        }

        @Override
        public Iterable<File> getExtraClassPath() {
            return this._projExtraClassPath;
        }

        @Override
        public void setExtraClassPath(Iterable<File> cp) {
            this._projExtraClassPath = cp;
            AbstractGlobalModel.this.setClassPathChanged(true);
        }
    }
}

