/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.model.BrowserDocumentRegion;
import edu.rice.cs.drjava.model.EventNotifier;
import edu.rice.cs.drjava.model.GlobalEventNotifier;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.RegionManagerListener;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.util.swing.Utilities;
import java.awt.EventQueue;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserHistoryManager
extends EventNotifier<RegionManagerListener<BrowserDocumentRegion>> {
    private volatile TreeSet<BrowserDocumentRegion> _regions = new TreeSet();
    private volatile BrowserDocumentRegion _current = null;
    private volatile int _maxSize;

    public BrowserHistoryManager(int size) {
        this._maxSize = size;
    }

    public BrowserHistoryManager() {
        this(0);
    }

    public void addBrowserRegion(final BrowserDocumentRegion r, GlobalEventNotifier notifier) {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        if (this._current != null) {
            SortedSet<BrowserDocumentRegion> tail = this._regions.tailSet(this._current);
            Iterator it = tail.iterator();
            if (it.hasNext()) {
                BrowserDocumentRegion nr = (BrowserDocumentRegion)it.next();
                assert (nr == this._current);
            }
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
        }
        this._current = r;
        this._regions.add(r);
        r.getDocument().addBrowserRegion(r);
        Utilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BrowserHistoryManager.this._lock.startRead();
                try {
                    for (RegionManagerListener l : BrowserHistoryManager.this._listeners) {
                        l.regionAdded(r);
                    }
                }
                finally {
                    BrowserHistoryManager.this._lock.endRead();
                }
            }
        });
        this.shrinkManager();
        notifier.browserChanged();
    }

    private void shrinkManager() {
        if (this._maxSize > 0) {
            int size = this._regions.size();
            int diff = size - this._maxSize;
            for (int i = 0; i < diff; ++i) {
                this.remove(this._regions.first());
            }
        }
    }

    public void remove(BrowserDocumentRegion r) {
        OpenDefinitionsDocument doc = r.getDocument();
        this._regions.remove(r);
        doc.removeBrowserRegion(r);
        this._current = this.next(r);
    }

    private BrowserDocumentRegion next(BrowserDocumentRegion r) {
        BrowserDocumentRegion next = this._higher(this._regions, r);
        if (next == null && !this._regions.isEmpty()) {
            next = this._regions.last();
        }
        return next;
    }

    public SortedSet<BrowserDocumentRegion> getRegions() {
        return this._regions;
    }

    public void clearBrowserRegions() {
        this._current = null;
        this._regions.clear();
    }

    public BrowserDocumentRegion getCurrentRegion() {
        return this._current;
    }

    public boolean isCurrentRegionFirst() {
        return !this._regions.isEmpty() && this._current == this._regions.first();
    }

    public boolean isCurrentRegionLast() {
        return !this._regions.isEmpty() && this._current == this._regions.last();
    }

    public void setCurrentRegion(BrowserDocumentRegion r) {
        this._current = r;
    }

    public BrowserDocumentRegion nextCurrentRegion(GlobalEventNotifier notifier) {
        if (this._regions.isEmpty()) {
            return null;
        }
        this._current = this._current == null ? this._regions.first() : this._higher(this._regions, this._current);
        notifier.browserChanged();
        return this._current;
    }

    public BrowserDocumentRegion prevCurrentRegion(GlobalEventNotifier notifier) {
        if (this._regions.isEmpty()) {
            return null;
        }
        this._current = this._current == null ? this._regions.last() : this._lower(this._regions, this._current);
        notifier.browserChanged();
        return this._current;
    }

    private BrowserDocumentRegion _lower(TreeSet<BrowserDocumentRegion> regions, BrowserDocumentRegion r) {
        if (this._regions.isEmpty()) {
            return null;
        }
        BrowserDocumentRegion least = this._regions.first();
        SortedSet<BrowserDocumentRegion> lowerSet = regions.subSet(least, r);
        if (lowerSet.isEmpty()) {
            return this._regions.first();
        }
        return lowerSet.last();
    }

    private BrowserDocumentRegion _higher(TreeSet<BrowserDocumentRegion> regions, BrowserDocumentRegion r) {
        if (this._regions.isEmpty()) {
            return null;
        }
        SortedSet<BrowserDocumentRegion> higherSet = regions.tailSet(r);
        for (BrowserDocumentRegion result : higherSet) {
            if (result.equals(r)) continue;
            return result;
        }
        return this._regions.last();
    }

    public void setMaximumSize(int size) {
        this._maxSize = size;
        this.shrinkManager();
    }

    public int getMaximumSize() {
        return this._maxSize;
    }

    public void changeRegion(final BrowserDocumentRegion region, Lambda<BrowserDocumentRegion, Object> cmd) {
        cmd.value(region);
        Utilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BrowserHistoryManager.this._lock.startRead();
                try {
                    for (RegionManagerListener l : BrowserHistoryManager.this._listeners) {
                        l.regionChanged(region);
                    }
                }
                finally {
                    BrowserHistoryManager.this._lock.endRead();
                }
            }
        });
    }
}

