/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.UnexpectedException;
import java.io.File;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DJError
implements Comparable<DJError>,
Serializable {
    private File _file;
    private final int _lineNumber;
    private final int _startColumn;
    private final String _message;
    private final boolean _isWarning;
    private boolean _noLocation;

    public DJError(File file, int lineNumber, int startColumn, String message, boolean isWarning) {
        if (message != null && message.indexOf("CompilerError") >= 0) {
            throw new UnexpectedException(message);
        }
        this._file = file;
        this._lineNumber = lineNumber;
        this._startColumn = startColumn;
        this._message = message;
        this._isWarning = isWarning;
        if (lineNumber < 0) {
            this._noLocation = true;
        }
    }

    public DJError(File file, String message, boolean isWarning) {
        this(file, -1, -1, message, isWarning);
    }

    public DJError(String message, boolean isWarning) {
        this(null, message, isWarning);
    }

    public boolean hasNoLocation() {
        return this._noLocation;
    }

    public String toString() {
        return this.getClass().toString() + "(file=" + this.fileName() + ", line=" + this._lineNumber + ", col=" + this._startColumn + ", msg=" + this._message + ")";
    }

    public File file() {
        return this._file;
    }

    public String fileName() {
        if (this._file == null) {
            return "";
        }
        return this._file.getAbsolutePath();
    }

    public int lineNumber() {
        return this._lineNumber;
    }

    public int startColumn() {
        return this._startColumn;
    }

    public String message() {
        return this._message;
    }

    public String getFileMessage() {
        if (this._file == null || this._file == FileOps.NULL_FILE) {
            return "(no associated file)";
        }
        return this.fileName();
    }

    public String getLineMessage() {
        if (this._file == null || this._file == FileOps.NULL_FILE || this._lineNumber < 0) {
            return "(no source location)";
        }
        return "" + (this._lineNumber + 1);
    }

    public boolean isWarning() {
        return this._isWarning;
    }

    @Override
    public int compareTo(DJError other) {
        if (this._file != null) {
            if (other.file() != null) {
                int fileComp = this._file.compareTo(other.file());
                if (fileComp != 0) {
                    return fileComp;
                }
                return this.compareByPosition(other);
            }
            return 1;
        }
        if (other.file() != null) {
            return -1;
        }
        return this.compareErrorWarning(other);
    }

    private int compareByPosition(DJError other) {
        int byLine = this._lineNumber - other.lineNumber();
        if (byLine != 0) {
            return byLine;
        }
        int byCol = this._startColumn - other.startColumn();
        if (byCol != 0) {
            return byCol;
        }
        return this.compareErrorWarning(other);
    }

    private int compareErrorWarning(DJError other) {
        return this.isWarning() ? (other.isWarning() ? 0 : 1) : (other.isWarning() ? -1 : 0);
    }
}

