/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.AbstractGlobalModel;
import edu.rice.cs.drjava.model.FileSaveSelector;
import edu.rice.cs.drjava.model.JDKToolsLibrary;
import edu.rice.cs.drjava.model.JarJDKToolsLibrary;
import edu.rice.cs.drjava.model.MovingDocumentRegion;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.RegionManagerListener;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.CompilerListener;
import edu.rice.cs.drjava.model.compiler.CompilerModel;
import edu.rice.cs.drjava.model.compiler.DefaultCompilerModel;
import edu.rice.cs.drjava.model.compiler.DummyCompilerListener;
import edu.rice.cs.drjava.model.debug.Breakpoint;
import edu.rice.cs.drjava.model.debug.DebugException;
import edu.rice.cs.drjava.model.debug.DebugListener;
import edu.rice.cs.drjava.model.debug.DebugThreadData;
import edu.rice.cs.drjava.model.debug.DebugWatchData;
import edu.rice.cs.drjava.model.debug.Debugger;
import edu.rice.cs.drjava.model.debug.NoDebuggerAvailable;
import edu.rice.cs.drjava.model.definitions.ClassNameNotFoundException;
import edu.rice.cs.drjava.model.definitions.InvalidPackageException;
import edu.rice.cs.drjava.model.javadoc.JavadocModel;
import edu.rice.cs.drjava.model.javadoc.NoJavadocAvailable;
import edu.rice.cs.drjava.model.junit.DefaultJUnitModel;
import edu.rice.cs.drjava.model.junit.JUnitModel;
import edu.rice.cs.drjava.model.repl.DefaultInteractionsModel;
import edu.rice.cs.drjava.model.repl.DummyInteractionsListener;
import edu.rice.cs.drjava.model.repl.InteractionsDJDocument;
import edu.rice.cs.drjava.model.repl.InteractionsDocument;
import edu.rice.cs.drjava.model.repl.InteractionsListener;
import edu.rice.cs.drjava.model.repl.InteractionsScriptModel;
import edu.rice.cs.drjava.model.repl.newjvm.MainJVM;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.util.FileOpenSelector;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.NullFile;
import edu.rice.cs.util.OperationCanceledException;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.Utilities;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGlobalModel
extends AbstractGlobalModel {
    protected final InteractionsDJDocument _interactionsDocument;
    final MainJVM _jvm;
    protected final DefaultInteractionsModel _interactionsModel;
    protected InteractionsListener _interactionsListener = new InteractionsListener(){

        public void interactionStarted() {
        }

        public void interactionEnded() {
        }

        public void interactionErrorOccurred(int offset, int length) {
        }

        public void interpreterResetting() {
        }

        public void interpreterReady(File wd) {
            File buildDir = DefaultGlobalModel.this._state.getBuildDirectory();
            if (buildDir != null) {
                DefaultGlobalModel.this._jvm.addBuildDirectoryClassPath(IOUtil.attemptAbsoluteFile(buildDir));
            }
        }

        public void interpreterResetFailed(Throwable t) {
        }

        public void interpreterExited(int status) {
        }

        public void interpreterChanged(boolean inProgress) {
        }

        public void interactionIncomplete() {
        }

        public void slaveJVMUsed() {
        }
    };
    private CompilerListener _clearInteractionsListener = new DummyCompilerListener(){

        @Override
        public void compileEnded(File workDir, List<? extends File> excludedFiles) {
            if ((DefaultGlobalModel.this._compilerModel.getNumErrors() == 0 || DefaultGlobalModel.this._compilerModel.getCompilerErrorModel().hasOnlyWarnings()) && !DefaultGlobalModel.this._junitModel.isTestInProgress() && DefaultGlobalModel.this._resetAfterCompile) {
                DefaultGlobalModel.this.resetInteractions(workDir);
            }
        }
    };
    private final CompilerModel _compilerModel;
    private volatile boolean _resetAfterCompile = true;
    private volatile int _numCompErrors = 0;
    private final DefaultJUnitModel _junitModel;
    protected volatile JavadocModel _javadocModel;
    private volatile Debugger _debugger;

    public DefaultGlobalModel() {
        Iterable<JDKToolsLibrary> tools = this.findLibraries();
        LinkedList<CompilerInterface> compilers = new LinkedList<CompilerInterface>();
        this._debugger = null;
        this._javadocModel = null;
        for (JDKToolsLibrary t : tools) {
            if (t.compiler().isAvailable()) {
                compilers.add(t.compiler());
            }
            if (this._debugger == null && t.debugger().isAvailable()) {
                this._debugger = t.debugger();
            }
            if (this._javadocModel != null || !t.javadoc().isAvailable()) continue;
            this._javadocModel = t.javadoc();
        }
        if (this._debugger == null) {
            this._debugger = NoDebuggerAvailable.ONLY;
        }
        if (this._javadocModel == null) {
            this._javadocModel = new NoJavadocAvailable(this);
        }
        File workDir = Utilities.TEST_MODE ? new File(System.getProperty("user.home")) : this.getWorkingDirectory();
        try {
            this._jvm = new MainJVM(workDir);
        }
        catch (ExportException e) {
            if (e.getMessage().equals("Listen failed on port: 0")) {
                throw new RuntimeException(e);
            }
            throw new UnexpectedException(e);
        }
        catch (RemoteException e) {
            throw new UnexpectedException(e);
        }
        this._compilerModel = new DefaultCompilerModel(this, compilers);
        this._junitModel = new DefaultJUnitModel(this._jvm, this._compilerModel, this);
        this._interactionsDocument = new InteractionsDJDocument();
        this._interactionsModel = new DefaultInteractionsModel(this, this._jvm, this._interactionsDocument, workDir);
        this._interactionsModel.addListener(this._interactionsListener);
        this._jvm.setInteractionsModel(this._interactionsModel);
        this._jvm.setJUnitModel(this._junitModel);
        StringBuilder sb = new StringBuilder();
        if (!"".equals(DrJava.getConfig().getSetting(SLAVE_JVM_XMX)) && !OptionConstants.heapSizeChoices.get(0).equals(DrJava.getConfig().getSetting(SLAVE_JVM_XMX))) {
            sb.append("-Xmx");
            sb.append(DrJava.getConfig().getSetting(SLAVE_JVM_XMX));
            sb.append("M ");
        }
        sb.append(DrJava.getConfig().getSetting(SLAVE_JVM_ARGS));
        this._jvm.setOptionArgs(sb.toString());
        OptionListener<String> updateListener = new OptionListener<String>(){

            @Override
            public void optionChanged(OptionEvent<String> oe) {
                StringBuilder sb = new StringBuilder();
                if (!"".equals(DrJava.getConfig().getSetting(OptionConstants.SLAVE_JVM_XMX)) && !OptionConstants.heapSizeChoices.get(0).equals(DrJava.getConfig().getSetting(OptionConstants.SLAVE_JVM_XMX))) {
                    sb.append("-Xmx");
                    sb.append(DrJava.getConfig().getSetting(OptionConstants.SLAVE_JVM_XMX));
                    sb.append("M ");
                }
                sb.append(DrJava.getConfig().getSetting(OptionConstants.SLAVE_JVM_ARGS));
                DefaultGlobalModel.this._jvm.setOptionArgs(sb.toString());
            }
        };
        DrJava.getConfig().addOptionListener(SLAVE_JVM_ARGS, updateListener);
        DrJava.getConfig().addOptionListener(SLAVE_JVM_XMX, updateListener);
        this._setupDebugger();
        this._interactionsModel.addListener(this._notifier);
        this._compilerModel.addListener(this._notifier);
        this._junitModel.addListener(this._notifier);
        this._javadocModel.addListener(this._notifier);
        this._compilerModel.addListener(this._clearInteractionsListener);
        this._jvm.startInterpreterJVM();
    }

    private Iterable<JDKToolsLibrary> findLibraries() {
        JarJDKToolsLibrary fromConfig;
        TreeMap<JavaVersion, JDKToolsLibrary> results = new TreeMap<JavaVersion, JDKToolsLibrary>();
        File configTools = DrJava.getConfig().getSetting(JAVAC_LOCATION);
        if (configTools != FileOps.NULL_FILE && (fromConfig = JarJDKToolsLibrary.makeFromFile(configTools, this)).isValid()) {
            results.put(fromConfig.version().majorVersion(), fromConfig);
        }
        JDKToolsLibrary fromRuntime = JDKToolsLibrary.makeFromRuntime(this);
        JavaVersion runtimeVersion = fromRuntime.version().majorVersion();
        if (fromRuntime.isValid() && !results.containsKey((Object)runtimeVersion)) {
            results.put(runtimeVersion, fromRuntime);
        }
        Iterable<JarJDKToolsLibrary> fromSearch = JarJDKToolsLibrary.search(this);
        for (JarJDKToolsLibrary t : fromSearch) {
            JavaVersion tVersion = t.version().majorVersion();
            if (results.containsKey((Object)tVersion)) continue;
            results.put(tVersion, t);
        }
        return IterUtil.reverse(results.values());
    }

    @Override
    public void setBuildDirectory(File f) {
        this._state.setBuildDirectory(f);
        if (f != FileOps.NULL_FILE) {
            this._jvm.addBuildDirectoryClassPath(IOUtil.attemptAbsoluteFile(f));
        }
        this._notifier.projectBuildDirChanged();
        this.setProjectChanged(true);
        this.setClassPathChanged(true);
    }

    @Override
    public DefaultInteractionsModel getInteractionsModel() {
        return this._interactionsModel;
    }

    @Override
    public InteractionsDJDocument getSwingInteractionsDocument() {
        return this._interactionsDocument;
    }

    @Override
    public InteractionsDocument getInteractionsDocument() {
        return this._interactionsModel.getDocument();
    }

    @Override
    public CompilerModel getCompilerModel() {
        return this._compilerModel;
    }

    @Override
    public JUnitModel getJUnitModel() {
        return this._junitModel;
    }

    @Override
    public JavadocModel getJavadocModel() {
        return this._javadocModel;
    }

    @Override
    public int getNumCompErrors() {
        return this._numCompErrors;
    }

    @Override
    public void setNumCompErrors(int num) {
        this._numCompErrors = num;
    }

    @Override
    public void dispose() {
        this._jvm.killInterpreter(null);
        this._notifier.removeAllListeners();
    }

    @Override
    public void disposeExternalResources() {
        this._jvm.killInterpreter(null);
    }

    @Override
    public void resetInteractions(File wd) {
        this.resetInteractions(wd, false);
    }

    @Override
    public void resetInteractions(File wd, boolean forceReset) {
        assert (this._interactionsModel._pane != null);
        DebugUtil.debug.logStart();
        File workDir = this._interactionsModel.getWorkingDirectory();
        if (wd == null) {
            wd = workDir;
        }
        if (!forceReset && !this._jvm.slaveJVMUsed() && !this.isClassPathChanged() && wd.equals(workDir)) {
            DebugUtil.debug.log();
            this._interactionsModel._notifyInterpreterReady(wd);
            DebugUtil.debug.logEnd();
            return;
        }
        DebugUtil.debug.log();
        DrJava.getConfig().setSetting(LAST_INTERACTIONS_DIRECTORY, wd);
        this._interactionsModel.resetInterpreter(wd);
        DebugUtil.debug.logEnd();
    }

    @Override
    public void interpretCurrentInteraction() {
        this._interactionsModel.interpretCurrentInteraction();
    }

    @Override
    public void loadHistory(final FileOpenSelector selector) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    DefaultGlobalModel.this._interactionsModel.loadHistory(selector);
                }
                catch (IOException e) {
                    throw new UnexpectedException(e);
                }
            }
        });
    }

    @Override
    public InteractionsScriptModel loadHistoryAsScript(FileOpenSelector selector) throws IOException, OperationCanceledException {
        return this._interactionsModel.loadHistoryAsScript(selector);
    }

    @Override
    public void clearHistory() {
        this._interactionsModel.getDocument().clearHistory();
    }

    @Override
    public void saveHistory(FileSaveSelector selector) throws IOException {
        this._interactionsModel.getDocument().saveHistory(selector);
    }

    @Override
    public void saveHistory(FileSaveSelector selector, String editedVersion) throws IOException {
        this._interactionsModel.getDocument().saveHistory(selector, editedVersion);
    }

    @Override
    public String getHistoryAsStringWithSemicolons() {
        return this._interactionsModel.getDocument().getHistoryAsStringWithSemicolons();
    }

    @Override
    public String getHistoryAsString() {
        return this._interactionsModel.getDocument().getHistoryAsString();
    }

    @Override
    public void printDebugMessage(String s) {
        this._interactionsModel.getDocument().insertBeforeLastPrompt(s + "\n", "debugger");
    }

    @Override
    public void waitForInterpreter() {
        this._jvm.ensureInterpreterConnected();
    }

    @Override
    public Iterable<File> getInteractionsClassPath() {
        return this._jvm.getClassPath();
    }

    void setResetAfterCompile(boolean shouldReset) {
        this._resetAfterCompile = shouldReset;
    }

    @Override
    public Debugger getDebugger() {
        return this._debugger;
    }

    @Override
    public int getDebugPort() throws IOException {
        return this._interactionsModel.getDebugPort();
    }

    @Override
    protected ConcreteOpenDefDoc _createOpenDefinitionsDocument(NullFile f) {
        return new ConcreteOpenDefDoc(f);
    }

    @Override
    protected ConcreteOpenDefDoc _createOpenDefinitionsDocument(File f) throws IOException {
        if (!f.exists()) {
            throw new FileNotFoundException("file " + f + " cannot be found");
        }
        return new ConcreteOpenDefDoc(f);
    }

    @Override
    protected void addDocToClassPath(OpenDefinitionsDocument doc) {
        try {
            File sourceRoot = doc.getSourceRoot();
            if (doc.isAuxiliaryFile()) {
                this._interactionsModel.addProjectFilesClassPath(sourceRoot);
            } else {
                this._interactionsModel.addExternalFilesClassPath(sourceRoot);
            }
            this.setClassPathChanged(true);
        }
        catch (InvalidPackageException invalidPackageException) {
            // empty catch block
        }
    }

    private void _setupDebugger() {
        this._jvm.setDebugModel(this._debugger.callback());
        this.getBreakpointManager().addListener(new RegionManagerListener<Breakpoint>(){

            @Override
            public void regionAdded(Breakpoint bp) {
                DefaultGlobalModel.this.setProjectChanged(true);
            }

            @Override
            public void regionChanged(Breakpoint bp) {
                DefaultGlobalModel.this.setProjectChanged(true);
            }

            @Override
            public void regionRemoved(Breakpoint bp) {
                try {
                    DefaultGlobalModel.this.getDebugger().removeBreakpoint(bp);
                }
                catch (DebugException debugException) {
                    // empty catch block
                }
                DefaultGlobalModel.this.setProjectChanged(true);
            }
        });
        this.getBookmarkManager().addListener(new RegionManagerListener<MovingDocumentRegion>(){

            @Override
            public void regionAdded(MovingDocumentRegion r) {
                DefaultGlobalModel.this.setProjectChanged(true);
            }

            @Override
            public void regionChanged(MovingDocumentRegion r) {
                DefaultGlobalModel.this.setProjectChanged(true);
            }

            @Override
            public void regionRemoved(MovingDocumentRegion r) {
                DefaultGlobalModel.this.setProjectChanged(true);
            }
        });
        this._debugger.addListener(new DebugListener(){

            public void watchSet(DebugWatchData w) {
                DefaultGlobalModel.this.setProjectChanged(true);
            }

            public void watchRemoved(DebugWatchData w) {
                DefaultGlobalModel.this.setProjectChanged(true);
            }

            public void regionAdded(Breakpoint bp) {
            }

            public void regionChanged(Breakpoint bp) {
            }

            public void regionRemoved(Breakpoint bp) {
            }

            public void debuggerStarted() {
            }

            public void debuggerShutdown() {
            }

            public void threadLocationUpdated(OpenDefinitionsDocument doc, int lineNumber, boolean shouldHighlight) {
            }

            public void breakpointReached(Breakpoint bp) {
            }

            public void stepRequested() {
            }

            public void currThreadSuspended() {
            }

            public void currThreadResumed() {
            }

            public void threadStarted() {
            }

            public void currThreadDied() {
            }

            public void nonCurrThreadDied() {
            }

            public void currThreadSet(DebugThreadData thread) {
            }
        });
    }

    @Override
    public Iterable<File> getClassPath() {
        AbstractIterable result = IterUtil.empty();
        if (this.isProjectActive()) {
            Iterable<File> projectExtras;
            File projRoot;
            File buildDir = this.getBuildDirectory();
            if (buildDir != null) {
                result = IterUtil.compose(result, buildDir);
            }
            if ((projRoot = this.getProjectRoot()) != null) {
                result = IterUtil.compose(result, projRoot);
            }
            if ((projectExtras = this.getExtraClassPath()) != null) {
                result = IterUtil.compose(result, projectExtras);
            }
        } else {
            result = IterUtil.compose(result, this.getSourceRootSet());
        }
        Vector globalExtras = (Vector)DrJava.getConfig().getSetting(EXTRA_CLASSPATH);
        if (globalExtras != null) {
            result = IterUtil.compose(result, globalExtras);
        }
        result = IterUtil.compose(result, RUNTIME_CLASS_PATH);
        return result;
    }

    public void resetInteractionsClassPath() {
        Vector cp;
        Iterable<File> projectExtras = this.getExtraClassPath();
        if (projectExtras != null) {
            for (File cpE : projectExtras) {
                this._interactionsModel.addProjectClassPath(cpE);
            }
        }
        if ((cp = (Vector)DrJava.getConfig().getSetting(EXTRA_CLASSPATH)) != null) {
            for (File f : cp) {
                this._interactionsModel.addExtraClassPath(f);
            }
        }
        for (OpenDefinitionsDocument odd : this.getAuxiliaryDocuments()) {
            try {
                this._interactionsModel.addProjectFilesClassPath(odd.getSourceRoot());
            }
            catch (InvalidPackageException e) {}
        }
        for (OpenDefinitionsDocument odd : this.getNonProjectDocuments()) {
            try {
                File sourceRoot = odd.getSourceRoot();
                if (sourceRoot == null) continue;
                this._interactionsModel.addExternalFilesClassPath(sourceRoot);
            }
            catch (InvalidPackageException e) {}
        }
        this._interactionsModel.addProjectFilesClassPath(this.getProjectRoot());
        this.setClassPathChanged(false);
    }

    class ConcreteOpenDefDoc
    extends AbstractGlobalModel.ConcreteOpenDefDoc {
        private volatile InteractionsListener _runMain;

        ConcreteOpenDefDoc(File f) {
            super(f);
        }

        ConcreteOpenDefDoc(NullFile f) {
            super(f);
        }

        public void startCompile() throws IOException {
            assert (EventQueue.isDispatchThread());
            DefaultGlobalModel.this._compilerModel.compile(this);
        }

        public void runMain() throws ClassNameNotFoundException, IOException {
            File workDir;
            assert (EventQueue.isDispatchThread());
            DefaultGlobalModel.this._notifier.prepareForRun(this);
            final String className = this.getDocument().getQualifiedClassName();
            final InteractionsDocument iDoc = DefaultGlobalModel.this._interactionsModel.getDocument();
            if (!this.checkIfClassFileInSync()) {
                iDoc.insertBeforeLastPrompt("Current document is out of sync with the Interactions Pane and should be recompiled!\n", "error");
                return;
            }
            final boolean wasDebuggerEnabled = DefaultGlobalModel.this.getDebugger().isReady();
            this._runMain = new DummyInteractionsListener(){

                public void interpreterReady(File wd) {
                    DefaultGlobalModel.this._interactionsModel.removeListener(ConcreteOpenDefDoc.this._runMain);
                    if (wasDebuggerEnabled && !DefaultGlobalModel.this.getDebugger().isReady()) {
                        try {
                            DefaultGlobalModel.this.getDebugger().startUp();
                        }
                        catch (DebugException debugException) {
                            // empty catch block
                        }
                    }
                    iDoc.clearCurrentInput();
                    iDoc.append("java " + className, null);
                    new Thread("Running main method"){

                        public void run() {
                            DefaultGlobalModel.this._interactionsModel.interpretCurrentInteraction();
                        }
                    }.start();
                }
            };
            DefaultGlobalModel.this._interactionsModel.addListener(this._runMain);
            if (DefaultGlobalModel.this.isProjectActive()) {
                workDir = DefaultGlobalModel.this.getWorkingDirectory();
            } else {
                try {
                    workDir = this.getSourceRoot();
                }
                catch (InvalidPackageException e) {
                    workDir = FileOps.NULL_FILE;
                }
            }
            DefaultGlobalModel.this.resetInteractions(workDir);
        }

        public void startJUnit() throws ClassNotFoundException, IOException {
            DefaultGlobalModel.this._junitModel.junit(this);
        }

        public void generateJavadoc(FileSaveSelector saver) throws IOException {
            DefaultGlobalModel.this._javadocModel.javadocDocument(this, saver);
        }

        public void removeFromDebugger() {
            this.getBreakpointManager().removeRegions(this);
        }
    }
}

