/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.drjava.model.JDKToolsLibrary;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.NoCompilerAvailable;
import edu.rice.cs.drjava.model.debug.Debugger;
import edu.rice.cs.drjava.model.debug.NoDebuggerAvailable;
import edu.rice.cs.drjava.model.javadoc.DefaultJavadocModel;
import edu.rice.cs.drjava.model.javadoc.JavadocModel;
import edu.rice.cs.drjava.model.javadoc.NoJavadocAvailable;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SingletonIterable;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.plt.reflect.PathClassLoader;
import edu.rice.cs.plt.reflect.PreemptingClassLoader;
import edu.rice.cs.plt.reflect.ReflectException;
import edu.rice.cs.plt.reflect.ReflectUtil;
import edu.rice.cs.plt.reflect.ShadowingClassLoader;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarJDKToolsLibrary
extends JDKToolsLibrary {
    private static final Iterable<String> TOOLS_PACKAGES = IterUtil.asIterable("com.sun.javadoc", "com.sun.jdi", "com.sun.tools", "sun.applet", "sun.rmi.rmic", "sun.tools", "com.sun.jarsigner", "com.sun.mirror", "sun.jvmstat", "com.sun.codemodel", "com.sun.istack.internal.tools", "com.sun.istack.internal.ws", "com.sun.source", "com.sun.xml.internal.dtdparser", "com.sun.xml.internal.rngom", "com.sun.xml.internal.xsom", "org.relaxng");
    private final File _location;

    private JarJDKToolsLibrary(File location, JavaVersion.FullVersion version, CompilerInterface compiler, Debugger debugger, JavadocModel javadoc) {
        super(version, compiler, debugger, javadoc);
        this._location = location;
    }

    public File location() {
        return this._location;
    }

    @Override
    public String toString() {
        return super.toString() + " at " + this._location;
    }

    public static JarJDKToolsLibrary makeFromFile(File f, GlobalModel model) {
        JavaVersion.FullVersion version = JarJDKToolsLibrary.guessVersion(f);
        Object compiler = NoCompilerAvailable.ONLY;
        Debugger debugger = NoDebuggerAvailable.ONLY;
        JavadocModel javadoc = new NoJavadocAvailable(model);
        if (JavaVersion.CURRENT.supports(version.majorVersion())) {
            Object attempt;
            Class[] sig;
            ShadowingClassLoader loader = new ShadowingClassLoader(JarJDKToolsLibrary.class.getClassLoader(), true, TOOLS_PACKAGES, true);
            SingletonIterable<File> path = IterUtil.singleton(IOUtil.attemptAbsoluteFile(f));
            String compilerAdapter = JarJDKToolsLibrary.adapterForCompiler(version.majorVersion());
            if (compilerAdapter != null) {
                File[] jars;
                File jdkLibDir;
                File libDir = null;
                if (f.getName().equals("classes.jar")) {
                    libDir = f.getParentFile();
                } else if (f.getName().equals("tools.jar") && (jdkLibDir = f.getParentFile()) != null) {
                    File jreLibDir;
                    File jdkRoot = jdkLibDir.getParentFile();
                    if (jdkRoot != null && IOUtil.attemptExists(new File(jreLibDir = new File(jdkRoot, "jre/lib"), "rt.jar"))) {
                        libDir = jreLibDir;
                    }
                    if (libDir == null && IOUtil.attemptExists(new File(jdkLibDir, "rt.jar"))) {
                        libDir = jdkLibDir;
                    }
                }
                List<File> bootClassPath = null;
                if (libDir != null && (jars = IOUtil.attemptListFiles(libDir, IOUtil.extensionFilePredicate("jar"))) != null) {
                    bootClassPath = Arrays.asList(jars);
                }
                try {
                    sig = new Class[]{JavaVersion.FullVersion.class, String.class, List.class};
                    Object[] args = new Object[]{version, f.toString(), bootClassPath};
                    attempt = (CompilerInterface)ReflectUtil.loadLibraryAdapter((ClassLoader)loader, path, compilerAdapter, sig, args);
                    if (attempt.isAvailable()) {
                        compiler = attempt;
                    }
                }
                catch (ReflectException e) {
                }
                catch (LinkageError e) {
                    // empty catch block
                }
            }
            String debuggerAdapter = JarJDKToolsLibrary.adapterForDebugger(version.majorVersion());
            String debuggerPackage = "edu.rice.cs.drjava.model.debug.jpda";
            if (debuggerAdapter != null) {
                try {
                    sig = new Class[]{GlobalModel.class};
                    PreemptingClassLoader debugLoader = new PreemptingClassLoader((ClassLoader)new PathClassLoader((ClassLoader)loader, path), debuggerPackage);
                    attempt = (Debugger)ReflectUtil.loadObject((ClassLoader)debugLoader, debuggerAdapter, sig, new Object[]{model});
                    if (attempt.isAvailable()) {
                        debugger = attempt;
                    }
                }
                catch (ReflectException e) {
                }
                catch (LinkageError e) {
                    // empty catch block
                }
            }
            try {
                new PathClassLoader((ClassLoader)loader, path).loadClass("com.sun.tools.javadoc.Main");
                File bin = new File(f.getParentFile(), "../bin");
                if (!IOUtil.attemptIsDirectory(bin)) {
                    bin = new File(f.getParentFile(), "../Home/bin");
                }
                if (!IOUtil.attemptIsDirectory(bin)) {
                    bin = new File(System.getProperty("java.home", f.getParent()));
                }
                javadoc = new DefaultJavadocModel(model, bin, path);
            }
            catch (ClassNotFoundException e) {
            }
            catch (LinkageError e) {
                // empty catch block
            }
        }
        return new JarJDKToolsLibrary(f, version, (CompilerInterface)compiler, debugger, javadoc);
    }

    private static JavaVersion.FullVersion guessVersion(File f) {
        JavaVersion.FullVersion result = null;
        File current = IOUtil.attemptCanonicalFile(f);
        do {
            String name;
            if ((name = current.getName()).startsWith("jdk")) {
                result = JavaVersion.parseFullVersion(name.substring(3));
                continue;
            }
            if (name.startsWith("j2sdk")) {
                result = JavaVersion.parseFullVersion(name.substring(5));
                continue;
            }
            if (!name.matches("\\d+\\.\\d+\\.\\d+")) continue;
            result = JavaVersion.parseFullVersion(name);
        } while ((current = current.getParentFile()) != null && result == null);
        if (result == null || result.majorVersion().equals((Object)JavaVersion.UNRECOGNIZED)) {
            result = JavaVersion.CURRENT_FULL;
        }
        return result;
    }

    public static Iterable<JarJDKToolsLibrary> search(GlobalModel model) {
        String javaHome = System.getProperty("java.home");
        String envJavaHome = null;
        String programFiles = null;
        String systemDrive = null;
        if (JavaVersion.CURRENT.supports(JavaVersion.JAVA_5)) {
            envJavaHome = System.getenv("JAVA_HOME");
            programFiles = System.getenv("ProgramFiles");
            systemDrive = System.getenv("SystemDrive");
        }
        LinkedHashSet roots = new LinkedHashSet();
        if (javaHome != null) {
            JarJDKToolsLibrary.addIfDir(new File(javaHome), roots);
            JarJDKToolsLibrary.addIfDir(new File(javaHome, ".."), roots);
            JarJDKToolsLibrary.addIfDir(new File(javaHome, "../.."), roots);
        }
        if (envJavaHome != null) {
            JarJDKToolsLibrary.addIfDir(new File(envJavaHome), roots);
            JarJDKToolsLibrary.addIfDir(new File(envJavaHome, ".."), roots);
            JarJDKToolsLibrary.addIfDir(new File(envJavaHome, "../.."), roots);
        }
        if (programFiles != null) {
            JarJDKToolsLibrary.addIfDir(new File(programFiles, "Java"), roots);
            JarJDKToolsLibrary.addIfDir(new File(programFiles), roots);
        }
        JarJDKToolsLibrary.addIfDir(new File("/C:/Program Files/Java"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/C:/Program Files"), roots);
        if (systemDrive != null) {
            JarJDKToolsLibrary.addIfDir(new File(systemDrive, "Java"), roots);
            JarJDKToolsLibrary.addIfDir(new File(systemDrive), roots);
        }
        JarJDKToolsLibrary.addIfDir(new File("/C:/Java"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/C:"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/System/Library/Frameworks/JavaVM.framework/Versions"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/java"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/j2se"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/local/java"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/local/j2se"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/local"), roots);
        LinkedHashSet jars = new LinkedHashSet();
        Predicate<File> subdirFilter = LambdaUtil.or(IOUtil.regexCanonicalCaseFilePredicate("j2sdk.*"), IOUtil.regexCanonicalCaseFilePredicate("jdk.*"), IOUtil.regexCanonicalCaseFilePredicate("\\d+\\.\\d+\\.\\d+"));
        for (File root : roots) {
            for (File subdir : IOUtil.attemptListFilesAsIterable(root, subdirFilter)) {
                JarJDKToolsLibrary.addIfFile(new File(subdir, "lib/tools.jar"), jars);
                JarJDKToolsLibrary.addIfFile(new File(subdir, "Classes/classes.jar"), jars);
            }
        }
        TreeMap<JavaVersion.FullVersion, AbstractIterable> results = new TreeMap<JavaVersion.FullVersion, AbstractIterable>();
        for (File jar : jars) {
            JarJDKToolsLibrary lib = JarJDKToolsLibrary.makeFromFile(jar, model);
            if (!lib.isValid()) continue;
            JavaVersion.FullVersion v = lib.version();
            if (results.containsKey(v)) {
                results.put(v, IterUtil.compose(lib, (Iterable)results.get(v)));
                continue;
            }
            results.put(v, IterUtil.singleton(lib));
        }
        return IterUtil.reverse(IterUtil.collapse(results.values()));
    }

    private static void addIfDir(File f, Set<? super File> set) {
        if (IOUtil.attemptIsDirectory(f = IOUtil.attemptCanonicalFile(f))) {
            set.add(f);
        }
    }

    private static void addIfFile(File f, Set<? super File> set) {
        if (IOUtil.attemptIsFile(f = IOUtil.attemptCanonicalFile(f))) {
            set.add(f);
        }
    }
}

