/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.model.DJError;
import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.compiler.CompilerErrorModel;
import edu.rice.cs.drjava.model.compiler.CompilerEventNotifier;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.CompilerListener;
import edu.rice.cs.drjava.model.compiler.CompilerModel;
import edu.rice.cs.drjava.model.compiler.NoCompilerAvailable;
import edu.rice.cs.drjava.model.definitions.InvalidPackageException;
import edu.rice.cs.javalanglevels.JExprParseException;
import edu.rice.cs.javalanglevels.LanguageLevelConverter;
import edu.rice.cs.javalanglevels.Options;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.parser.JExprParser;
import edu.rice.cs.javalanglevels.tree.JExpressionIF;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.Utilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCompilerModel
implements CompilerModel {
    private final List<CompilerInterface> _compilers;
    private CompilerInterface _active;
    private final CompilerEventNotifier _notifier = new CompilerEventNotifier();
    private final GlobalModel _model;
    private CompilerErrorModel _compilerErrorModel;
    private Object _compilerLock = new Object();

    public DefaultCompilerModel(GlobalModel m, Iterable<? extends CompilerInterface> compilers) {
        this._compilers = new ArrayList<CompilerInterface>();
        for (CompilerInterface compilerInterface : compilers) {
            this._compilers.add(compilerInterface);
        }
        this._active = this._compilers.size() > 0 ? this._compilers.get(0) : NoCompilerAvailable.ONLY;
        this._model = m;
        this._compilerErrorModel = new CompilerErrorModel(new DJError[0], this._model);
    }

    @Override
    public Object getCompilerLock() {
        return this._compilerLock;
    }

    @Override
    public void addListener(CompilerListener listener) {
        this._notifier.addListener(listener);
    }

    @Override
    public void removeListener(CompilerListener listener) {
        this._notifier.removeListener(listener);
    }

    @Override
    public void removeAllListeners() {
        this._notifier.removeAllListeners();
    }

    @Override
    public void compileAll() throws IOException {
        if (this._prepareForCompile()) {
            this._doCompile(this._model.getOpenDefinitionsDocuments());
        } else {
            this._notifier.compileAborted(new UnexpectedException("Some modified open files are unsaved"));
        }
    }

    @Override
    public void compileProject() throws IOException {
        if (!this._model.isProjectActive()) {
            throw new UnexpectedException("compileProject invoked when DrJava is not in project mode");
        }
        if (this._prepareForCompile()) {
            this._doCompile(this._model.getProjectDocuments());
        } else {
            this._notifier.compileAborted(new UnexpectedException("Project contains unsaved modified files"));
        }
    }

    @Override
    public void compile(List<OpenDefinitionsDocument> defDocs) throws IOException {
        if (this._prepareForCompile()) {
            this._doCompile(defDocs);
        } else {
            this._notifier.compileAborted(new UnexpectedException("The files to be compiled include unsaved modified files"));
        }
    }

    @Override
    public void compile(OpenDefinitionsDocument doc) throws IOException {
        if (this._prepareForCompile()) {
            this._doCompile(Arrays.asList(doc));
        } else {
            this._notifier.compileAborted(new UnexpectedException(doc + "is modified but unsaved"));
        }
    }

    private boolean _prepareForCompile() {
        if (this._model.hasModifiedDocuments()) {
            this._notifier.saveBeforeCompile();
        }
        return !this._model.hasModifiedDocuments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _doCompile(List<OpenDefinitionsDocument> docs) throws IOException {
        ArrayList<File> excludedFiles;
        block11: {
            ArrayList<File> filesToCompile = new ArrayList<File>();
            excludedFiles = new ArrayList<File>();
            ArrayList<DJError> packageErrors = new ArrayList<DJError>();
            for (OpenDefinitionsDocument doc : docs) {
                if (doc.isSourceFile()) {
                    File f = doc.getFile();
                    if (f != null && f != FileOps.NULL_FILE) {
                        filesToCompile.add(f);
                    }
                    doc.setCachedClassFile(FileOps.NULL_FILE);
                    try {
                        doc.getSourceRoot();
                    }
                    catch (InvalidPackageException e) {
                        packageErrors.add(new DJError(f, e.getMessage(), false));
                    }
                    continue;
                }
                excludedFiles.add(doc.getFile());
            }
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    DefaultCompilerModel.this._notifier.compileStarted();
                }
            });
            try {
                if (!packageErrors.isEmpty()) {
                    this._distributeErrors(packageErrors);
                    break block11;
                }
                try {
                    File buildDir = this._model.getBuildDirectory();
                    if (buildDir != null && buildDir != FileOps.NULL_FILE && !buildDir.exists() && !buildDir.mkdirs()) {
                        throw new IOException("Could not create build directory: " + buildDir);
                    }
                    this._compileFiles(filesToCompile, buildDir);
                }
                catch (Throwable t) {
                    DJError err = new DJError(t.toString(), false);
                    this._distributeErrors(Arrays.asList(err));
                }
            }
            catch (Throwable throwable) {
                Utilities.invokeLater(new Runnable(excludedFiles){
                    final /* synthetic */ ArrayList val$excludedFiles;
                    {
                        this.val$excludedFiles = arrayList;
                    }

                    public void run() {
                        DefaultCompilerModel.this._notifier.compileEnded(DefaultCompilerModel.this._model.getWorkingDirectory(), this.val$excludedFiles);
                    }
                });
                throw throwable;
            }
        }
        Utilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private LinkedList<DJError> _parseExceptions2CompilerErrors(LinkedList<JExprParseException> pes) {
        LinkedList<DJError> errors = new LinkedList<DJError>();
        for (JExprParseException pe : pes) {
            errors.addLast(new DJError(pe.getFile(), pe.currentToken.beginLine - 1, pe.currentToken.beginColumn - 1, pe.getMessage(), false));
        }
        return errors;
    }

    private LinkedList<DJError> _visitorErrors2CompilerErrors(LinkedList<Pair<String, JExpressionIF>> visitorErrors) {
        LinkedList<DJError> errors = new LinkedList<DJError>();
        for (Pair pair : visitorErrors) {
            String message = (String)pair.getFirst();
            JExpressionIF jexpr = (JExpressionIF)pair.getSecond();
            SourceInfo si = jexpr == null ? JExprParser.NO_SOURCE_INFO : ((JExpressionIF)pair.getSecond()).getSourceInfo();
            errors.addLast(new DJError(si.getFile(), si.getStartLine() - 1, si.getStartColumn() - 1, message, false));
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _compileFiles(List<? extends File> files, File buildDir) throws IOException {
        if (!files.isEmpty()) {
            if (buildDir == FileOps.NULL_FILE) {
                buildDir = null;
            }
            if (buildDir != null) {
                buildDir = IOUtil.attemptCanonicalFile(buildDir);
            }
            List<File> classPath = CollectUtil.makeList(this._model.getClassPath());
            List<File> bootClassPath = null;
            String bootProp = System.getProperty("drjava.bootclasspath");
            if (bootProp != null) {
                bootClassPath = CollectUtil.makeList(IOUtil.parsePath(bootProp));
            }
            LinkedList<DJError> errors = new LinkedList<DJError>();
            List<? extends File> preprocessedFiles = this._compileLanguageLevelsFiles(files, errors, classPath, bootClassPath);
            if (errors.isEmpty()) {
                CompilerInterface compiler = this.getActiveCompiler();
                Object object = this._compilerLock;
                synchronized (object) {
                    if (preprocessedFiles == null) {
                        errors.addAll(compiler.compile(files, classPath, null, buildDir, bootClassPath, null, true));
                    } else {
                        errors.addAll(compiler.compile(preprocessedFiles, classPath, null, buildDir, bootClassPath, null, false));
                    }
                }
            }
            this._distributeErrors(errors);
        } else {
            this._distributeErrors(Collections.emptyList());
        }
    }

    private List<? extends File> _compileLanguageLevelsFiles(List<? extends File> files, List<DJError> errors, Iterable<File> classPath, Iterable<File> bootClassPath) {
        LanguageLevelConverter llc = new LanguageLevelConverter();
        Options llOpts = bootClassPath == null ? new Options(this.getActiveCompiler().version(), classPath) : new Options(this.getActiveCompiler().version(), classPath, bootClassPath);
        Pair<LinkedList<JExprParseException>, LinkedList<Pair<String, JExpressionIF>>> llErrors = llc.convert(files.toArray(new File[0]), llOpts);
        HashSet<File> javaFileSet = new HashSet<File>();
        boolean containsLanguageLevels = false;
        for (File file : files) {
            File canonicalFile = IOUtil.attemptCanonicalFile(file);
            String fileName = canonicalFile.getPath();
            int lastIndex = fileName.lastIndexOf(".dj");
            if (lastIndex != -1) {
                containsLanguageLevels = true;
                javaFileSet.add(new File(fileName.substring(0, lastIndex) + ".java"));
                continue;
            }
            javaFileSet.add(canonicalFile);
        }
        files = new LinkedList<File>(javaFileSet);
        errors.addAll(this._parseExceptions2CompilerErrors(llErrors.getFirst()));
        errors.addAll(this._visitorErrors2CompilerErrors(llErrors.getSecond()));
        if (containsLanguageLevels) {
            return files;
        }
        return null;
    }

    private void _distributeErrors(List<? extends DJError> errors) throws IOException {
        this._compilerErrorModel = new CompilerErrorModel(errors.toArray(new DJError[0]), this._model);
        this._model.setNumCompErrors(this._compilerErrorModel.getNumCompErrors());
    }

    @Override
    public CompilerErrorModel getCompilerErrorModel() {
        return this._compilerErrorModel;
    }

    @Override
    public int getNumErrors() {
        return this.getCompilerErrorModel().getNumErrors();
    }

    public int getNumCompErrors() {
        return this.getCompilerErrorModel().getNumCompErrors();
    }

    public int getNumWarnings() {
        return this.getCompilerErrorModel().getNumWarnings();
    }

    @Override
    public void resetCompilerErrors() {
        this._compilerErrorModel = new CompilerErrorModel(new DJError[0], this._model);
    }

    @Override
    public Iterable<CompilerInterface> getAvailableCompilers() {
        if (this._compilers.isEmpty()) {
            return IterUtil.singleton(NoCompilerAvailable.ONLY);
        }
        return IterUtil.snapshot(this._compilers);
    }

    @Override
    public CompilerInterface getActiveCompiler() {
        return this._active;
    }

    @Override
    public void setActiveCompiler(CompilerInterface compiler) {
        if (!this._compilers.isEmpty() || !compiler.equals(NoCompilerAvailable.ONLY)) {
            if (this._compilers.contains(compiler)) {
                this._active = compiler;
                this._notifier.activeCompilerChanged();
            } else {
                throw new IllegalArgumentException("Compiler is not in the list of available compilers: " + compiler);
            }
        }
    }

    @Override
    public void addCompiler(CompilerInterface compiler) {
        if (this._compilers.isEmpty()) {
            this._active = compiler;
        }
        this._compilers.add(compiler);
    }
}

