/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DefaultFileManager;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import edu.rice.cs.drjava.model.DJError;
import edu.rice.cs.drjava.model.compiler.CompilerOptions;
import edu.rice.cs.drjava.model.compiler.JavacCompiler;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.reflect.JavaVersion;
import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public class Javac160Compiler
extends JavacCompiler {
    public Javac160Compiler(JavaVersion.FullVersion version, String location, java.util.List<? extends File> defaultBootClassPath) {
        super(version, location, defaultBootClassPath);
    }

    public boolean isAvailable() {
        try {
            Class<?> diagnostic = Class.forName("javax.tools.Diagnostic");
            diagnostic.getMethod("getKind", new Class[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
        catch (LinkageError e) {
            return false;
        }
    }

    public java.util.List<? extends DJError> compile(java.util.List<? extends File> files, java.util.List<? extends File> classPath, java.util.List<? extends File> sourcePath, File destination, java.util.List<? extends File> bootClassPath, String sourceVersion, boolean showWarnings) {
        DebugUtil.debug.logStart("compile()");
        DebugUtil.debug.logValues(new String[]{"this", "files", "classPath", "sourcePath", "destination", "bootClassPath", "sourceVersion", "showWarnings"}, new Object[]{this, files, classPath, sourcePath, destination, bootClassPath, sourceVersion, showWarnings});
        Context context = this._createContext(classPath, sourcePath, destination, bootClassPath, sourceVersion, showWarnings);
        LinkedList<DJError> errors = new LinkedList<DJError>();
        new CompilerErrorListener(context, errors);
        JavaCompiler compiler = JavaCompiler.instance(context);
        DefaultFileManager fileManager = (DefaultFileManager)context.get(JavaFileManager.class);
        List<JavaFileObject> fileObjects = List.nil();
        for (File file : files) {
            fileObjects = fileObjects.prepend(fileManager.getRegularFile(file));
        }
        try {
            compiler.compile(fileObjects);
        }
        catch (Throwable t) {
            errors.addFirst(new DJError("Compile exception: " + t, false));
            DebugUtil.error.log(t);
        }
        DebugUtil.debug.logEnd("compile()");
        return errors;
    }

    private Context _createContext(java.util.List<? extends File> classPath, java.util.List<? extends File> sourcePath, File destination, java.util.List<? extends File> bootClassPath, String sourceVersion, boolean showWarnings) {
        if (bootClassPath == null) {
            bootClassPath = this._defaultBootClassPath;
        }
        Context context = new Context();
        Options options = Options.instance(context);
        for (Map.Entry e : CompilerOptions.getOptions((boolean)showWarnings).entrySet()) {
            options.put((String)e.getKey(), (String)e.getValue());
        }
        options.put("-g", "");
        if (classPath != null) {
            options.put("-classpath", IOUtil.pathToString(classPath));
        }
        if (sourcePath != null) {
            options.put("-sourcepath", IOUtil.pathToString(sourcePath));
        }
        if (destination != null) {
            options.put("-d", destination.getPath());
        }
        if (bootClassPath != null) {
            options.put("-bootclasspath", IOUtil.pathToString(bootClassPath));
        }
        if (sourceVersion != null) {
            options.put("-source", sourceVersion);
        }
        if (!showWarnings) {
            options.put("-nowarn", "");
        }
        return context;
    }

    private static class CompilerErrorListener
    implements DiagnosticListener<JavaFileObject> {
        private java.util.List<? super DJError> _errors;

        public CompilerErrorListener(Context context, java.util.List<? super DJError> errors) {
            this._errors = errors;
            context.put(DiagnosticListener.class, this);
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> d) {
            Diagnostic.Kind dt = d.getKind();
            boolean isWarning = false;
            switch (dt) {
                case OTHER: {
                    return;
                }
                case NOTE: {
                    return;
                }
                case MANDATORY_WARNING: {
                    isWarning = true;
                    break;
                }
                case WARNING: {
                    isWarning = true;
                    break;
                }
                case ERROR: {
                    isWarning = false;
                }
            }
            this._errors.add(new DJError(new File(d.getSource().toUri().getPath()), (int)d.getLineNumber() - 1, (int)d.getColumnNumber() - 1, d.getMessage(null), isWarning));
        }
    }
}

