/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions;

import edu.rice.cs.drjava.model.AbstractDJDocument;
import edu.rice.cs.drjava.model.Finalizable;
import edu.rice.cs.drjava.model.FinalizationEvent;
import edu.rice.cs.drjava.model.FinalizationListener;
import edu.rice.cs.drjava.model.GlobalEventNotifier;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.Query;
import edu.rice.cs.drjava.model.definitions.ClassNameNotFoundException;
import edu.rice.cs.drjava.model.definitions.CompoundUndoManager;
import edu.rice.cs.drjava.model.definitions.DocumentClosedListener;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.drjava.model.definitions.reducedmodel.BraceInfo;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelStates;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.Utilities;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import koala.dynamicjava.parser.impl.ParseException;
import koala.dynamicjava.parser.impl.Parser;
import koala.dynamicjava.parser.impl.TokenMgrError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinitionsDocument
extends AbstractDJDocument
implements Finalizable<DefinitionsDocument> {
    public static final Log _log = new Log("GlobalModel.txt", false);
    private static final int NO_COMMENT_OFFSET = 0;
    private static final int WING_COMMENT_OFFSET = 2;
    private final List<DocumentClosedListener> _closedListeners = new LinkedList<DocumentClosedListener>();
    private static final int UNDO_LIMIT = 1000;
    private static boolean _tabsRemoved = true;
    private volatile boolean _isModifiedSinceSave = false;
    private volatile OpenDefinitionsDocument _odd;
    private volatile CompoundUndoManager _undoManager;
    private final GlobalEventNotifier _notifier;
    private volatile LinkedList<WeakReference<WrappedPosition>> _wrappedPosList;
    private List<FinalizationListener<DefinitionsDocument>> _finalizationListeners = new LinkedList<FinalizationListener<DefinitionsDocument>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocumentClosedListener(DocumentClosedListener l) {
        List<DocumentClosedListener> list = this._closedListeners;
        synchronized (list) {
            this._closedListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocumentClosedListener(DocumentClosedListener l) {
        List<DocumentClosedListener> list = this._closedListeners;
        synchronized (list) {
            this._closedListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this._removeIndenter();
        List<DocumentClosedListener> list = this._closedListeners;
        synchronized (list) {
            for (DocumentClosedListener l : this._closedListeners) {
                l.close();
            }
            this._closedListeners.clear();
        }
    }

    public DefinitionsDocument(Indenter indenter, GlobalEventNotifier notifier) {
        super(indenter);
        this._notifier = notifier;
        this.resetUndoManager();
    }

    public DefinitionsDocument(GlobalEventNotifier notifier) {
        this._notifier = notifier;
        this.resetUndoManager();
    }

    public DefinitionsDocument(GlobalEventNotifier notifier, CompoundUndoManager undoManager) {
        this._notifier = notifier;
        this._undoManager = undoManager;
    }

    protected Indenter makeNewIndenter(int indentLevel) {
        return new Indenter(indentLevel);
    }

    public void setOpenDefDoc(OpenDefinitionsDocument odd) {
        if (this._odd == null) {
            this._odd = odd;
        }
    }

    public OpenDefinitionsDocument getOpenDefDoc() {
        if (this._odd == null) {
            throw new IllegalStateException("The OpenDefinitionsDocument for this DefinitionsDocument has never been set");
        }
        return this._odd;
    }

    @Override
    protected void _styleChanged() {
        int length = this.getLength() - this._currentLocation;
        AbstractDocument.DefaultDocumentEvent evt = new AbstractDocument.DefaultDocumentEvent(this, this._currentLocation, length, DocumentEvent.EventType.CHANGE);
        this.fireChangedUpdate(evt);
    }

    public String getQualifiedClassName() throws ClassNameNotFoundException {
        return this.getPackageQualifier() + this.getMainClassName();
    }

    public String getQualifiedClassName(int pos) throws ClassNameNotFoundException {
        return this.getPackageQualifier() + this.getEnclosingTopLevelClassName(pos);
    }

    private String getPackageQualifier() {
        String packageName = this.getPackageName();
        if (packageName != null && !packageName.equals("")) {
            packageName = packageName + ".";
        }
        return packageName;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        if (_tabsRemoved) {
            str = DefinitionsDocument._removeTabs(str);
        }
        this._setModifiedSinceSave();
        super.insertString(offset, str, a);
    }

    @Override
    public void remove(int offset, int len) throws BadLocationException {
        if (len == 0) {
            return;
        }
        this._setModifiedSinceSave();
        super.remove(offset, len);
    }

    static String _removeTabs(String source) {
        return source.replace('\t', ' ');
    }

    public void updateModifiedSinceSave() {
        this._isModifiedSinceSave = this._undoManager.isModified();
        if (this._odd != null) {
            this._odd.documentReset();
        }
    }

    private void _setModifiedSinceSave() {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        if (!this._isModifiedSinceSave) {
            this._isModifiedSinceSave = true;
            if (this._odd != null) {
                this._odd.documentModified();
            }
        }
    }

    public void resetModification() {
        this._isModifiedSinceSave = false;
        this._undoManager.documentSaved();
        if (this._odd != null) {
            this._odd.documentReset();
        }
    }

    public boolean isModifiedSinceSave() {
        return this._isModifiedSinceSave;
    }

    public int getCurrentCol() {
        Element root = this.getDefaultRootElement();
        int line = root.getElementIndex(this._currentLocation);
        return this._currentLocation - root.getElement(line).getStartOffset();
    }

    public int getCurrentLine() {
        return this.getLineOfOffset(this._currentLocation);
    }

    public int getLineOfOffset(int offset) {
        return this.getDefaultRootElement().getElementIndex(offset) + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int _getOffset(int lineNum) {
        if (lineNum <= 0) {
            return -1;
        }
        if (lineNum == 1) {
            return 0;
        }
        int origPos = this.getCurrentLocation();
        try {
            int n;
            int i;
            int docLen = this.getLength();
            this.setCurrentLocation(0);
            for (i = 1; i < lineNum && this._currentLocation < docLen; ++i) {
                int dist = this._reduced.getDistToNextNewline();
                if (this._currentLocation + dist < docLen) {
                    ++dist;
                }
                this.move(dist);
            }
            if (i == lineNum) {
                n = this._currentLocation;
                return n;
            }
            n = -1;
            return n;
        }
        finally {
            this.setCurrentLocation(origPos);
        }
    }

    public boolean tabsRemoved() {
        return _tabsRemoved;
    }

    public int commentLines(int selStart, int selEnd) {
        int toReturn = selEnd;
        if (selStart == selEnd) {
            this.setCurrentLocation(this._getLineStartPos(selStart));
            this._commentLine();
            toReturn += 2;
        } else {
            toReturn = this.commentBlock(selStart, selEnd);
        }
        this._undoManager.endLastCompoundEdit();
        return toReturn;
    }

    private int commentBlock(int start, int end) {
        int afterCommentEnd = end;
        try {
            Position endPos = this.createUnwrappedPosition(end);
            for (int walker = this._getLineStartPos(start); walker < endPos.getOffset(); walker += this._reduced.getDistToNextNewline() + 1) {
                this.setCurrentLocation(walker);
                this._commentLine();
                afterCommentEnd += 2;
                this.setCurrentLocation(walker += 2);
            }
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        return afterCommentEnd;
    }

    private void _commentLine() {
        try {
            this.insertString(this._currentLocation, "//", null);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    public int uncommentLines(int selStart, int selEnd) {
        int toReturn = selEnd;
        if (selStart == selEnd) {
            try {
                this.setCurrentLocation(this._getLineStartPos(selStart));
                this._uncommentLine();
                toReturn -= 2;
            }
            catch (BadLocationException e) {
                throw new UnexpectedException(e);
            }
        } else {
            toReturn = this.uncommentBlock(selStart, selEnd);
        }
        this._undoManager.endLastCompoundEdit();
        return toReturn;
    }

    private int uncommentBlock(int start, int end) {
        int afterUncommentEnd = end;
        try {
            Position endPos = this.createUnwrappedPosition(end);
            int walker = this._getLineStartPos(start);
            while (walker < endPos.getOffset()) {
                this.setCurrentLocation(walker);
                int diff = this._uncommentLine();
                afterUncommentEnd -= diff;
                walker = this._getLineEndPos(walker) + 1;
            }
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        return afterUncommentEnd;
    }

    private int _uncommentLine() throws BadLocationException {
        int pos2;
        int pos1 = this.getText().indexOf("//", this._currentLocation);
        if (pos1 != (pos2 = this.getFirstNonWSCharPos(this._currentLocation, true))) {
            return 0;
        }
        this.remove(pos1, 2);
        return 2;
    }

    public void gotoLine(int line) {
        if (line < 0) {
            return;
        }
        int actualLine = 1;
        int len = this.getLength();
        this.setCurrentLocation(0);
        for (int i = 1; i < line && this._currentLocation < len; ++i) {
            int dist = this._reduced.getDistToNextNewline();
            if (this._currentLocation + dist < len) {
                ++dist;
            }
            ++actualLine;
            this.move(dist);
        }
    }

    private int _findNextOpenCurly(String text, int pos) throws BadLocationException {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        int reducedPos = pos;
        int origLocation = this._currentLocation;
        this._reduced.move(pos - origLocation);
        int i = text.indexOf(123, reducedPos);
        while (i > -1) {
            this._reduced.move(i - reducedPos);
            reducedPos = i;
            ReducedModelState state = this._reduced.getStateAtCurrent();
            if (state.equals(ReducedModelStates.FREE) && !DefinitionsDocument._isStartOfComment(text, i) && (i <= 0 || !DefinitionsDocument._isStartOfComment(text, i - 1))) break;
            i = text.indexOf(123, reducedPos + 1);
        }
        this._reduced.move(origLocation - reducedPos);
        if (i == -1) {
            reducedPos = -1;
        }
        return reducedPos;
    }

    public int _findPrevKeyword(String text, String kw, int pos) throws BadLocationException {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        int reducedPos = pos;
        int origLocation = this._currentLocation;
        this._reduced.move(pos - origLocation);
        int i = text.lastIndexOf(kw, reducedPos);
        while (i > -1) {
            if (i > 0 && Character.isJavaIdentifierPart(text.charAt(i - 1))) {
                i = text.lastIndexOf(kw, i - 1);
                continue;
            }
            if (i + kw.length() < text.length() && Character.isJavaIdentifierPart(text.charAt(i + kw.length()))) {
                i = text.lastIndexOf(kw, i - 1);
                continue;
            }
            this._reduced.move(i - reducedPos);
            reducedPos = i;
            ReducedModelState state = this._reduced.getStateAtCurrent();
            if (state.equals(ReducedModelStates.FREE) && !DefinitionsDocument._isStartOfComment(text, i) && (i <= 0 || !DefinitionsDocument._isStartOfComment(text, i - 1))) break;
            i = text.lastIndexOf(kw, reducedPos - 1);
        }
        this._reduced.move(origLocation - reducedPos);
        if (i == -1) {
            reducedPos = -1;
        }
        return reducedPos;
    }

    public String getEnclosingClassName(int pos, boolean qual) throws BadLocationException, ClassNameNotFoundException {
        return this._getEnclosingClassName(pos, qual);
    }

    public String _getEnclosingClassName(int pos, boolean qual) throws BadLocationException, ClassNameNotFoundException {
        String pn;
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        Query.EnclosingClassName key = new Query.EnclosingClassName(pos, qual);
        String cached = (String)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        char[] delims = new char[]{'{', '}', '(', ')', '[', ']', '+', '-', '/', '*', ';', ':', '=', '!', '@', '#', '$', '%', '^', '~', '\\', '\"', '`', '|'};
        String name = "";
        String text = this.getText(0, pos);
        int curPos = pos;
        while ((curPos = this.findPrevEnclosingBrace(curPos, '{', '}')) != -1) {
            int openParenPos;
            int classPos = this._findPrevKeyword(text, "class", curPos);
            int interPos = this._findPrevKeyword(text, "interface", curPos);
            int otherPos = this.findPrevDelimiter(curPos, delims);
            int newPos = -1;
            int closeParenPos = this._findPrevNonWSCharPos(curPos);
            if (closeParenPos != -1 && text.charAt(closeParenPos) == ')' && (openParenPos = this.findPrevEnclosingBrace(closeParenPos, '(', ')')) != -1 && text.charAt(openParenPos) == '(' && !this._isAnonymousInnerClass(newPos = this._findPrevKeyword(text, "new", openParenPos), curPos)) {
                newPos = -1;
            }
            while (classPos != -1 || interPos != -1 || newPos != -1) {
                if (newPos != -1) {
                    classPos = -1;
                    interPos = -1;
                    break;
                }
                if (otherPos > classPos && otherPos > interPos) {
                    if (text.charAt(otherPos) != '{' || text.charAt(otherPos) != '}') {
                        ++otherPos;
                    }
                    curPos = this.findPrevEnclosingBrace(otherPos, '{', '}');
                    classPos = this._findPrevKeyword(text, "class", curPos);
                    interPos = this._findPrevKeyword(text, "interface", curPos);
                    otherPos = this.findPrevDelimiter(curPos, delims);
                    newPos = -1;
                    closeParenPos = this._findPrevNonWSCharPos(curPos);
                    if (closeParenPos == -1 || text.charAt(closeParenPos) != ')' || (openParenPos = this.findPrevEnclosingBrace(closeParenPos, '(', ')')) == -1 || text.charAt(openParenPos) != '(' || this._isAnonymousInnerClass(newPos = this._findPrevKeyword(text, "new", openParenPos), curPos)) continue;
                    newPos = -1;
                    continue;
                }
                curPos = Math.max(classPos, Math.max(interPos, newPos));
                break;
            }
            if (classPos != -1 || interPos != -1) {
                int nameEnd;
                curPos = classPos > interPos ? (curPos += "class".length()) : (curPos += "interface".length());
                int nameStart = this.getFirstNonWSCharPos(curPos);
                if (nameStart == -1) {
                    throw new ClassNameNotFoundException("Cannot determine enclosing class name");
                }
                for (nameEnd = nameStart + 1; nameEnd < text.length() && (Character.isJavaIdentifierPart(text.charAt(nameEnd)) || text.charAt(nameEnd) == '.'); ++nameEnd) {
                }
                name = text.substring(nameStart, nameEnd) + '$' + name;
            } else {
                if (newPos == -1) break;
                name = String.valueOf(this._getAnonymousInnerClassIndex(curPos)) + "$" + name;
                curPos = newPos;
            }
            if (qual) continue;
        }
        if (name.length() > 0) {
            name = name.substring(0, name.length() - 1);
        }
        if (qual && (pn = this.getPackageName()).length() > 0 && name.length() > 0) {
            name = this.getPackageName() + "." + name;
        }
        this._storeInCache(key, name, pos);
        return name;
    }

    public boolean _isAnonymousInnerClass(int pos, int openCurlyPos) throws BadLocationException {
        Query.AnonymousInnerClass key = new Query.AnonymousInnerClass(pos, openCurlyPos);
        Boolean cached = (Boolean)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        int newPos = pos;
        cached = false;
        String text = this.getText(0, openCurlyPos + 1);
        int classStart = this.getFirstNonWSCharPos(newPos += "new".length());
        if (classStart != -1) {
            int origParenStart;
            int classEnd;
            for (classEnd = classStart + 1; classEnd < text.length() && (Character.isJavaIdentifierPart(text.charAt(classEnd)) || text.charAt(classEnd) == '.'); ++classEnd) {
            }
            int parenStart = this.getFirstNonWSCharPos(classEnd);
            if (parenStart != -1 && text.charAt(origParenStart = parenStart) == '<') {
                parenStart = -1;
                int closePointyBracket = this.findNextEnclosingBrace(origParenStart, '<', '>');
                if (closePointyBracket != -1 && text.charAt(closePointyBracket) == '>') {
                    parenStart = this.getFirstNonWSCharPos(closePointyBracket + 1);
                }
            }
            if (parenStart != -1 && text.charAt(parenStart) == '(') {
                this.setCurrentLocation(parenStart + 1);
                int parenEnd = this.balanceForward();
                if (parenEnd > -1) {
                    int afterParen = this.getFirstNonWSCharPos(parenEnd = parenEnd + parenStart + 1);
                    cached = afterParen == openCurlyPos;
                }
            }
        }
        this._storeInCache(key, cached, openCurlyPos);
        return cached;
    }

    /*
     * Loose catch block
     */
    public String getPackageName() {
        StringReader r = new StringReader(this.getText());
        try {
            String string = new Parser(r).packageDeclaration().getName();
            return string;
        }
        catch (ParseException e) {
            String e2 = "";
            return e2;
        }
        catch (TokenMgrError e) {
            String e2 = "";
            return e2;
        }
        catch (Error e3) {
            block20: {
                String msg = e3.getMessage();
                if (msg == null || !msg.startsWith("Invalid escape character")) break block20;
                String string = "";
                return string;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            throw e3;
        }
        finally {
            try {
                ((Reader)r).close();
            }
            catch (IOException e) {}
        }
    }

    int _getAnonymousInnerClassIndex(int pos) throws BadLocationException, ClassNameNotFoundException {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        Query.AnonymousInnerClassIndex key = new Query.AnonymousInnerClassIndex(pos);
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        int newPos = pos;
        String className = this._getEnclosingClassName(newPos - 2, true);
        String text = this.getText(0, newPos - 2);
        int index = 1;
        while ((newPos = this._findPrevKeyword(text, "new", newPos - 4)) != -1) {
            int parenEnd;
            int nextOpenCurly;
            int classEnd;
            int afterNewPos = newPos + "new".length();
            int classStart = this.getFirstNonWSCharPos(afterNewPos);
            if (classStart == -1) continue;
            for (classEnd = classStart + 1; classEnd < text.length() && (Character.isJavaIdentifierPart(text.charAt(classEnd)) || text.charAt(classEnd) == '.'); ++classEnd) {
            }
            int parenStart = this.getFirstNonWSCharPos(classEnd);
            if (parenStart == -1) continue;
            int origParenStart = parenStart;
            if (text.charAt(origParenStart) == '<') {
                parenStart = -1;
                int closePointyBracket = this.findNextEnclosingBrace(origParenStart, '<', '>');
                if (closePointyBracket != -1 && text.charAt(closePointyBracket) == '>') {
                    parenStart = this.getFirstNonWSCharPos(closePointyBracket + 1);
                }
            }
            if (parenStart == -1 || text.charAt(parenStart) != '(' || (nextOpenCurly = this._findNextOpenCurly(text, parenEnd = this.findNextEnclosingBrace(parenStart, '(', ')'))) == -1 || !this._isAnonymousInnerClass(newPos, nextOpenCurly)) continue;
            String cn = this._getEnclosingClassName(newPos, true);
            if (!cn.startsWith(className)) break;
            if (!cn.equals(className)) {
                newPos = this.findPrevEnclosingBrace(newPos, '{', '}');
                continue;
            }
            ++index;
        }
        this._storeInCache(key, index, pos);
        return index;
    }

    public String getEnclosingTopLevelClassName(int pos) throws ClassNameNotFoundException {
        int oldPos = this._currentLocation;
        try {
            this.setCurrentLocation(pos);
            BraceInfo info = this._getEnclosingBrace();
            int topLevelBracePos = -1;
            String braceType = info.braceType();
            while (!braceType.equals("")) {
                if (braceType.equals("{")) {
                    topLevelBracePos = this._currentLocation - info.distance();
                }
                this.move(-info.distance());
                info = this._getEnclosingBrace();
                braceType = info.braceType();
            }
            if (topLevelBracePos == -1) {
                this.setCurrentLocation(oldPos);
                throw new ClassNameNotFoundException("no top level brace found");
            }
            char[] delims = new char[]{'{', '}', ';'};
            int prevDelimPos = this.findPrevDelimiter(topLevelBracePos, delims);
            prevDelimPos = prevDelimPos == -1 ? 0 : ++prevDelimPos;
            this.setCurrentLocation(oldPos);
            String string = this.getNextTopLevelClassName(prevDelimPos, topLevelBracePos);
            return string;
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
        finally {
            this.setCurrentLocation(oldPos);
        }
    }

    private String getFirstClassName(int indexOfClass, int indexOfInterface, int indexOfEnum) throws ClassNameNotFoundException {
        if (indexOfClass == -1 && indexOfInterface == -1 && indexOfEnum == -1) {
            throw ClassNameNotFoundException.DEFAULT;
        }
        if (indexOfEnum == -1 || indexOfClass != -1 && indexOfClass < indexOfEnum || indexOfInterface != -1 && indexOfInterface < indexOfEnum) {
            if (indexOfInterface == -1 || indexOfClass != -1 && indexOfClass < indexOfInterface) {
                return this.getNextIdentifier(indexOfClass + "class".length());
            }
            return this.getNextIdentifier(indexOfInterface + "interface".length());
        }
        return this.getNextIdentifier(indexOfEnum + "enum".length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMainClassName() throws ClassNameNotFoundException {
        int oldPos = this._currentLocation;
        try {
            int indexOfPublicEnum;
            int indexOfPublicInterface;
            this.setCurrentLocation(0);
            String text = this.getText();
            int indexOfClass = this._findKeywordAtToplevel("class", text, 0);
            int indexOfInterface = this._findKeywordAtToplevel("interface", text, 0);
            int indexOfEnum = this._findKeywordAtToplevel("enum", text, 0);
            int indexOfPublic = this._findKeywordAtToplevel("public", text, 0);
            if (indexOfPublic == -1) {
                String string = this.getFirstClassName(indexOfClass, indexOfInterface, indexOfEnum);
                return string;
            }
            int afterPublic = indexOfPublic + "public".length();
            String subText = text.substring(afterPublic);
            this.setCurrentLocation(afterPublic);
            int indexOfPublicClass = this._findKeywordAtToplevel("class", subText, afterPublic);
            if (indexOfPublicClass != -1) {
                indexOfPublicClass += afterPublic;
            }
            if ((indexOfPublicInterface = this._findKeywordAtToplevel("interface", subText, afterPublic)) != -1) {
                indexOfPublicInterface += afterPublic;
            }
            if ((indexOfPublicEnum = this._findKeywordAtToplevel("enum", subText, afterPublic)) != -1) {
                indexOfPublicEnum += afterPublic;
            }
            String string = this.getFirstClassName(indexOfPublicClass, indexOfPublicInterface, indexOfPublicEnum);
            return string;
        }
        finally {
            this.setCurrentLocation(oldPos);
        }
    }

    public String getFirstTopLevelClassName() throws ClassNameNotFoundException {
        return this.getNextTopLevelClassName(0, this.getLength());
    }

    public String getNextTopLevelClassName(int startPos, int endPos) throws ClassNameNotFoundException {
        int oldPos = this._currentLocation;
        try {
            int index;
            this.setCurrentLocation(startPos);
            int textLength = endPos - startPos;
            String text = this.getText(startPos, textLength);
            int indexOfClass = this._findKeywordAtToplevel("class", text, startPos);
            int indexOfInterface = this._findKeywordAtToplevel("interface", text, startPos);
            int indexOfEnum = this._findKeywordAtToplevel("enum", text, startPos);
            if (!(indexOfClass <= -1 || indexOfInterface > -1 && indexOfClass >= indexOfInterface || indexOfEnum > -1 && indexOfClass >= indexOfEnum)) {
                index = indexOfClass + "class".length();
            } else if (!(indexOfInterface <= -1 || indexOfClass > -1 && indexOfInterface >= indexOfClass || indexOfEnum > -1 && indexOfInterface >= indexOfEnum)) {
                index = indexOfInterface + "interface".length();
            } else if (!(indexOfEnum <= -1 || indexOfClass > -1 && indexOfEnum >= indexOfClass || indexOfInterface > -1 && indexOfEnum >= indexOfInterface)) {
                index = indexOfEnum + "enum".length();
            } else {
                throw ClassNameNotFoundException.DEFAULT;
            }
            String string = this.getNextIdentifier(startPos + index);
            return string;
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
        catch (IllegalStateException e) {
            throw new ClassNameNotFoundException("No top level class name found");
        }
        finally {
            this.setCurrentLocation(oldPos);
        }
    }

    private String getNextIdentifier(int startPos) throws ClassNameNotFoundException {
        try {
            int length;
            int index = this.getFirstNonWSCharPos(startPos);
            if (index == -1) {
                throw new IllegalStateException("No identifier found");
            }
            String text = this.getText();
            int endIndex = length = text.length();
            for (int i = index; i < length; ++i) {
                char c = text.charAt(i);
                if (Character.isJavaIdentifierPart(c)) continue;
                endIndex = i;
                break;
            }
            return text.substring(index, endIndex);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    private int _findKeywordAtToplevel(String keyword, String text, int textOffset) {
        int oldPos = this._currentLocation;
        int index = 0;
        while ((index = text.indexOf(keyword, index)) != -1) {
            this.setCurrentLocation(textOffset + index);
            int indexPastKeyword = index + keyword.length();
            if (indexPastKeyword < text.length()) {
                if (!this.isShadowed() && Character.isWhitespace(text.charAt(indexPastKeyword))) {
                    if (this.notInBlock(index)) break;
                    index = -1;
                    break;
                }
                ++index;
                continue;
            }
            index = -1;
            break;
        }
        this.setCurrentLocation(oldPos);
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Position createPosition(int offset) throws BadLocationException {
        WrappedPosition wp = new WrappedPosition(this.createUnwrappedPosition(offset));
        Object object = _wrappedPosListLock;
        synchronized (object) {
            if (this._wrappedPosList == null) {
                this._wrappedPosList = new LinkedList();
            }
            this._wrappedPosList.add(new WeakReference<WrappedPosition>(wp));
        }
        return wp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WeakHashMap<WrappedPosition, Integer> getWrappedPositionOffsets() {
        LinkedList<WeakReference> newList = new LinkedList<WeakReference>();
        Object object = _wrappedPosListLock;
        synchronized (object) {
            if (this._wrappedPosList == null) {
                this._wrappedPosList = new LinkedList();
            }
            WeakHashMap<WrappedPosition, Integer> ret = new WeakHashMap<WrappedPosition, Integer>(this._wrappedPosList.size());
            for (WeakReference weakReference : this._wrappedPosList) {
                if (weakReference.get() == null) continue;
                newList.add(weakReference);
                ret.put((WrappedPosition)weakReference.get(), ((WrappedPosition)weakReference.get()).getOffset());
            }
            this._wrappedPosList.clear();
            this._wrappedPosList = newList;
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWrappedPositionOffsets(WeakHashMap<WrappedPosition, Integer> whm) throws BadLocationException {
        Object object = _wrappedPosListLock;
        synchronized (object) {
            if (this._wrappedPosList == null) {
                this._wrappedPosList = new LinkedList();
            }
            this._wrappedPosList.clear();
            for (Map.Entry<WrappedPosition, Integer> entry : whm.entrySet()) {
                if (entry.getKey() == null) continue;
                WrappedPosition wp = entry.getKey();
                wp.setWrapped(this.createUnwrappedPosition(entry.getValue()));
                this._wrappedPosList.add(new WeakReference<WrappedPosition>(wp));
            }
        }
    }

    public CompoundUndoManager getUndoManager() {
        return this._undoManager;
    }

    public void resetUndoManager() {
        this._undoManager = new CompoundUndoManager(this._notifier);
        this._undoManager.setLimit(1000);
    }

    public UndoableEdit getNextUndo() {
        return this._undoManager.getNextUndo();
    }

    public UndoableEdit getNextRedo() {
        return this._undoManager.getNextRedo();
    }

    public void documentSaved() {
        this._undoManager.documentSaved();
    }

    @Override
    protected int startCompoundEdit() {
        return this._undoManager.startCompoundEdit();
    }

    @Override
    protected void endCompoundEdit(int key) {
        this._undoManager.endCompoundEdit(key);
    }

    @Override
    protected void endLastCompoundEdit() {
        this._undoManager.endLastCompoundEdit();
    }

    @Override
    protected void addUndoRedo(AbstractDocument.DefaultDocumentEvent chng, Runnable undoCommand, Runnable doCommand) {
        chng.addEdit(new CommandUndoableEdit(undoCommand, doCommand));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFinalizationListener(FinalizationListener<DefinitionsDocument> fl) {
        List<FinalizationListener<DefinitionsDocument>> list = this._finalizationListeners;
        synchronized (list) {
            this._finalizationListeners.add(fl);
        }
    }

    @Override
    public List<FinalizationListener<DefinitionsDocument>> getFinalizationListeners() {
        return this._finalizationListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        FinalizationEvent<DefinitionsDocument> fe = new FinalizationEvent<DefinitionsDocument>(this);
        List<FinalizationListener<DefinitionsDocument>> list = this._finalizationListeners;
        synchronized (list) {
            for (FinalizationListener<DefinitionsDocument> fl : this._finalizationListeners) {
                fl.finalized(fe);
            }
        }
    }

    public String toString() {
        return "ddoc for " + this._odd;
    }

    private static class CommandUndoableEdit
    extends AbstractUndoableEdit {
        private final Runnable _undoCommand;
        private final Runnable _redoCommand;

        public CommandUndoableEdit(Runnable undoCommand, Runnable redoCommand) {
            this._undoCommand = undoCommand;
            this._redoCommand = redoCommand;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this._undoCommand.run();
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this._redoCommand.run();
        }

        public boolean isSignificant() {
            return false;
        }
    }

    public static class WrappedPosition
    implements Position {
        private Position _wrapped;

        WrappedPosition(Position w) {
            this.setWrapped(w);
        }

        public void setWrapped(Position w) {
            this._wrapped = w;
        }

        public int getOffset() {
            return this._wrapped.getOffset();
        }
    }
}

