/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.reducedmodel;

import edu.rice.cs.plt.collect.WeakHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModelList<T> {
    private Node<T> _head = new Node();
    private Node<T> _tail = new Node();
    private int _length;
    private Set<ModelIterator> _listeners;

    ModelList() {
        this._head._prev = null;
        this._head._next = this._tail;
        this._tail._prev = this._head;
        this._tail._next = null;
        this._length = 0;
        this._listeners = new WeakHashSet<ModelIterator>();
    }

    public void insertFront(T item) {
        this.insert(this._head._next, item);
    }

    private Node<T> insert(Node<T> point, T item) {
        assert (point != this._head);
        Node<T> newNode = point.insert(item);
        ++this._length;
        return newNode;
    }

    private void remove(Node<T> point) {
        assert (point != this._head && point != this._tail);
        point.remove();
        --this._length;
    }

    private void addListener(ModelIterator that) {
        this._listeners.add(that);
    }

    private void removeListener(ModelIterator that) {
        this._listeners.remove(that);
    }

    public int listenerCount() {
        return this._listeners.size();
    }

    public boolean isEmpty() {
        return this._head._next == this._tail;
    }

    public int length() {
        return this._length;
    }

    public ModelIterator getIterator() {
        return new ModelIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ModelIterator {
        private Node<T> _point;
        private int _pos;

        public ModelIterator() {
            this._point = ModelList.this._head;
            this._pos = 0;
            ModelList.this.addListener(this);
        }

        public ModelIterator(ModelIterator iter) {
            this._point = iter._point;
            this._pos = iter._pos;
            ModelList.this.addListener(this);
        }

        public ModelIterator copy() {
            return new ModelIterator(this);
        }

        public boolean eq(ModelIterator that) {
            return this._point == that._point;
        }

        public void setTo(ModelIterator that) {
            this._point = that._point;
            this._pos = that._pos;
        }

        public void dispose() {
            ModelList.this.removeListener(this);
        }

        public boolean atStart() {
            return this._point == ModelList.this._head;
        }

        public boolean atEnd() {
            return this._point == ModelList.this._tail;
        }

        public boolean atFirstItem() {
            return this._point._prev == ModelList.this._head;
        }

        public boolean atLastItem() {
            return this._point._next == ModelList.this._tail;
        }

        public T current() {
            return this._point._item;
        }

        public T prevItem() {
            assert (!(this.atStart() || ModelList.this.isEmpty() || this.atFirstItem()));
            return this._point._prev._item;
        }

        public T nextItem() {
            assert (!(this.atStart() || ModelList.this.isEmpty() || this.atLastItem()));
            return this._point._next._item;
        }

        public int pos() {
            return this._pos;
        }

        public void insert(T item) {
            if (this.atStart()) {
                this.next();
            }
            this._point = ModelList.this.insert(this._point, item);
            int savPos = this._pos;
            this.notifyOfInsert(this._pos);
            this._pos = savPos;
        }

        public void remove() {
            Node succ = this._point._next;
            ModelList.this.remove(this._point);
            this._point = succ;
            this.notifyOfRemove(this._pos, succ);
        }

        public void prev() {
            assert (!this.atStart());
            this._point = this._point._prev;
            --this._pos;
        }

        public void next() {
            assert (!this.atEnd());
            this._point = this._point._next;
            ++this._pos;
        }

        public void collapse(ModelIterator iter) {
            Node rightPoint;
            int rightPos;
            Node leftPoint;
            int leftPos;
            int itPos = iter._pos;
            int diff = Math.abs(this._pos - itPos);
            if (diff <= 1) {
                return;
            }
            if (this._pos > itPos) {
                leftPos = itPos;
                leftPoint = iter._point;
                rightPos = this._pos;
                rightPoint = this._point;
            } else {
                leftPos = this._pos;
                leftPoint = this._point;
                rightPos = itPos;
                rightPoint = iter._point;
            }
            rightPoint._prev = leftPoint;
            leftPoint._next = rightPoint;
            ModelList.this._length -= rightPos - leftPos - 1;
            this.notifyOfCollapse(leftPos, rightPos, rightPoint);
        }

        private void notifyOfInsert(int pos) {
            for (ModelIterator listener : ModelList.this._listeners) {
                int lisPos = listener._pos;
                if (lisPos < pos) continue;
                listener._pos = lisPos + 1;
            }
        }

        private void notifyOfRemove(int pos, Node<T> point) {
            for (ModelIterator listener : ModelList.this._listeners) {
                int lisPos = listener._pos;
                if (lisPos == pos) {
                    listener._point = point;
                    continue;
                }
                if (lisPos <= pos) continue;
                listener._pos = lisPos - 1;
            }
        }

        private void notifyOfCollapse(int leftPos, int rightPos, Node<T> rightPoint) {
            for (ModelIterator listener : ModelList.this._listeners) {
                int lisPos = listener._pos;
                if (lisPos <= leftPos) continue;
                if (lisPos < rightPos) {
                    listener._pos = leftPos + 1;
                    listener._point = rightPoint;
                    continue;
                }
                listener._pos = lisPos - (rightPos - leftPos - 1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<T> {
        Node<T> _prev;
        Node<T> _next;
        T _item;

        Node() {
        }

        Node(T item, Node<T> pred, Node<T> succ) {
            this._item = item;
            this._prev = pred;
            this._next = succ;
        }

        Node<T> insert(T item) {
            assert (this._prev != null);
            Node<T> newNode = new Node<T>(item, this._prev, this);
            this._prev._next = newNode;
            this._prev = newNode;
            return newNode;
        }

        void remove() {
            assert (this._prev != null && this._next != null);
            this._prev._next = this._next;
            this._next._prev = this._prev;
        }
    }
}

