/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.junit;

import edu.rice.cs.drjava.model.junit.JUnitError;
import edu.rice.cs.drjava.model.junit.JUnitModelCallback;
import edu.rice.cs.drjava.model.junit.JUnitTestRunner;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.reflect.ShadowingClassLoader;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.classloader.ClassFileError;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitTestManager {
    protected static final Log _log = new Log("/Users/cork/drjava/drjava/GlobalModel.txt", false);
    private final JUnitModelCallback _jmc;
    private final Lambda<ClassLoader, ClassLoader> _loaderFactory;
    private JUnitTestRunner _testRunner;
    private TestSuite _suite = null;
    private List<String> _testClassNames = null;
    private List<File> _testFiles = null;

    public JUnitTestManager(JUnitModelCallback jmc, Lambda<ClassLoader, ClassLoader> loaderFactory) {
        this._jmc = jmc;
        this._loaderFactory = loaderFactory;
    }

    public List<String> findTestClasses(List<String> classNames, List<File> files) {
        _log.log("findTestClasses(" + classNames + ", " + files + ")");
        if (this._testClassNames != null && !this._testClassNames.isEmpty()) {
            throw new IllegalStateException("Test suite is still pending!");
        }
        this._testRunner = this.makeRunner();
        this._testClassNames = new ArrayList<String>();
        this._testFiles = new ArrayList<File>();
        this._suite = new TestSuite();
        for (Pair pair : IterUtil.zip(classNames, files)) {
            String cName = (String)pair.first();
            try {
                if (!this._isJUnitTest(this._testRunner.loadPossibleTest(cName))) continue;
                this._testClassNames.add(cName);
                this._testFiles.add((File)pair.second());
                this._suite.addTest(this._testRunner.getTest(cName));
            }
            catch (ClassNotFoundException e) {
                DebugUtil.error.log(e);
            }
            catch (LinkageError e) {
                String path = IOUtil.attemptAbsoluteFile((File)pair.second()).getPath();
                this._jmc.classFileError(new ClassFileError(cName, path, e));
            }
        }
        _log.log("returning: " + this._testClassNames);
        return this._testClassNames;
    }

    public boolean runTestSuite() {
        _log.log("runTestSuite() called");
        if (this._testClassNames == null || this._testClassNames.isEmpty()) {
            return false;
        }
        try {
            TestResult result = this._testRunner.runSuite(this._suite);
            JUnitError[] errors = new JUnitError[result.errorCount() + result.failureCount()];
            Enumeration<TestFailure> failures = result.failures();
            Enumeration<TestFailure> errEnum = result.errors();
            int i = 0;
            while (errEnum.hasMoreElements()) {
                TestFailure tErr = errEnum.nextElement();
                errors[i] = this._makeJUnitError(tErr, this._testClassNames, true, this._testFiles);
                ++i;
            }
            while (failures.hasMoreElements()) {
                TestFailure tFail = failures.nextElement();
                errors[i] = this._makeJUnitError(tFail, this._testClassNames, false, this._testFiles);
                ++i;
            }
            this._reset();
            this._jmc.testSuiteEnded(errors);
        }
        catch (Exception e) {
            JUnitError[] errors = new JUnitError[]{new JUnitError(null, -1, -1, e.getMessage(), false, "", "", StringOps.getStackTrace(e))};
            this._reset();
            this._jmc.testSuiteEnded(errors);
        }
        _log.log("Exiting runTestSuite()");
        return true;
    }

    private void _reset() {
        this._suite = null;
        this._testClassNames = null;
        this._testFiles = null;
        _log.log("test manager state reset");
    }

    private boolean _isJUnitTest(Class<?> c) {
        boolean result = Test.class.isAssignableFrom(c) && !Modifier.isAbstract(c.getModifiers()) && !Modifier.isInterface(c.getModifiers());
        return result;
    }

    private JUnitError _makeJUnitError(TestFailure failure, List<String> classNames, boolean isError, List<File> files) {
        Test failedTest = failure.failedTest();
        String testName = failedTest instanceof TestCase ? ((TestCase)failedTest).getName() : failedTest.getClass().getName();
        String testString = failure.toString();
        int firstIndex = testString.indexOf(40) + 1;
        int secondIndex = testString.indexOf(41);
        String className = firstIndex != secondIndex ? testString.substring(firstIndex, secondIndex) : testString.substring(0, firstIndex - 1);
        String classNameAndTest = className + "." + testName;
        String stackTrace = StringOps.getStackTrace(failure.thrownException());
        int lineNum = -1;
        if (stackTrace.indexOf(classNameAndTest) == -1) {
            String trace = failure.trace();
            trace = trace.substring(trace.indexOf(10) + 1);
            while (trace.indexOf("junit.framework.Assert") != -1 && trace.indexOf("junit.framework.Assert") < trace.indexOf("(")) {
                trace = trace.substring(trace.indexOf(10) + 1);
            }
            trace = trace.substring(trace.indexOf(40) + 1);
            trace = trace.substring(0, trace.indexOf(41));
            if (stackTrace.indexOf(className) == -1) {
                className = trace.substring(0, trace.lastIndexOf(46));
                classNameAndTest = className + "." + testName;
            }
            try {
                lineNum = Integer.parseInt(trace.substring(trace.indexOf(58) + 1)) - 1;
            }
            catch (NumberFormatException e) {
                throw new UnexpectedException(e);
            }
        }
        if (lineNum < 0) {
            lineNum = this._lineNumber(stackTrace, classNameAndTest);
        }
        String exception = isError ? failure.thrownException().toString() : failure.thrownException().getMessage();
        boolean isFailure = failure.thrownException() instanceof AssertionFailedError && !classNameAndTest.equals("junit.framework.TestSuite$1.warning");
        int indexOfClass = classNames.indexOf(className);
        File file = indexOfClass != -1 ? files.get(indexOfClass) : this._jmc.getFileForClassName(className);
        if (file == null) {
            return new JUnitError(new File("nofile"), 0, 0, exception, !isFailure, testName, className, stackTrace);
        }
        String name = file.getName();
        int adjLineNum = name.endsWith(".dj0") || name.endsWith(".dj0") ? lineNum - 1 : lineNum;
        return new JUnitError(file, adjLineNum, 0, exception, !isFailure, testName, className, stackTrace);
    }

    private int _lineNumber(String sw, String classname) {
        int lineNum;
        int idxClassname = sw.indexOf(classname);
        if (idxClassname == -1) {
            return -1;
        }
        String theLine = sw.substring(idxClassname, sw.length());
        theLine = theLine.substring(theLine.indexOf(classname), theLine.length());
        theLine = theLine.substring(theLine.indexOf("(") + 1, theLine.length());
        theLine = theLine.substring(0, theLine.indexOf(")"));
        try {
            int i = theLine.indexOf(":") + 1;
            lineNum = Integer.parseInt(theLine.substring(i, theLine.length())) - 1;
        }
        catch (NumberFormatException e) {
            throw new UnexpectedException(e);
        }
        return lineNum;
    }

    private JUnitTestRunner makeRunner() {
        ClassLoader current = JUnitTestManager.class.getClassLoader();
        ShadowingClassLoader parent = ShadowingClassLoader.whiteList(current, "junit", "org.junit");
        return new JUnitTestRunner(this._jmc, this._loaderFactory.value(parent));
    }
}

