/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl.newjvm;

import edu.rice.cs.drjava.model.junit.JUnitError;
import edu.rice.cs.drjava.model.junit.JUnitModelCallback;
import edu.rice.cs.drjava.model.junit.JUnitTestManager;
import edu.rice.cs.drjava.model.repl.newjvm.ClassPathManager;
import edu.rice.cs.drjava.model.repl.newjvm.InterpretResult;
import edu.rice.cs.drjava.model.repl.newjvm.InterpreterJVMRemoteI;
import edu.rice.cs.drjava.model.repl.newjvm.MainJVMRemoteI;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.interpreter.ClassContext;
import edu.rice.cs.dynamicjava.interpreter.ClassSignatureContext;
import edu.rice.cs.dynamicjava.interpreter.DelegatingContext;
import edu.rice.cs.dynamicjava.interpreter.EvaluatorException;
import edu.rice.cs.dynamicjava.interpreter.Interpreter;
import edu.rice.cs.dynamicjava.interpreter.InterpreterException;
import edu.rice.cs.dynamicjava.interpreter.LocalContext;
import edu.rice.cs.dynamicjava.interpreter.RuntimeBindings;
import edu.rice.cs.dynamicjava.interpreter.TopLevelContext;
import edu.rice.cs.dynamicjava.interpreter.TypeContext;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.LocalVariable;
import edu.rice.cs.dynamicjava.symbol.SymbolUtil;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.text.TextUtil;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.OptionVisitor;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.InputStreamRedirector;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.OutputStreamRedirector;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.classloader.ClassFileError;
import edu.rice.cs.util.newjvm.AbstractSlaveJVM;
import edu.rice.cs.util.newjvm.MasterRemote;
import java.io.File;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpreterJVM
extends AbstractSlaveJVM
implements InterpreterJVMRemoteI,
JUnitModelCallback {
    public static final InterpreterJVM ONLY;
    private static final Log _log;
    private final Options _interpreterOptions;
    private volatile Pair<String, Interpreter> _activeInterpreter;
    private final Interpreter _defaultInterpreter;
    private final Map<String, Interpreter> _interpreters;
    private final Set<Interpreter> _busyInterpreters;
    private final Map<String, Pair<TypeContext, RuntimeBindings>> _environments;
    private final ClassPathManager _classPathManager;
    private final ClassLoader _interpreterLoader;
    private final JUnitTestManager _junitTestManager;
    private volatile MainJVMRemoteI _mainJVM;
    private volatile boolean _messageOnResetFailure;

    private InterpreterJVM() throws RemoteException {
        this._quitSlaveThreadName = "Reset Interactions Thread";
        this._pollMasterThreadName = "Poll DrJava Thread";
        SizedIterable<File> runtimeCP = IOUtil.parsePath(System.getProperty("java.class.path", ""));
        this._classPathManager = new ClassPathManager(runtimeCP);
        this._interpreterLoader = this._classPathManager.makeClassLoader(null);
        this._junitTestManager = new JUnitTestManager(this, this._classPathManager);
        this._messageOnResetFailure = true;
        this._interpreterOptions = Options.DEFAULT;
        this._defaultInterpreter = new Interpreter(this._interpreterOptions, this._interpreterLoader);
        this._interpreters = new HashMap<String, Interpreter>();
        this._busyInterpreters = new HashSet<Interpreter>();
        this._environments = new HashMap<String, Pair<TypeContext, RuntimeBindings>>();
        this._activeInterpreter = Pair.make("", this._defaultInterpreter);
    }

    @Override
    protected void handleStart(MasterRemote mainJVM) {
        this._mainJVM = (MainJVMRemoteI)mainJVM;
        System.setIn(new InputStreamRedirector(){

            protected String _getInput() {
                try {
                    return InterpreterJVM.this._mainJVM.getConsoleInput();
                }
                catch (RemoteException re) {
                    _log.log("System.in: " + re.toString());
                    throw new IllegalStateException("Main JVM can't be reached for input.\n" + re);
                }
            }
        });
        System.setOut(new PrintStream(new OutputStreamRedirector(){

            public void print(String s) {
                try {
                    InterpreterJVM.this._mainJVM.systemOutPrint(s);
                }
                catch (RemoteException re) {
                    DebugUtil.error.log(re);
                    _log.log("System.out: " + re.toString());
                }
            }
        }));
        System.setErr(new PrintStream(new OutputStreamRedirector(){

            public void print(String s) {
                try {
                    InterpreterJVM.this._mainJVM.systemErrPrint(s);
                }
                catch (RemoteException re) {
                    DebugUtil.error.log(re);
                    _log.log("System.err: " + re.toString());
                }
            }
        }));
        if (PlatformFactory.ONLY.isWindowsPlatform()) {
            JDialog d = new JDialog();
            d.setSize(0, 0);
            d.setVisible(true);
            d.setVisible(false);
        }
    }

    @Override
    public void setShowMessageOnResetFailure(boolean show) {
        this._messageOnResetFailure = show;
    }

    @Override
    protected void quitFailed(Throwable th) {
        if (this._messageOnResetFailure) {
            String msg = "The interactions pane could not be reset:\n" + th;
            JOptionPane.showMessageDialog(null, msg);
        }
        try {
            this._mainJVM.quitFailed(th);
        }
        catch (RemoteException re) {
            _log.log("quitFailed: " + re.toString());
        }
    }

    @Override
    public InterpretResult interpret(String s) {
        return this.interpret(s, this._activeInterpreter.second());
    }

    public InterpretResult interpret(String s, String interpreterName) {
        Interpreter i = this._interpreters.get(interpreterName);
        if (i == null) {
            throw new IllegalArgumentException("Interpreter '" + interpreterName + "' does not exist.");
        }
        return this.interpret(s, i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InterpretResult interpret(String input, Interpreter interpreter) {
        DebugUtil.debug.logStart("Interpret " + input);
        boolean available = this._busyInterpreters.add(interpreter);
        if (!available) {
            DebugUtil.debug.logEnd();
            return InterpretResult.busy();
        }
        Option<Object> result = null;
        try {
            result = interpreter.interpret(input);
        }
        catch (InterpreterException e) {
            DebugUtil.debug.logEnd();
            InterpretResult interpretResult = InterpretResult.exception(e);
            return interpretResult;
        }
        catch (Throwable e) {
            DebugUtil.debug.logEnd();
            InterpretResult interpretResult = InterpretResult.unexpectedException(e);
            return interpretResult;
        }
        finally {
            this._busyInterpreters.remove(interpreter);
        }
        return result.apply(new OptionVisitor<Object, InterpretResult>(){

            @Override
            public InterpretResult forNone() {
                return InterpretResult.noValue();
            }

            @Override
            public InterpretResult forSome(Object obj) {
                if (obj instanceof String) {
                    DebugUtil.debug.logEnd();
                    return InterpretResult.stringValue((String)obj);
                }
                if (obj instanceof Character) {
                    DebugUtil.debug.logEnd();
                    return InterpretResult.charValue((Character)obj);
                }
                if (obj instanceof Number) {
                    DebugUtil.debug.logEnd();
                    return InterpretResult.numberValue((Number)obj);
                }
                if (obj instanceof Boolean) {
                    DebugUtil.debug.logEnd();
                    return InterpretResult.booleanValue((Boolean)obj);
                }
                try {
                    String resultString = TextUtil.toString(obj);
                    DebugUtil.debug.logEnd();
                    return InterpretResult.objectValue(resultString);
                }
                catch (Throwable t) {
                    DebugUtil.debug.logEnd();
                    return InterpretResult.exception(new EvaluatorException(t));
                }
            }
        });
    }

    public Object[] getVariable(String var) {
        Pair<TypeContext, RuntimeBindings> env = this._environments.get(this._activeInterpreter.first());
        if (env == null) {
            return new Object[0];
        }
        LocalVariable lv = env.first().getLocalVariable(var, this._interpreterOptions.typeSystem());
        if (lv == null) {
            return new Object[0];
        }
        return new Object[]{env.second().get(lv)};
    }

    @Override
    public String getVariableToString(String var) {
        Object[] val = this.getVariable(var);
        if (val.length == 0) {
            return null;
        }
        try {
            return TextUtil.toString(val[0]);
        }
        catch (Throwable t) {
            return "<error in toString()>";
        }
    }

    @Override
    public String getVariableType(String var) {
        Pair<TypeContext, RuntimeBindings> env = this._environments.get(this._activeInterpreter.first());
        if (env == null) {
            return null;
        }
        LocalVariable lv = env.first().getLocalVariable(var, this._interpreterOptions.typeSystem());
        if (lv == null) {
            return null;
        }
        return this._interpreterOptions.typeSystem().userRepresentation(lv.type());
    }

    @Override
    public void addInterpreter(String name) {
        if (this._interpreters.containsKey(name)) {
            throw new IllegalArgumentException("'" + name + "' is not a unique interpreter name");
        }
        Interpreter i = new Interpreter(this._interpreterOptions, this._interpreterLoader);
        this._interpreters.put(name, i);
    }

    public void addInterpreter(String name, Object thisVal, Class<?> thisClass, Object[] localVars, String[] localVarNames, Class<?>[] localVarClasses) {
        DebugUtil.debug.logValues(new String[]{"name", "thisVal", "thisClass", "localVars", "localVarNames", "localVarClasses"}, name, thisVal, thisClass, localVars, localVarNames, localVarClasses);
        if (this._interpreters.containsKey(name)) {
            throw new IllegalArgumentException("'" + name + "' is not a unique interpreter name");
        }
        if (localVars.length != localVarNames.length || localVars.length != localVarClasses.length) {
            throw new IllegalArgumentException("Local variable arrays are inconsistent");
        }
        Package pkg = thisClass.getPackage();
        DJClass c = SymbolUtil.wrapClass(thisClass);
        LinkedList<LocalVariable> vars = new LinkedList<LocalVariable>();
        for (int i = 0; i < localVars.length; ++i) {
            if (localVarClasses[i] == null) {
                try {
                    localVarClasses[i] = (Class)localVars[i].getClass().getField("TYPE").get(null);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            Type varT = SymbolUtil.typeOfGeneralClass(localVarClasses[i], this._interpreterOptions.typeSystem());
            vars.add(new LocalVariable(localVarNames[i], varT, false));
        }
        TypeContext ctx = new TopLevelContext(this._interpreterLoader);
        if (pkg != null) {
            ctx = ctx.setPackage(pkg.getName());
        }
        ctx = new ClassSignatureContext(ctx, c, this._interpreterLoader);
        ctx = new ClassContext(ctx, c);
        ctx = new DebugMethodContext(ctx, thisVal == null);
        ctx = new LocalContext(ctx, vars);
        RuntimeBindings bindings = RuntimeBindings.EMPTY;
        if (thisVal != null) {
            bindings = new RuntimeBindings(bindings, c, thisVal);
        }
        bindings = new RuntimeBindings(bindings, vars, IterUtil.asIterable(localVars));
        Interpreter i = new Interpreter(this._interpreterOptions, ctx, bindings);
        this._environments.put(name, Pair.make(ctx, bindings));
        this._interpreters.put(name, i);
    }

    @Override
    public void removeInterpreter(String name) {
        this._interpreters.remove(name);
        this._environments.remove(name);
    }

    @Override
    public synchronized boolean setActiveInterpreter(String name) {
        Interpreter i = this._interpreters.get(name);
        if (i == null) {
            throw new IllegalArgumentException("Interpreter '" + name + "' does not exist.");
        }
        this._activeInterpreter = Pair.make(name, i);
        return this._busyInterpreters.contains(i);
    }

    @Override
    public synchronized boolean setToDefaultInterpreter() {
        this._activeInterpreter = Pair.make("", this._defaultInterpreter);
        return this._busyInterpreters.contains(this._defaultInterpreter);
    }

    @Override
    public synchronized void setPrivateAccessible(boolean allow) {
    }

    @Override
    public List<String> findTestClasses(List<String> classNames, List<File> files) throws RemoteException {
        return this._junitTestManager.findTestClasses(classNames, files);
    }

    @Override
    public boolean runTestSuite() throws RemoteException {
        return this._junitTestManager.runTestSuite();
    }

    @Override
    public void nonTestCase(boolean isTestAll) {
        try {
            this._mainJVM.nonTestCase(isTestAll);
        }
        catch (RemoteException re) {
            _log.log("nonTestCase: " + re.toString());
        }
    }

    @Override
    public void classFileError(ClassFileError e) {
        try {
            this._mainJVM.classFileError(e);
        }
        catch (RemoteException re) {
            _log.log("classFileError: " + re.toString());
        }
    }

    @Override
    public void testSuiteStarted(int numTests) {
        try {
            this._mainJVM.testSuiteStarted(numTests);
        }
        catch (RemoteException re) {
            _log.log("testSuiteStarted: " + re.toString());
        }
    }

    @Override
    public void testStarted(String testName) {
        try {
            this._mainJVM.testStarted(testName);
        }
        catch (RemoteException re) {
            _log.log("testStarted" + re.toString());
        }
    }

    @Override
    public void testEnded(String testName, boolean wasSuccessful, boolean causedError) {
        try {
            this._mainJVM.testEnded(testName, wasSuccessful, causedError);
        }
        catch (RemoteException re) {
            _log.log("testEnded: " + re.toString());
        }
    }

    @Override
    public void testSuiteEnded(JUnitError[] errors) {
        try {
            this._mainJVM.testSuiteEnded(errors);
        }
        catch (RemoteException re) {
            _log.log("testSuiteFinished: " + re.toString());
        }
    }

    @Override
    public File getFileForClassName(String className) {
        try {
            return this._mainJVM.getFileForClassName(className);
        }
        catch (RemoteException re) {
            _log.log("getFileForClassName: " + re.toString());
            return null;
        }
    }

    @Override
    public void junitJVMReady() {
    }

    @Override
    public void addExtraClassPath(File f) {
        this._classPathManager.addExtraCP(f);
    }

    @Override
    public void addProjectClassPath(File f) {
        this._classPathManager.addProjectCP(f);
    }

    @Override
    public void addBuildDirectoryClassPath(File f) {
        this._classPathManager.addBuildDirectoryCP(f);
    }

    @Override
    public void addProjectFilesClassPath(File f) {
        this._classPathManager.addProjectFilesCP(f);
    }

    @Override
    public void addExternalFilesClassPath(File f) {
        this._classPathManager.addExternalFilesCP(f);
    }

    @Override
    public List<File> getClassPath() {
        return CollectUtil.makeList(this._classPathManager.getClassPath());
    }

    static {
        try {
            ONLY = new InterpreterJVM();
        }
        catch (RemoteException e) {
            throw new UnexpectedException(e);
        }
        _log = new Log("MasterSlave.txt", false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DebugMethodContext
    extends DelegatingContext {
        private final boolean _isStatic;

        public DebugMethodContext(TypeContext next, boolean isStatic) {
            super(next);
            this._isStatic = isStatic;
        }

        @Override
        protected TypeContext duplicate(TypeContext next) {
            return new DebugMethodContext(next, this._isStatic);
        }

        @Override
        public DJClass getThis() {
            return this._isStatic ? null : super.getThis();
        }

        @Override
        public DJClass getThis(String className) {
            return this._isStatic ? null : super.getThis(className);
        }

        @Override
        public Type getSuperType(TypeSystem ts) {
            return this._isStatic ? null : super.getSuperType(ts);
        }

        @Override
        public Type getReturnType() {
            return null;
        }

        @Override
        public Iterable<Type> getDeclaredThrownTypes() {
            return IterUtil.empty();
        }
    }
}

