/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.plugins.eclipse.repl;

import edu.rice.cs.drjava.model.repl.InteractionsDJDocument;
import edu.rice.cs.drjava.model.repl.InteractionsListener;
import edu.rice.cs.drjava.model.repl.RMIInteractionsModel;
import edu.rice.cs.drjava.model.repl.newjvm.MainJVM;
import edu.rice.cs.drjava.plugins.eclipse.EclipsePlugin;
import edu.rice.cs.drjava.plugins.eclipse.util.text.SWTDocumentAdapter;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.util.OutputStreamRedirector;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.text.ConsoleDocument;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseInteractionsModel
extends RMIInteractionsModel {
    protected static final int HISTORY_SIZE = 1000;
    protected static final int WRITE_DELAY = 50;
    public static final File WORKING_DIR = new File(System.getProperty("user.home", ""));
    private static final boolean DEBUG = false;
    protected final LinkedList<InteractionsListener> _listeners = new LinkedList();
    protected boolean _warnedToReset = false;

    private static MainJVM newMainJVM() {
        try {
            return new MainJVM(WORKING_DIR);
        }
        catch (RemoteException e) {
            DebugUtil.error.log(e);
            throw new UnexpectedException(e);
        }
    }

    public EclipseInteractionsModel(SWTDocumentAdapter adapter) {
        this(EclipseInteractionsModel.newMainJVM(), adapter);
    }

    public EclipseInteractionsModel(MainJVM control, SWTDocumentAdapter adapter) {
        super(control, adapter, WORKING_DIR, 1000, 50);
        this._jvm.setInteractionsModel(this);
        EclipsePlugin plugin = EclipsePlugin.getDefault();
        if (plugin != null) {
            String classpath = plugin.getPluginClasspath();
            this._jvm.setStartupClassPath(classpath);
        }
        this._jvm.startInterpreterJVM();
        this._addChangeListener();
    }

    public void dispose() {
        this._jvm.killInterpreter(null);
    }

    @Override
    public Iterable<File> getClassPath() {
        return this._jvm.getClassPath();
    }

    public void addInteractionsListener(InteractionsListener l) {
        this._listeners.addLast(l);
    }

    public void removeInteractionsListener(InteractionsListener l) {
        this._listeners.remove(l);
    }

    public void removeAllInteractionsListeners() {
        this._listeners.clear();
    }

    @Override
    protected void _interpreterResetFailed(Throwable t) {
        this._document.insertBeforeLastPrompt("Reset Failed!\n", "error");
    }

    @Override
    public void interpreterReady(File wd) {
        DebugUtil.debug.logStart();
        this._resetInteractionsClasspath();
        super.interpreterReady(wd);
        DebugUtil.debug.logEnd();
    }

    @Override
    protected void _resetInterpreter(File wd) {
        super._resetInterpreter(wd);
        this._warnedToReset = false;
    }

    @Override
    public void _notifyInteractionStarted() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).interactionStarted();
        }
    }

    @Override
    protected void _notifyInteractionEnded() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).interactionEnded();
        }
    }

    @Override
    protected void _notifySyntaxErrorOccurred(int offset, int length) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).interactionErrorOccurred(offset, length);
        }
    }

    @Override
    protected void _notifyInterpreterResetting() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).interpreterResetting();
        }
    }

    @Override
    public void _notifyInterpreterReady(File wd) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).interpreterReady(wd);
        }
    }

    @Override
    protected void _notifyInterpreterExited(int status) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).interpreterExited(status);
        }
    }

    @Override
    protected void _notifyInterpreterResetFailed(Throwable t) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).interpreterResetFailed(t);
        }
    }

    @Override
    protected void _notifyInterpreterChanged(boolean inProgress) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).interpreterChanged(inProgress);
        }
    }

    @Override
    protected void _notifyInteractionIncomplete() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).interactionIncomplete();
        }
    }

    @Override
    protected void _notifySlaveJVMUsed() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).slaveJVMUsed();
        }
    }

    protected void _resetInteractionsClasspath() {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IJavaModel jModel = JavaCore.create((IWorkspaceRoot)root);
            IJavaProject[] jProjects = jModel.getJavaProjects();
            for (int i = 0; i < jProjects.length; ++i) {
                IJavaProject jProj = jProjects[i];
                this._addProjectToClasspath(jProj, jModel, root);
            }
        }
        catch (CoreException ce) {
            throw new UnexpectedException(ce);
        }
    }

    private void _addProjectToClasspath(IJavaProject jProj) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel jModel = JavaCore.create((IWorkspaceRoot)root);
        this._addProjectToClasspath(jProj, jModel, root);
    }

    private void _addProjectToClasspath(IJavaProject jProj, IJavaModel jModel, IWorkspaceRoot root) throws CoreException {
        IProject proj = jProj.getProject();
        URI projRoot = proj.getDescription().getLocationURI();
        IClasspathEntry[] entries = jProj.getResolvedClasspath(true);
        block5: for (int j = 0; j < entries.length; ++j) {
            IClasspathEntry entry = entries[j];
            int kind = entry.getEntryKind();
            switch (kind) {
                case 1: {
                    IPath path = entry.getPath();
                    this.addToClassPath(path.toOSString());
                    continue block5;
                }
                case 3: {
                    IPath path = entry.getOutputLocation();
                    if (path == null) {
                        path = jProj.getOutputLocation();
                    }
                    if (projRoot != null && (!projRoot.isAbsolute() || projRoot.getScheme().equals("file"))) {
                        path = path.removeFirstSegments(1);
                        path = new Path(projRoot.getPath()).append(path);
                    } else {
                        path = root.getLocation().append(path);
                    }
                    this.addBuildDirectoryClassPath(path.toOSString());
                    continue block5;
                }
                case 2: {
                    continue block5;
                }
                default: {
                    throw new RuntimeException("Unsupported classpath entry type.");
                }
            }
        }
    }

    protected void _warnUserToReset() {
        if (!this._warnedToReset && this._jvm.slaveJVMUsed()) {
            String warning = "Warning: Interactions are out of sync with the current class files.\nYou should reset interactions from the toolbar menu.\n";
            this._document.insertBeforeLastPrompt(warning, "error");
            this._warnedToReset = true;
        }
    }

    protected void _addChangeListener() {
        JavaCore.addElementChangedListener((IElementChangedListener)new IElementChangedListener(){

            public void elementChanged(ElementChangedEvent e) {
                IJavaElementDelta delta = e.getDelta();
                EclipseInteractionsModel.this._visitDelta(delta, 0);
            }
        });
    }

    public URL toURL(String path) {
        try {
            return new File(path).toURI().toURL();
        }
        catch (MalformedURLException e) {
            this._document.insertBeforeLastPrompt("Malformed URL " + path + "\n", "error");
            throw new RuntimeException("Trying to add an invalid file:" + path);
        }
    }

    public void addBuildDirectoryClassPath(String path) {
        super.addBuildDirectoryClassPath(new File(path));
    }

    public void addProjectFilesClassPath(String path) {
        super.addProjectFilesClassPath(new File(path));
    }

    public void addToClassPath(String path) {
        super.addProjectClassPath(new File(path));
    }

    protected void _visitDelta(IJavaElementDelta delta, int depth) {
        int kind = delta.getKind();
        IJavaElement element = delta.getElement();
        if (this._isCompilationUnit(element) && kind == 4) {
            this._warnUserToReset();
        }
        if ((delta.getFlags() & 8) != 0) {
            IJavaElementDelta[] children = delta.getAffectedChildren();
            for (int i = 0; i < children.length; ++i) {
                this._visitDelta(children[i], depth + 1);
            }
        } else if (kind == 1 && element instanceof IJavaProject) {
            try {
                this._addProjectToClasspath((IJavaProject)element);
            }
            catch (CoreException e) {
                throw new UnexpectedException(e);
            }
        }
    }

    protected boolean _isCompilationUnit(IJavaElement element) {
        boolean isCompilationUnit = element instanceof ICompilationUnit;
        boolean isWorkingCopy = isCompilationUnit && ((ICompilationUnit)element).isWorkingCopy();
        return isCompilationUnit && !isWorkingCopy;
    }

    private void _debugSystemOutAndErr() {
        try {
            File outF = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "out.txt");
            FileWriter wo = new FileWriter(outF);
            final PrintWriter outWriter = new PrintWriter(wo);
            File errF = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "err.txt");
            FileWriter we = new FileWriter(errF);
            final PrintWriter errWriter = new PrintWriter(we);
            System.setOut(new PrintStream(new OutputStreamRedirector(){

                public void print(String s) {
                    outWriter.print(s);
                    outWriter.flush();
                }
            }));
            System.setErr(new PrintStream(new OutputStreamRedirector(){

                public void print(String s) {
                    errWriter.print(s);
                    errWriter.flush();
                }
            }));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void setPrivateAccessible(boolean allow) {
        this._jvm.setPrivateAccessible(allow);
    }

    public void setOptionArgs(String optionArgString) {
        this._jvm.setOptionArgs(optionArgString);
    }

    @Override
    public ConsoleDocument getConsoleDocument() {
        return new ConsoleDocument(new InteractionsDJDocument());
    }
}

