/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.plugins.eclipse.views;

import edu.rice.cs.drjava.model.repl.InputListener;
import edu.rice.cs.drjava.model.repl.InteractionsDocument;
import edu.rice.cs.drjava.model.repl.InteractionsListener;
import edu.rice.cs.drjava.plugins.eclipse.EclipsePlugin;
import edu.rice.cs.drjava.plugins.eclipse.repl.EclipseInteractionsModel;
import edu.rice.cs.drjava.plugins.eclipse.util.text.SWTDocumentAdapter;
import edu.rice.cs.drjava.plugins.eclipse.views.InteractionsView;
import java.io.File;
import java.util.Iterator;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;

public class InteractionsController {
    protected EclipseInteractionsModel _model;
    protected SWTDocumentAdapter _adapter;
    protected InteractionsDocument _doc;
    protected InteractionsView _view;
    private String _input;
    protected Color _colorRed;
    protected Color _colorDarkRed;
    protected Color _colorDarkGreen;
    protected Color _colorDarkBlue;
    protected Color _colorYellow;
    protected Color _colorPurple;
    protected boolean _enabled;
    protected static final String INPUT_ENTERED_NAME = "Input Entered";
    protected static final String INSERT_NEWLINE_NAME = "Insert Newline";
    private IInputValidator _inputValidator = new IInputValidator(){

        public String isValid(String newText) {
            return null;
        }
    };
    protected InputListener _inputListener = new InputListener(){

        public String getConsoleInput() {
            Display d = InteractionsController.this._view.getTextPane().getDisplay();
            d.syncExec(new Runnable(){

                public void run() {
                    try {
                        InputDialog input = new InputDialog(InteractionsController.this._view.getSite().getShell(), "System.in", "Please enter a line of input to System.in.", "", InteractionsController.this._inputValidator);
                        input.open();
                        InteractionsController.this._input = input.getValue();
                    }
                    catch (Throwable t) {
                        InteractionsController.this._input = "";
                    }
                }
            });
            InteractionsController.this._input = InteractionsController.this._input + "\n";
            InteractionsController.this._doc.insertBeforeLastPrompt(InteractionsController.this._input, "System.in");
            return InteractionsController.this._input;
        }
    };
    protected Preferences.IPropertyChangeListener _preferenceListener;
    protected IPropertyChangeListener _jfacePreferenceListener;
    protected boolean _promptToReset;
    protected boolean _promptIfExited;
    boolean called = false;

    public InteractionsController(EclipseInteractionsModel model, SWTDocumentAdapter adapter, InteractionsView view) {
        this._model = model;
        this._adapter = adapter;
        this._doc = model.getDocument();
        this._view = view;
        this._enabled = true;
        Preferences prefs = EclipsePlugin.getDefault().getPluginPreferences();
        this._preferenceListener = new PrefChangeListener();
        this._jfacePreferenceListener = new JFacePrefChangeListener();
        prefs.addPropertyChangeListener(this._preferenceListener);
        JFaceResources.getFontRegistry().addListener(this._jfacePreferenceListener);
        this._updateJFacePreferences();
        this._updatePreferences();
        this._view.getTextPane().setCaretOffset(this._doc.getLength());
        this._addDocumentStyles();
        this._setupModel();
        this._setupView();
    }

    public void dispose() {
        this._model.dispose();
        this._colorRed.dispose();
        this._colorDarkRed.dispose();
        this._colorDarkGreen.dispose();
        this._colorDarkBlue.dispose();
        this._colorYellow.dispose();
        Preferences store = EclipsePlugin.getDefault().getPluginPreferences();
        store.removePropertyChangeListener(this._preferenceListener);
        JFaceResources.getFontRegistry().removeListener(this._jfacePreferenceListener);
    }

    private void _updateJFacePreferences() {
        this._view.updateFont();
    }

    private void _updatePreferences() {
        Preferences store = EclipsePlugin.getDefault().getPluginPreferences();
        this._promptToReset = store.getBoolean("interactions.reset.prompt");
        this._promptIfExited = store.getBoolean("interactions.exit.prompt");
        boolean privateAccessible = store.getBoolean("allow.private.access");
        this._model.setPrivateAccessible(privateAccessible);
        String jvmArgs = store.getString("jvm.args");
        if (jvmArgs.equals("") || !this.called) {
            this._model.setOptionArgs(jvmArgs);
        } else {
            String confirmMessage = "Specifying the command-line arguments to the Interactions JVM is an\nadvanced option, and incorrect arguments may cause the Interactions\nView to stop responding. Are you sure you want to set this option?\n(You must reset the Interactions View before changes will take effect.)";
            if (this._view.showConfirmDialog("Setting JVM Arguments", confirmMessage)) {
                this._model.setOptionArgs(jvmArgs);
            } else {
                store.setValue("jvm.args", "");
            }
        }
        this.called = true;
    }

    public EclipseInteractionsModel getInteractionsModel() {
        return this._model;
    }

    public SWTDocumentAdapter getDocumentAdapter() {
        return this._adapter;
    }

    public InteractionsDocument getDocument() {
        return this._doc;
    }

    public InteractionsView getView() {
        return this._view;
    }

    protected void _addDocumentStyles() {
        Display display = this._view.getTextPane().getDisplay();
        this._colorRed = new Color((Device)display, 255, 0, 0);
        this._colorDarkRed = new Color((Device)display, 178, 0, 0);
        this._colorDarkGreen = new Color((Device)display, 0, 124, 0);
        this._colorDarkBlue = new Color((Device)display, 0, 0, 178);
        this._colorYellow = new Color((Device)display, 255, 255, 0);
        this._colorPurple = new Color((Device)display, 124, 0, 124);
        SWTDocumentAdapter.SWTStyle out = new SWTDocumentAdapter.SWTStyle(this._colorDarkGreen, 0);
        this._adapter.addDocStyle("System.out", out);
        SWTDocumentAdapter.SWTStyle err = new SWTDocumentAdapter.SWTStyle(this._colorRed, 0);
        this._adapter.addDocStyle("System.err", err);
        SWTDocumentAdapter.SWTStyle in = new SWTDocumentAdapter.SWTStyle(this._colorPurple, 0);
        this._adapter.addDocStyle("System.in", in);
        SWTDocumentAdapter.SWTStyle error = new SWTDocumentAdapter.SWTStyle(this._colorDarkRed, 1);
        this._adapter.addDocStyle("error", error);
        SWTDocumentAdapter.SWTStyle debug = new SWTDocumentAdapter.SWTStyle(this._colorDarkBlue, 1);
        this._adapter.addDocStyle("debugger", debug);
    }

    protected void _setupModel() {
        this._adapter.addModifyListener(new DocumentUpdateListener());
        this._doc.setBeep(this._view.getBeep());
        this._model.addInteractionsListener(new EclipseInteractionsListener());
        this._model.setInputListener(this._inputListener);
    }

    protected void _enableInteractionsPane() {
        this._enabled = true;
        this._view.setBusyCursorShown(false);
        this._view.setEditable(true);
    }

    protected void _disableInteractionsPane() {
        this._enabled = false;
        this._view.setBusyCursorShown(true);
        this._view.setEditable(false);
    }

    protected void _setupView() {
        this._view.getTextPane().addVerifyKeyListener((VerifyKeyListener)new KeyUpdateListener());
        this._setupMenu();
    }

    protected void _setupMenu() {
        IWorkbenchWindow window = this._view.getSite().getWorkbenchWindow();
        ActionFactory.IWorkbenchAction copyAction = ActionFactory.COPY.create(window);
        copyAction.setEnabled(false);
        this._view.addSelectionListener((SelectionListener)new SelectionAdapter((IAction)copyAction){
            final /* synthetic */ IAction val$copyAction;
            {
                this.val$copyAction = iAction;
            }

            public void widgetSelected(SelectionEvent e) {
                this.val$copyAction.setEnabled(InteractionsController.this._view.getTextPane().getSelectionCount() > 0);
            }
        });
        this._view.addMenuItem((IAction)copyAction);
        Action resetInteractionsAction = new Action(){

            public void run() {
                String title = "Confirm Reset Interactions";
                String message = "Are you sure you want to reset the Interactions View?";
                if (!InteractionsController.this._promptToReset || InteractionsController.this._view.showConfirmDialog(title, message)) {
                    InteractionsController.this._model.resetInterpreter(EclipseInteractionsModel.WORKING_DIR);
                }
            }
        };
        resetInteractionsAction.setText("Reset Interactions");
        resetInteractionsAction.setToolTipText("Reset the Interactions View");
        resetInteractionsAction.setImageDescriptor(this._getStandardIcon(ActionFactory.DELETE, window));
        this._view.addMenuItem((IAction)resetInteractionsAction);
        this._view.addToolbarItem((IAction)resetInteractionsAction);
        Action showClasspathAction = new Action(){

            public void run() {
                String title = "Interpreter Classpath";
                StringBuffer cpBuf = new StringBuffer();
                Iterable<File> classpathElements = InteractionsController.this._model.getClassPath();
                Iterator<File> files = classpathElements.iterator();
                while (files.hasNext()) {
                    cpBuf.append(files.next());
                    cpBuf.append("\n");
                }
                InteractionsController.this._view.showInfoDialog(title, cpBuf.toString());
            }
        };
        showClasspathAction.setText("Show Interpreter Classpath");
        showClasspathAction.setToolTipText("Show the classpath used in the Interactions View");
        this._view.addMenuItem((IAction)showClasspathAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageDescriptor _getStandardIcon(ActionFactory f, IWorkbenchWindow w) {
        ActionFactory.IWorkbenchAction a = f.create(w);
        try {
            ImageDescriptor imageDescriptor = a.getImageDescriptor();
            return imageDescriptor;
        }
        finally {
            a.dispose();
        }
    }

    boolean evalAction() {
        new Thread(){

            public void run() {
                InteractionsController.this._model.interpretCurrentInteraction();
            }
        }.start();
        return false;
    }

    boolean newLineAction() {
        StyledText pane = this._view.getTextPane();
        pane.replaceTextRange(pane.getCaretOffset(), 0, "\n");
        return false;
    }

    boolean historyPrevAction() {
        this._doc.recallPreviousInteractionInHistory();
        this.moveToEnd();
        return false;
    }

    boolean historyNextAction() {
        this._doc.recallNextInteractionInHistory();
        this.moveToEnd();
        return false;
    }

    boolean historyReverseSearchAction() {
        this._doc.reverseSearchInteractionsInHistory();
        this.moveToEnd();
        return false;
    }

    boolean historyForwardSearchAction() {
        this._doc.forwardSearchInteractionsInHistory();
        this.moveToEnd();
        return false;
    }

    boolean clearCurrentAction() {
        this._doc.clearCurrentInteraction();
        return false;
    }

    boolean gotoPromptPosAction() {
        this.moveToPrompt();
        return false;
    }

    boolean selectToPromptPosAction() {
        StyledText pane = this._view.getTextPane();
        int start = this._doc.getPromptPos();
        int end = pane.getCaretOffset();
        if (end < start) {
            int t = start;
            start = end;
            end = t;
        }
        pane.setSelection(start, end);
        return false;
    }

    boolean moveLeftAction() {
        int position = this._view.getTextPane().getCaretOffset();
        if (position < this._doc.getPromptPos()) {
            this.moveToPrompt();
            return false;
        }
        if (position == this._doc.getPromptPos()) {
            this.moveToEnd();
            return false;
        }
        return true;
    }

    boolean moveRightAction() {
        int position = this._view.getTextPane().getCaretOffset();
        if (position < this._doc.getPromptPos()) {
            this.moveToEnd();
            return false;
        }
        if (position >= this._doc.getLength()) {
            this.moveToPrompt();
            return false;
        }
        return true;
    }

    void moveToEnd() {
        final StyledText pane = this._view.getTextPane();
        pane.getDisplay().syncExec(new Runnable(){

            public void run() {
                pane.setCaretOffset(InteractionsController.this._doc.getLength());
                pane.showSelection();
            }
        });
    }

    void moveToPrompt() {
        final StyledText pane = this._view.getTextPane();
        pane.getDisplay().syncExec(new Runnable(){

            public void run() {
                pane.setCaretOffset(InteractionsController.this._doc.getPromptPos());
                pane.showSelection();
            }
        });
    }

    class PrefChangeListener
    implements Preferences.IPropertyChangeListener {
        PrefChangeListener() {
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            InteractionsController.this._updatePreferences();
        }
    }

    class JFacePrefChangeListener
    implements IPropertyChangeListener {
        JFacePrefChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            InteractionsController.this._updateJFacePreferences();
        }
    }

    class KeyUpdateListener
    implements VerifyKeyListener {
        KeyUpdateListener() {
        }

        public void verifyKey(VerifyEvent event) {
            if (!InteractionsController.this._enabled) {
                return;
            }
            if (event.keyCode == 13 && event.stateMask == 0) {
                event.doit = InteractionsController.this.evalAction();
            } else if (event.keyCode == 13 && (event.stateMask & 0x20000) == 1) {
                event.doit = InteractionsController.this.newLineAction();
            } else if (event.keyCode == 0x1000001) {
                event.doit = InteractionsController.this.historyPrevAction();
            } else if (event.keyCode == 0x1000002) {
                event.doit = InteractionsController.this.historyNextAction();
            } else if (event.keyCode == 0x1000003) {
                event.doit = InteractionsController.this.moveLeftAction();
            } else if (event.keyCode == 0x1000004) {
                event.doit = InteractionsController.this.moveRightAction();
            } else if (event.keyCode == 0x1000007 && (event.stateMask & 0x20000) == 1) {
                event.doit = InteractionsController.this.selectToPromptPosAction();
            } else if (event.keyCode == 0x1000007) {
                event.doit = InteractionsController.this.gotoPromptPosAction();
            } else if (event.keyCode == 9 && event.stateMask == 0) {
                event.doit = InteractionsController.this.historyReverseSearchAction();
            } else if (event.keyCode == 9 && (event.stateMask & 0x20000) == 1) {
                event.doit = InteractionsController.this.historyForwardSearchAction();
            }
        }
    }

    class EclipseInteractionsListener
    implements InteractionsListener {
        EclipseInteractionsListener() {
        }

        public void interactionStarted() {
            InteractionsController.this._disableInteractionsPane();
        }

        public void interactionEnded() {
            InteractionsController.this._enableInteractionsPane();
            InteractionsController.this.moveToPrompt();
        }

        public void interactionErrorOccurred(final int offset, final int length) {
            InteractionsController.this._view.getTextPane().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    InteractionsController.this._adapter.highlightRange(offset, length, InteractionsController.this._colorYellow);
                }
            });
        }

        public void interpreterResetting() {
            InteractionsController.this._disableInteractionsPane();
        }

        public void interpreterReady(File wd) {
            InteractionsController.this._enableInteractionsPane();
            InteractionsController.this.moveToPrompt();
        }

        public void interpreterExited(int status) {
            if (InteractionsController.this._promptIfExited) {
                String title = "Interactions terminated by System.exit(" + status + ")";
                String msg = "The interactions window was terminated by a call to System.exit(" + status + ").\n" + "The interactions window will now be restarted.";
                InteractionsController.this._view.showInfoDialog(title, msg);
            }
        }

        public void interpreterChanged(boolean inProgress) {
            if (inProgress) {
                InteractionsController.this._disableInteractionsPane();
            } else {
                InteractionsController.this._enableInteractionsPane();
            }
        }

        public void interpreterResetFailed(Throwable t) {
            String title = "Interactions Could Not Reset";
            String msg = "The interactions window could not be reset:\n" + t.toString();
            InteractionsController.this._view.showInfoDialog(title, msg);
            this.interpreterReady(null);
        }

        public void interactionIncomplete() {
            InteractionsController.this._view.getTextPane().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    InteractionsController.this.moveToEnd();
                }
            });
        }

        public void slaveJVMUsed() {
        }
    }

    class DocumentUpdateListener
    implements ModifyListener {
        DocumentUpdateListener() {
        }

        public void modifyText(ModifyEvent e) {
            StyledText pane = InteractionsController.this._view.getTextPane();
            int caretPos = pane.getCaretOffset();
            int promptPos = InteractionsController.this._doc.getPromptPos();
            int docLength = InteractionsController.this._doc.getLength();
            if (InteractionsController.this._doc.inProgress()) {
                InteractionsController.this.moveToEnd();
            } else if (caretPos < promptPos && promptPos <= docLength) {
                InteractionsController.this.moveToPrompt();
            } else {
                pane.showSelection();
            }
        }
    }
}

