/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import com.sun.jdi.VMOutOfMemoryException;
import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.ui.DrJavaErrorPopup;
import edu.rice.cs.drjava.ui.DrJavaErrorWindow;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.Utilities;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;

public class DrJavaErrorHandler {
    private static ArrayList<Throwable> _errors = new ArrayList();
    public static final Log LOG = new Log("error_handler.txt", false);
    private static JButton _errorsButton;

    public static void setButton(JButton b) {
        _errorsButton = b;
    }

    public static JButton getButton() {
        return _errorsButton;
    }

    public static int getErrorCount() {
        return _errors.size();
    }

    public static Throwable getError(int index) {
        if (index >= 0 && index < _errors.size()) {
            return _errors.get(index);
        }
        return new UnexpectedException("Error in DrJavaErrorHandler");
    }

    public static void clearErrors() {
        _errors.clear();
    }

    public void handle(Throwable thrown) {
        System.out.println("Unhandled exception: " + thrown);
        DrJavaErrorHandler.record(thrown);
    }

    public static void record(final Throwable thrown) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                JFrame f;
                if (thrown instanceof OutOfMemoryError) {
                    Runtime.getRuntime().gc();
                    f = DrJavaErrorWindow.getFrame();
                    if (f instanceof MainFrame) {
                        MainFrame mf = (MainFrame)f;
                        mf.askToIncreaseMasterMaxHeap();
                    }
                } else if (thrown instanceof VMOutOfMemoryException && (f = DrJavaErrorWindow.getFrame()) instanceof MainFrame) {
                    MainFrame mf = (MainFrame)f;
                    mf.askToIncreaseSlaveMaxHeap();
                }
                _errors.add(thrown);
                if (_errorsButton != null) {
                    _errorsButton.setVisible(true);
                }
                if (_errors.size() == 1 && !Utilities.TEST_MODE && DrJava.getConfig().getSetting(OptionConstants.DIALOG_DRJAVA_ERROR_POPUP_ENABLED).booleanValue()) {
                    DrJavaErrorPopup popup = new DrJavaErrorPopup(DrJavaErrorWindow.getFrame(), thrown);
                    MainFrame.setPopupLoc(popup, popup.getOwner());
                    popup.setVisible(true);
                }
            }
        });
    }

    public static void log(String message) {
        DrJavaErrorHandler.record(new LoggedCondition(message));
    }

    public static class LoggedCondition
    extends Throwable {
        public LoggedCondition(String s) {
            super(s);
        }
    }
}

