/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.drjava.ui.DrJavaErrorWindow;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.util.swing.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DrJavaErrorPopup
extends JDialog {
    private JComponent _errorInfo;
    private JCheckBox _keepDisplaying;
    private JPanel _bottomPanel;
    private JPanel _buttonPanel;
    private JButton _okButton;
    private JButton _moreButton;
    private Throwable _error;
    private Action _okAction = new AbstractAction("OK"){

        public void actionPerformed(ActionEvent e) {
            DrJavaErrorPopup.this.dispose();
            if (DrJavaErrorHandler.getButton() == null) {
                System.exit(1);
            }
        }
    };
    private Action _moreAction = new AbstractAction("More Information"){

        public void actionPerformed(ActionEvent e) {
            if (!Utilities.TEST_MODE) {
                DrJavaErrorPopup.this.dispose();
                MainFrame.setPopupLoc(DrJavaErrorWindow.singleton(), DrJavaErrorWindow.getFrame());
                DrJavaErrorWindow.singleton().setVisible(true);
            }
        }
    };
    private final String[] msg = new String[]{"An error occurred in DrJava:", "", "You may wish to save all your work and restart DrJava."};

    public DrJavaErrorPopup(JFrame parent, Throwable error) {
        super((Frame)parent, "DrJava Error");
        this._error = error;
        this.setSize(500, 150);
        this._keepDisplaying = new JCheckBox("Keep showing this notification", (boolean)DrJava.getConfig().getSetting(OptionConstants.DIALOG_DRJAVA_ERROR_POPUP_ENABLED));
        this._keepDisplaying.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DrJava.getConfig().setSetting(OptionConstants.DIALOG_DRJAVA_ERROR_POPUP_ENABLED, DrJavaErrorPopup.this._keepDisplaying.isSelected());
            }
        });
        this._moreButton = new JButton(this._moreAction);
        this._okButton = new JButton(this._okAction);
        this._bottomPanel = new JPanel(new BorderLayout());
        this._buttonPanel = new JPanel();
        this._buttonPanel.add(this._moreButton);
        this._buttonPanel.add(this._okButton);
        this._bottomPanel.add((Component)this._keepDisplaying, "West");
        this._bottomPanel.add((Component)this._buttonPanel, "East");
        this.msg[1] = this._error instanceof DrJavaErrorHandler.LoggedCondition ? "Logged condition: " + this._error.getMessage() : this._error.toString();
        this._errorInfo = new JOptionPane(this.msg, 0, -1, null, new Object[0]);
        JPanel cp = new JPanel(new BorderLayout(5, 5));
        cp.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(cp);
        cp.add((Component)this._errorInfo, "Center");
        cp.add((Component)this._bottomPanel, "South");
        this.getRootPane().setDefaultButton(this._okButton);
    }
}

