/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.model.DJError;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.compiler.CompilerErrorModel;
import edu.rice.cs.drjava.ui.DefinitionsPane;
import edu.rice.cs.drjava.ui.ErrorPanel;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.util.swing.Utilities;
import java.awt.EventQueue;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Position;

public class ErrorCaretListener
implements CaretListener {
    private final OpenDefinitionsDocument _openDoc;
    private final DefinitionsPane _definitionsPane;
    protected final MainFrame _frame;

    public ErrorCaretListener(OpenDefinitionsDocument doc, DefinitionsPane defPane, MainFrame frame) {
        this._openDoc = doc;
        this._definitionsPane = defPane;
        this._frame = frame;
    }

    public OpenDefinitionsDocument getOpenDefDoc() {
        return this._openDoc;
    }

    public void caretUpdate(final CaretEvent evt) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                if (ErrorCaretListener.this._frame.getSelectedErrorPanel() == null) {
                    return;
                }
                ErrorCaretListener.this.updateHighlight(evt.getDot());
            }
        });
    }

    public void updateHighlight(int curPos) {
        ErrorPanel panel = this._frame.getSelectedErrorPanel();
        if (panel == null) {
            return;
        }
        CompilerErrorModel model = panel.getErrorModel();
        if (!model.hasErrorsWithPositions(this._openDoc)) {
            return;
        }
        DJError error = model.getErrorAtOffset(this._openDoc, curPos);
        ErrorPanel.ErrorListPane errorListPane = panel.getErrorListPane();
        if (error == null) {
            errorListPane.selectNothing();
        } else {
            if (errorListPane.shouldShowHighlightsInSource()) {
                this._highlightErrorInSource(model.getPosition(error));
            }
            errorListPane.selectItem(error);
        }
    }

    public void removeHighlight() {
        this._definitionsPane.removeErrorHighlight();
    }

    private void _highlightErrorInSource(Position pos) {
        int nextNewline;
        assert (EventQueue.isDispatchThread());
        if (pos == null) {
            return;
        }
        int errPos = pos.getOffset();
        String text = this._openDoc.getText();
        int prevNewline = text.lastIndexOf(10, errPos - 1);
        if (prevNewline == -1) {
            prevNewline = 0;
        }
        if ((nextNewline = text.indexOf(10, errPos)) == -1) {
            nextNewline = text.length();
        }
        this.removeHighlight();
        if (prevNewline > 0) {
            ++prevNewline;
        }
        if (prevNewline <= nextNewline) {
            this._definitionsPane.addErrorHighlight(prevNewline, nextNewline);
        }
    }
}

