/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.ClipboardHistoryModel;
import edu.rice.cs.drjava.model.FindReplaceMachine;
import edu.rice.cs.drjava.model.FindResult;
import edu.rice.cs.drjava.model.MovingDocumentRegion;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.RegionManager;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.ui.AbstractDJPane;
import edu.rice.cs.drjava.ui.BackgroundColorListener;
import edu.rice.cs.drjava.ui.DefinitionsPane;
import edu.rice.cs.drjava.ui.FindResultsPanel;
import edu.rice.cs.drjava.ui.ForegroundColorListener;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.TabbedPanel;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.BorderlessScrollPane;
import edu.rice.cs.util.swing.Utilities;
import edu.rice.cs.util.text.SwingDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FindReplacePanel
extends TabbedPanel
implements ClipboardOwner {
    public static final char LEFT = '\u25fe';
    public static final char RIGHT = '\u25fe';
    private JButton _findNextButton;
    private JButton _findPreviousButton;
    private JButton _findAllButton;
    private JButton _replaceButton;
    private JButton _replaceFindNextButton;
    private JButton _replaceFindPreviousButton;
    private JButton _replaceAllButton;
    private JTextPane _findField;
    private JTextPane _replaceField;
    private JLabel _findLabelBot;
    private JCheckBox _ignoreCommentsAndStrings;
    private JCheckBox _matchCase;
    private JCheckBox _searchAllDocuments;
    private JCheckBox _matchWholeWord;
    private JCheckBox _ignoreTestCases;
    private FindReplaceMachine _machine;
    private SingleDisplayModel _model;
    private DefinitionsPane _defPane = null;
    private boolean _caretChanged;
    private CaretListener _caretListener = new CaretListener(){

        public void caretUpdate(CaretEvent e) {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    FindReplacePanel.this._replaceAction.setEnabled(false);
                    FindReplacePanel.this._replaceFindNextAction.setEnabled(false);
                    FindReplacePanel.this._replaceFindPreviousAction.setEnabled(false);
                    FindReplacePanel.this._machine.positionChanged();
                    FindReplacePanel.this._caretChanged = true;
                }
            });
        }
    };
    private Action _findNextAction = new AbstractAction("Find Next"){

        public void actionPerformed(ActionEvent e) {
            FindReplacePanel.this.findNext();
        }
    };
    private Action _findPreviousAction = new AbstractAction("Find Previous"){

        public void actionPerformed(ActionEvent e) {
            FindReplacePanel.this.findPrevious();
        }
    };
    private Action _findAllAction = new AbstractAction("Find All"){

        public void actionPerformed(ActionEvent e) {
            FindReplacePanel.this._findAll();
        }
    };
    private Action _doFindAction = new AbstractAction("Do Find"){

        public void actionPerformed(ActionEvent e) {
            FindReplacePanel.this._doFind();
        }
    };
    private Action _replaceAction = new AbstractAction("Replace"){

        public void actionPerformed(ActionEvent e) {
            FindReplacePanel.this._replace();
        }
    };
    private Action _replaceFindNextAction = new AbstractAction("Replace/Find Next"){

        public void actionPerformed(ActionEvent e) {
            FindReplacePanel.this._replaceFindNext();
        }
    };
    private Action _replaceFindPreviousAction = new AbstractAction("Replace/Find Previous"){

        public void actionPerformed(ActionEvent e) {
            FindReplacePanel.this._replaceFindPrevious();
        }
    };
    private Action _replaceAllAction = new AbstractAction("Replace All"){

        public void actionPerformed(ActionEvent e) {
            FindReplacePanel.this._replaceAll();
        }
    };
    Action _standardNewlineAction = new TextAction("Newline Action"){

        public void actionPerformed(ActionEvent e) {
            JTextComponent c = this.getTextComponent(e);
            String text = c.getText();
            int caretPos = c.getCaretPosition();
            String textBeforeCaret = text.substring(0, caretPos);
            String textAfterCaret = text.substring(caretPos);
            c.setText(textBeforeCaret.concat("\n").concat(textAfterCaret));
            c.setCaretPosition(caretPos + 1);
        }
    };
    Action cutAction = new DefaultEditorKit.CutAction(){

        public void actionPerformed(ActionEvent e) {
            JTextComponent tc;
            if (e.getSource() instanceof JTextComponent && (tc = (JTextComponent)e.getSource()).getSelectedText() != null) {
                super.actionPerformed(e);
                String s = Utilities.getClipboardSelection(FindReplacePanel.this);
                if (s != null && s.length() != 0) {
                    ClipboardHistoryModel.singleton().put(s);
                }
            }
        }
    };
    Action copyAction = new DefaultEditorKit.CopyAction(){

        public void actionPerformed(ActionEvent e) {
            JTextComponent tc;
            if (e.getSource() instanceof JTextComponent && (tc = (JTextComponent)e.getSource()).getSelectedText() != null) {
                super.actionPerformed(e);
                String s = Utilities.getClipboardSelection(FindReplacePanel.this);
                if (s != null && s.length() != 0) {
                    ClipboardHistoryModel.singleton().put(s);
                }
            }
        }
    };

    public FindReplacePanel(MainFrame frame, SingleDisplayModel model) {
        super(frame, "Find/Replace");
        this._model = model;
        this._machine = new FindReplaceMachine(this._model, this._model.getDocumentIterator());
        this._findNextButton = new JButton(this._findNextAction);
        this._findPreviousButton = new JButton(this._findPreviousAction);
        this._findAllButton = new JButton(this._findAllAction);
        this._replaceButton = new JButton(this._replaceAction);
        this._replaceFindNextButton = new JButton(this._replaceFindNextAction);
        this._replaceFindPreviousButton = new JButton(this._replaceFindPreviousAction);
        this._replaceAllButton = new JButton(this._replaceAllAction);
        this._replaceAction.setEnabled(false);
        this._replaceFindNextAction.setEnabled(false);
        this._replaceFindPreviousAction.setEnabled(false);
        this._findField = new JTextPane(new DefaultStyledDocument());
        this._replaceField = new JTextPane(new SwingDocument());
        AbstractDJPane.disableAltCntlMetaChars(this._findField);
        AbstractDJPane.disableAltCntlMetaChars(this._replaceField);
        this._findField.addKeyListener(frame._historyListener);
        this._findField.addFocusListener(frame._focusListenerForRecentDocs);
        this._replaceField.addKeyListener(frame._historyListener);
        this._findField.addFocusListener(frame._focusListenerForRecentDocs);
        int tabForward = 0;
        int tabBackward = 1;
        this._findField.setFocusTraversalKeys(tabForward, null);
        this._replaceField.setFocusTraversalKeys(tabForward, null);
        this._findField.setFocusTraversalKeys(tabBackward, null);
        this._replaceField.setFocusTraversalKeys(tabBackward, null);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        KeyStroke ctrlEnter = KeyStroke.getKeyStroke(10, 2);
        KeyStroke ctrlTab = KeyStroke.getKeyStroke(9, 2);
        InputMap findIM = this._findField.getInputMap();
        InputMap replaceIM = this._replaceField.getInputMap();
        findIM.put(enter, "Do Find");
        findIM.put(ctrlEnter, "Insert Newline");
        findIM.put(ctrlTab, "Insert Tab");
        findIM.put(DrJava.getConfig().getSetting(OptionConstants.KEY_CUT), "Cut");
        findIM.put(DrJava.getConfig().getSetting(OptionConstants.KEY_COPY), "Copy");
        replaceIM.put(enter, "Insert Newline");
        replaceIM.put(ctrlEnter, "Insert Newline");
        replaceIM.put(ctrlTab, "Insert Tab");
        replaceIM.put(DrJava.getConfig().getSetting(OptionConstants.KEY_CUT), "Cut");
        replaceIM.put(DrJava.getConfig().getSetting(OptionConstants.KEY_COPY), "Copy");
        DefaultEditorKit.InsertTabAction insertTabAction = new DefaultEditorKit.InsertTabAction();
        ActionMap findAM = this._findField.getActionMap();
        ActionMap replaceAM = this._replaceField.getActionMap();
        findAM.put("Do Find", this._doFindAction);
        findAM.put("Insert Newline", this._standardNewlineAction);
        findAM.put("Insert Tab", insertTabAction);
        findAM.put("Cut", this.cutAction);
        findAM.put("Copy", this.copyAction);
        replaceAM.put("Insert Newline", this._standardNewlineAction);
        replaceAM.put("Insert Tab", insertTabAction);
        replaceAM.put("Cut", this.cutAction);
        replaceAM.put("Copy", this.copyAction);
        new ForegroundColorListener(this._findField);
        new BackgroundColorListener(this._findField);
        new ForegroundColorListener(this._replaceField);
        new BackgroundColorListener(this._replaceField);
        Font font = DrJava.getConfig().getSetting(OptionConstants.FONT_MAIN);
        this.setFieldFont(font);
        JLabel _replaceLabelTop = new JLabel("Replace", 4);
        JLabel _replaceLabelBot = new JLabel("With", 4);
        JPanel replaceLabelPanelTop = new JPanel(new BorderLayout(5, 5));
        JPanel replaceLabelPanelBot = new JPanel(new BorderLayout(5, 5));
        JPanel replaceLabelPanel = new JPanel(new GridLayout(2, 1));
        replaceLabelPanelTop.add((Component)_replaceLabelTop, "South");
        replaceLabelPanelBot.add((Component)_replaceLabelBot, "North");
        replaceLabelPanel.add(replaceLabelPanelTop);
        replaceLabelPanel.add(replaceLabelPanelBot);
        JLabel _findLabelTop = new JLabel("Find", 4);
        this._findLabelBot = new JLabel("Next", 4);
        JPanel findLabelPanelTop = new JPanel(new BorderLayout(5, 5));
        JPanel findLabelPanelBot = new JPanel(new BorderLayout(5, 5));
        JPanel findLabelPanel = new JPanel(new GridLayout(2, 1));
        findLabelPanelTop.add((Component)_findLabelTop, "South");
        findLabelPanelBot.add((Component)this._findLabelBot, "North");
        findLabelPanel.add(findLabelPanelTop);
        findLabelPanel.add(findLabelPanelBot);
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(1, 0, 5, 0));
        buttons.add(this._findNextButton);
        buttons.add(this._findPreviousButton);
        buttons.add(this._findAllButton);
        buttons.add(this._replaceFindNextButton);
        buttons.add(this._replaceFindPreviousButton);
        buttons.add(this._replaceButton);
        buttons.add(this._replaceAllButton);
        boolean matchCaseSelected = DrJava.getConfig().getSetting(OptionConstants.FIND_MATCH_CASE);
        this._matchCase = new JCheckBox("Match Case", matchCaseSelected);
        this._machine.setMatchCase(matchCaseSelected);
        this._matchCase.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean isSelected = e.getStateChange() == 1;
                FindReplacePanel.this._machine.setMatchCase(isSelected);
                DrJava.getConfig().setSetting(OptionConstants.FIND_MATCH_CASE, isSelected);
                FindReplacePanel.this._findField.requestFocusInWindow();
            }
        });
        boolean searchAllSelected = DrJava.getConfig().getSetting(OptionConstants.FIND_ALL_DOCUMENTS);
        this._searchAllDocuments = new JCheckBox("Search All Documents", searchAllSelected);
        this._machine.setSearchAllDocuments(searchAllSelected);
        this._searchAllDocuments.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean isSelected = e.getStateChange() == 1;
                FindReplacePanel.this._machine.setSearchAllDocuments(isSelected);
                DrJava.getConfig().setSetting(OptionConstants.FIND_ALL_DOCUMENTS, isSelected);
                FindReplacePanel.this._findField.requestFocusInWindow();
            }
        });
        boolean matchWordSelected = DrJava.getConfig().getSetting(OptionConstants.FIND_WHOLE_WORD);
        this._matchWholeWord = new JCheckBox("Whole Word", matchWordSelected);
        if (matchWordSelected) {
            this._machine.setMatchWholeWord();
        } else {
            this._machine.setFindAnyOccurrence();
        }
        this._matchWholeWord.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean isSelected;
                boolean bl = isSelected = e.getStateChange() == 1;
                if (isSelected) {
                    FindReplacePanel.this._machine.setMatchWholeWord();
                } else {
                    FindReplacePanel.this._machine.setFindAnyOccurrence();
                }
                DrJava.getConfig().setSetting(OptionConstants.FIND_WHOLE_WORD, isSelected);
                FindReplacePanel.this._findField.requestFocusInWindow();
            }
        });
        boolean ignoreCommentsSelected = DrJava.getConfig().getSetting(OptionConstants.FIND_NO_COMMENTS_STRINGS);
        this._ignoreCommentsAndStrings = new JCheckBox("No Comments/Strings", ignoreCommentsSelected);
        this._machine.setIgnoreCommentsAndStrings(ignoreCommentsSelected);
        this._ignoreCommentsAndStrings.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean isSelected = e.getStateChange() == 1;
                FindReplacePanel.this._machine.setIgnoreCommentsAndStrings(isSelected);
                DrJava.getConfig().setSetting(OptionConstants.FIND_NO_COMMENTS_STRINGS, isSelected);
                FindReplacePanel.this._findField.requestFocusInWindow();
            }
        });
        boolean ignoreTestCasesSelected = DrJava.getConfig().getSetting(OptionConstants.FIND_NO_TEST_CASES);
        this._ignoreTestCases = new JCheckBox("No Test Cases", ignoreTestCasesSelected);
        this._ignoreTestCases.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean isSelected = e.getStateChange() == 1;
                DrJava.getConfig().setSetting(OptionConstants.FIND_NO_TEST_CASES, isSelected);
                FindReplacePanel.this._findField.requestFocusInWindow();
            }
        });
        this.removeAll();
        this._closePanel = new JPanel(new BorderLayout());
        this._closePanel.add((Component)this._closeButton, "North");
        JPanel _lowerCheckPanel = new JPanel(new FlowLayout(0, 0, 0));
        _lowerCheckPanel.add(this._matchWholeWord);
        _lowerCheckPanel.add(this._ignoreCommentsAndStrings);
        _lowerCheckPanel.setMaximumSize(new Dimension(200, 40));
        JPanel _matchCaseAndAllDocsPanel = new JPanel(new FlowLayout(0, 0, 0));
        this._matchCase.setPreferredSize(this._matchWholeWord.getPreferredSize());
        _matchCaseAndAllDocsPanel.add(this._matchCase);
        _matchCaseAndAllDocsPanel.add(this._searchAllDocuments);
        _matchCaseAndAllDocsPanel.setMaximumSize(new Dimension(200, 40));
        JPanel _ignoreTestCasesPanel = new JPanel(new FlowLayout(0, 0, 0));
        _ignoreTestCasesPanel.add(this._ignoreTestCases);
        _ignoreTestCasesPanel.setMaximumSize(new Dimension(200, 40));
        BorderlessScrollPane _findPane = new BorderlessScrollPane(this._findField);
        BorderlessScrollPane _replacePane = new BorderlessScrollPane(this._replaceField);
        _findPane.setHorizontalScrollBarPolicy(30);
        _replacePane.setHorizontalScrollBarPolicy(30);
        JPanel findPanel = new JPanel(new BorderLayout(5, 5));
        findPanel.add((Component)findLabelPanel, "West");
        findPanel.add((Component)_findPane, "Center");
        JPanel replacePanel = new JPanel(new BorderLayout(5, 5));
        replacePanel.add((Component)replaceLabelPanel, "West");
        replacePanel.add((Component)_replacePane, "Center");
        JPanel leftPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        leftPanel.add(findPanel);
        leftPanel.add(replacePanel);
        GridBagLayout gbLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel emptyPanel = new JPanel();
        JPanel optionsPanel = new JPanel(gbLayout);
        optionsPanel.setLayout(gbLayout);
        optionsPanel.add(_matchCaseAndAllDocsPanel);
        optionsPanel.add(_lowerCheckPanel);
        optionsPanel.add(_ignoreTestCasesPanel);
        optionsPanel.add(emptyPanel);
        c.fill = 2;
        c.anchor = 11;
        c.gridwidth = 0;
        c.weightx = 1.0;
        gbLayout.setConstraints(_matchCaseAndAllDocsPanel, c);
        gbLayout.setConstraints(_lowerCheckPanel, c);
        gbLayout.setConstraints(_ignoreTestCasesPanel, c);
        c.fill = 1;
        c.anchor = 15;
        c.gridheight = 0;
        c.weighty = 1.0;
        gbLayout.setConstraints(emptyPanel, c);
        JPanel midPanel = new JPanel(new BorderLayout(5, 5));
        midPanel.add((Component)leftPanel, "Center");
        midPanel.add((Component)optionsPanel, "East");
        JPanel _rightPanel = new JPanel(new BorderLayout(5, 5));
        _rightPanel.add((Component)midPanel, "Center");
        _rightPanel.add((Component)this._closePanel, "East");
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        newPanel.add(_rightPanel);
        newPanel.add(Box.createVerticalStrut(5));
        newPanel.add(buttons);
        newPanel.add(Box.createVerticalStrut(5));
        this.add(newPanel);
        this._findField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this._updateHelper();
            }

            public void insertUpdate(DocumentEvent e) {
                this._updateHelper();
            }

            public void removeUpdate(DocumentEvent e) {
                this._updateHelper();
            }

            private void _updateHelper() {
                FindReplacePanel.this.updateFirstDocInSearch();
                FindReplacePanel.this._replaceAction.setEnabled(false);
                FindReplacePanel.this._replaceFindNextAction.setEnabled(false);
                FindReplacePanel.this._replaceFindPreviousAction.setEnabled(false);
                FindReplacePanel.this._machine.positionChanged();
                if (FindReplacePanel.this._findField.getText().equals("")) {
                    FindReplacePanel.this._replaceAllAction.setEnabled(false);
                } else {
                    FindReplacePanel.this._replaceAllAction.setEnabled(true);
                }
                FindReplacePanel.this.updateUI();
            }
        });
    }

    @Override
    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        this._findField.selectAll();
        return this._findField.requestFocusInWindow();
    }

    JTextPane getFindField() {
        return this._findField;
    }

    private void _findAll() {
        String searchStr;
        this._findLabelBot.setText("Next");
        String title = searchStr = this._findField.getText();
        OpenDefinitionsDocument startDoc = this._defPane.getOpenDefDocument();
        boolean searchAll = this._machine.getSearchAllDocuments();
        String tabLabel = title.length() <= 20 ? title : title.substring(0, 20);
        RegionManager<MovingDocumentRegion> rm = this._model.createFindResultsManager();
        final FindResultsPanel panel = this._frame.createFindResultsPanel(rm, tabLabel, searchStr, searchAll, this._machine.getMatchCase(), this._machine.getMatchWholeWord(), this._machine.getIgnoreCommentsAndStrings(), this._ignoreTestCases.isSelected(), new WeakReference<OpenDefinitionsDocument>(startDoc), this);
        this.findAll(searchStr, searchAll, this._machine.getMatchCase(), this._machine.getMatchWholeWord(), this._machine.getIgnoreCommentsAndStrings(), this._ignoreTestCases.isSelected(), startDoc, rm, panel);
        panel.requestFocusInWindow();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                panel._regTree.scrollRowToVisible(0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findAll(String searchStr, boolean searchAll, boolean matchCase, boolean wholeWord, boolean noComments, boolean noTestCases, OpenDefinitionsDocument startDoc, RegionManager<MovingDocumentRegion> rm, FindResultsPanel panel) {
        this._machine.setSearchBackwards(false);
        int searchLen = searchStr.length();
        if (searchLen == 0) {
            return;
        }
        this._frame.updateStatusField("Finding All");
        OpenDefinitionsDocument oldDoc = this._machine.getDocument();
        OpenDefinitionsDocument oldFirstDoc = this._machine.getFirstDoc();
        String oldFindWord = this._machine.getFindWord();
        boolean oldSearchAll = this._machine.getSearchAllDocuments();
        boolean oldMatchCase = this._machine.getMatchCase();
        boolean oldWholeWord = this._machine.getMatchWholeWord();
        boolean oldNoComments = this._machine.getIgnoreCommentsAndStrings();
        boolean oldNoTestCases = this._machine.getIgnoreTestCases();
        int oldPosition = this._machine.getCurrentOffset();
        this._machine.setDocument(startDoc);
        if (this._machine.getFirstDoc() == null) {
            this._machine.setFirstDoc(startDoc);
        }
        this._machine.setSearchAllDocuments(searchAll);
        this._machine.setMatchCase(matchCase);
        if (wholeWord) {
            this._machine.setMatchWholeWord();
        } else {
            this._machine.setFindAnyOccurrence();
        }
        this._machine.setIgnoreCommentsAndStrings(noComments);
        this._machine.setPosition(startDoc.getCurrentLocation());
        this._machine.setIgnoreTestCases(noTestCases);
        this._machine.setFindWord(searchStr);
        String replaceStr = this._replaceField.getText();
        this._machine.setReplaceWord(replaceStr);
        this._frame.clearStatusMessage();
        final ArrayList results = new ArrayList();
        this._frame.hourglassOn();
        try {
            int count = this._machine.processAll(new Runnable1<FindResult>(){

                @Override
                public void run(FindResult fr) {
                    results.add(fr);
                }
            });
            this._machine.setDocument(oldDoc);
            this._machine.setFirstDoc(oldFirstDoc);
            this._machine.setFindWord(oldFindWord);
            this._machine.setSearchAllDocuments(oldSearchAll);
            this._machine.setMatchCase(oldMatchCase);
            if (oldWholeWord) {
                this._machine.setMatchWholeWord();
            } else {
                this._machine.setFindAnyOccurrence();
            }
            this._machine.setIgnoreCommentsAndStrings(oldNoComments);
            this._machine.setIgnoreTestCases(oldNoTestCases);
            this._machine.setPosition(oldPosition);
            for (FindResult fr : results) {
                OpenDefinitionsDocument doc = fr.getDocument();
                if (this._model.getActiveDocument() != doc) {
                    this._model.setActiveDocument(doc);
                } else {
                    this._model.refreshActiveDocument();
                }
                int end = fr.getFoundOffset();
                int start = end - searchLen;
                int lineStart = doc._getLineStartPos(start);
                int lineEnd = doc._getLineEndPos(end);
                rm.addRegion(new MovingDocumentRegion(doc, start, end, lineStart, lineEnd));
            }
            if (count > 0) {
                this._frame.showFindResultsPanel(panel);
            } else {
                Toolkit.getDefaultToolkit().beep();
                panel.freeResources();
            }
            this._frame.setStatusMessage("Found " + count + " occurrence" + (count == 1 ? "" : "s") + ".");
        }
        finally {
            this._frame.hourglassOff();
            this._model.setActiveDocument(startDoc);
        }
    }

    private void _replaceAll() {
        this._frame.updateStatusField("Replacing All");
        this._machine.setFindWord(this._findField.getText());
        this._machine.setReplaceWord(this._replaceField.getText());
        this._frame.clearStatusMessage();
        int count = this._machine.replaceAll();
        Toolkit.getDefaultToolkit().beep();
        this._frame.setStatusMessage("Replaced " + count + " occurrence" + (count == 1 ? "" : "s") + ".");
        this._replaceAction.setEnabled(false);
        this._replaceFindNextAction.setEnabled(false);
        this._replaceFindPreviousAction.setEnabled(false);
        this._model.refreshActiveDocument();
    }

    private void _replaceFindNext() {
        this._frame.updateStatusField("Replacing and Finding Next");
        if (this.isSearchBackwards()) {
            this._machine.positionChanged();
            this.findNext();
        }
        this._updateMachine();
        this._machine.setFindWord(this._findField.getText());
        String replaceWord = this._replaceField.getText();
        this._machine.setReplaceWord(replaceWord);
        this._frame.clearStatusMessage();
        boolean replaced = this._machine.replaceCurrent();
        if (replaced) {
            this._selectFoundOrReplacedItem(replaceWord.length());
            this.findNext();
            this._replaceFindNextButton.requestFocusInWindow();
        } else {
            this._replaceAction.setEnabled(false);
            this._replaceFindNextAction.setEnabled(false);
            this._replaceFindPreviousAction.setEnabled(false);
            Toolkit.getDefaultToolkit().beep();
            this._frame.setStatusMessage("Replace failed.");
        }
    }

    private void _replaceFindPrevious() {
        this._frame.updateStatusField("Replacing and Finding Previous");
        if (!this.isSearchBackwards()) {
            this._machine.positionChanged();
            this.findPrevious();
        }
        this._updateMachine();
        this._machine.setFindWord(this._findField.getText());
        String replaceWord = this._replaceField.getText();
        this._machine.setReplaceWord(replaceWord);
        this._frame.clearStatusMessage();
        boolean replaced = this._machine.replaceCurrent();
        if (replaced) {
            this._selectFoundOrReplacedItem(replaceWord.length());
            this.findPrevious();
            this._replaceFindPreviousButton.requestFocusInWindow();
        } else {
            this._replaceAction.setEnabled(false);
            this._replaceFindNextAction.setEnabled(false);
            this._replaceFindPreviousAction.setEnabled(false);
            Toolkit.getDefaultToolkit().beep();
            this._frame.setStatusMessage("Replace failed.");
        }
    }

    void findNext() {
        this._frame.updateStatusField("Finding Next");
        this._machine.setSearchBackwards(false);
        this._findLabelBot.setText("Next");
        this._doFind();
        this._defPane.requestFocusInWindow();
    }

    void findPrevious() {
        this._frame.updateStatusField("Finding Previous");
        this._machine.setSearchBackwards(true);
        this._findLabelBot.setText("Prev");
        this._doFind();
        this._defPane.requestFocusInWindow();
    }

    private void _replace() {
        this._frame.updateStatusField("Replacing");
        this._machine.setFindWord(this._findField.getText());
        String replaceWord = this._replaceField.getText();
        this._machine.setReplaceWord(replaceWord);
        this._frame.clearStatusMessage();
        boolean replaced = this._machine.replaceCurrent();
        if (replaced) {
            this._selectFoundOrReplacedItem(replaceWord.length());
        }
        this._replaceAction.setEnabled(false);
        this._replaceFindNextAction.setEnabled(false);
        this._replaceFindPreviousAction.setEnabled(false);
        this._replaceButton.requestFocusInWindow();
    }

    void beginListeningTo(DefinitionsPane defPane) {
        if (this._defPane == null) {
            this._displayed = true;
            this._defPane = defPane;
            this._defPane.addCaretListener(this._caretListener);
            this._caretChanged = true;
            this._updateMachine();
            this._machine.setFindWord(this._findField.getText());
            this._machine.setReplaceWord(this._replaceField.getText());
            this._frame.clearStatusMessage();
            if (!this._machine.onMatch() || this._findField.getText().equals("")) {
                this._replaceAction.setEnabled(false);
                this._replaceFindNextAction.setEnabled(false);
                this._replaceFindPreviousAction.setEnabled(false);
            } else {
                this._replaceAction.setEnabled(true);
                this._replaceFindNextAction.setEnabled(true);
                this._replaceFindPreviousAction.setEnabled(true);
                this._machine.setLastFindWord();
            }
            if (this._findField.getText().equals("")) {
                this._replaceAllAction.setEnabled(false);
            } else {
                this._replaceAllAction.setEnabled(true);
            }
        } else {
            throw new UnexpectedException(new RuntimeException("FindReplacePanel should not be listening to anything"));
        }
        this._frame.clearStatusMessage();
    }

    public void stopListening() {
        if (this._defPane != null) {
            this._defPane.removeCaretListener(this._caretListener);
            this._defPane = null;
            this._displayed = false;
            this._frame.clearStatusMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _doFind() {
        if (this._findField.getText().length() > 0) {
            this._updateMachine();
            final String findWord = this._findField.getText();
            this._machine.setFindWord(findWord);
            this._machine.setReplaceWord(this._replaceField.getText());
            this._frame.clearStatusMessage();
            boolean searchAll = this._machine.getSearchAllDocuments();
            this._frame.hourglassOn();
            try {
                FindResult fr = this._machine.findNext();
                OpenDefinitionsDocument matchDoc = fr.getDocument();
                OpenDefinitionsDocument openDoc = this._defPane.getOpenDefDocument();
                boolean docChanged = matchDoc != openDoc;
                int pos = fr.getFoundOffset();
                if (pos >= 0) {
                    this._model.addToBrowserHistory();
                }
                if (searchAll) {
                    if (docChanged) {
                        this._model.setActiveDocument(matchDoc);
                    } else {
                        this._model.refreshActiveDocument();
                    }
                }
                if (fr.getWrapped() && !searchAll) {
                    Toolkit.getDefaultToolkit().beep();
                    if (!this._machine.isSearchBackwards()) {
                        this._frame.setStatusMessage("Search wrapped to beginning.");
                    } else {
                        this._frame.setStatusMessage("Search wrapped to end.");
                    }
                }
                if (fr.getAllWrapped() && searchAll) {
                    Toolkit.getDefaultToolkit().beep();
                    this._frame.setStatusMessage("Search wrapped around all documents.");
                }
                if (pos >= 0) {
                    this._defPane.setCaretPosition(pos);
                    this._caretChanged = true;
                    this._updateMachine();
                    Runnable command = new Runnable(){

                        public void run() {
                            FindReplacePanel.this._selectFoundOrReplacedItem(findWord.length());
                            FindReplacePanel.this._replaceAction.setEnabled(true);
                            FindReplacePanel.this._replaceFindNextAction.setEnabled(true);
                            FindReplacePanel.this._replaceFindPreviousAction.setEnabled(true);
                            FindReplacePanel.this._machine.setLastFindWord();
                            FindReplacePanel.this._model.addToBrowserHistory();
                        }
                    };
                    if (docChanged) {
                        EventQueue.invokeLater(command);
                    } else {
                        command.run();
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                    StringBuilder statusMessage = new StringBuilder("Search text \"");
                    if (findWord.length() <= 50) {
                        statusMessage.append(findWord);
                    } else {
                        statusMessage.append(findWord.substring(0, 49) + "...");
                    }
                    statusMessage.append("\" not found.");
                    this._frame.setStatusMessage(statusMessage.toString());
                }
            }
            finally {
                this._frame.hourglassOff();
            }
        }
        if (!DrJava.getConfig().getSetting(OptionConstants.FIND_REPLACE_FOCUS_IN_DEFPANE).booleanValue()) {
            this._findField.requestFocusInWindow();
        }
    }

    @Override
    protected void _close() {
        this._defPane.requestFocusInWindow();
        if (this._displayed) {
            this.stopListening();
        }
        super._close();
    }

    public void setSearchBackwards(boolean b) {
        this._machine.setSearchBackwards(b);
    }

    public boolean isSearchBackwards() {
        return this._machine.isSearchBackwards();
    }

    public void setFieldFont(Font f) {
        this._findField.setFont(f);
        this._replaceField.setFont(f);
    }

    public void updateFirstDocInSearch() {
        this._machine.setFirstDoc(this._model.getActiveDocument());
    }

    private void _updateMachine() {
        if (this._caretChanged) {
            OpenDefinitionsDocument doc = this._model.getActiveDocument();
            this._machine.setDocument(doc);
            if (this._machine.getFirstDoc() == null) {
                this._machine.setFirstDoc(doc);
            }
            this._machine.setPosition(this._defPane.getCaretPosition());
            this._caretChanged = false;
        }
    }

    private void _selectFoundOrReplacedItem(int length) {
        int to;
        int from;
        int offset = this._machine.getCurrentOffset();
        if (this._machine.isSearchBackwards()) {
            from = offset + length;
            to = offset;
        } else {
            from = offset - length;
            to = offset;
        }
        this._selectFoundOrReplacedItem(from, to);
    }

    private void _selectFoundOrReplacedItem(int from, int to) {
        this._defPane.centerViewOnOffset(from);
        this._defPane.select(from, to);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                FindReplacePanel.this._defPane.getCaret().setSelectionVisible(true);
            }
        });
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public DefinitionsPane getDefPane() {
        return this._defPane;
    }

    public JButton getFindNextButton() {
        return this._findNextButton;
    }
}

