/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.Version;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.plt.lambda.Box;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.plt.lambda.SimpleBox;
import edu.rice.cs.plt.text.TextUtil;
import edu.rice.cs.util.swing.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewVersionPopup
extends JDialog {
    private JComboBox _modeBox;
    private JButton _closeButton;
    private JButton _downloadButton;
    private MainFrame _mainFrame;
    private JOptionPane _versionPanel;
    private JPanel _bottomPanel;
    private static Date BUILD_TIME = Version.getBuildTime();
    private String[] _msg = null;
    private String _newestVersionString = "";
    private Action _closeAction = new AbstractAction("Close"){

        public void actionPerformed(ActionEvent e) {
            NewVersionPopup.this.closeAction();
        }
    };
    private Action _downloadAction = new AbstractAction("Download"){

        public void actionPerformed(ActionEvent e) {
            NewVersionPopup.this.downloadAction();
        }
    };
    protected final Runnable1<WindowEvent> CANCEL = new Runnable1<WindowEvent>(){

        @Override
        public void run(WindowEvent e) {
            NewVersionPopup.this.closeAction();
        }
    };

    public NewVersionPopup(MainFrame parent) {
        super((Frame)parent, "Check for New Version of DrJava");
        this.setResizable(false);
        this._mainFrame = parent;
        this._mainFrame.setPopupLoc(this);
        this.setSize(500, 150);
        this._modeBox = new JComboBox<Object>(OptionConstants.NEW_VERSION_NOTIFICATION_CHOICES.toArray());
        for (int i = 0; i < OptionConstants.NEW_VERSION_NOTIFICATION_CHOICES.size(); ++i) {
            if (!DrJava.getConfig().getSetting(OptionConstants.NEW_VERSION_NOTIFICATION).equals(OptionConstants.NEW_VERSION_NOTIFICATION_CHOICES.get(i))) continue;
            this._modeBox.setSelectedIndex(i);
            break;
        }
        this._modeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrJava.getConfig().setSetting(OptionConstants.NEW_VERSION_NOTIFICATION, OptionConstants.NEW_VERSION_NOTIFICATION_CHOICES.get(NewVersionPopup.this._modeBox.getSelectedIndex()));
                NewVersionPopup.access$102(NewVersionPopup.this, null);
                NewVersionPopup.this.updateText();
            }
        });
        this._downloadButton = new JButton(this._downloadAction);
        this._closeButton = new JButton(this._closeAction);
        this._downloadButton.setEnabled(false);
        this._bottomPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this._downloadButton);
        buttonPanel.add(this._closeButton);
        this._bottomPanel.add((Component)buttonPanel, "Center");
        JPanel comboPanel = new JPanel();
        comboPanel.add(new JLabel("Check for: "));
        comboPanel.add(this._modeBox);
        this._bottomPanel.add((Component)comboPanel, "West");
        this.updateText();
    }

    private void updateText() {
        if (this._msg != null) {
            this._versionPanel = new JOptionPane(this._msg, 1, -1, null, new Object[0]);
            JPanel cp = new JPanel(new BorderLayout(5, 5));
            cp.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setContentPane(cp);
            cp.add((Component)this._versionPanel, "Center");
            cp.add((Component)this._bottomPanel, "South");
            this.getRootPane().setDefaultButton(this._closeButton);
            this.setTitle("Check for New Version of DrJava");
            this.pack();
            return;
        }
        this.setTitle("Checking for new versions, please wait...");
        String[] msg = new String[]{"Checking drjava.org for new versions.", "Please wait..."};
        this._versionPanel = new JOptionPane(msg, 1, -1, null, new Object[0]);
        JPanel cp = new JPanel(new BorderLayout(5, 5));
        cp.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(cp);
        cp.add((Component)this._versionPanel, "Center");
        cp.add((Component)this._bottomPanel, "South");
        this.getRootPane().setDefaultButton(this._closeButton);
        this.pack();
        Utilities.clearEventQueue();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                NewVersionPopup.access$102(NewVersionPopup.this, NewVersionPopup.this.getMessage(null));
                NewVersionPopup.this._versionPanel = new JOptionPane(NewVersionPopup.this._msg, 1, -1, null, new Object[0]);
                JPanel cp = new JPanel(new BorderLayout(5, 5));
                cp.setBorder(new EmptyBorder(5, 5, 5, 5));
                NewVersionPopup.this.setContentPane(cp);
                cp.add((Component)NewVersionPopup.this._versionPanel, "Center");
                cp.add((Component)NewVersionPopup.this._bottomPanel, "South");
                NewVersionPopup.this.getRootPane().setDefaultButton(NewVersionPopup.this._closeButton);
                NewVersionPopup.this.setTitle("Check for New Version of DrJava");
                NewVersionPopup.this.pack();
            }
        });
    }

    protected void closeAction() {
        this.setVisible(false);
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadAction() {
        this.closeAction();
        String DRJAVA_FILES_PAGE = "http://sourceforge.net/project/showfiles.php?group_id=44253";
        String LINK_PREFIX = "<a href=\"/project/showfiles.php?group_id=44253";
        String LINK_SUFFIX = "\">";
        BufferedReader br = null;
        try {
            URL url = new URL("http://sourceforge.net/project/showfiles.php?group_id=44253");
            InputStream urls = url.openStream();
            InputStreamReader is = new InputStreamReader(urls);
            br = new BufferedReader(is);
            while (true) {
                String line;
                if ((line = br.readLine()) != null) {
                    int suffixPos;
                    int pos = line.indexOf(this._newestVersionString);
                    if (pos < 0) continue;
                    int prePos = line.indexOf("<a href=\"/project/showfiles.php?group_id=44253");
                    if (prePos < 0 || prePos >= pos || (suffixPos = line.indexOf("\">", prePos)) < 0 || suffixPos + "\">".length() != pos) continue;
                    String versionLink = TextUtil.xmlUnescape(line.substring(prePos + "<a href=\"/project/showfiles.php?group_id=44253".length(), suffixPos));
                    PlatformFactory.ONLY.openURL(new URL("http://sourceforge.net/project/showfiles.php?group_id=44253" + versionLink));
                    return;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this._openFileDownloadPage("http://sourceforge.net/project/showfiles.php?group_id=44253");
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private void _openFileDownloadPage(String page) {
        try {
            PlatformFactory.ONLY.openURL(new URL(page));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean checkNewVersion() {
        SimpleBox<Boolean> availableRef = new SimpleBox<Boolean>(false);
        this.getMessage(availableRef);
        return (Boolean)availableRef.value();
    }

    protected String[] getMessage(Box<Boolean> availableRef) {
        SimpleBox<String> stableString = new SimpleBox<String>("");
        SimpleBox<String> betaString = new SimpleBox<String>("");
        SimpleBox<String> devString = new SimpleBox<String>("");
        SimpleBox<Date> stableTime = new SimpleBox<Date>(new Date(0L));
        SimpleBox<Date> betaTime = new SimpleBox<Date>(new Date(0L));
        SimpleBox<Date> devTime = new SimpleBox<Date>(new Date(0L));
        boolean newVersion = false;
        this._newestVersionString = "";
        if (availableRef != null) {
            availableRef.set(false);
        }
        switch (this._modeBox.getSelectedIndex()) {
            case 2: {
                newVersion |= NewVersionPopup.checkNewDevVersion(devString, devTime);
            }
            case 1: {
                newVersion |= NewVersionPopup.checkNewBetaVersion(betaString, betaTime);
            }
            case 0: {
                this._downloadButton.setEnabled(newVersion |= NewVersionPopup.checkNewStableVersion(stableString, stableTime));
                DrJava.getConfig().setSetting(OptionConstants.LAST_NEW_VERSION_NOTIFICATION, new Date().getTime());
                if (availableRef != null) {
                    availableRef.set(newVersion);
                }
                if (newVersion) {
                    String newestType = "";
                    if (((Date)stableTime.value()).after((Date)betaTime.value())) {
                        if (((Date)stableTime.value()).after((Date)devTime.value())) {
                            this._newestVersionString = (String)stableString.value();
                            newestType = "stable ";
                        } else {
                            this._newestVersionString = (String)devString.value();
                            newestType = "development ";
                        }
                    } else if (((Date)betaTime.value()).after((Date)devTime.value())) {
                        this._newestVersionString = (String)betaString.value();
                        newestType = "beta ";
                    } else {
                        this._newestVersionString = (String)devString.value();
                        newestType = "development ";
                    }
                    return new String[]{"A new " + newestType + "version has been found.", "The new version is: " + this._newestVersionString, "Do you want to download this new version?"};
                }
                if (availableRef != null) {
                    availableRef.set(false);
                }
                return new String[]{"No new version of DrJava has been found.", "You are using the newest version that matches your criterion."};
            }
        }
        this._downloadButton.setEnabled(false);
        return new String[]{"Checking for new versions has been disabled.", "You can change this setting below."};
    }

    public static boolean checkNewStableVersion(Box<String> versionStringRef, Box<Date> buildTimeRef) {
        try {
            Date newestTime = NewVersionPopup.getBuildTime(new URL("http://www.drjava.org/LATEST_VERSION.TXT"), versionStringRef);
            if (newestTime == null) {
                return false;
            }
            if (buildTimeRef != null) {
                buildTimeRef.set(newestTime);
            }
            return BUILD_TIME.before(newestTime);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean checkNewBetaVersion(Box<String> versionStringRef, Box<Date> buildTimeRef) {
        try {
            Date newestTime = NewVersionPopup.getBuildTime(new URL("http://www.drjava.org/LATEST_BETA_VERSION.TXT"), versionStringRef);
            if (newestTime == null) {
                return false;
            }
            if (buildTimeRef != null) {
                buildTimeRef.set(newestTime);
            }
            return BUILD_TIME.before(newestTime);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean checkNewDevVersion(Box<String> versionStringRef, Box<Date> buildTimeRef) {
        try {
            Date newestTime = NewVersionPopup.getBuildTime(new URL("http://www.drjava.org/LATEST_DEV_VERSION.TXT"), versionStringRef);
            if (newestTime == null) {
                return false;
            }
            if (buildTimeRef != null) {
                buildTimeRef.set(newestTime);
            }
            return BUILD_TIME.before(newestTime);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static Date getBuildTime(URL url) {
        return NewVersionPopup.getBuildTime(url, null);
    }

    public static Date getBuildTime(URL url, Box<String> versionStringRef) {
        try {
            int releasePos;
            InputStream urls = url.openStream();
            InputStreamReader is = null;
            BufferedReader br = null;
            is = new InputStreamReader(urls);
            br = new BufferedReader(is);
            String line = br.readLine();
            if (versionStringRef != null) {
                versionStringRef.set(line);
            }
            br.close();
            String DRJAVA_PREFIX = "drjava-";
            if (!line.startsWith("drjava-")) {
                return null;
            }
            line = line.substring("drjava-".length());
            String STABLE_PREFIX = "stable-";
            if (line.startsWith("stable-")) {
                line = line.substring("stable-".length());
            }
            String BETA_PREFIX = "beta-";
            if (line.startsWith("beta-")) {
                line = line.substring("beta-".length());
            }
            if ((releasePos = line.indexOf("-r")) >= 0) {
                line = line.substring(0, releasePos);
            }
            return new SimpleDateFormat("yyyyMMdd-HHmm z").parse(line + " GMT");
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setVisible(boolean vis) {
        assert (EventQueue.isDispatchThread());
        this.validate();
        if (vis) {
            this._mainFrame.hourglassOn();
            this._mainFrame.installModalWindowAdapter(this, LambdaUtil.NO_OP, this.CANCEL);
        } else {
            this._mainFrame.removeModalWindowAdapter(this);
            this._mainFrame.hourglassOff();
            this._mainFrame.toFront();
        }
        super.setVisible(vis);
    }

    static /* synthetic */ String[] access$102(NewVersionPopup x0, String[] x1) {
        x0._msg = x1;
        return x1;
    }
}

