/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.VectorOption;
import edu.rice.cs.drjava.ui.ClassPathFilter;
import edu.rice.cs.drjava.ui.config.VectorOptionComponent;
import edu.rice.cs.util.swing.SwingFrame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorFileOptionComponent
extends VectorOptionComponent<File>
implements OptionConstants {
    private FileFilter _fileFilter;
    private JFileChooser _jfc;
    protected boolean _moveButtonEnabled = true;
    protected File _baseDir = null;

    public VectorFileOptionComponent(VectorOption<File> opt, String text, SwingFrame parent) {
        this(opt, text, parent, false);
    }

    public VectorFileOptionComponent(VectorOption<File> opt, String text, SwingFrame parent, String description) {
        this(opt, text, parent, description, false);
    }

    public VectorFileOptionComponent(VectorOption<File> opt, String text, SwingFrame parent, boolean moveButtonEnabled) {
        super(opt, text, parent);
        this._moveButtonEnabled = moveButtonEnabled;
        File workDir = new File(System.getProperty("user.home"));
        this._jfc = new JFileChooser(workDir);
        this._jfc.setDialogTitle("Select");
        this._jfc.setApproveButtonText("Select");
        this._jfc.setFileSelectionMode(2);
        this._jfc.setMultiSelectionEnabled(true);
        this._fileFilter = ClassPathFilter.ONLY;
    }

    public VectorFileOptionComponent(VectorOption<File> opt, String text, SwingFrame parent, String description, boolean moveButtonEnabled) {
        this(opt, text, parent, moveButtonEnabled);
        this.setDescription(description);
    }

    @Override
    protected void _addButtons() {
        super._addButtons();
        if (this._moveButtonEnabled) {
            this._buttonPanel.add(this._moveUpButton);
            this._buttonPanel.add(this._moveDownButton);
        }
    }

    @Override
    public void setValue(ArrayList<File> files) {
        this._listModel.clear();
        for (File f : files) {
            this._listModel.addElement(f);
        }
    }

    public void setFileFilter(FileFilter fileFilter) {
        this._fileFilter = fileFilter;
    }

    public void setBaseDir(File f) {
        if (f.isDirectory()) {
            this._baseDir = f;
        }
    }

    public void chooseFile() {
        File selection = (File)this._list.getSelectedValue();
        if (selection != null) {
            File parent = selection.getParentFile();
            if (parent != null) {
                this._jfc.setCurrentDirectory(parent);
            }
        } else if (this._baseDir != null) {
            this._jfc.setCurrentDirectory(this._baseDir);
        }
        this._jfc.setFileFilter(this._fileFilter);
        File[] c = null;
        int returnValue = this._jfc.showDialog(this._parent, null);
        if (returnValue == 0) {
            c = this._jfc.getSelectedFiles();
        }
        if (c != null) {
            for (int i = 0; i < c.length; ++i) {
                this._listModel.addElement(c[i]);
            }
        }
    }

    @Override
    protected Action _getAddAction() {
        return new AbstractAction("Add"){

            public void actionPerformed(ActionEvent ae) {
                VectorFileOptionComponent.this.chooseFile();
                VectorFileOptionComponent.this._list.setSelectedIndex(VectorFileOptionComponent.this._listModel.getSize() - 1);
                VectorFileOptionComponent.this.notifyChangeListeners();
            }
        };
    }
}

