/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.predictive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredictiveInputModel<T extends Comparable<? super T>> {
    private volatile ArrayList<T> _items = new ArrayList();
    private volatile int _index = 0;
    private final ArrayList<T> _matchingItems = new ArrayList();
    private volatile String _mask = "";
    private volatile boolean _ignoreCase = false;
    private volatile MatchingStrategy<T> _strategy;

    public PredictiveInputModel(boolean ignoreCase, PredictiveInputModel<T> pim) {
        this(ignoreCase, pim._strategy, (List<T>)pim._items);
        this.setMask(pim.getMask());
    }

    public PredictiveInputModel(boolean ignoreCase, MatchingStrategy<T> strategy, List<T> items) {
        this._ignoreCase = ignoreCase;
        this._strategy = strategy;
        this.setList(items);
    }

    public PredictiveInputModel(boolean ignoreCase, MatchingStrategy<T> strategy, T ... items) {
        this._ignoreCase = ignoreCase;
        this._strategy = strategy;
        this.setList((Comparable[])items);
    }

    public void setStrategy(MatchingStrategy<T> strategy) {
        this._strategy = strategy;
        this.updateMatchingStrings(this._items);
    }

    public List<T> getList() {
        return new ArrayList<T>(this._items);
    }

    public void setList(List<T> items) {
        this._items = new ArrayList<T>(items);
        Collections.sort(this._items);
        this.updateMatchingStrings(this._items);
    }

    public void setList(T ... items) {
        this._items = new ArrayList(items.length);
        for (T s : items) {
            this._items.add(s);
        }
        Collections.sort(this._items);
        this.updateMatchingStrings(this._items);
    }

    public void setList(PredictiveInputModel<T> pim) {
        this.setList((List<T>)pim._items);
    }

    public String getMask() {
        return this._mask;
    }

    public void setMask(String mask) {
        this._mask = mask;
        this.updateMatchingStrings(this._items);
    }

    private int indexOf(ArrayList<T> l, T item) {
        int index = 0;
        for (Comparable i : l) {
            if (this._strategy.equivalent(item, i, this)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private void updateMatchingStrings(ArrayList<T> items) {
        items = new ArrayList<T>(items);
        this._matchingItems.clear();
        for (Comparable s : items) {
            if (!this._strategy.isMatch(s, this)) continue;
            this._matchingItems.add(s);
        }
        if (this._items.size() > 0) {
            for (int i = 0; i < this._items.size(); ++i) {
                if (!this._strategy.isPerfectMatch((Comparable)this._items.get(i), this)) continue;
                this._index = i;
                break;
            }
            this.setCurrentItem((Comparable)this._items.get(this._index));
        } else {
            this._index = 0;
        }
    }

    public T getCurrentItem() {
        if (this._items.size() > 0) {
            return (T)((Comparable)this._items.get(this._index));
        }
        return null;
    }

    public void setCurrentItem(T item) {
        if (this._items.size() == 0) {
            this._index = 0;
            return;
        }
        boolean found = false;
        int index = this.indexOf(this._items, item);
        if (index < 0) {
            this.pickClosestMatch(item);
        } else {
            for (int i = index; i < this._items.size(); ++i) {
                if (0 > this.indexOf(this._matchingItems, (Comparable)this._items.get(i))) continue;
                this._index = i;
                found = true;
                break;
            }
            if (!found) {
                this.pickClosestMatch(item);
            }
        }
    }

    private void pickClosestMatch(T item) {
        if (this._matchingItems.size() > 0) {
            Comparable i;
            Comparable follows = (Comparable)this._matchingItems.get(0);
            Iterator<T> i$ = this._matchingItems.iterator();
            while (i$.hasNext() && this._strategy.compare(item, i = (Comparable)i$.next(), this) >= 0) {
                follows = i;
            }
            this._index = this.indexOf(this._items, follows);
        } else {
            this._index = this.indexOf(this._items, this._strategy.getLongestMatch(item, this._items, this));
        }
    }

    public List<T> getMatchingItems() {
        return new ArrayList<T>(this._matchingItems);
    }

    public String getSharedMaskExtension() {
        return this._strategy.getSharedMaskExtension(this._matchingItems, this);
    }

    public void extendMask(String extension) {
        this._mask = this._mask + extension;
        this.updateMatchingStrings(this._matchingItems);
    }

    public void extendSharedMask() {
        this._mask = this._strategy.getExtendedSharedMask(this._matchingItems, this);
        this.updateMatchingStrings(this._matchingItems);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RegExLineNumStrategy<X extends Comparable<? super X>>
    implements MatchingStrategy<X> {
        public String toString() {
            return "RegEx";
        }

        @Override
        public boolean isMatch(X item, PredictiveInputModel<X> pim) {
            int posB = ((PredictiveInputModel)pim)._mask.lastIndexOf(58);
            if (posB < 0) {
                posB = ((PredictiveInputModel)pim)._mask.length();
            }
            String mask = ((PredictiveInputModel)pim)._mask.substring(0, posB);
            String a = item.toString();
            try {
                Pattern p = Pattern.compile(mask, ((PredictiveInputModel)pim)._ignoreCase ? 2 : 0);
                Matcher m = p.matcher(a);
                return m.matches();
            }
            catch (PatternSyntaxException e) {
                return false;
            }
        }

        @Override
        public boolean isPerfectMatch(X item, PredictiveInputModel<X> pim) {
            int posB = ((PredictiveInputModel)pim)._mask.lastIndexOf(58);
            if (posB < 0) {
                posB = ((PredictiveInputModel)pim)._mask.length();
            }
            String mask = ((PredictiveInputModel)pim)._mask.substring(0, posB);
            String a = ((PredictiveInputModel)pim)._ignoreCase ? item.toString().toLowerCase() : item.toString();
            return a.equals(((PredictiveInputModel)pim)._ignoreCase ? mask.toLowerCase() : mask);
        }

        @Override
        public boolean equivalent(X item1, X item2, PredictiveInputModel<X> pim) {
            int posA = item1.toString().lastIndexOf(58);
            if (posA < 0) {
                posA = item1.toString().length();
            }
            String i1 = item1.toString().substring(0, posA);
            int posB = item2.toString().lastIndexOf(58);
            if (posB < 0) {
                posB = item2.toString().length();
            }
            String i2 = item2.toString().substring(0, posB);
            String a = ((PredictiveInputModel)pim)._ignoreCase ? i1.toLowerCase() : i1;
            String b = ((PredictiveInputModel)pim)._ignoreCase ? i2.toLowerCase() : i2;
            return a.equals(b);
        }

        @Override
        public int compare(X item1, X item2, PredictiveInputModel<X> pim) {
            int posA = item1.toString().lastIndexOf(58);
            if (posA < 0) {
                posA = item1.toString().length();
            }
            String i1 = item1.toString().substring(0, posA);
            int posB = item2.toString().lastIndexOf(58);
            if (posB < 0) {
                posB = item2.toString().length();
            }
            String i2 = item2.toString().substring(0, posB);
            String a = ((PredictiveInputModel)pim)._ignoreCase ? i1.toLowerCase() : i1;
            String b = ((PredictiveInputModel)pim)._ignoreCase ? i2.toLowerCase() : i2;
            return a.compareTo(b);
        }

        @Override
        public X getLongestMatch(X item, List<X> items, PredictiveInputModel<X> pim) {
            if (items.size() > 0) {
                return (X)((Comparable)items.get(0));
            }
            return null;
        }

        @Override
        public String getSharedMaskExtension(List<X> items, PredictiveInputModel<X> pim) {
            return "";
        }

        @Override
        public String getExtendedSharedMask(List<X> items, PredictiveInputModel<X> pim) {
            return ((PredictiveInputModel)pim)._mask;
        }

        @Override
        public String force(X item, String mask) {
            int pos = mask.lastIndexOf(58);
            if (pos < 0) {
                return item.toString();
            }
            return item.toString() + mask.substring(pos);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FragmentLineNumStrategy<X extends Comparable<? super X>>
    implements MatchingStrategy<X> {
        public String toString() {
            return "Fragments";
        }

        @Override
        public boolean isMatch(X item, PredictiveInputModel<X> pim) {
            int posB = ((PredictiveInputModel)pim)._mask.lastIndexOf(58);
            if (posB < 0) {
                posB = ((PredictiveInputModel)pim)._mask.length();
            }
            String mask = ((PredictiveInputModel)pim)._mask.substring(0, posB);
            String a = ((PredictiveInputModel)pim)._ignoreCase ? item.toString().toLowerCase() : item.toString();
            String b = ((PredictiveInputModel)pim)._ignoreCase ? mask.toLowerCase() : mask;
            StringTokenizer tok = new StringTokenizer(b);
            while (tok.hasMoreTokens()) {
                if (a.indexOf(tok.nextToken()) >= 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isPerfectMatch(X item, PredictiveInputModel<X> pim) {
            int posB = ((PredictiveInputModel)pim)._mask.lastIndexOf(58);
            if (posB < 0) {
                posB = ((PredictiveInputModel)pim)._mask.length();
            }
            String mask = ((PredictiveInputModel)pim)._mask.substring(0, posB);
            String a = ((PredictiveInputModel)pim)._ignoreCase ? item.toString().toLowerCase() : item.toString();
            String b = ((PredictiveInputModel)pim)._ignoreCase ? mask.toLowerCase() : mask;
            return a.equals(b);
        }

        @Override
        public boolean equivalent(X item1, X item2, PredictiveInputModel<X> pim) {
            int posA = item1.toString().lastIndexOf(58);
            if (posA < 0) {
                posA = item1.toString().length();
            }
            String i1 = item1.toString().substring(0, posA);
            int posB = item2.toString().lastIndexOf(58);
            if (posB < 0) {
                posB = item2.toString().length();
            }
            String i2 = item2.toString().substring(0, posB);
            String a = ((PredictiveInputModel)pim)._ignoreCase ? i1.toLowerCase() : i1;
            String b = ((PredictiveInputModel)pim)._ignoreCase ? i2.toLowerCase() : i2;
            return a.equals(b);
        }

        @Override
        public int compare(X item1, X item2, PredictiveInputModel<X> pim) {
            int posA = item1.toString().lastIndexOf(58);
            if (posA < 0) {
                posA = item1.toString().length();
            }
            String i1 = item1.toString().substring(0, posA);
            int posB = item2.toString().lastIndexOf(58);
            if (posB < 0) {
                posB = item2.toString().length();
            }
            String i2 = item2.toString().substring(0, posB);
            String a = ((PredictiveInputModel)pim)._ignoreCase ? i1.toLowerCase() : i1;
            String b = ((PredictiveInputModel)pim)._ignoreCase ? i2.toLowerCase() : i2;
            return a.compareTo(b);
        }

        @Override
        public X getLongestMatch(X item, List<X> items, PredictiveInputModel<X> pim) {
            if (items.size() > 0) {
                return (X)((Comparable)items.get(0));
            }
            return null;
        }

        @Override
        public String getSharedMaskExtension(List<X> items, PredictiveInputModel<X> pim) {
            return "";
        }

        @Override
        public String getExtendedSharedMask(List<X> items, PredictiveInputModel<X> pim) {
            return ((PredictiveInputModel)pim)._mask;
        }

        @Override
        public String force(X item, String mask) {
            int pos = mask.lastIndexOf(58);
            if (pos < 0) {
                return item.toString();
            }
            return item.toString() + mask.substring(pos);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PrefixLineNumStrategy<X extends Comparable<? super X>>
    implements MatchingStrategy<X> {
        public String toString() {
            return "Prefix";
        }

        @Override
        public boolean isMatch(X item, PredictiveInputModel<X> pim) {
            int posB = ((PredictiveInputModel)pim)._mask.lastIndexOf(58);
            if (posB < 0) {
                posB = ((PredictiveInputModel)pim)._mask.length();
            }
            String mask = ((PredictiveInputModel)pim)._mask.substring(0, posB);
            String a = ((PredictiveInputModel)pim)._ignoreCase ? item.toString().toLowerCase() : item.toString();
            String b = ((PredictiveInputModel)pim)._ignoreCase ? mask.toLowerCase() : mask;
            return a.startsWith(b);
        }

        @Override
        public boolean isPerfectMatch(X item, PredictiveInputModel<X> pim) {
            int posB = ((PredictiveInputModel)pim)._mask.lastIndexOf(58);
            if (posB < 0) {
                posB = ((PredictiveInputModel)pim)._mask.length();
            }
            String mask = ((PredictiveInputModel)pim)._mask.substring(0, posB);
            String a = ((PredictiveInputModel)pim)._ignoreCase ? item.toString().toLowerCase() : item.toString();
            String b = ((PredictiveInputModel)pim)._ignoreCase ? mask.toLowerCase() : mask;
            return a.equals(b);
        }

        @Override
        public boolean equivalent(X item1, X item2, PredictiveInputModel<X> pim) {
            int posA = item1.toString().lastIndexOf(58);
            if (posA < 0) {
                posA = item1.toString().length();
            }
            String i1 = item1.toString().substring(0, posA);
            int posB = item2.toString().lastIndexOf(58);
            if (posB < 0) {
                posB = item2.toString().length();
            }
            String i2 = item2.toString().substring(0, posB);
            String a = ((PredictiveInputModel)pim)._ignoreCase ? i1.toLowerCase() : i1;
            String b = ((PredictiveInputModel)pim)._ignoreCase ? i2.toLowerCase() : i2;
            return a.equals(b);
        }

        @Override
        public int compare(X item1, X item2, PredictiveInputModel<X> pim) {
            int posA = item1.toString().lastIndexOf(58);
            if (posA < 0) {
                posA = item1.toString().length();
            }
            String i1 = item1.toString().substring(0, posA);
            int posB = item2.toString().lastIndexOf(58);
            if (posB < 0) {
                posB = item2.toString().length();
            }
            String i2 = item2.toString().substring(0, posB);
            String a = ((PredictiveInputModel)pim)._ignoreCase ? i1.toLowerCase() : i1;
            String b = ((PredictiveInputModel)pim)._ignoreCase ? i2.toLowerCase() : i2;
            return a.compareTo(b);
        }

        @Override
        public X getLongestMatch(X item, List<X> items, PredictiveInputModel<X> pim) {
            Comparable longestMatch = null;
            int matchLength = -1;
            for (Comparable i : items) {
                int ml;
                int posA = i.toString().lastIndexOf(58);
                if (posA < 0) {
                    posA = i.toString().length();
                }
                String i1 = i.toString().substring(0, posA);
                int posB = item.toString().lastIndexOf(58);
                if (posB < 0) {
                    posB = item.toString().length();
                }
                String i2 = item.toString().substring(0, posB);
                String s = ((PredictiveInputModel)pim)._ignoreCase ? i1.toLowerCase() : i1;
                String t = ((PredictiveInputModel)pim)._ignoreCase ? i2.toLowerCase() : i2;
                for (ml = 0; s.length() > ml && t.length() > ml && s.charAt(ml) == t.charAt(ml); ++ml) {
                }
                if (ml <= matchLength) continue;
                matchLength = ml;
                longestMatch = i;
            }
            return (X)longestMatch;
        }

        @Override
        public String getSharedMaskExtension(List<X> items, PredictiveInputModel<X> pim) {
            StringBuilder res = new StringBuilder();
            String ext = "";
            if (items.size() == 0) {
                return ext;
            }
            int posB = ((PredictiveInputModel)pim)._mask.lastIndexOf(58);
            if (posB < 0) {
                posB = ((PredictiveInputModel)pim)._mask.length();
            }
            String mask = ((PredictiveInputModel)pim)._mask.substring(0, posB);
            boolean allMatching = true;
            int len = mask.length();
            while (allMatching && mask.length() + ext.length() < ((Comparable)items.get(0)).toString().length()) {
                char origCh = ((Comparable)items.get(0)).toString().charAt(mask.length() + ext.length());
                char ch = ((PredictiveInputModel)pim)._ignoreCase ? Character.toLowerCase(origCh) : origCh;
                allMatching = true;
                for (Comparable i : items) {
                    String a = ((PredictiveInputModel)pim)._ignoreCase ? i.toString().toLowerCase() : i.toString();
                    if (a.charAt(len) == ch) continue;
                    allMatching = false;
                    break;
                }
                if (!allMatching) continue;
                ext = ext + ch;
                res.append(origCh);
                ++len;
            }
            return res.toString();
        }

        @Override
        public String getExtendedSharedMask(List<X> items, PredictiveInputModel<X> pim) {
            int pos = ((PredictiveInputModel)pim)._mask.lastIndexOf(58);
            if (pos < 0) {
                return ((PredictiveInputModel)pim)._mask + this.getSharedMaskExtension(items, pim);
            }
            return ((PredictiveInputModel)pim)._mask.substring(0, pos) + this.getSharedMaskExtension(items, pim) + ((PredictiveInputModel)pim)._mask.substring(pos);
        }

        @Override
        public String force(X item, String mask) {
            int pos = mask.lastIndexOf(58);
            if (pos < 0) {
                return item.toString();
            }
            return item.toString() + mask.substring(pos);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RegExStrategy<X extends Comparable<? super X>>
    implements MatchingStrategy<X> {
        public String toString() {
            return "RegEx";
        }

        @Override
        public boolean isMatch(X item, PredictiveInputModel<X> pim) {
            String a = item.toString();
            try {
                Pattern p = Pattern.compile(((PredictiveInputModel)pim)._mask, ((PredictiveInputModel)pim)._ignoreCase ? 2 : 0);
                Matcher m = p.matcher(a);
                return m.matches();
            }
            catch (PatternSyntaxException e) {
                return false;
            }
        }

        @Override
        public boolean isPerfectMatch(X item, PredictiveInputModel<X> pim) {
            String a = ((PredictiveInputModel)pim)._ignoreCase ? item.toString().toLowerCase() : item.toString();
            String b = ((PredictiveInputModel)pim)._ignoreCase ? ((PredictiveInputModel)pim)._mask.toLowerCase() : ((PredictiveInputModel)pim)._mask;
            return a.equals(b);
        }

        @Override
        public boolean equivalent(X item1, X item2, PredictiveInputModel<X> pim) {
            String a = ((PredictiveInputModel)pim)._ignoreCase ? item1.toString().toLowerCase() : item1.toString();
            String b = ((PredictiveInputModel)pim)._ignoreCase ? item2.toString().toLowerCase() : item2.toString();
            return a.equals(b);
        }

        @Override
        public int compare(X item1, X item2, PredictiveInputModel<X> pim) {
            String a = ((PredictiveInputModel)pim)._ignoreCase ? item1.toString().toLowerCase() : item1.toString();
            String b = ((PredictiveInputModel)pim)._ignoreCase ? item2.toString().toLowerCase() : item2.toString();
            return a.compareTo(b);
        }

        @Override
        public X getLongestMatch(X item, List<X> items, PredictiveInputModel<X> pim) {
            if (items.size() > 0) {
                return (X)((Comparable)items.get(0));
            }
            return null;
        }

        @Override
        public String getSharedMaskExtension(List<X> items, PredictiveInputModel<X> pim) {
            return "";
        }

        @Override
        public String getExtendedSharedMask(List<X> items, PredictiveInputModel<X> pim) {
            return ((PredictiveInputModel)pim)._mask;
        }

        @Override
        public String force(X item, String mask) {
            return item.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FragmentStrategy<X extends Comparable<? super X>>
    implements MatchingStrategy<X> {
        public String toString() {
            return "Fragments";
        }

        @Override
        public boolean isMatch(X item, PredictiveInputModel<X> pim) {
            String a = ((PredictiveInputModel)pim)._ignoreCase ? item.toString().toLowerCase() : item.toString();
            String b = ((PredictiveInputModel)pim)._ignoreCase ? ((PredictiveInputModel)pim)._mask.toLowerCase() : ((PredictiveInputModel)pim)._mask;
            StringTokenizer tok = new StringTokenizer(b);
            while (tok.hasMoreTokens()) {
                if (a.indexOf(tok.nextToken()) >= 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isPerfectMatch(X item, PredictiveInputModel<X> pim) {
            String a = ((PredictiveInputModel)pim)._ignoreCase ? item.toString().toLowerCase() : item.toString();
            String b = ((PredictiveInputModel)pim)._ignoreCase ? ((PredictiveInputModel)pim)._mask.toLowerCase() : ((PredictiveInputModel)pim)._mask;
            return a.equals(b);
        }

        @Override
        public boolean equivalent(X item1, X item2, PredictiveInputModel<X> pim) {
            String a = ((PredictiveInputModel)pim)._ignoreCase ? item1.toString().toLowerCase() : item1.toString();
            String b = ((PredictiveInputModel)pim)._ignoreCase ? item2.toString().toLowerCase() : item2.toString();
            return a.equals(b);
        }

        @Override
        public int compare(X item1, X item2, PredictiveInputModel<X> pim) {
            String a = ((PredictiveInputModel)pim)._ignoreCase ? item1.toString().toLowerCase() : item1.toString();
            String b = ((PredictiveInputModel)pim)._ignoreCase ? item2.toString().toLowerCase() : item2.toString();
            return a.compareTo(b);
        }

        @Override
        public X getLongestMatch(X item, List<X> items, PredictiveInputModel<X> pim) {
            if (items.size() > 0) {
                return (X)((Comparable)items.get(0));
            }
            return null;
        }

        @Override
        public String getSharedMaskExtension(List<X> items, PredictiveInputModel<X> pim) {
            return "";
        }

        @Override
        public String getExtendedSharedMask(List<X> items, PredictiveInputModel<X> pim) {
            return ((PredictiveInputModel)pim)._mask;
        }

        @Override
        public String force(X item, String mask) {
            return item.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PrefixStrategy<X extends Comparable<? super X>>
    implements MatchingStrategy<X> {
        public String toString() {
            return "Prefix";
        }

        @Override
        public boolean isMatch(X item, PredictiveInputModel<X> pim) {
            String a = ((PredictiveInputModel)pim)._ignoreCase ? item.toString().toLowerCase() : item.toString();
            String b = ((PredictiveInputModel)pim)._ignoreCase ? ((PredictiveInputModel)pim)._mask.toLowerCase() : ((PredictiveInputModel)pim)._mask;
            return a.startsWith(b);
        }

        @Override
        public boolean isPerfectMatch(X item, PredictiveInputModel<X> pim) {
            String a = ((PredictiveInputModel)pim)._ignoreCase ? item.toString().toLowerCase() : item.toString();
            String b = ((PredictiveInputModel)pim)._ignoreCase ? ((PredictiveInputModel)pim)._mask.toLowerCase() : ((PredictiveInputModel)pim)._mask;
            return a.equals(b);
        }

        @Override
        public boolean equivalent(X item1, X item2, PredictiveInputModel<X> pim) {
            String a = ((PredictiveInputModel)pim)._ignoreCase ? item1.toString().toLowerCase() : item1.toString();
            String b = ((PredictiveInputModel)pim)._ignoreCase ? item2.toString().toLowerCase() : item2.toString();
            return a.equals(b);
        }

        @Override
        public int compare(X item1, X item2, PredictiveInputModel<X> pim) {
            String a = ((PredictiveInputModel)pim)._ignoreCase ? item1.toString().toLowerCase() : item1.toString();
            String b = ((PredictiveInputModel)pim)._ignoreCase ? item2.toString().toLowerCase() : item2.toString();
            return a.compareTo(b);
        }

        @Override
        public X getLongestMatch(X item, List<X> items, PredictiveInputModel<X> pim) {
            Comparable longestMatch = null;
            int matchLength = -1;
            for (Comparable i : items) {
                int ml;
                String s = ((PredictiveInputModel)pim)._ignoreCase ? i.toString().toLowerCase() : i.toString();
                String t = ((PredictiveInputModel)pim)._ignoreCase ? item.toString().toLowerCase() : item.toString();
                for (ml = 0; s.length() > ml && t.length() > ml && s.charAt(ml) == t.charAt(ml); ++ml) {
                }
                if (ml <= matchLength) continue;
                matchLength = ml;
                longestMatch = i;
            }
            return (X)longestMatch;
        }

        @Override
        public String getSharedMaskExtension(List<X> items, PredictiveInputModel<X> pim) {
            StringBuilder res = new StringBuilder();
            String ext = "";
            if (items.size() == 0) {
                return ext;
            }
            boolean allMatching = true;
            int len = ((PredictiveInputModel)pim)._mask.length();
            while (allMatching && ((PredictiveInputModel)pim)._mask.length() + ext.length() < ((Comparable)items.get(0)).toString().length()) {
                char origCh = ((Comparable)items.get(0)).toString().charAt(((PredictiveInputModel)pim)._mask.length() + ext.length());
                char ch = ((PredictiveInputModel)pim)._ignoreCase ? Character.toLowerCase(origCh) : origCh;
                allMatching = true;
                for (Comparable i : items) {
                    String a = ((PredictiveInputModel)pim)._ignoreCase ? i.toString().toLowerCase() : i.toString();
                    if (a.charAt(len) == ch) continue;
                    allMatching = false;
                    break;
                }
                if (!allMatching) continue;
                ext = ext + ch;
                res.append(origCh);
                ++len;
            }
            return res.toString();
        }

        @Override
        public String getExtendedSharedMask(List<X> items, PredictiveInputModel<X> pim) {
            return ((PredictiveInputModel)pim)._mask + this.getSharedMaskExtension(items, pim);
        }

        @Override
        public String force(X item, String mask) {
            return item.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MatchingStrategy<X extends Comparable<? super X>> {
        public boolean isMatch(X var1, PredictiveInputModel<X> var2);

        public boolean isPerfectMatch(X var1, PredictiveInputModel<X> var2);

        public boolean equivalent(X var1, X var2, PredictiveInputModel<X> var3);

        public int compare(X var1, X var2, PredictiveInputModel<X> var3);

        public X getLongestMatch(X var1, List<X> var2, PredictiveInputModel<X> var3);

        public String getSharedMaskExtension(List<X> var1, PredictiveInputModel<X> var2);

        public String getExtendedSharedMask(List<X> var1, PredictiveInputModel<X> var2);

        public String force(X var1, String var2);
    }
}

