/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.interpreter.ExpressionChecker;
import edu.rice.cs.dynamicjava.interpreter.FunctionContext;
import edu.rice.cs.dynamicjava.interpreter.FunctionSignatureContext;
import edu.rice.cs.dynamicjava.interpreter.StatementChecker;
import edu.rice.cs.dynamicjava.interpreter.TypeContext;
import edu.rice.cs.dynamicjava.interpreter.TypeNameChecker;
import edu.rice.cs.dynamicjava.symbol.BoundedSymbol;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.DJConstructor;
import edu.rice.cs.dynamicjava.symbol.DJMethod;
import edu.rice.cs.dynamicjava.symbol.LocalVariable;
import edu.rice.cs.dynamicjava.symbol.SymbolUtil;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.dynamicjava.symbol.type.VariableType;
import java.lang.reflect.Modifier;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ClassInitializer;
import koala.dynamicjava.tree.ConstructorCall;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.FieldDeclaration;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.InstanceInitializer;
import koala.dynamicjava.tree.InterfaceDeclaration;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.ReferenceTypeName;
import koala.dynamicjava.tree.tiger.PolymorphicConstructorDeclaration;
import koala.dynamicjava.tree.tiger.PolymorphicMethodDeclaration;
import koala.dynamicjava.tree.tiger.TypeParameter;
import koala.dynamicjava.tree.visitor.AbstractVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMemberChecker {
    private final TypeContext _context;
    private final Options _opt;

    public ClassMemberChecker(TypeContext context, Options opt) {
        this._context = context;
        this._opt = opt;
    }

    public void checkClassMembers(Iterable<Node> nodes) {
        this.checkClassSignatures(nodes);
        this.checkBodies(nodes);
    }

    public void checkInterfaceMembers(Iterable<Node> nodes) {
        this.checkInterfaceSignatures(nodes);
        this.checkBodies(nodes);
    }

    private void checkClassSignatures(Iterable<Node> nodes) {
        ClassMemberSignatureVisitor sig = new ClassMemberSignatureVisitor();
        for (Node n : nodes) {
            n.acceptVisitor(sig);
        }
    }

    private void checkInterfaceSignatures(Iterable<Node> nodes) {
        InterfaceMemberSignatureVisitor sig = new InterfaceMemberSignatureVisitor();
        for (Node n : nodes) {
            n.acceptVisitor(sig);
        }
    }

    private void checkBodies(Iterable<Node> nodes) {
        BodyVisitor bod = new BodyVisitor();
        for (Node n : nodes) {
            n.acceptVisitor(bod);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BodyVisitor
    extends AbstractVisitor<Void> {
        private BodyVisitor() {
        }

        @Override
        public Void visit(ClassDeclaration node) {
            throw new ExecutionError("not.implemented", node);
        }

        @Override
        public Void visit(InterfaceDeclaration node) {
            throw new ExecutionError("not.implemented", node);
        }

        @Override
        public Void visit(MethodDeclaration node) {
            if (node.getBody() != null) {
                DJMethod m = NodeProperties.getMethod(node);
                FunctionSignatureContext sigContext = new FunctionSignatureContext(ClassMemberChecker.this._context, m);
                FunctionContext bodyContext = new FunctionContext(sigContext, m);
                node.getBody().acceptVisitor(new StatementChecker(bodyContext, ClassMemberChecker.this._opt));
            }
            return null;
        }

        @Override
        public Void visit(ConstructorDeclaration node) {
            DJConstructor k = NodeProperties.getConstructor(node);
            FunctionSignatureContext sigContext = new FunctionSignatureContext(ClassMemberChecker.this._context, k);
            TypeContext bodyContext = new FunctionContext(sigContext, k);
            ConstructorCall call = node.getConstructorCall();
            if (call == null) {
                call = new ConstructorCall(null, null, true);
            }
            new ExpressionChecker(bodyContext, ClassMemberChecker.this._opt).check(call);
            for (Node n : node.getStatements()) {
                bodyContext = n.acceptVisitor(new StatementChecker(bodyContext, ClassMemberChecker.this._opt));
            }
            return null;
        }

        @Override
        public Void visit(FieldDeclaration node) {
            Expression init = node.getInitializer();
            if (init != null) {
                Type expectedT = NodeProperties.getType(node.getType());
                Type initT = new ExpressionChecker(ClassMemberChecker.this._context, ClassMemberChecker.this._opt).check(init, expectedT);
                TypeSystem ts = ClassMemberChecker.this._opt.typeSystem();
                try {
                    Expression newInit = ts.assign(expectedT, init);
                    node.setInitializer(newInit);
                }
                catch (TypeSystem.UnsupportedConversionException e) {
                    NodeProperties.setErrorStrings(node, ts.userRepresentation(initT), ts.userRepresentation(expectedT));
                    throw new ExecutionError("assignment.types", node);
                }
            }
            return null;
        }

        @Override
        public Void visit(ClassInitializer node) {
            node.getBlock().acceptVisitor(new StatementChecker(ClassMemberChecker.this._context, ClassMemberChecker.this._opt));
            return null;
        }

        @Override
        public Void visit(InstanceInitializer node) {
            node.getBlock().acceptVisitor(new StatementChecker(ClassMemberChecker.this._context, ClassMemberChecker.this._opt));
            return null;
        }
    }

    private class InterfaceMemberSignatureVisitor
    extends SignatureVisitor {
        private InterfaceMemberSignatureVisitor() {
        }

        public Void visit(MethodDeclaration node) {
            int access = node.getAccessFlags();
            if (Modifier.isProtected(access) || Modifier.isPrivate(access) || Modifier.isStatic(access) || Modifier.isStrict(access) || Modifier.isNative(access) || Modifier.isSynchronized(access) || Modifier.isFinal(access)) {
                NodeProperties.setErrorStrings(node, node.getName());
                throw new ExecutionError("interface.method.modifier", node);
            }
            super.visit(node);
            if (node.getBody() != null) {
                NodeProperties.setErrorStrings(node, node.getName());
                throw new ExecutionError("abstract.method.body", node);
            }
            return null;
        }

        public Void visit(FieldDeclaration node) {
            int access = node.getAccessFlags();
            if (Modifier.isProtected(access) || Modifier.isPrivate(access)) {
                NodeProperties.setErrorStrings(node, node.getName());
                throw new ExecutionError("interface.field.modifier", node);
            }
            super.visit(node);
            if (node.getInitializer() == null) {
                NodeProperties.setErrorStrings(node, node.getName());
                throw new ExecutionError("uninitialized.variable", node);
            }
            return null;
        }

        public Void visit(ConstructorDeclaration node) {
            throw new ExecutionError("interface.member", node);
        }

        public Void visit(ClassInitializer node) {
            throw new ExecutionError("interface.member", node);
        }

        public Void visit(InstanceInitializer node) {
            throw new ExecutionError("interface.member", node);
        }
    }

    private class ClassMemberSignatureVisitor
    extends SignatureVisitor {
        private ClassMemberSignatureVisitor() {
        }

        public Void visit(MethodDeclaration node) {
            super.visit(node);
            int access = node.getAccessFlags();
            if (Modifier.isAbstract(access) && node.getBody() != null) {
                NodeProperties.setErrorStrings(node, node.getName());
                throw new ExecutionError("abstract.method.body", node);
            }
            if (!Modifier.isAbstract(access) && node.getBody() == null) {
                NodeProperties.setErrorStrings(node, node.getName());
                throw new ExecutionError("missing.method.body", node);
            }
            return null;
        }

        public Void visit(ConstructorDeclaration node) {
            DJClass thisClass = ClassMemberChecker.this._context.getThis();
            DJConstructor k = NodeProperties.getConstructor(node);
            if (thisClass.isAnonymous() || !thisClass.declaredName().equals(node.getName())) {
                NodeProperties.setErrorStrings(node, SymbolUtil.shortName(thisClass));
                throw new ExecutionError("constructor.name");
            }
            TypeParameter[] tparams = node instanceof PolymorphicConstructorDeclaration ? ((PolymorphicConstructorDeclaration)node).getTypeParameters() : new TypeParameter[]{};
            for (TypeParameter typeParameter : tparams) {
                NodeProperties.setTypeVariable(typeParameter, new VariableType(new BoundedSymbol(typeParameter, typeParameter.getRepresentation())));
            }
            FunctionSignatureContext sigContext = new FunctionSignatureContext(ClassMemberChecker.this._context, k);
            TypeNameChecker sigChecker = new TypeNameChecker(sigContext, ClassMemberChecker.this._opt);
            sigChecker.setTypeParameterBounds(tparams);
            for (FormalParameter formalParameter : node.getParameters()) {
                Type t = sigChecker.check(formalParameter.getType());
                NodeProperties.setVariable(formalParameter, new LocalVariable(formalParameter.getName(), t, formalParameter.isFinal()));
            }
            for (ReferenceTypeName referenceTypeName : node.getExceptions()) {
                sigChecker.check(referenceTypeName);
            }
            return null;
        }

        public Void visit(ClassInitializer node) {
            return null;
        }

        public Void visit(InstanceInitializer node) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class SignatureVisitor
    extends AbstractVisitor<Void> {
        private SignatureVisitor() {
        }

        @Override
        public Void visit(ClassDeclaration node) {
            throw new ExecutionError("not.implemented", node);
        }

        @Override
        public Void visit(InterfaceDeclaration node) {
            throw new ExecutionError("not.implemented", node);
        }

        @Override
        public Void visit(MethodDeclaration node) {
            DJMethod m = NodeProperties.getMethod(node);
            TypeParameter[] tparams = node instanceof PolymorphicMethodDeclaration ? ((PolymorphicMethodDeclaration)node).getTypeParameters() : new TypeParameter[]{};
            for (TypeParameter tparam : tparams) {
                NodeProperties.setTypeVariable(tparam, new VariableType(new BoundedSymbol(tparam, tparam.getRepresentation())));
            }
            FunctionSignatureContext sigContext = new FunctionSignatureContext(ClassMemberChecker.this._context, m);
            TypeNameChecker sigChecker = new TypeNameChecker(sigContext, ClassMemberChecker.this._opt);
            sigChecker.setTypeParameterBounds(tparams);
            Type returnT = sigChecker.check(node.getReturnType());
            NodeProperties.setErasedType(node, ClassMemberChecker.this._opt.typeSystem().erasedClass(returnT));
            for (FormalParameter formalParameter : node.getParameters()) {
                Type t = sigChecker.check(formalParameter.getType());
                NodeProperties.setVariable(formalParameter, new LocalVariable(formalParameter.getName(), t, formalParameter.isFinal()));
            }
            for (ReferenceTypeName referenceTypeName : node.getExceptions()) {
                sigChecker.check(referenceTypeName);
            }
            return null;
        }

        @Override
        public Void visit(FieldDeclaration node) {
            new TypeNameChecker(ClassMemberChecker.this._context, ClassMemberChecker.this._opt).check(node.getType());
            return null;
        }

        @Override
        public abstract Void visit(ConstructorDeclaration var1);

        @Override
        public abstract Void visit(ClassInitializer var1);

        @Override
        public abstract Void visit(InstanceInitializer var1);
    }
}

