/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.interpreter.AmbiguousNameException;
import edu.rice.cs.dynamicjava.interpreter.ClassContext;
import edu.rice.cs.dynamicjava.interpreter.ClassMemberChecker;
import edu.rice.cs.dynamicjava.interpreter.ExpressionEvaluator;
import edu.rice.cs.dynamicjava.interpreter.TreeClassLoader;
import edu.rice.cs.dynamicjava.interpreter.TypeContext;
import edu.rice.cs.dynamicjava.interpreter.TypeNameChecker;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.FunctionWrapperClass;
import edu.rice.cs.dynamicjava.symbol.LocalFunction;
import edu.rice.cs.dynamicjava.symbol.LocalVariable;
import edu.rice.cs.dynamicjava.symbol.SymbolUtil;
import edu.rice.cs.dynamicjava.symbol.TreeClass;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.dynamicjava.symbol.type.BooleanType;
import edu.rice.cs.dynamicjava.symbol.type.ClassType;
import edu.rice.cs.dynamicjava.symbol.type.IntType;
import edu.rice.cs.dynamicjava.symbol.type.IntegralType;
import edu.rice.cs.dynamicjava.symbol.type.NumericType;
import edu.rice.cs.dynamicjava.symbol.type.SimpleArrayType;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.dynamicjava.symbol.type.ValidType;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.iter.ComposedIterable;
import edu.rice.cs.plt.iter.EmptyIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Lambda2;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.interpreter.TypeUtil;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.tree.AddAssignExpression;
import koala.dynamicjava.tree.AddExpression;
import koala.dynamicjava.tree.AmbiguousName;
import koala.dynamicjava.tree.AndExpression;
import koala.dynamicjava.tree.AnonymousAllocation;
import koala.dynamicjava.tree.AnonymousInnerAllocation;
import koala.dynamicjava.tree.ArrayAccess;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.BinaryExpression;
import koala.dynamicjava.tree.BitAndAssignExpression;
import koala.dynamicjava.tree.BitAndExpression;
import koala.dynamicjava.tree.BitOrAssignExpression;
import koala.dynamicjava.tree.BitOrExpression;
import koala.dynamicjava.tree.CastExpression;
import koala.dynamicjava.tree.ComplementExpression;
import koala.dynamicjava.tree.ConditionalExpression;
import koala.dynamicjava.tree.ConstructorCall;
import koala.dynamicjava.tree.DivideAssignExpression;
import koala.dynamicjava.tree.DivideExpression;
import koala.dynamicjava.tree.EqualExpression;
import koala.dynamicjava.tree.ExclusiveOrAssignExpression;
import koala.dynamicjava.tree.ExclusiveOrExpression;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.GreaterExpression;
import koala.dynamicjava.tree.GreaterOrEqualExpression;
import koala.dynamicjava.tree.IdentifierToken;
import koala.dynamicjava.tree.InnerAllocation;
import koala.dynamicjava.tree.InstanceOfExpression;
import koala.dynamicjava.tree.LessExpression;
import koala.dynamicjava.tree.LessOrEqualExpression;
import koala.dynamicjava.tree.Literal;
import koala.dynamicjava.tree.MinusExpression;
import koala.dynamicjava.tree.MultiplyAssignExpression;
import koala.dynamicjava.tree.MultiplyExpression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.NotEqualExpression;
import koala.dynamicjava.tree.NotExpression;
import koala.dynamicjava.tree.NullLiteral;
import koala.dynamicjava.tree.ObjectFieldAccess;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.OrExpression;
import koala.dynamicjava.tree.PlusExpression;
import koala.dynamicjava.tree.PostDecrement;
import koala.dynamicjava.tree.PostIncrement;
import koala.dynamicjava.tree.PreDecrement;
import koala.dynamicjava.tree.PreIncrement;
import koala.dynamicjava.tree.PrimaryExpression;
import koala.dynamicjava.tree.ReferenceTypeName;
import koala.dynamicjava.tree.RemainderAssignExpression;
import koala.dynamicjava.tree.RemainderExpression;
import koala.dynamicjava.tree.ShiftLeftAssignExpression;
import koala.dynamicjava.tree.ShiftLeftExpression;
import koala.dynamicjava.tree.ShiftRightAssignExpression;
import koala.dynamicjava.tree.ShiftRightExpression;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.SimpleFieldAccess;
import koala.dynamicjava.tree.SimpleMethodCall;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StaticMethodCall;
import koala.dynamicjava.tree.StringLiteral;
import koala.dynamicjava.tree.SubtractAssignExpression;
import koala.dynamicjava.tree.SubtractExpression;
import koala.dynamicjava.tree.SuperFieldAccess;
import koala.dynamicjava.tree.SuperMethodCall;
import koala.dynamicjava.tree.ThisExpression;
import koala.dynamicjava.tree.TypeExpression;
import koala.dynamicjava.tree.TypeName;
import koala.dynamicjava.tree.UnaryExpression;
import koala.dynamicjava.tree.UnsignedShiftRightAssignExpression;
import koala.dynamicjava.tree.UnsignedShiftRightExpression;
import koala.dynamicjava.tree.VariableAccess;
import koala.dynamicjava.tree.tiger.PolymorphicAnonymousAllocation;
import koala.dynamicjava.tree.tiger.PolymorphicAnonymousInnerAllocation;
import koala.dynamicjava.tree.tiger.PolymorphicInnerAllocation;
import koala.dynamicjava.tree.tiger.PolymorphicObjectMethodCall;
import koala.dynamicjava.tree.tiger.PolymorphicSimpleAllocation;
import koala.dynamicjava.tree.tiger.PolymorphicStaticMethodCall;
import koala.dynamicjava.tree.tiger.PolymorphicSuperMethodCall;
import koala.dynamicjava.tree.visitor.AbstractVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionChecker {
    private final TypeContext context;
    private final TypeSystem ts;
    private final Options opt;

    public ExpressionChecker(TypeContext ctx, Options options) {
        this.context = ctx;
        this.ts = options.typeSystem();
        this.opt = options;
    }

    public Type check(Expression e) {
        return e.acceptVisitor(new ExpressionVisitor(Option.<Type>none()));
    }

    public Type check(Expression e, Type expected) {
        return e.acceptVisitor(new ExpressionVisitor(Option.some(expected)));
    }

    public Type check(Expression e, Option<Type> expected) {
        return e.acceptVisitor(new ExpressionVisitor(expected));
    }

    public Iterable<Type> checkList(Iterable<? extends Expression> l) {
        return IterUtil.mapSnapshot(l, new ExpressionVisitor(Option.<Type>none()));
    }

    public Iterable<Type> checkList(Iterable<? extends Expression> l, Type expected) {
        return IterUtil.mapSnapshot(l, new ExpressionVisitor(Option.some(expected)));
    }

    public Iterable<Type> checkList(Iterable<? extends Expression> l, Option<Type> expected) {
        return IterUtil.mapSnapshot(l, new ExpressionVisitor(expected));
    }

    private Type checkTypeName(TypeName t) {
        return new TypeNameChecker(this.context, this.opt).check(t);
    }

    private Iterable<Type> checkTypeNameList(Iterable<? extends TypeName> l) {
        return new TypeNameChecker(this.context, this.opt).checkList(l);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExpressionVisitor
    extends AbstractVisitor<Type>
    implements Lambda<Expression, Type> {
        private final Option<Type> expected;

        public ExpressionVisitor(Option<Type> exp) {
            this.expected = exp;
        }

        @Override
        public Type value(Expression e) {
            return e.acceptVisitor(this);
        }

        private String nodeTypesString(Iterable<? extends Node> nodes) {
            Lambda<Node, String> typeString = new Lambda<Node, String>(){

                @Override
                public String value(Node n) {
                    return ExpressionChecker.this.ts.userRepresentation(NodeProperties.getType(n));
                }
            };
            return IterUtil.toString(IterUtil.map(nodes, typeString), "", ", ", "");
        }

        @Override
        public Type visit(AmbiguousName node) {
            Node resolved = this.resolveAmbiguousName(node);
            if (resolved instanceof ReferenceTypeName) {
                NodeProperties.setErrorStrings(node, ((ReferenceTypeName)resolved).getRepresentation());
                throw new ExecutionError("undefined.name", node);
            }
            Expression resolvedExp = (Expression)resolved;
            resolvedExp.acceptVisitor(this);
            NodeProperties.setTranslation(node, resolvedExp);
            if (NodeProperties.hasVariableType(resolvedExp)) {
                NodeProperties.setVariableType(node, NodeProperties.getVariableType(resolvedExp));
            }
            return NodeProperties.setType(node, NodeProperties.getType(resolvedExp));
        }

        private Node resolveAmbiguousName(AmbiguousName node) {
            Iterator<IdentifierToken> ids = node.getIdentifiers().iterator();
            IdentifierToken first = ids.next();
            PrimaryExpression resultExp = null;
            if (ExpressionChecker.this.context.localVariableExists(first.image(), ExpressionChecker.this.ts)) {
                resultExp = new VariableAccess(first.image(), node.getFilename(), first.beginLine(), first.beginColumn(), first.endLine(), first.endColumn());
            } else if (ExpressionChecker.this.context.fieldExists(first.image(), ExpressionChecker.this.ts)) {
                resultExp = new SimpleFieldAccess(first.image(), node.getFilename(), first.beginLine(), first.beginColumn(), first.endLine(), first.endColumn());
            } else {
                ValidType classType;
                IdentifierToken last = first;
                String className = first.image();
                LinkedList<IdentifierToken> classIds = new LinkedList<IdentifierToken>();
                classIds.add(first);
                while (!ExpressionChecker.this.context.typeExists(className, ExpressionChecker.this.ts)) {
                    if (!ids.hasNext()) {
                        NodeProperties.setErrorStrings(node, className);
                        throw new ExecutionError("undefined.name", node);
                    }
                    last = ids.next();
                    className = className + "." + last.image();
                    classIds.add(last);
                }
                try {
                    DJClass c = ExpressionChecker.this.context.getTopLevelClass(className, ExpressionChecker.this.ts);
                    if (c != null) {
                        classType = ExpressionChecker.this.ts.makeClassType(c);
                    } else {
                        classType = ExpressionChecker.this.context.getTypeVariable(className, ExpressionChecker.this.ts);
                        if (classType == null) {
                            ClassType outer = ExpressionChecker.this.context.typeContainingMemberClass(className, ExpressionChecker.this.ts);
                            classType = ExpressionChecker.this.ts.lookupStaticClass(outer, className, IterUtil.empty());
                        }
                    }
                }
                catch (AmbiguousNameException e) {
                    throw new ExecutionError("ambiguous.name", node);
                }
                catch (TypeSystem.InvalidTargetException e) {
                    throw new RuntimeException("context produced bad type");
                }
                catch (TypeSystem.InvalidTypeArgumentException e) {
                    throw new ExecutionError("type.argument.arity", node);
                }
                catch (TypeSystem.UnmatchedLookupException e) {
                    if (e.matches() == 0) {
                        throw new ExecutionError("undefined.name.noinfo", node);
                    }
                    throw new ExecutionError("ambiguous.name", node);
                }
                while (ids.hasNext() && resultExp == null) {
                    IdentifierToken memberName = ids.next();
                    if (ExpressionChecker.this.ts.containsField(classType, memberName.image())) {
                        ReferenceTypeName rt = new ReferenceTypeName(classIds, node.getFilename(), first.beginLine(), first.beginColumn(), last.endLine(), last.endColumn());
                        resultExp = new StaticFieldAccess(rt, memberName.image(), rt.getFilename(), first.beginLine(), first.beginColumn(), memberName.endLine(), memberName.endColumn());
                        continue;
                    }
                    if (ExpressionChecker.this.ts.containsClass(classType, memberName.image())) {
                        last = memberName;
                        className = className + "." + last.image();
                        classIds.add(last);
                        try {
                            classType = ExpressionChecker.this.ts.lookupStaticClass(classType, memberName.image(), IterUtil.empty());
                            continue;
                        }
                        catch (TypeSystem.InvalidTargetException e) {
                            throw new RuntimeException("ts.containsClass lied");
                        }
                        catch (TypeSystem.InvalidTypeArgumentException e) {
                            throw new ExecutionError("type.argument.arity", node);
                        }
                        catch (TypeSystem.UnmatchedLookupException e) {
                            if (e.matches() == 0) {
                                throw new ExecutionError("undefined.name.noinfo", node);
                            }
                            throw new ExecutionError("ambiguous.name", node);
                        }
                    }
                    NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.userRepresentation(classType), memberName.image());
                    throw new ExecutionError("no.such.member", node);
                }
                if (resultExp == null) {
                    return new ReferenceTypeName(classIds, node.getFilename(), first.beginLine(), first.beginColumn(), last.endLine(), last.endColumn());
                }
            }
            while (ids.hasNext()) {
                IdentifierToken field = ids.next();
                resultExp = new ObjectFieldAccess(resultExp, field.image(), node.getFilename(), first.beginLine(), first.beginColumn(), field.endLine(), field.endColumn());
            }
            return resultExp;
        }

        @Override
        public Type visit(Literal node) {
            NodeProperties.setValue(node, node.getValue());
            if (node instanceof NullLiteral) {
                return NodeProperties.setType(node, TypeSystem.NULL);
            }
            if (node instanceof StringLiteral) {
                return NodeProperties.setType(node, TypeSystem.STRING);
            }
            return NodeProperties.setType(node, SymbolUtil.typeOfPrimitiveClass(node.getType()));
        }

        @Override
        public Type visit(ThisExpression node) {
            DJClass thisC;
            String name = node.getClassName();
            if (name.equals("")) {
                thisC = ExpressionChecker.this.context.getThis();
                if (thisC == null) {
                    throw new ExecutionError("this.undefined", node);
                }
            } else {
                thisC = ExpressionChecker.this.context.getThis(name);
                if (thisC == null) {
                    NodeProperties.setErrorStrings(node, name);
                    throw new ExecutionError("undefined.class", node);
                }
            }
            NodeProperties.setDJClass(node, thisC);
            return NodeProperties.setType(node, SymbolUtil.thisType(thisC));
        }

        @Override
        public Type visit(VariableAccess node) {
            LocalVariable v = ExpressionChecker.this.context.getLocalVariable(node.getVariableName(), ExpressionChecker.this.ts);
            NodeProperties.setVariable(node, v);
            NodeProperties.setVariableType(node, v.type());
            return NodeProperties.setType(node, ExpressionChecker.this.ts.capture(v.type()));
        }

        @Override
        public Type visit(SimpleFieldAccess node) {
            try {
                TypeSystem.FieldReference ref;
                ClassType t = ExpressionChecker.this.context.typeContainingField(node.getFieldName(), ExpressionChecker.this.ts);
                if (t == null) {
                    NodeProperties.setErrorStrings(node, node.getFieldName());
                    throw new ExecutionError("undefined.name", node);
                }
                if (ExpressionChecker.this.context.getThis() == null) {
                    ref = ExpressionChecker.this.ts.lookupStaticField(t, node.getFieldName());
                } else {
                    Expression obj = TypeUtil.makeEmptyExpression(node);
                    NodeProperties.setType(obj, t);
                    ref = ExpressionChecker.this.ts.lookupField(obj, node.getFieldName());
                }
                NodeProperties.setField(node, ref.field());
                NodeProperties.setVariableType(node, ref.type());
                if (!ref.field().isStatic()) {
                    NodeProperties.setDJClass(node, t.ofClass());
                }
                Type result = ExpressionChecker.this.ts.capture(ref.type());
                this.addRuntimeCheck(node, result, ref.field().type());
                return NodeProperties.setType(node, result);
            }
            catch (AmbiguousNameException e) {
                throw new ExecutionError("ambiguous.name", node);
            }
            catch (TypeSystem.InvalidTargetException e) {
                throw new RuntimeException("context produced bad type");
            }
            catch (TypeSystem.UnmatchedLookupException e) {
                if (e.matches() == 0) {
                    throw new ExecutionError("undefined.name.noinfo", node);
                }
                throw new ExecutionError("ambiguous.name", node);
            }
        }

        @Override
        public Type visit(ObjectFieldAccess node) {
            Expression receiver = node.getExpression();
            if (receiver instanceof AmbiguousName) {
                Node resolved = this.resolveAmbiguousName((AmbiguousName)receiver);
                if (resolved instanceof ReferenceTypeName) {
                    StaticFieldAccess translation = new StaticFieldAccess((ReferenceTypeName)resolved, node.getFieldName(), node.getFilename(), node.getBeginLine(), node.getBeginColumn(), node.getEndLine(), node.getEndColumn());
                    ((Node)translation).acceptVisitor(this);
                    NodeProperties.setTranslation(node, translation);
                    NodeProperties.setVariableType(node, NodeProperties.getVariableType(translation));
                    return NodeProperties.setType(node, NodeProperties.getType(translation));
                }
                receiver = (Expression)resolved;
            }
            Type receiverT = ExpressionChecker.this.check(receiver);
            try {
                TypeSystem.ObjectFieldReference ref = ExpressionChecker.this.ts.lookupField(receiver, node.getFieldName());
                node.setExpression(ref.object());
                NodeProperties.setField(node, ref.field());
                NodeProperties.setVariableType(node, ref.type());
                Type result = ExpressionChecker.this.ts.capture(ref.type());
                this.addRuntimeCheck(node, result, ref.field().type());
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.TypeSystemException e) {
                NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.userRepresentation(receiverT), node.getFieldName());
                throw new ExecutionError("no.such.field", node);
            }
        }

        @Override
        public Type visit(SuperFieldAccess node) {
            Type t = ExpressionChecker.this.context.getSuperType(ExpressionChecker.this.ts);
            if (t == null) {
                throw new ExecutionError("super.undefined", node);
            }
            Expression obj = TypeUtil.makeEmptyExpression(node);
            NodeProperties.setType(obj, t);
            try {
                TypeSystem.ObjectFieldReference ref = ExpressionChecker.this.ts.lookupField(obj, node.getFieldName());
                NodeProperties.setField(node, ref.field());
                NodeProperties.setDJClass(node, ExpressionChecker.this.context.getThis());
                NodeProperties.setVariableType(node, ref.type());
                Type result = ExpressionChecker.this.ts.capture(ref.type());
                this.addRuntimeCheck(node, result, ref.field().type());
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.TypeSystemException e) {
                NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.userRepresentation(t), node.getFieldName());
                throw new ExecutionError("no.such.field", node);
            }
        }

        @Override
        public Type visit(StaticFieldAccess node) {
            Type t = ExpressionChecker.this.checkTypeName(node.getFieldType());
            try {
                TypeSystem.StaticFieldReference ref = ExpressionChecker.this.ts.lookupStaticField(t, node.getFieldName());
                NodeProperties.setField(node, ref.field());
                NodeProperties.setVariableType(node, ref.type());
                Type result = ExpressionChecker.this.ts.capture(ref.type());
                this.addRuntimeCheck(node, result, ref.field().type());
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.TypeSystemException e) {
                NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.userRepresentation(t), node.getFieldName());
                throw new ExecutionError("no.such.field", node);
            }
        }

        @Override
        public Type visit(SimpleMethodCall node) {
            ClassType t;
            Iterable<Object> args = IterUtil.empty();
            if (node.getArguments() != null) {
                args = node.getArguments();
                ExpressionChecker.this.checkList(args);
            }
            EmptyIterable targs = IterUtil.empty();
            if (ExpressionChecker.this.context.localFunctionExists(node.getMethodName(), ExpressionChecker.this.ts)) {
                Iterable<LocalFunction> matches = ExpressionChecker.this.context.getLocalFunctions(node.getMethodName(), ExpressionChecker.this.ts);
                t = ExpressionChecker.this.ts.makeClassType(new FunctionWrapperClass(ExpressionChecker.this.context.getPackage(), matches));
            } else {
                try {
                    t = ExpressionChecker.this.context.typeContainingMethod(node.getMethodName(), ExpressionChecker.this.ts);
                    if (t == null) {
                        NodeProperties.setErrorStrings(node, node.getMethodName());
                        throw new ExecutionError("undefined.name", node);
                    }
                }
                catch (AmbiguousNameException e) {
                    throw new ExecutionError("ambiguous.name", node);
                }
            }
            try {
                TypeSystem.MethodInvocation inv;
                if (ExpressionChecker.this.context.getThis() == null) {
                    inv = ExpressionChecker.this.ts.lookupStaticMethod(t, node.getMethodName(), targs, args, this.expected);
                } else {
                    Expression obj = TypeUtil.makeEmptyExpression(node);
                    NodeProperties.setType(obj, t);
                    inv = ExpressionChecker.this.ts.lookupMethod(obj, node.getMethodName(), targs, args, this.expected);
                }
                this.checkThrownExceptions(inv.thrown(), node);
                node.setArguments(CollectUtil.makeList(inv.args()));
                NodeProperties.setMethod(node, inv.method());
                if (!inv.method().isStatic()) {
                    NodeProperties.setDJClass(node, t.ofClass());
                }
                Type result = ExpressionChecker.this.ts.capture(inv.returnType());
                DebugUtil.debug.logValue("Type of method call " + node.getMethodName(), ExpressionChecker.this.ts.wrap(result));
                this.addRuntimeCheck(node, result, inv.method().returnType());
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.InvalidTypeArgumentException e) {
                throw new ExecutionError("type.argument", node);
            }
            catch (TypeSystem.TypeSystemException e) {
                NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.userRepresentation(t), node.getMethodName(), this.nodeTypesString(args));
                throw new ExecutionError("no.such.method", node);
            }
        }

        @Override
        public Type visit(ObjectMethodCall node) {
            Expression receiver = node.getExpression();
            if (receiver instanceof AmbiguousName) {
                Node resolved = this.resolveAmbiguousName((AmbiguousName)receiver);
                if (resolved instanceof ReferenceTypeName) {
                    StaticMethodCall translation = node instanceof PolymorphicObjectMethodCall ? new PolymorphicStaticMethodCall((ReferenceTypeName)resolved, node.getMethodName(), node.getArguments(), ((PolymorphicObjectMethodCall)node).getTypeArguments(), node.getFilename(), node.getBeginLine(), node.getBeginColumn(), node.getEndLine(), node.getEndColumn()) : new StaticMethodCall((ReferenceTypeName)resolved, node.getMethodName(), node.getArguments(), node.getFilename(), node.getBeginLine(), node.getBeginColumn(), node.getEndLine(), node.getEndColumn());
                    ((Node)translation).acceptVisitor(this);
                    NodeProperties.setTranslation(node, translation);
                    return NodeProperties.setType(node, NodeProperties.getType(translation));
                }
                receiver = (Expression)resolved;
            }
            Type receiverT = ExpressionChecker.this.check(receiver);
            Iterable<Object> args = IterUtil.empty();
            if (node.getArguments() != null) {
                args = node.getArguments();
                ExpressionChecker.this.checkList(args);
            }
            Iterable targs = IterUtil.empty();
            if (node instanceof PolymorphicObjectMethodCall) {
                targs = ExpressionChecker.this.checkTypeNameList(((PolymorphicObjectMethodCall)node).getTypeArguments());
            }
            try {
                TypeSystem.ObjectMethodInvocation inv = ExpressionChecker.this.ts.lookupMethod(receiver, node.getMethodName(), targs, args, this.expected);
                this.checkThrownExceptions(inv.thrown(), node);
                node.setExpression(inv.object());
                node.setArguments(CollectUtil.makeList(inv.args()));
                NodeProperties.setMethod(node, inv.method());
                Type result = ExpressionChecker.this.ts.capture(inv.returnType());
                DebugUtil.debug.logValue("Type of method call " + node.getMethodName(), ExpressionChecker.this.ts.wrap(result));
                this.addRuntimeCheck(node, result, inv.method().returnType());
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.InvalidTypeArgumentException e) {
                throw new ExecutionError("type.argument", node);
            }
            catch (TypeSystem.TypeSystemException e) {
                NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.userRepresentation(receiverT), node.getMethodName(), this.nodeTypesString(args));
                throw new ExecutionError("no.such.method", node);
            }
        }

        @Override
        public Type visit(SuperMethodCall node) {
            Type t = ExpressionChecker.this.context.getSuperType(ExpressionChecker.this.ts);
            if (t == null) {
                throw new ExecutionError("super.undefined", node);
            }
            Iterable<Object> args = IterUtil.empty();
            if (node.getArguments() != null) {
                args = node.getArguments();
                ExpressionChecker.this.checkList(args);
            }
            Iterable targs = IterUtil.empty();
            if (node instanceof PolymorphicSuperMethodCall) {
                targs = ExpressionChecker.this.checkTypeNameList(((PolymorphicSuperMethodCall)node).getTypeArguments());
            }
            Expression obj = TypeUtil.makeEmptyExpression(node);
            NodeProperties.setType(obj, t);
            try {
                TypeSystem.ObjectMethodInvocation inv = ExpressionChecker.this.ts.lookupMethod(obj, node.getMethodName(), targs, args, this.expected);
                this.checkThrownExceptions(inv.thrown(), node);
                node.setArguments(CollectUtil.makeList(inv.args()));
                NodeProperties.setMethod(node, inv.method());
                NodeProperties.setDJClass(node, ExpressionChecker.this.context.getThis());
                Type result = ExpressionChecker.this.ts.capture(inv.returnType());
                DebugUtil.debug.logValue("Type of method call " + node.getMethodName(), ExpressionChecker.this.ts.wrap(result));
                this.addRuntimeCheck(node, result, inv.method().returnType());
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.InvalidTypeArgumentException e) {
                throw new ExecutionError("type.argument", node);
            }
            catch (TypeSystem.TypeSystemException e) {
                NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.userRepresentation(t), node.getMethodName(), this.nodeTypesString(args));
                throw new ExecutionError("no.such.method", node);
            }
        }

        @Override
        public Type visit(StaticMethodCall node) {
            Type t = ExpressionChecker.this.checkTypeName(node.getMethodType());
            Iterable<Object> args = IterUtil.empty();
            if (node.getArguments() != null) {
                args = node.getArguments();
                ExpressionChecker.this.checkList(args);
            }
            Iterable targs = IterUtil.empty();
            if (node instanceof PolymorphicStaticMethodCall) {
                targs = ExpressionChecker.this.checkTypeNameList(((PolymorphicStaticMethodCall)node).getTypeArguments());
            }
            try {
                TypeSystem.StaticMethodInvocation inv = ExpressionChecker.this.ts.lookupStaticMethod(t, node.getMethodName(), targs, args, this.expected);
                this.checkThrownExceptions(inv.thrown(), node);
                node.setArguments(CollectUtil.makeList(inv.args()));
                NodeProperties.setMethod(node, inv.method());
                Type result = ExpressionChecker.this.ts.capture(inv.returnType());
                DebugUtil.debug.logValue("Type of method call " + node.getMethodName(), ExpressionChecker.this.ts.wrap(result));
                this.addRuntimeCheck(node, result, inv.method().returnType());
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.InvalidTypeArgumentException e) {
                throw new ExecutionError("type.argument", node);
            }
            catch (TypeSystem.TypeSystemException e) {
                NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.userRepresentation(t), node.getMethodName(), this.nodeTypesString(args));
                throw new ExecutionError("no.such.method", node);
            }
        }

        private void addRuntimeCheck(Node node, Type expectedType, Type declaredActualType) {
            Thunk<Class<?>> erasedExpectedType;
            if (!ExpressionChecker.this.ts.isSubtype(ExpressionChecker.this.ts.erase(declaredActualType), ExpressionChecker.this.ts.erase(expectedType)) && (erasedExpectedType = ExpressionChecker.this.ts.erasedClass(expectedType)) != null) {
                NodeProperties.setCheckedType(node, erasedExpectedType);
            }
        }

        @Override
        public Type visit(ArrayAllocation node) {
            Type elementType = ExpressionChecker.this.checkTypeName(node.getElementType());
            if (!ExpressionChecker.this.ts.isReifiable(elementType)) {
                throw new ExecutionError("reifiable.type", node);
            }
            Type result = elementType;
            for (int i = 0; i < node.getDimension(); ++i) {
                result = new SimpleArrayType(result);
            }
            ExpressionChecker.this.checkList(node.getSizes(), TypeSystem.INT);
            ArrayList<Expression> newSizes = new ArrayList<Expression>(node.getSizes().size());
            for (Expression exp : node.getSizes()) {
                try {
                    Expression newExp = ExpressionChecker.this.ts.unaryPromote(ExpressionChecker.this.ts.makePrimitive(exp));
                    if (!(NodeProperties.getType(newExp) instanceof IntType)) {
                        throw new ExecutionError("array.dimension.type", node);
                    }
                    newSizes.add(newExp);
                }
                catch (TypeSystem.UnsupportedConversionException e) {
                    throw new ExecutionError("array.dimension.type", node);
                }
            }
            node.setSizes(newSizes);
            if (node.getInitialization() != null) {
                ExpressionChecker.this.check((Expression)node.getInitialization(), result);
            }
            NodeProperties.setErasedType(node, ExpressionChecker.this.ts.erasedClass(result));
            return NodeProperties.setType(node, result);
        }

        @Override
        public Type visit(ArrayInitializer node) {
            Type elementType = ExpressionChecker.this.checkTypeName(node.getElementType());
            if (this.expected.isSome() && ExpressionChecker.this.ts.isArray(this.expected.unwrap())) {
                ExpressionChecker.this.checkList(node.getCells(), ExpressionChecker.this.ts.arrayElementType(this.expected.unwrap()));
            } else {
                ExpressionChecker.this.checkList(node.getCells());
            }
            ArrayList<Expression> newCells = new ArrayList<Expression>(node.getCells().size());
            for (Expression exp : node.getCells()) {
                try {
                    newCells.add(ExpressionChecker.this.ts.assign(elementType, exp));
                }
                catch (TypeSystem.UnsupportedConversionException e) {
                    Type expT = NodeProperties.getType(exp);
                    NodeProperties.setErrorStrings(exp, ExpressionChecker.this.ts.userRepresentation(expT), ExpressionChecker.this.ts.userRepresentation(elementType));
                    throw new ExecutionError("assignment.types", exp);
                }
            }
            node.setCells(newCells);
            SimpleArrayType result = new SimpleArrayType(elementType);
            NodeProperties.setErasedType(node, ExpressionChecker.this.ts.erasedClass(result));
            return NodeProperties.setType(node, result);
        }

        @Override
        public Type visit(SimpleAllocation node) {
            Type t = ExpressionChecker.this.checkTypeName(node.getCreationType());
            if (!ExpressionChecker.this.ts.isConcrete(t) || !ExpressionChecker.this.ts.isStatic(t)) {
                throw new ExecutionError("allocation.type", node);
            }
            Iterable<Object> args = IterUtil.empty();
            if (node.getArguments() != null) {
                args = node.getArguments();
                ExpressionChecker.this.checkList(args);
            }
            Iterable targs = IterUtil.empty();
            if (node instanceof PolymorphicSimpleAllocation) {
                targs = ExpressionChecker.this.checkTypeNameList(((PolymorphicSimpleAllocation)node).getTypeArguments());
            }
            try {
                TypeSystem.ConstructorInvocation inv = ExpressionChecker.this.ts.lookupConstructor(t, targs, args, this.expected);
                this.checkThrownExceptions(inv.thrown(), node);
                node.setArguments(CollectUtil.makeList(inv.args()));
                NodeProperties.setConstructor(node, inv.constructor());
                return NodeProperties.setType(node, t);
            }
            catch (TypeSystem.InvalidTypeArgumentException e) {
                throw new ExecutionError("type.argument", node);
            }
            catch (TypeSystem.TypeSystemException e) {
                NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.userRepresentation(t), this.nodeTypesString(args));
                throw new ExecutionError("no.such.constructor", node);
            }
        }

        @Override
        public Type visit(AnonymousAllocation node) {
            Type t = ExpressionChecker.this.checkTypeName(node.getCreationType());
            if (!ExpressionChecker.this.ts.isStatic(t) || !ExpressionChecker.this.ts.isExtendable(t) && !ExpressionChecker.this.ts.isImplementable(t)) {
                throw new ExecutionError("allocation.type", node);
            }
            Iterable<Object> args = IterUtil.empty();
            if (node.getArguments() != null) {
                args = node.getArguments();
                ExpressionChecker.this.checkList(args);
            }
            Iterable targs = IterUtil.empty();
            if (node instanceof PolymorphicAnonymousAllocation) {
                targs = ExpressionChecker.this.checkTypeNameList(((PolymorphicAnonymousAllocation)node).getTypeArguments());
            }
            if (!(IterUtil.isEmpty(args) && IterUtil.isEmpty(targs) && ExpressionChecker.this.ts.isImplementable(t))) {
                try {
                    TypeSystem.ConstructorInvocation inv = ExpressionChecker.this.ts.lookupConstructor(t, targs, args, this.expected);
                    this.checkThrownExceptions(inv.thrown(), node);
                    node.setArguments(CollectUtil.makeList(inv.args()));
                }
                catch (TypeSystem.InvalidTypeArgumentException e) {
                    throw new ExecutionError("type.argument", node);
                }
                catch (TypeSystem.TypeSystemException e) {
                    NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.userRepresentation(t), this.nodeTypesString(args));
                    throw new ExecutionError("no.such.constructor", node);
                }
            }
            TreeClass c = new TreeClass(ExpressionChecker.this.context.makeAnonymousClassName(), null, node, new TreeClassLoader(ExpressionChecker.this.context.getClassLoader(), ExpressionChecker.this.opt), ExpressionChecker.this.opt);
            NodeProperties.setDJClass(node, c);
            new ClassMemberChecker(new ClassContext(ExpressionChecker.this.context, c), ExpressionChecker.this.opt).checkClassMembers(node.getMembers());
            NodeProperties.setConstructor(node, IterUtil.first(c.declaredConstructors()));
            return NodeProperties.setType(node, ExpressionChecker.this.ts.makeClassType(c));
        }

        @Override
        public Type visit(InnerAllocation node) {
            Type enclosing = ExpressionChecker.this.check(node.getExpression());
            Iterable classTargs = IterUtil.empty();
            if (node.getClassTypeArguments() != null) {
                classTargs = ExpressionChecker.this.checkTypeNameList(node.getClassTypeArguments());
            }
            try {
                ClassType t = ExpressionChecker.this.ts.lookupClass(node.getExpression(), node.getClassName(), classTargs);
                if (!ExpressionChecker.this.ts.isConcrete(t)) {
                    throw new ExecutionError("allocation.type", node);
                }
                Iterable<Object> args = IterUtil.empty();
                if (node.getArguments() != null) {
                    args = node.getArguments();
                    ExpressionChecker.this.checkList(args);
                }
                Iterable targs = IterUtil.empty();
                if (node instanceof PolymorphicInnerAllocation) {
                    targs = ExpressionChecker.this.checkTypeNameList(((PolymorphicInnerAllocation)node).getTypeArguments());
                }
                try {
                    TypeSystem.ConstructorInvocation inv = ExpressionChecker.this.ts.lookupConstructor(t, targs, args, this.expected);
                    this.checkThrownExceptions(inv.thrown(), node);
                    node.setArguments(CollectUtil.makeList(inv.args()));
                    NodeProperties.setConstructor(node, inv.constructor());
                    return NodeProperties.setType(node, t);
                }
                catch (TypeSystem.InvalidTypeArgumentException e) {
                    throw new ExecutionError("type.argument", node);
                }
                catch (TypeSystem.TypeSystemException e) {
                    NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.userRepresentation(t), this.nodeTypesString(args));
                    throw new ExecutionError("no.such.constructor", node);
                }
            }
            catch (TypeSystem.InvalidTypeArgumentException e) {
                throw new ExecutionError("type.argument", node);
            }
            catch (TypeSystem.TypeSystemException e) {
                NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.userRepresentation(enclosing), node.getClassName());
                throw new ExecutionError("no.such.inner.class", node);
            }
        }

        @Override
        public Type visit(AnonymousInnerAllocation node) {
            Type enclosing = ExpressionChecker.this.check(node.getExpression());
            Iterable classTargs = IterUtil.empty();
            if (node.getClassTypeArguments() != null) {
                classTargs = ExpressionChecker.this.checkTypeNameList(node.getClassTypeArguments());
            }
            try {
                ClassType t = ExpressionChecker.this.ts.lookupClass(node.getExpression(), node.getClassName(), classTargs);
                if (!ExpressionChecker.this.ts.isExtendable(t)) {
                    throw new ExecutionError("allocation.type", node);
                }
                NodeProperties.setSuperType(node, t);
                Iterable<Object> args = IterUtil.empty();
                if (node.getArguments() != null) {
                    args = node.getArguments();
                    ExpressionChecker.this.checkList(args);
                }
                Iterable targs = IterUtil.empty();
                if (node instanceof PolymorphicAnonymousInnerAllocation) {
                    targs = ExpressionChecker.this.checkTypeNameList(((PolymorphicAnonymousInnerAllocation)node).getTypeArguments());
                }
                try {
                    TypeSystem.ConstructorInvocation inv = ExpressionChecker.this.ts.lookupConstructor(t, targs, args, this.expected);
                    this.checkThrownExceptions(inv.thrown(), node);
                    node.setArguments(CollectUtil.makeList(inv.args()));
                }
                catch (TypeSystem.InvalidTypeArgumentException e) {
                    throw new ExecutionError("type.argument", node);
                }
                catch (TypeSystem.TypeSystemException e) {
                    NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.userRepresentation(t), this.nodeTypesString(args));
                    throw new ExecutionError("no.such.constructor", node);
                }
            }
            catch (TypeSystem.InvalidTypeArgumentException e) {
                throw new ExecutionError("type.argument", node);
            }
            catch (TypeSystem.TypeSystemException e) {
                NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.userRepresentation(enclosing), node.getClassName());
                throw new ExecutionError("no.such.inner.class", node);
            }
            TreeClass c = new TreeClass(ExpressionChecker.this.context.makeAnonymousClassName(), null, node, new TreeClassLoader(ExpressionChecker.this.context.getClassLoader(), ExpressionChecker.this.opt), ExpressionChecker.this.opt);
            NodeProperties.setDJClass(node, c);
            new ClassMemberChecker(new ClassContext(ExpressionChecker.this.context, c), ExpressionChecker.this.opt).checkClassMembers(node.getMembers());
            NodeProperties.setConstructor(node, IterUtil.first(c.declaredConstructors()));
            return NodeProperties.setType(node, ExpressionChecker.this.ts.makeClassType(c));
        }

        @Override
        public Type visit(ConstructorCall node) {
            if (node.getExpression() != null) {
                throw new ExecutionError("not.implemented", node);
            }
            Iterable<Object> args = IterUtil.empty();
            if (node.getArguments() != null) {
                args = node.getArguments();
                ExpressionChecker.this.checkList(args);
            }
            EmptyIterable targs = IterUtil.empty();
            Type result = node.isSuper() ? ExpressionChecker.this.context.getSuperType(ExpressionChecker.this.ts) : SymbolUtil.thisType(ExpressionChecker.this.context.getThis());
            if (result == null) {
                throw new IllegalArgumentException("Can't check a ConstructorCall in this context");
            }
            try {
                TypeSystem.ConstructorInvocation inv = ExpressionChecker.this.ts.lookupConstructor(result, targs, args, this.expected);
                this.checkThrownExceptions(inv.thrown(), node);
                node.setArguments(CollectUtil.makeList(inv.args()));
                NodeProperties.setConstructor(node, inv.constructor());
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.InvalidTypeArgumentException e) {
                throw new ExecutionError("type.argument", node);
            }
            catch (TypeSystem.TypeSystemException e) {
                NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.userRepresentation(result), this.nodeTypesString(args));
                throw new ExecutionError("no.such.constructor", node);
            }
        }

        private void checkThrownExceptions(Iterable<? extends Type> thrownTypes, Node node) {
            ComposedIterable<Type> allowed = IterUtil.compose(TypeSystem.RUNTIME_EXCEPTION, ExpressionChecker.this.context.getDeclaredThrownTypes());
            for (Type type : thrownTypes) {
                if (!ExpressionChecker.this.ts.isAssignable(TypeSystem.EXCEPTION, type)) continue;
                boolean valid = false;
                for (Type t : allowed) {
                    if (!ExpressionChecker.this.ts.isAssignable(t, type)) continue;
                    valid = true;
                    break;
                }
                if (valid) continue;
                NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.userRepresentation(type));
                throw new ExecutionError("uncaught.exception", node);
            }
        }

        @Override
        public Type visit(ArrayAccess node) {
            Type arrayType = ExpressionChecker.this.check(node.getExpression());
            if (!ExpressionChecker.this.ts.isArray(arrayType)) {
                NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.userRepresentation(arrayType));
                throw new ExecutionError("array.required", node);
            }
            Type elementType = ExpressionChecker.this.ts.arrayElementType(arrayType);
            ExpressionChecker.this.check(node.getCellNumber(), TypeSystem.INT);
            try {
                Expression cell = ExpressionChecker.this.ts.unaryPromote(ExpressionChecker.this.ts.makePrimitive(node.getCellNumber()));
                if (!(NodeProperties.getType(cell) instanceof IntType)) {
                    throw new ExecutionError("array.index.type", node);
                }
                node.setCellNumber(cell);
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("array.index.type", node);
            }
            NodeProperties.setVariableType(node, elementType);
            return NodeProperties.setType(node, ExpressionChecker.this.ts.capture(elementType));
        }

        @Override
        public Type visit(TypeExpression node) {
            Type t = ExpressionChecker.this.checkTypeName(node.getType());
            NodeProperties.setErasedType(node.getType(), ExpressionChecker.this.ts.erasedClass(t));
            Type targ = t;
            if (ExpressionChecker.this.ts.isEqual(t, TypeSystem.VOID)) {
                targ = TypeSystem.VOID_CLASS;
            } else if (!ExpressionChecker.this.ts.isReference(t)) {
                Expression pseudoExp = TypeUtil.makeEmptyExpression(node.getType());
                NodeProperties.setType(pseudoExp, t);
                try {
                    Expression boxedPseudoExp = ExpressionChecker.this.ts.makeReference(pseudoExp);
                    targ = NodeProperties.getType(boxedPseudoExp);
                }
                catch (TypeSystem.UnsupportedConversionException e) {
                    throw new ExecutionError("reference.type", node);
                }
            }
            return NodeProperties.setType(node, ExpressionChecker.this.ts.reflectionClassOf(targ));
        }

        @Override
        public Type visit(NotExpression node) {
            ExpressionChecker.this.check(node.getExpression(), TypeSystem.BOOLEAN);
            try {
                Expression exp = ExpressionChecker.this.ts.makePrimitive(node.getExpression());
                if (!(NodeProperties.getType(exp) instanceof BooleanType)) {
                    throw new ExecutionError("not.expression.type", node);
                }
                node.setExpression(exp);
                return NodeProperties.setType(node, NodeProperties.getType(exp));
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("not.expression.type", node);
            }
        }

        @Override
        public Type visit(ComplementExpression node) {
            ExpressionChecker.this.check(node.getExpression());
            try {
                Expression exp = ExpressionChecker.this.ts.unaryPromote(ExpressionChecker.this.ts.makePrimitive(node.getExpression()));
                if (!(NodeProperties.getType(exp) instanceof IntegralType)) {
                    throw new ExecutionError("complement.expression.type", node);
                }
                node.setExpression(exp);
                return NodeProperties.setType(node, NodeProperties.getType(exp));
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("complement.expression.type", node);
            }
        }

        @Override
        public Type visit(PlusExpression node) {
            return this.handleNumericUnaryExpression(node);
        }

        @Override
        public Type visit(MinusExpression node) {
            return this.handleNumericUnaryExpression(node);
        }

        private Type handleNumericUnaryExpression(UnaryExpression node) {
            ExpressionChecker.this.check(node.getExpression());
            try {
                Expression exp = ExpressionChecker.this.ts.unaryPromote(ExpressionChecker.this.ts.makePrimitive(node.getExpression()));
                node.setExpression(exp);
                return NodeProperties.setType(node, NodeProperties.getType(exp));
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("numeric.expression.type", node);
            }
        }

        @Override
        public Type visit(AddExpression node) {
            Type leftT = ExpressionChecker.this.check(node.getLeftExpression());
            Type rightT = ExpressionChecker.this.check(node.getRightExpression());
            if (ExpressionChecker.this.ts.isSubtype(leftT, TypeSystem.STRING) || ExpressionChecker.this.ts.isSubtype(rightT, TypeSystem.STRING)) {
                try {
                    Expression left = ExpressionChecker.this.ts.makeReference(node.getLeftExpression());
                    Expression right = ExpressionChecker.this.ts.makeReference(node.getRightExpression());
                    node.setLeftExpression(left);
                    node.setRightExpression(right);
                    NodeProperties.setOperation(node, ExpressionEvaluator.CONCATENATE);
                    return NodeProperties.setType(node, TypeSystem.STRING);
                }
                catch (TypeSystem.UnsupportedConversionException e) {
                    throw new ExecutionError("addition.type", node);
                }
            }
            try {
                Expression left = ExpressionChecker.this.ts.makePrimitive(node.getLeftExpression());
                Expression right = ExpressionChecker.this.ts.makePrimitive(node.getRightExpression());
                Pair<Expression, Expression> promoted = ExpressionChecker.this.ts.binaryPromote(left, right);
                node.setLeftExpression(promoted.first());
                node.setRightExpression(promoted.second());
                NodeProperties.setOperation(node, ExpressionEvaluator.ADD);
                return NodeProperties.setType(node, NodeProperties.getType(promoted.first()));
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("addition.type", node);
            }
        }

        @Override
        public Type visit(AddAssignExpression node) {
            Type leftT = ExpressionChecker.this.check(node.getLeftExpression());
            Type rightT = ExpressionChecker.this.check(node.getRightExpression());
            if (ExpressionChecker.this.ts.isEqual(leftT, TypeSystem.STRING)) {
                try {
                    Expression right = ExpressionChecker.this.ts.makeReference(node.getRightExpression());
                    node.setRightExpression(right);
                    NodeProperties.setOperation(node, ExpressionEvaluator.CONCATENATE);
                }
                catch (TypeSystem.UnsupportedConversionException e) {
                    throw new ExecutionError("addition.type", node);
                }
            }
            if (ExpressionChecker.this.ts.isSubtype(leftT, TypeSystem.STRING) || ExpressionChecker.this.ts.isSubtype(rightT, TypeSystem.STRING)) {
                throw new ExecutionError("addition.type", node);
            }
            try {
                Expression left = ExpressionChecker.this.ts.makePrimitive(node.getLeftExpression());
                Expression right = ExpressionChecker.this.ts.makePrimitive(node.getRightExpression());
                Pair<Expression, Expression> promoted = ExpressionChecker.this.ts.binaryPromote(left, right);
                NodeProperties.setLeftExpression(node, promoted.first());
                node.setRightExpression(promoted.second());
                NodeProperties.setOperation(node, ExpressionEvaluator.ADD);
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("addition.type", node);
            }
            if (!NodeProperties.hasVariableType(node.getLeftExpression())) {
                throw new ExecutionError("addition.type", node);
            }
            return NodeProperties.setType(node, leftT);
        }

        @Override
        public Type visit(SubtractExpression node) {
            return this.handleNumericExpression(node);
        }

        @Override
        public Type visit(MultiplyExpression node) {
            return this.handleNumericExpression(node);
        }

        @Override
        public Type visit(DivideExpression node) {
            return this.handleNumericExpression(node);
        }

        @Override
        public Type visit(RemainderExpression node) {
            return this.handleNumericExpression(node);
        }

        private Type handleNumericExpression(BinaryExpression node) {
            ExpressionChecker.this.check(node.getLeftExpression());
            ExpressionChecker.this.check(node.getRightExpression());
            try {
                Expression left = ExpressionChecker.this.ts.makePrimitive(node.getLeftExpression());
                Expression right = ExpressionChecker.this.ts.makePrimitive(node.getRightExpression());
                Pair<Expression, Expression> promoted = ExpressionChecker.this.ts.binaryPromote(left, right);
                node.setLeftExpression(promoted.first());
                node.setRightExpression(promoted.second());
                return NodeProperties.setType(node, NodeProperties.getType(promoted.first()));
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("numeric.expression.type", node);
            }
        }

        @Override
        public Type visit(SubtractAssignExpression node) {
            return this.handleNumericAssignmentExpression(node);
        }

        @Override
        public Type visit(MultiplyAssignExpression node) {
            return this.handleNumericAssignmentExpression(node);
        }

        @Override
        public Type visit(DivideAssignExpression node) {
            return this.handleNumericAssignmentExpression(node);
        }

        @Override
        public Type visit(RemainderAssignExpression node) {
            return this.handleNumericAssignmentExpression(node);
        }

        private Type handleNumericAssignmentExpression(BinaryExpression node) {
            Type result = ExpressionChecker.this.check(node.getLeftExpression());
            ExpressionChecker.this.check(node.getRightExpression());
            try {
                Expression left = ExpressionChecker.this.ts.makePrimitive(node.getLeftExpression());
                Expression right = ExpressionChecker.this.ts.makePrimitive(node.getRightExpression());
                Pair<Expression, Expression> promoted = ExpressionChecker.this.ts.binaryPromote(left, right);
                if (!NodeProperties.hasVariableType(node.getLeftExpression())) {
                    throw new ExecutionError("numeric.expression.type", node);
                }
                NodeProperties.setLeftExpression(node, promoted.first());
                node.setRightExpression(promoted.second());
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("numeric.expression.type", node);
            }
        }

        @Override
        public Type visit(EqualExpression node) {
            return this.handleEqualityExpression(node, ExpressionEvaluator.OBJECT_EQUAL, ExpressionEvaluator.PRIMITIVE_EQUAL);
        }

        @Override
        public Type visit(NotEqualExpression node) {
            return this.handleEqualityExpression(node, ExpressionEvaluator.OBJECT_NOT_EQUAL, ExpressionEvaluator.PRIMITIVE_NOT_EQUAL);
        }

        private Type handleEqualityExpression(BinaryExpression node, Lambda2<Object, Object, Object> objectCase, Lambda2<Object, Object, Object> primitiveCase) {
            Type leftT = ExpressionChecker.this.check(node.getLeftExpression());
            Type rightT = ExpressionChecker.this.check(node.getRightExpression());
            if (ExpressionChecker.this.ts.isReference(leftT) && ExpressionChecker.this.ts.isReference(rightT)) {
                if (!ExpressionChecker.this.ts.isCastable(leftT, rightT) && !ExpressionChecker.this.ts.isCastable(rightT, leftT)) {
                    throw new ExecutionError("compare.type", node);
                }
                NodeProperties.setOperation(node, objectCase);
            } else {
                try {
                    Expression left = ExpressionChecker.this.ts.makePrimitive(node.getLeftExpression());
                    Expression right = ExpressionChecker.this.ts.makePrimitive(node.getRightExpression());
                    if (NodeProperties.getType(left) instanceof BooleanType && NodeProperties.getType(right) instanceof BooleanType) {
                        node.setLeftExpression(left);
                        node.setRightExpression(right);
                    } else if (NodeProperties.getType(left) instanceof NumericType && NodeProperties.getType(right) instanceof NumericType) {
                        Pair<Expression, Expression> promoted = ExpressionChecker.this.ts.binaryPromote(left, right);
                        left = promoted.first();
                        right = promoted.second();
                        node.setLeftExpression(promoted.first());
                        node.setRightExpression(promoted.second());
                    } else {
                        throw new ExecutionError("compare.type", node);
                    }
                    NodeProperties.setOperation(node, primitiveCase);
                }
                catch (TypeSystem.UnsupportedConversionException e) {
                    throw new ExecutionError("compare.type", node);
                }
            }
            return NodeProperties.setType(node, TypeSystem.BOOLEAN);
        }

        @Override
        public Type visit(LessExpression node) {
            return this.handleRelationalExpression(node);
        }

        @Override
        public Type visit(LessOrEqualExpression node) {
            return this.handleRelationalExpression(node);
        }

        @Override
        public Type visit(GreaterExpression node) {
            return this.handleRelationalExpression(node);
        }

        @Override
        public Type visit(GreaterOrEqualExpression node) {
            return this.handleRelationalExpression(node);
        }

        private Type handleRelationalExpression(BinaryExpression node) {
            ExpressionChecker.this.check(node.getLeftExpression());
            ExpressionChecker.this.check(node.getRightExpression());
            try {
                Expression left = ExpressionChecker.this.ts.makePrimitive(node.getLeftExpression());
                Expression right = ExpressionChecker.this.ts.makePrimitive(node.getRightExpression());
                Pair<Expression, Expression> promoted = ExpressionChecker.this.ts.binaryPromote(left, right);
                node.setLeftExpression(promoted.first());
                node.setRightExpression(promoted.second());
                return NodeProperties.setType(node, TypeSystem.BOOLEAN);
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("compare.type", node);
            }
        }

        @Override
        public Type visit(BitAndExpression node) {
            return this.handleBitwiseExpression(node);
        }

        @Override
        public Type visit(BitOrExpression node) {
            return this.handleBitwiseExpression(node);
        }

        @Override
        public Type visit(ExclusiveOrExpression node) {
            return this.handleBitwiseExpression(node);
        }

        private Type handleBitwiseExpression(BinaryExpression node) {
            ExpressionChecker.this.check(node.getLeftExpression());
            ExpressionChecker.this.check(node.getRightExpression());
            try {
                Expression left = ExpressionChecker.this.ts.makePrimitive(node.getLeftExpression());
                Expression right = ExpressionChecker.this.ts.makePrimitive(node.getRightExpression());
                if (!(NodeProperties.getType(left) instanceof BooleanType) || !(NodeProperties.getType(right) instanceof BooleanType)) {
                    if (NodeProperties.getType(left) instanceof IntegralType && NodeProperties.getType(right) instanceof IntegralType) {
                        Pair<Expression, Expression> promoted = ExpressionChecker.this.ts.binaryPromote(left, right);
                        left = promoted.first();
                        right = promoted.second();
                    } else {
                        throw new ExecutionError("bitwise.expression.type", node);
                    }
                }
                node.setLeftExpression(left);
                node.setRightExpression(right);
                return NodeProperties.setType(node, NodeProperties.getType(left));
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("bitwise.expression.type", node);
            }
        }

        @Override
        public Type visit(BitAndAssignExpression node) {
            return this.handleBitwiseAssignmentExpression(node);
        }

        @Override
        public Type visit(BitOrAssignExpression node) {
            return this.handleBitwiseAssignmentExpression(node);
        }

        @Override
        public Type visit(ExclusiveOrAssignExpression node) {
            return this.handleBitwiseAssignmentExpression(node);
        }

        private Type handleBitwiseAssignmentExpression(BinaryExpression node) {
            Type result = ExpressionChecker.this.check(node.getLeftExpression());
            ExpressionChecker.this.check(node.getRightExpression());
            try {
                Expression left = ExpressionChecker.this.ts.makePrimitive(node.getLeftExpression());
                Expression right = ExpressionChecker.this.ts.makePrimitive(node.getRightExpression());
                if (!(NodeProperties.getType(left) instanceof BooleanType) || !(NodeProperties.getType(right) instanceof BooleanType)) {
                    if (NodeProperties.getType(left) instanceof IntegralType && NodeProperties.getType(right) instanceof IntegralType) {
                        Pair<Expression, Expression> promoted = ExpressionChecker.this.ts.binaryPromote(left, right);
                        left = promoted.first();
                        right = promoted.second();
                    } else {
                        throw new ExecutionError("bitwise.expression.type", node);
                    }
                }
                if (!NodeProperties.hasVariableType(node.getLeftExpression())) {
                    throw new ExecutionError("bitwise.expression.type", node);
                }
                NodeProperties.setLeftExpression(node, left);
                node.setRightExpression(right);
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("bitwise.expression.type", node);
            }
        }

        @Override
        public Type visit(ShiftLeftExpression node) {
            return this.handleShiftExpression(node);
        }

        @Override
        public Type visit(ShiftRightExpression node) {
            return this.handleShiftExpression(node);
        }

        @Override
        public Type visit(UnsignedShiftRightExpression node) {
            return this.handleShiftExpression(node);
        }

        private Type handleShiftExpression(BinaryExpression node) {
            ExpressionChecker.this.check(node.getLeftExpression());
            ExpressionChecker.this.check(node.getRightExpression());
            try {
                Expression left = ExpressionChecker.this.ts.unaryPromote(ExpressionChecker.this.ts.makePrimitive(node.getLeftExpression()));
                Expression right = ExpressionChecker.this.ts.unaryPromote(ExpressionChecker.this.ts.makePrimitive(node.getRightExpression()));
                node.setLeftExpression(left);
                node.setRightExpression(right);
                if (!(NodeProperties.getType(left) instanceof IntegralType) || !(NodeProperties.getType(right) instanceof IntegralType)) {
                    throw new ExecutionError("shift.expression.type", node);
                }
                return NodeProperties.setType(node, NodeProperties.getType(left));
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("shift.expression.type", node);
            }
        }

        @Override
        public Type visit(ShiftLeftAssignExpression node) {
            return this.handleShiftAssignmentExpression(node);
        }

        @Override
        public Type visit(ShiftRightAssignExpression node) {
            return this.handleShiftAssignmentExpression(node);
        }

        @Override
        public Type visit(UnsignedShiftRightAssignExpression node) {
            return this.handleShiftAssignmentExpression(node);
        }

        private Type handleShiftAssignmentExpression(BinaryExpression node) {
            Type result = ExpressionChecker.this.check(node.getLeftExpression());
            ExpressionChecker.this.check(node.getRightExpression());
            try {
                Expression left = ExpressionChecker.this.ts.unaryPromote(ExpressionChecker.this.ts.makePrimitive(node.getLeftExpression()));
                Expression right = ExpressionChecker.this.ts.unaryPromote(ExpressionChecker.this.ts.makePrimitive(node.getRightExpression()));
                if (!(NodeProperties.getType(left) instanceof IntegralType && NodeProperties.getType(right) instanceof IntegralType && NodeProperties.hasVariableType(node.getLeftExpression()))) {
                    throw new ExecutionError("shift.expression.type", node);
                }
                NodeProperties.setLeftExpression(node, left);
                node.setRightExpression(right);
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("shift.expression.type", node);
            }
        }

        @Override
        public Type visit(AndExpression node) {
            return this.handleBooleanExpression(node);
        }

        @Override
        public Type visit(OrExpression node) {
            return this.handleBooleanExpression(node);
        }

        private Type handleBooleanExpression(BinaryExpression node) {
            ExpressionChecker.this.check(node.getLeftExpression(), TypeSystem.BOOLEAN);
            ExpressionChecker.this.check(node.getRightExpression(), TypeSystem.BOOLEAN);
            try {
                Expression left = ExpressionChecker.this.ts.makePrimitive(node.getLeftExpression());
                Expression right = ExpressionChecker.this.ts.makePrimitive(node.getRightExpression());
                if (!(NodeProperties.getType(left) instanceof BooleanType) || !(NodeProperties.getType(right) instanceof BooleanType)) {
                    throw new ExecutionError("boolean.expression.type", node);
                }
                node.setLeftExpression(left);
                node.setRightExpression(right);
                return NodeProperties.setType(node, TypeSystem.BOOLEAN);
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("boolean.expression.type", node);
            }
        }

        @Override
        public Type visit(InstanceOfExpression node) {
            Type expT = ExpressionChecker.this.check(node.getExpression());
            Type targetT = ExpressionChecker.this.checkTypeName(node.getReferenceType());
            if (!(ExpressionChecker.this.ts.isReference(expT) && ExpressionChecker.this.ts.isReference(targetT) && ExpressionChecker.this.ts.isCastable(targetT, expT))) {
                throw new ExecutionError("instanceof.type", node);
            }
            if (!ExpressionChecker.this.ts.isReifiable(targetT)) {
                throw new ExecutionError("reifiable.type", node);
            }
            NodeProperties.setErasedType(node.getReferenceType(), ExpressionChecker.this.ts.erasedClass(targetT));
            return NodeProperties.setType(node, TypeSystem.BOOLEAN);
        }

        @Override
        public Type visit(ConditionalExpression node) {
            ExpressionChecker.this.check(node.getConditionExpression(), TypeSystem.BOOLEAN);
            ExpressionChecker.this.check(node.getIfTrueExpression(), this.expected);
            ExpressionChecker.this.check(node.getIfFalseExpression(), this.expected);
            try {
                Expression cond = ExpressionChecker.this.ts.makePrimitive(node.getConditionExpression());
                if (!(NodeProperties.getType(cond) instanceof BooleanType)) {
                    throw new ExecutionError("condition.type", node);
                }
                node.setConditionExpression(cond);
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("condition.type", node);
            }
            try {
                Pair<Expression, Expression> joined = ExpressionChecker.this.ts.join(node.getIfTrueExpression(), node.getIfFalseExpression());
                node.setIfTrueExpression(joined.first());
                node.setIfFalseExpression(joined.second());
                return NodeProperties.setType(node, ExpressionChecker.this.ts.capture(NodeProperties.getType(joined.first())));
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("conditional.type", node);
            }
        }

        @Override
        public Type visit(SimpleAssignExpression node) {
            Expression left = node.getLeftExpression();
            Type result = ExpressionChecker.this.check(left);
            if (!NodeProperties.hasVariableType(left)) {
                throw new ExecutionError("left.expression", node);
            }
            if (NodeProperties.hasVariable(left) && NodeProperties.getVariable(left).isFinal() || NodeProperties.hasField(left) && NodeProperties.getField(left).isFinal()) {
                throw new ExecutionError("cannot.modify", node);
            }
            Type target = NodeProperties.getVariableType(left);
            Type rightT = ExpressionChecker.this.check(node.getRightExpression(), target);
            try {
                Expression newRight = ExpressionChecker.this.ts.assign(target, node.getRightExpression());
                node.setRightExpression(newRight);
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.userRepresentation(rightT), ExpressionChecker.this.ts.userRepresentation(target));
                throw new ExecutionError("assignment.types", node);
            }
        }

        @Override
        public Type visit(PostIncrement node) {
            return this.handleIncrementExpression(node);
        }

        @Override
        public Type visit(PreIncrement node) {
            return this.handleIncrementExpression(node);
        }

        @Override
        public Type visit(PostDecrement node) {
            return this.handleIncrementExpression(node);
        }

        @Override
        public Type visit(PreDecrement node) {
            return this.handleIncrementExpression(node);
        }

        private Type handleIncrementExpression(UnaryExpression node) {
            Type result = ExpressionChecker.this.check(node.getExpression());
            try {
                Expression exp = ExpressionChecker.this.ts.makePrimitive(node.getExpression());
                if (!(NodeProperties.getType(exp) instanceof NumericType) || !NodeProperties.hasVariableType(node.getExpression())) {
                    throw new ExecutionError("increment.type", node);
                }
                NodeProperties.setLeftExpression(node, exp);
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("increment.type", node);
            }
        }

        @Override
        public Type visit(CastExpression node) {
            Type t = ExpressionChecker.this.checkTypeName(node.getTargetType());
            Type fromT = ExpressionChecker.this.check(node.getExpression());
            try {
                Expression exp = ExpressionChecker.this.ts.cast(t, node.getExpression());
                node.setExpression(exp);
                return NodeProperties.setType(node, ExpressionChecker.this.ts.capture(t));
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.userRepresentation(fromT), ExpressionChecker.this.ts.userRepresentation(t));
                throw new ExecutionError("cast.types", node);
            }
        }
    }
}

