/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import edu.rice.cs.dynamicjava.interpreter.DelegatingContext;
import edu.rice.cs.dynamicjava.interpreter.TypeContext;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.DJMethod;
import edu.rice.cs.dynamicjava.symbol.Function;
import edu.rice.cs.dynamicjava.symbol.LocalFunction;
import edu.rice.cs.dynamicjava.symbol.LocalVariable;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.plt.iter.IterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionContext
extends DelegatingContext {
    private Function _f;

    public FunctionContext(TypeContext next, Function f) {
        super(next);
        this._f = f;
    }

    @Override
    protected FunctionContext duplicate(TypeContext next) {
        return new FunctionContext(next, this._f);
    }

    @Override
    public boolean variableExists(String name, TypeSystem ts) {
        return this.getParameter(name) != null || super.variableExists(name, ts);
    }

    @Override
    public boolean localVariableExists(String name, TypeSystem ts) {
        return this.getParameter(name) != null || super.localVariableExists(name, ts);
    }

    @Override
    public LocalVariable getLocalVariable(String name, TypeSystem ts) {
        LocalVariable result = this.getParameter(name);
        return result == null ? super.getLocalVariable(name, ts) : result;
    }

    private LocalVariable getParameter(String name) {
        for (LocalVariable v : this._f.declaredParameters()) {
            if (!v.declaredName().equals(name)) continue;
            return v;
        }
        return null;
    }

    @Override
    public boolean functionExists(String name, TypeSystem ts) {
        return this.isLocalFunction(name) || super.functionExists(name, ts);
    }

    @Override
    public boolean localFunctionExists(String name, TypeSystem ts) {
        return this.isLocalFunction(name) || super.localFunctionExists(name, ts);
    }

    @Override
    public Iterable<LocalFunction> getLocalFunctions(String name, TypeSystem ts, Iterable<LocalFunction> partial) {
        if (IterUtil.isEmpty(partial)) {
            if (this.isLocalFunction(name)) {
                partial = IterUtil.singleton((LocalFunction)this._f);
            }
            return super.getLocalFunctions(name, ts, partial);
        }
        return partial;
    }

    private boolean isLocalFunction(String name) {
        return this._f instanceof LocalFunction && ((LocalFunction)this._f).declaredName().equals(name);
    }

    @Override
    public String makeClassName(String n) {
        return super.makeAnonymousClassName() + n;
    }

    @Override
    public DJClass getThis() {
        if (this.isStatic()) {
            return null;
        }
        return super.getThis();
    }

    @Override
    public DJClass getThis(String className) {
        if (this.isStatic()) {
            return null;
        }
        return super.getThis(className);
    }

    @Override
    public Type getSuperType(TypeSystem ts) {
        if (this.isStatic()) {
            return null;
        }
        return super.getSuperType(ts);
    }

    @Override
    public Type getReturnType() {
        if (this._f instanceof LocalFunction) {
            return ((LocalFunction)this._f).returnType();
        }
        if (this._f instanceof DJMethod) {
            return ((DJMethod)this._f).returnType();
        }
        return null;
    }

    @Override
    public Iterable<Type> getDeclaredThrownTypes() {
        return this._f.thrownTypes();
    }

    private boolean isStatic() {
        return this._f instanceof DJMethod && ((DJMethod)this._f).isStatic();
    }
}

