/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import edu.rice.cs.dynamicjava.interpreter.AmbiguousNameException;
import edu.rice.cs.dynamicjava.interpreter.TypeContext;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.LocalFunction;
import edu.rice.cs.dynamicjava.symbol.LocalVariable;
import edu.rice.cs.dynamicjava.symbol.SymbolUtil;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.dynamicjava.symbol.type.ClassType;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.dynamicjava.symbol.type.VariableType;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SequenceIterator;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.text.TextUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopLevelContext
implements TypeContext {
    private final ClassLoader _loader;
    private final String _currentPackage;
    private final Iterator<Integer> _anonymousCounter;
    private final HashSet<String> _onDemandPackages;
    private final HashSet<DJClass> _onDemandClasses;
    private final HashSet<DJClass> _staticOnDemandClasses;
    private final HashMap<String, DJClass> _importedTopLevelClasses;
    private final HashMap<String, DJClass> _importedMemberClasses;
    private final HashMap<String, DJClass> _importedFields;
    private final HashMap<String, DJClass> _importedMethods;

    public TopLevelContext(ClassLoader loader) {
        this._loader = loader;
        this._currentPackage = "";
        this._anonymousCounter = new SequenceIterator<Integer>(1, LambdaUtil.INCREMENT_INT);
        this._onDemandPackages = new HashSet();
        this._onDemandClasses = new HashSet();
        this._staticOnDemandClasses = new HashSet();
        this._importedTopLevelClasses = new HashMap();
        this._importedMemberClasses = new HashMap();
        this._importedFields = new HashMap();
        this._importedMethods = new HashMap();
        this._onDemandPackages.add("java.lang");
    }

    private TopLevelContext(TopLevelContext copy) {
        this(copy._loader, copy._currentPackage, copy);
    }

    private TopLevelContext(ClassLoader loader, String currentPackage, TopLevelContext bindings) {
        this._loader = loader;
        this._currentPackage = currentPackage;
        this._anonymousCounter = bindings._anonymousCounter;
        this._onDemandPackages = (HashSet)bindings._onDemandPackages.clone();
        this._onDemandClasses = (HashSet)bindings._onDemandClasses.clone();
        this._staticOnDemandClasses = (HashSet)bindings._staticOnDemandClasses.clone();
        this._importedTopLevelClasses = (HashMap)bindings._importedTopLevelClasses.clone();
        this._importedMemberClasses = (HashMap)bindings._importedMemberClasses.clone();
        this._importedFields = (HashMap)bindings._importedFields.clone();
        this._importedMethods = (HashMap)bindings._importedMethods.clone();
    }

    @Override
    public TypeContext setPackage(String name) {
        return new TopLevelContext(this._loader, name, this);
    }

    @Override
    public TypeContext importTopLevelClasses(String pkg) {
        TopLevelContext result = new TopLevelContext(this);
        result._onDemandPackages.add(pkg);
        return result;
    }

    @Override
    public TypeContext importMemberClasses(DJClass outer) {
        TopLevelContext result = new TopLevelContext(this);
        result._onDemandClasses.add(outer);
        return result;
    }

    @Override
    public TypeContext importStaticMembers(DJClass c) {
        TopLevelContext result = new TopLevelContext(this);
        result._staticOnDemandClasses.add(c);
        return result;
    }

    @Override
    public TypeContext importTopLevelClass(DJClass c) {
        TopLevelContext result = new TopLevelContext(this);
        String name = c.declaredName();
        result._importedMemberClasses.remove(name);
        result._importedTopLevelClasses.put(name, c);
        return result;
    }

    @Override
    public TypeContext importMemberClass(DJClass outer, String name) {
        TopLevelContext result = new TopLevelContext(this);
        result._importedTopLevelClasses.remove(name);
        result._importedMemberClasses.put(name, outer);
        return result;
    }

    @Override
    public TypeContext importField(DJClass c, String name) {
        TopLevelContext result = new TopLevelContext(this);
        result._importedFields.put(name, c);
        return result;
    }

    @Override
    public TypeContext importMethod(DJClass c, String name) {
        TopLevelContext result = new TopLevelContext(this);
        result._importedMethods.put(name, c);
        return result;
    }

    @Override
    public boolean typeExists(String name, TypeSystem ts) {
        return this.topLevelClassExists(name, ts) || this.memberClassExists(name, ts);
    }

    @Override
    public boolean topLevelClassExists(String name, TypeSystem ts) {
        try {
            return this.getTopLevelClass(name, ts) != null;
        }
        catch (AmbiguousNameException e) {
            return true;
        }
    }

    @Override
    public DJClass getTopLevelClass(String name, TypeSystem ts) throws AmbiguousNameException {
        if (TextUtil.contains(name, 46)) {
            try {
                return SymbolUtil.wrapClass(this._loader.loadClass(name));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            catch (LinkageError e) {
                return null;
            }
        }
        DJClass result = this._importedTopLevelClasses.get(name);
        if (result == null) {
            try {
                result = SymbolUtil.wrapClass(this._loader.loadClass(this.makeClassName(name)));
            }
            catch (ClassNotFoundException e) {
            }
            catch (LinkageError e) {
                // empty catch block
            }
            if (result == null) {
                LinkedList onDemandMatches = new LinkedList();
                for (String p : this._onDemandPackages) {
                    try {
                        onDemandMatches.add(this._loader.loadClass(p + "." + name));
                    }
                    catch (ClassNotFoundException e2) {
                    }
                    catch (LinkageError e) {}
                }
                if (onDemandMatches.size() > 1) {
                    throw new AmbiguousNameException();
                }
                if (onDemandMatches.size() == 1) {
                    result = SymbolUtil.wrapClass((Class)onDemandMatches.getFirst());
                }
            }
        }
        return result;
    }

    @Override
    public boolean memberClassExists(String name, TypeSystem ts) {
        try {
            return this.typeContainingMemberClass(name, ts) != null;
        }
        catch (AmbiguousNameException e) {
            return true;
        }
    }

    @Override
    public ClassType typeContainingMemberClass(String name, TypeSystem ts) throws AmbiguousNameException {
        ClassType result;
        DJClass explicitImport = this._importedMemberClasses.get(name);
        ClassType classType = result = explicitImport == null ? null : ts.makeClassType(explicitImport);
        if (result == null) {
            ClassType t;
            LinkedList<ClassType> onDemandMatches = new LinkedList<ClassType>();
            for (DJClass c : this._onDemandClasses) {
                t = ts.makeClassType(c);
                if (!ts.containsClass(t, name)) continue;
                onDemandMatches.add(t);
            }
            for (DJClass c : this._staticOnDemandClasses) {
                t = ts.makeClassType(c);
                if (!ts.containsStaticClass(t, name)) continue;
                onDemandMatches.add(t);
            }
            if (onDemandMatches.size() > 1) {
                throw new AmbiguousNameException();
            }
            if (onDemandMatches.size() == 1) {
                result = (ClassType)onDemandMatches.getFirst();
            }
        }
        return result;
    }

    @Override
    public boolean typeVariableExists(String name, TypeSystem ts) {
        return false;
    }

    @Override
    public VariableType getTypeVariable(String name, TypeSystem ts) {
        return null;
    }

    @Override
    public boolean variableExists(String name, TypeSystem ts) {
        return this.fieldExists(name, ts);
    }

    @Override
    public boolean fieldExists(String name, TypeSystem ts) {
        try {
            return this.typeContainingField(name, ts) != null;
        }
        catch (AmbiguousNameException e) {
            return true;
        }
    }

    @Override
    public ClassType typeContainingField(String name, TypeSystem ts) throws AmbiguousNameException {
        ClassType result;
        DJClass explicitImport = this._importedFields.get(name);
        ClassType classType = result = explicitImport == null ? null : ts.makeClassType(explicitImport);
        if (result == null) {
            LinkedList<ClassType> onDemandMatches = new LinkedList<ClassType>();
            for (DJClass c : this._staticOnDemandClasses) {
                ClassType t = ts.makeClassType(c);
                if (!ts.containsStaticField(t, name)) continue;
                onDemandMatches.add(t);
            }
            if (onDemandMatches.size() > 1) {
                throw new AmbiguousNameException();
            }
            if (onDemandMatches.size() == 1) {
                result = (ClassType)onDemandMatches.getFirst();
            }
        }
        return result;
    }

    @Override
    public boolean localVariableExists(String name, TypeSystem ts) {
        return false;
    }

    @Override
    public LocalVariable getLocalVariable(String name, TypeSystem ts) {
        return null;
    }

    @Override
    public boolean functionExists(String name, TypeSystem ts) {
        return this.methodExists(name, ts);
    }

    @Override
    public boolean methodExists(String name, TypeSystem ts) {
        try {
            return this.typeContainingMethod(name, ts) != null;
        }
        catch (AmbiguousNameException e) {
            return true;
        }
    }

    @Override
    public ClassType typeContainingMethod(String name, TypeSystem ts) throws AmbiguousNameException {
        ClassType result;
        DJClass explicitImport = this._importedMethods.get(name);
        ClassType classType = result = explicitImport == null ? null : ts.makeClassType(explicitImport);
        if (result == null) {
            LinkedList<ClassType> onDemandMatches = new LinkedList<ClassType>();
            for (DJClass c : this._staticOnDemandClasses) {
                ClassType t = ts.makeClassType(c);
                if (!ts.containsStaticMethod(t, name)) continue;
                onDemandMatches.add(t);
            }
            if (onDemandMatches.size() > 1) {
                throw new AmbiguousNameException();
            }
            if (onDemandMatches.size() == 1) {
                result = (ClassType)onDemandMatches.getFirst();
            }
        }
        return result;
    }

    @Override
    public boolean localFunctionExists(String name, TypeSystem ts) {
        return false;
    }

    @Override
    public Iterable<LocalFunction> getLocalFunctions(String name, TypeSystem ts) {
        return IterUtil.empty();
    }

    @Override
    public Iterable<LocalFunction> getLocalFunctions(String name, TypeSystem ts, Iterable<LocalFunction> partial) {
        return partial;
    }

    @Override
    public String getPackage() {
        return this._currentPackage;
    }

    @Override
    public String makeClassName(String n) {
        return this._currentPackage.equals("") ? n : this._currentPackage + "." + n;
    }

    @Override
    public String makeAnonymousClassName() {
        return this.makeClassName("$" + this._anonymousCounter.next().toString());
    }

    @Override
    public DJClass getThis() {
        return null;
    }

    @Override
    public DJClass getThis(String className) {
        return null;
    }

    @Override
    public Type getSuperType(TypeSystem ts) {
        return null;
    }

    @Override
    public Type getReturnType() {
        return null;
    }

    @Override
    public Iterable<Type> getDeclaredThrownTypes() {
        return IterUtil.singleton(TypeSystem.THROWABLE);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._loader;
    }
}

