/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.interpreter.RuntimeBindings;
import edu.rice.cs.dynamicjava.interpreter.TreeCompiler;
import edu.rice.cs.dynamicjava.symbol.TreeClass;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.reflect.ComposedClassLoader;
import edu.rice.cs.plt.reflect.ShadowingClassLoader;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeClassLoader
extends ClassLoader {
    private final Options _opt;
    private final Map<String, TreeClass> _registeredTrees;
    private final Map<String, TreeCompiler.EvaluationAdapter> _adapters;

    public TreeClassLoader(ClassLoader parent, Options opt) {
        this(parent, opt, new HashMap<String, TreeClass>());
    }

    private TreeClassLoader(ClassLoader parent, Options opt, Map<String, TreeClass> registeredTrees) {
        super(TreeClassLoader.makeParent(parent, registeredTrees.keySet()));
        this._opt = opt;
        this._registeredTrees = registeredTrees;
        this._adapters = new HashMap<String, TreeCompiler.EvaluationAdapter>();
    }

    private static ClassLoader makeParent(ClassLoader p, Iterable<String> registeredNames) {
        SizedIterable<String> includes = IterUtil.make(Object.class.getName(), String.class.getName(), RuntimeBindings.class.getName(), TreeClassLoader.class.getName(), TreeCompiler.EvaluationAdapter.class.getName(), TreeCompiler.BindingsFactory.class.getName());
        ShadowingClassLoader implementationLoader = new ShadowingClassLoader(TreeClassLoader.class.getClassLoader(), false, includes, true);
        ShadowingClassLoader parentLoader = new ShadowingClassLoader(p, true, registeredNames, true);
        return new ComposedClassLoader(implementationLoader, (ClassLoader)parentLoader);
    }

    public void registerTree(TreeClass treeClass) {
        this._registeredTrees.put(treeClass.fullName(), treeClass);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        TreeClass treeClass = this._registeredTrees.get(name);
        if (treeClass == null) {
            throw new ClassNotFoundException();
        }
        TreeCompiler compiler = new TreeCompiler(treeClass, this._opt);
        byte[] bytes = compiler.bytecode();
        this._adapters.put(name, compiler.evaluationAdapter());
        return this.defineClass(name, bytes, 0, bytes.length);
    }

    public TreeCompiler.EvaluationAdapter getAdapter(String className) {
        return this._adapters.get(className);
    }
}

