/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.symbol;

import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.interpreter.EvaluatorException;
import edu.rice.cs.dynamicjava.interpreter.RuntimeBindings;
import edu.rice.cs.dynamicjava.interpreter.StatementEvaluator;
import edu.rice.cs.dynamicjava.symbol.Function;
import edu.rice.cs.dynamicjava.symbol.LocalVariable;
import edu.rice.cs.dynamicjava.symbol.SymbolUtil;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.dynamicjava.symbol.type.VariableType;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.WrappedException;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.tiger.PolymorphicMethodDeclaration;
import koala.dynamicjava.tree.tiger.TypeParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFunction
implements Function {
    private MethodDeclaration _ast;

    public LocalFunction(MethodDeclaration ast) {
        this._ast = ast;
    }

    public String declaredName() {
        return this._ast.getName();
    }

    public Type returnType() {
        return NodeProperties.getType(this._ast.getReturnType());
    }

    @Override
    public Iterable<VariableType> declaredTypeParameters() {
        if (this._ast instanceof PolymorphicMethodDeclaration) {
            TypeParameter[] ps = ((PolymorphicMethodDeclaration)this._ast).getTypeParameters();
            return IterUtil.mapSnapshot(IterUtil.asIterable(ps), NodeProperties.NODE_TYPE_VARIABLE);
        }
        return IterUtil.empty();
    }

    @Override
    public Iterable<LocalVariable> declaredParameters() {
        return IterUtil.mapSnapshot(this._ast.getParameters(), NodeProperties.NODE_VARIABLE);
    }

    @Override
    public Iterable<Type> thrownTypes() {
        return IterUtil.mapSnapshot(this._ast.getExceptions(), NodeProperties.NODE_TYPE);
    }

    public Object evaluate(Iterable<Object> args, RuntimeBindings bindings, Options options) throws EvaluatorException {
        RuntimeBindings bodyBindings = new RuntimeBindings(bindings, this.declaredParameters(), args);
        try {
            this._ast.getBody().acceptVisitor(new StatementEvaluator(bodyBindings, options));
            return SymbolUtil.initialValue(NodeProperties.getErasedType(this._ast).value());
        }
        catch (StatementEvaluator.ReturnException e) {
            return e.value().unwrap(null);
        }
        catch (WrappedException e) {
            if (e.getCause() instanceof EvaluatorException) {
                throw (EvaluatorException)e.getCause();
            }
            throw e;
        }
    }
}

