/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.AdvancedVisitor;
import edu.rice.cs.javalanglevels.BodyBodyAdvancedVisitor;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.AbstractMethodDef;
import edu.rice.cs.javalanglevels.tree.ComplexAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.ConcreteMethodDef;
import edu.rice.cs.javalanglevels.tree.ConstructorDef;
import edu.rice.cs.javalanglevels.tree.InnerClassDef;
import edu.rice.cs.javalanglevels.tree.InnerInterfaceDef;
import edu.rice.cs.javalanglevels.tree.InstanceInitializer;
import edu.rice.cs.javalanglevels.tree.ModifiersAndVisibility;
import edu.rice.cs.javalanglevels.tree.SimpleAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.Statement;
import edu.rice.cs.javalanglevels.tree.TypeParameter;
import edu.rice.cs.javalanglevels.tree.UninitializedVariableDeclarator;
import edu.rice.cs.javalanglevels.tree.VariableDeclaration;
import java.io.File;
import java.util.Hashtable;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassBodyAdvancedVisitor
extends AdvancedVisitor {
    private SymbolData _symbolData;

    public ClassBodyAdvancedVisitor(SymbolData sd, File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, LinkedList<String> classDefsInThisFile, Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>> continuations) {
        super(file, packageName, importedFiles, importedPackages, classDefsInThisFile, continuations);
        this._symbolData = sd;
    }

    @Override
    public void forStatementDoFirst(Statement that) {
        ClassBodyAdvancedVisitor._addError("Statements cannot appear outside of method bodies", that);
    }

    @Override
    public void forConcreteMethodDefDoFirst(ConcreteMethodDef that) {
        ModifiersAndVisibility mav = that.getMav();
        String[] modifiers = mav.getModifiers();
        for (int i = 0; i < modifiers.length; ++i) {
            if (!modifiers[i].equals("abstract")) continue;
            ClassBodyAdvancedVisitor._addError("Methods that have a braced body cannot be declared \"abstract\"", that);
            break;
        }
    }

    @Override
    public void forAbstractMethodDefDoFirst(AbstractMethodDef that) {
        if (!this._symbolData.hasModifier("abstract")) {
            ClassBodyAdvancedVisitor._addError("Abstract methods can only be declared in abstract classes", that);
        }
        ModifiersAndVisibility mav = that.getMav();
        String[] modifiers = mav.getModifiers();
        super.forAbstractMethodDefDoFirst(that);
    }

    @Override
    public void forInstanceInitializerDoFirst(InstanceInitializer that) {
        ClassBodyAdvancedVisitor._addError("This open brace must mark the beginning of a method or class body", that);
    }

    @Override
    public void forVariableDeclarationOnly(VariableDeclaration that) {
        VariableData[] vds = this._variableDeclaration2VariableData(that, this._symbolData);
        LinkedList<VariableData> vdsList = new LinkedList<VariableData>();
        for (int i = 0; i < vds.length; ++i) {
            if (vds[i].hasModifier("static") && that.getDeclarators()[i] instanceof UninitializedVariableDeclarator) {
                ClassBodyAdvancedVisitor._addAndIgnoreError("All static fields must be initialized", that);
            }
            if (vds[i].hasModifier("abstract")) {
                ClassBodyAdvancedVisitor._addAndIgnoreError("Fields cannot be abstract", that);
                continue;
            }
            vdsList.addLast(vds[i]);
        }
        if (!this._symbolData.addVars(vdsList.toArray(new VariableData[vdsList.size()]))) {
            ClassBodyAdvancedVisitor._addAndIgnoreError("You cannot have two fields with the same name.  Either you already have a field by that name in this class, or one of your superclasses or interfaces has a field by that name", that);
        }
    }

    @Override
    public void forConcreteMethodDef(ConcreteMethodDef that) {
        this.forConcreteMethodDefDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        MethodData md = this.createMethodData(that, this._symbolData);
        String className = ClassBodyAdvancedVisitor.getUnqualifiedClassName(this._symbolData.getName());
        if (className.equals(md.getName())) {
            ClassBodyAdvancedVisitor._addAndIgnoreError("Only constructors can have the same name as the class they appear in, and constructors do not have an explicit return type", that);
        } else {
            this._symbolData.addMethod(md);
        }
        that.getBody().visit(new BodyBodyAdvancedVisitor(md, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, this._classNamesInThisFile, (Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>)continuations));
    }

    @Override
    public void forAbstractMethodDef(AbstractMethodDef that) {
        this.forAbstractMethodDefDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        MethodData md = this.createMethodData(that, this._symbolData);
        String className = ClassBodyAdvancedVisitor.getUnqualifiedClassName(this._symbolData.getName());
        if (className.equals(md.getName())) {
            ClassBodyAdvancedVisitor._addAndIgnoreError("Only constructors can have the same name as the class they appear in, and constructors do not have an explicit return type", that);
        } else {
            this._symbolData.addMethod(md);
        }
    }

    @Override
    public void forInnerInterfaceDef(InnerInterfaceDef that) {
        this.handleInnerInterfaceDef(that, this._symbolData, this.getQualifiedClassName(this._symbolData.getName()) + "$" + that.getName().getText());
    }

    @Override
    public void forInnerClassDef(InnerClassDef that) {
        this.handleInnerClassDef(that, this._symbolData, this.getQualifiedClassName(this._symbolData.getName()) + "$" + that.getName().getText());
    }

    @Override
    public void forConstructorDef(ConstructorDef that) {
        this.forConstructorDefDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        that.getMav().visit(this);
        String name = ClassBodyAdvancedVisitor.getUnqualifiedClassName(that.getName().getText());
        if (that.getName().getText().indexOf(".") != -1 && !that.getName().getText().equals(this._symbolData.getName()) || !name.equals(ClassBodyAdvancedVisitor.getUnqualifiedClassName(this._symbolData.getName()))) {
            ClassBodyAdvancedVisitor._addAndIgnoreError("The constructor return type and class name must match", that);
        }
        String[] throwStrings = this.referenceType2String(that.getThrows());
        SymbolData returnType = this._symbolData;
        MethodData md = new MethodData(name, that.getMav(), new TypeParameter[0], returnType, new VariableData[0], throwStrings, this._symbolData, that);
        ClassBodyAdvancedVisitor._checkError();
        VariableData[] vds = this.formalParameters2VariableData(that.getParameters(), md);
        if (!ClassBodyAdvancedVisitor._checkError()) {
            md.setParams(vds);
            if (!md.addFinalVars(vds)) {
                ClassBodyAdvancedVisitor._addAndIgnoreError("You cannot have two method parameters with the same name", that);
            }
        }
        this._symbolData.addMethod(md);
        that.getStatements().visit(new BodyBodyAdvancedVisitor(md, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, this._classNamesInThisFile, (Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>)continuations));
        this._symbolData.incrementConstructorCount();
    }

    @Override
    public void forComplexAnonymousClassInstantiation(ComplexAnonymousClassInstantiation that) {
        this.complexAnonymousClassInstantiationHelper(that, this._symbolData);
    }

    @Override
    public void forSimpleAnonymousClassInstantiation(SimpleAnonymousClassInstantiation that) {
        this.simpleAnonymousClassInstantiationHelper(that, this._symbolData);
    }

    static /* synthetic */ SymbolData access$000(ClassBodyAdvancedVisitor x0) {
        return x0._symbolData;
    }

    static /* synthetic */ SymbolData access$002(ClassBodyAdvancedVisitor x0, SymbolData x1) {
        x0._symbolData = x1;
        return x0._symbolData;
    }
}

