/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.BodyBodyElementaryVisitor;
import edu.rice.cs.javalanglevels.ElementaryVisitor;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.AbstractMethodDef;
import edu.rice.cs.javalanglevels.tree.ConcreteMethodDef;
import edu.rice.cs.javalanglevels.tree.InitializedVariableDeclarator;
import edu.rice.cs.javalanglevels.tree.InstanceInitializer;
import edu.rice.cs.javalanglevels.tree.ModifiersAndVisibility;
import edu.rice.cs.javalanglevels.tree.Statement;
import edu.rice.cs.javalanglevels.tree.VariableDeclaration;
import java.io.File;
import java.util.Hashtable;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassBodyElementaryVisitor
extends ElementaryVisitor {
    private SymbolData _symbolData;

    public ClassBodyElementaryVisitor(SymbolData sd, File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, LinkedList<String> classDefsInThisFile, Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>> continuations) {
        super(file, packageName, importedFiles, importedPackages, classDefsInThisFile, continuations);
        this._symbolData = sd;
    }

    @Override
    public void forStatementDoFirst(Statement that) {
        ClassBodyElementaryVisitor._addError("Statements cannot appear outside of method bodies.", that);
    }

    @Override
    public void forConcreteMethodDefDoFirst(ConcreteMethodDef that) {
        ModifiersAndVisibility mav = that.getMav();
        String[] modifiers = mav.getModifiers();
        for (int i = 0; i < modifiers.length; ++i) {
            if (!modifiers[i].equals("abstract")) continue;
            ClassBodyElementaryVisitor._addError("Methods that have a braced body cannot be declared \"abstract\".", that);
            break;
        }
        if (that.getThrows().length > 0) {
            ClassBodyElementaryVisitor._addAndIgnoreError("Methods cannot throw exceptions at the Elementary level", that);
        }
        super.forConcreteMethodDefDoFirst(that);
    }

    @Override
    public void forAbstractMethodDefDoFirst(AbstractMethodDef that) {
        if (that.getThrows().length > 0) {
            ClassBodyElementaryVisitor._addAndIgnoreError("Methods cannot throw exceptions at the Elementary level", that);
        }
        if (!this._symbolData.hasModifier("abstract")) {
            ClassBodyElementaryVisitor._addError("Abstract methods can only be declared in abstract classes.", that);
        } else {
            super.forAbstractMethodDefDoFirst(that);
        }
    }

    @Override
    public void forInstanceInitializerDoFirst(InstanceInitializer that) {
        ClassBodyElementaryVisitor._addError("This open brace must mark the beginning of a method or class body.", that);
    }

    @Override
    public void forInitializedVariableDeclaratorDoFirst(InitializedVariableDeclarator that) {
        ClassBodyElementaryVisitor._addError("Cannot initialize a class's fields at the Elementary level.  To set the value of a field, when you instantiate the class, pass the desired value to the class's constructor.", that);
        this.forVariableDeclaratorDoFirst(that);
    }

    @Override
    public void forVariableDeclarationOnly(VariableDeclaration that) {
        VariableData[] vds = this._variableDeclaration2VariableData(that, this._symbolData);
        for (int i = 0; i < vds.length; ++i) {
            if (!vds[i].hasModifier("abstract")) continue;
            ClassBodyElementaryVisitor._addAndIgnoreError("Fields cannot be abstract", that);
        }
        if (!this._symbolData.addFinalVars(vds)) {
            ClassBodyElementaryVisitor._addAndIgnoreError("You cannot have two fields with the same name.  Either you already have a field by that name in this class, or one of your superclasses has a field by that name", that);
        }
    }

    @Override
    public void forConcreteMethodDef(ConcreteMethodDef that) {
        this.forConcreteMethodDefDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        MethodData md = this.createMethodData(that, this._symbolData);
        md.addPublicMav();
        String className = ClassBodyElementaryVisitor.getUnqualifiedClassName(this._symbolData.getName());
        if (className.equals(md.getName())) {
            ClassBodyElementaryVisitor._addAndIgnoreError("Constructors are they only methods that can have the same name as the class they appear in, and they are not allowed at the Elementary level", that);
        } else {
            this._symbolData.addMethod(md);
        }
        that.getBody().visit(new BodyBodyElementaryVisitor(md, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, this._classNamesInThisFile, (Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>)continuations));
        this.forConcreteMethodDefOnly(that);
    }

    @Override
    public void forAbstractMethodDef(AbstractMethodDef that) {
        this.forAbstractMethodDefDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        MethodData md = this.createMethodData(that, this._symbolData);
        String className = ClassBodyElementaryVisitor.getUnqualifiedClassName(this._symbolData.getName());
        if (className.equals(md.getName())) {
            ClassBodyElementaryVisitor._addAndIgnoreError("Constructors are they only methods that can have the same name as the class they appear in, and they are not allowed at the Elementary level", that);
        } else {
            this._symbolData.addMethod(md);
        }
        this.forAbstractMethodDefOnly(that);
    }

    static /* synthetic */ SymbolData access$000(ClassBodyElementaryVisitor x0) {
        return x0._symbolData;
    }
}

