/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.ArrayData;
import edu.rice.cs.javalanglevels.Bob;
import edu.rice.cs.javalanglevels.ClassBodyTypeChecker;
import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.InstanceData;
import edu.rice.cs.javalanglevels.LValueTypeChecker;
import edu.rice.cs.javalanglevels.LValueWithValueTypeChecker;
import edu.rice.cs.javalanglevels.LanguageLevelConverter;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.PackageData;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.TypeData;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.AnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.ArrayAccess;
import edu.rice.cs.javalanglevels.tree.ArrayInitializer;
import edu.rice.cs.javalanglevels.tree.BitwiseAssignmentExpression;
import edu.rice.cs.javalanglevels.tree.BitwiseBinaryExpression;
import edu.rice.cs.javalanglevels.tree.BitwiseNotExpression;
import edu.rice.cs.javalanglevels.tree.BooleanExpression;
import edu.rice.cs.javalanglevels.tree.BooleanLiteral;
import edu.rice.cs.javalanglevels.tree.BracedBody;
import edu.rice.cs.javalanglevels.tree.CastExpression;
import edu.rice.cs.javalanglevels.tree.CharLiteral;
import edu.rice.cs.javalanglevels.tree.ClassInstantiation;
import edu.rice.cs.javalanglevels.tree.ClassLiteral;
import edu.rice.cs.javalanglevels.tree.ComparisonExpression;
import edu.rice.cs.javalanglevels.tree.ComplexAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.ComplexInitializedArrayInstantiation;
import edu.rice.cs.javalanglevels.tree.ComplexMethodInvocation;
import edu.rice.cs.javalanglevels.tree.ComplexNameReference;
import edu.rice.cs.javalanglevels.tree.ComplexNamedClassInstantiation;
import edu.rice.cs.javalanglevels.tree.ComplexSuperReference;
import edu.rice.cs.javalanglevels.tree.ComplexThisConstructorInvocation;
import edu.rice.cs.javalanglevels.tree.ComplexThisReference;
import edu.rice.cs.javalanglevels.tree.ComplexUninitializedArrayInstantiation;
import edu.rice.cs.javalanglevels.tree.ConditionalExpression;
import edu.rice.cs.javalanglevels.tree.DivideAssignmentExpression;
import edu.rice.cs.javalanglevels.tree.DoubleLiteral;
import edu.rice.cs.javalanglevels.tree.EmptyExpression;
import edu.rice.cs.javalanglevels.tree.EmptyForCondition;
import edu.rice.cs.javalanglevels.tree.EqualityExpression;
import edu.rice.cs.javalanglevels.tree.Expression;
import edu.rice.cs.javalanglevels.tree.FloatLiteral;
import edu.rice.cs.javalanglevels.tree.IncrementExpression;
import edu.rice.cs.javalanglevels.tree.InnerClassDef;
import edu.rice.cs.javalanglevels.tree.InstanceofExpression;
import edu.rice.cs.javalanglevels.tree.IntegerLiteral;
import edu.rice.cs.javalanglevels.tree.JExpression;
import edu.rice.cs.javalanglevels.tree.LongLiteral;
import edu.rice.cs.javalanglevels.tree.MethodInvocation;
import edu.rice.cs.javalanglevels.tree.MinusAssignmentExpression;
import edu.rice.cs.javalanglevels.tree.ModAssignmentExpression;
import edu.rice.cs.javalanglevels.tree.MultiplyAssignmentExpression;
import edu.rice.cs.javalanglevels.tree.NegativePostfixIncrementExpression;
import edu.rice.cs.javalanglevels.tree.NegativePrefixIncrementExpression;
import edu.rice.cs.javalanglevels.tree.NoOpExpression;
import edu.rice.cs.javalanglevels.tree.NotExpression;
import edu.rice.cs.javalanglevels.tree.NullLiteral;
import edu.rice.cs.javalanglevels.tree.NumericAssignmentExpression;
import edu.rice.cs.javalanglevels.tree.NumericBinaryExpression;
import edu.rice.cs.javalanglevels.tree.NumericUnaryExpression;
import edu.rice.cs.javalanglevels.tree.Parenthesized;
import edu.rice.cs.javalanglevels.tree.PlusAssignmentExpression;
import edu.rice.cs.javalanglevels.tree.PlusExpression;
import edu.rice.cs.javalanglevels.tree.PositivePostfixIncrementExpression;
import edu.rice.cs.javalanglevels.tree.PositivePrefixIncrementExpression;
import edu.rice.cs.javalanglevels.tree.ShiftAssignmentExpression;
import edu.rice.cs.javalanglevels.tree.ShiftBinaryExpression;
import edu.rice.cs.javalanglevels.tree.SimpleAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.SimpleAssignmentExpression;
import edu.rice.cs.javalanglevels.tree.SimpleInitializedArrayInstantiation;
import edu.rice.cs.javalanglevels.tree.SimpleMethodInvocation;
import edu.rice.cs.javalanglevels.tree.SimpleNameReference;
import edu.rice.cs.javalanglevels.tree.SimpleNamedClassInstantiation;
import edu.rice.cs.javalanglevels.tree.SimpleSuperReference;
import edu.rice.cs.javalanglevels.tree.SimpleThisConstructorInvocation;
import edu.rice.cs.javalanglevels.tree.SimpleThisReference;
import edu.rice.cs.javalanglevels.tree.SimpleUninitializedArrayInstantiation;
import edu.rice.cs.javalanglevels.tree.StringLiteral;
import edu.rice.cs.javalanglevels.tree.ThrowStatement;
import edu.rice.cs.javalanglevels.tree.UninitializedArrayInstantiation;
import edu.rice.cs.javalanglevels.tree.Word;
import java.io.File;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionTypeChecker
extends Bob {
    public ExpressionTypeChecker(Data data, File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, LinkedList<VariableData> vars, LinkedList<Pair<SymbolData, JExpression>> thrown) {
        super(data, file, packageName, importedFiles, importedPackages, vars, thrown);
    }

    @Override
    public TypeData forSimpleAssignmentExpression(SimpleAssignmentExpression that) {
        TypeData value_result = that.getValue().visit(this);
        TypeData name_result = that.getName().visit(new LValueTypeChecker(this));
        return this.forSimpleAssignmentExpressionOnly(that, name_result, value_result);
    }

    @Override
    public TypeData forSimpleAssignmentExpressionOnly(SimpleAssignmentExpression that, TypeData name_result, TypeData value_result) {
        if (name_result == null || value_result == null) {
            return null;
        }
        if (!this.assertFound(name_result, that) || !this.assertFound(value_result, that)) {
            return null;
        }
        if (this.assertInstanceType(name_result, "You cannot assign a value to the type " + name_result.getName(), that) && this.assertInstanceType(value_result, "You cannot use the type name " + value_result.getName() + " on the right hand side of an assignment", that) && !value_result.getSymbolData().isAssignableTo(name_result.getSymbolData(), LanguageLevelConverter.OPT.javaVersion())) {
            ExpressionTypeChecker._addError("You cannot assign something of type " + value_result.getName() + " to something of type " + name_result.getName(), that);
        }
        return name_result.getInstanceData();
    }

    @Override
    public TypeData forPlusAssignmentExpression(PlusAssignmentExpression that) {
        TypeData value_result = that.getValue().visit(this);
        TypeData name_result = that.getName().visit(new LValueWithValueTypeChecker(this));
        return this.forPlusAssignmentExpressionOnly(that, name_result, value_result);
    }

    @Override
    public TypeData forPlusAssignmentExpressionOnly(PlusAssignmentExpression that, TypeData name_result, TypeData value_result) {
        if (name_result == null || value_result == null) {
            return null;
        }
        if (!this.assertFound(name_result, that) || !this.assertFound(value_result, that)) {
            return null;
        }
        SymbolData string = this.getSymbolData("java.lang.String", that, false, false);
        if (name_result.getSymbolData().isAssignableTo(string, LanguageLevelConverter.OPT.javaVersion())) {
            this.assertInstanceType(name_result, "The arguments to a Plus Assignment Operator (+=) must both be instances, but you have specified a type name", that);
            this.assertInstanceType(value_result, "The arguments to a Plus Assignment Operator (+=) must both be instances, but you have specified a type name", that);
            return string.getInstanceData();
        }
        if (!name_result.getSymbolData().isNumberType(LanguageLevelConverter.OPT.javaVersion()) || !value_result.getSymbolData().isNumberType(LanguageLevelConverter.OPT.javaVersion())) {
            ExpressionTypeChecker._addError("The arguments to the Plus Assignment Operator (+=) must either include an instance of a String or both be numbers.  You have specified arguments of type " + name_result.getName() + " and " + value_result.getName(), that);
            return string.getInstanceData();
        }
        if (!value_result.getSymbolData().isAssignableTo(name_result.getSymbolData(), LanguageLevelConverter.OPT.javaVersion())) {
            ExpressionTypeChecker._addError("You cannot increment something of type " + name_result.getName() + " with something of type " + value_result.getName(), that);
        } else {
            this.assertInstanceType(name_result, "The arguments to the Plus Assignment Operator (+=) must both be instances, but you have specified a type name", that);
            this.assertInstanceType(value_result, "The arguments to the Plus Assignment Operator (+=) must both be instances, but you have specified a type name", that);
        }
        return name_result.getInstanceData();
    }

    public TypeData forNumericAssignmentExpression(NumericAssignmentExpression that) {
        TypeData value_result = that.getValue().visit(this);
        TypeData name_result = that.getName().visit(new LValueWithValueTypeChecker(this));
        return this.forNumericAssignmentExpressionOnly(that, name_result, value_result);
    }

    @Override
    public TypeData forMinusAssignmentExpression(MinusAssignmentExpression that) {
        return this.forNumericAssignmentExpression(that);
    }

    @Override
    public TypeData forMultiplyAssignmentExpression(MultiplyAssignmentExpression that) {
        return this.forNumericAssignmentExpression(that);
    }

    @Override
    public TypeData forDivideAssignmentExpression(DivideAssignmentExpression that) {
        return this.forNumericAssignmentExpression(that);
    }

    @Override
    public TypeData forModAssignmentExpression(ModAssignmentExpression that) {
        return this.forNumericAssignmentExpression(that);
    }

    @Override
    public TypeData forNumericAssignmentExpressionOnly(NumericAssignmentExpression that, TypeData name_result, TypeData value_result) {
        if (name_result == null || value_result == null) {
            return null;
        }
        if (!this.assertFound(name_result, that) || !this.assertFound(value_result, that)) {
            return null;
        }
        if (this.assertInstanceType(name_result, "You cannot use a numeric assignment (-=, %=, *=, /=) on the type " + name_result.getName(), that) && this.assertInstanceType(value_result, "You cannot use the type name " + value_result.getName() + " on the left hand side of a numeric assignment (-=, %=, *=, /=)", that)) {
            boolean error = false;
            if (!name_result.getSymbolData().isNumberType(LanguageLevelConverter.OPT.javaVersion())) {
                ExpressionTypeChecker._addError("The left side of this expression is not a number.  Therefore, you cannot apply a numeric assignment (-=, %=, *=, /=) to it", that);
                error = true;
            }
            if (!value_result.getSymbolData().isNumberType(LanguageLevelConverter.OPT.javaVersion())) {
                ExpressionTypeChecker._addError("The right side of this expression is not a number.  Therefore, you cannot apply a numeric assignment (-=, %=, *=, /=) to it", that);
                error = true;
            }
            if (!error && !value_result.getSymbolData().isAssignableTo(name_result.getSymbolData(), LanguageLevelConverter.OPT.javaVersion())) {
                ExpressionTypeChecker._addError("You cannot use a numeric assignment (-=, %=, *=, /=) on something of type " + name_result.getName() + " with something of type " + value_result.getName(), that);
            }
        }
        return name_result.getInstanceData();
    }

    @Override
    public TypeData forShiftAssignmentExpressionOnly(ShiftAssignmentExpression that, TypeData name_result, TypeData value_result) {
        throw new RuntimeException("Internal Program Error: Shift assignment operators are not supported.  This should have been caught before the TypeChecker.  Please report this bug.");
    }

    @Override
    public TypeData forBitwiseAssignmentExpressionOnly(BitwiseAssignmentExpression that, TypeData name_result, TypeData value_result) {
        throw new RuntimeException("Internal Program Error: Bitwise assignment operators are not supported.  This should have been caught before the TypeChecker.  Please report this bug.");
    }

    @Override
    public TypeData forBooleanExpressionOnly(BooleanExpression that, TypeData left_result, TypeData right_result) {
        if (left_result == null || right_result == null) {
            return null;
        }
        if (!this.assertFound(left_result, that) || !this.assertFound(right_result, that)) {
            return null;
        }
        if (this.assertInstanceType(left_result, "The left side of this expression is a type, not an instance", that) && !left_result.getSymbolData().isAssignableTo(SymbolData.BOOLEAN_TYPE, LanguageLevelConverter.OPT.javaVersion())) {
            ExpressionTypeChecker._addError("The left side of this expression is not a boolean value.  Therefore, you cannot apply a Boolean Operator (&&, ||) to it", that);
        }
        if (this.assertInstanceType(right_result, "The right side of this expression is a type, not an instance", that) && !right_result.getSymbolData().isAssignableTo(SymbolData.BOOLEAN_TYPE, LanguageLevelConverter.OPT.javaVersion())) {
            ExpressionTypeChecker._addError("The right side of this expression is not a boolean value.  Therefore, you cannot apply a Boolean Operator (&&, ||) to it", that);
        }
        return SymbolData.BOOLEAN_TYPE.getInstanceData();
    }

    @Override
    public TypeData forBitwiseBinaryExpressionOnly(BitwiseBinaryExpression that, TypeData left_result, TypeData right_result) {
        throw new RuntimeException("Internal Program Error: Bitwise operators are not supported.  This should have been caught before the TypeChecker.  Please report this bug.");
    }

    @Override
    public TypeData forEqualityExpressionOnly(EqualityExpression that, TypeData left_result, TypeData right_result) {
        if (left_result == null || right_result == null) {
            return null;
        }
        if (!this.assertFound(left_result, that) || !this.assertFound(right_result, that)) {
            return null;
        }
        if (!(!left_result.getSymbolData().isPrimitiveType() && !right_result.getSymbolData().isPrimitiveType() || left_result.getSymbolData().isNumberType(LanguageLevelConverter.OPT.javaVersion()) && right_result.getSymbolData().isNumberType(LanguageLevelConverter.OPT.javaVersion()) || left_result.getSymbolData().isAssignableTo(SymbolData.BOOLEAN_TYPE, LanguageLevelConverter.OPT.javaVersion()) && right_result.getSymbolData().isAssignableTo(SymbolData.BOOLEAN_TYPE, LanguageLevelConverter.OPT.javaVersion()))) {
            ExpressionTypeChecker._addError("At least one of the arguments to this Equality Operator (==, !=) is primitive.  Therefore, they must either both be number types or both be boolean types.  You have specified expressions with type " + left_result.getName() + " and " + right_result.getName(), that);
        }
        this.assertInstanceType(left_result, "The arguments to this Equality Operator(==, !=) must both be instances.  Instead, you have referenced a type name on the left side", that);
        this.assertInstanceType(right_result, "The arguments to this Equality Operator(==, !=) must both be instances.  Instead, you have referenced a type name on the right side", that);
        return SymbolData.BOOLEAN_TYPE.getInstanceData();
    }

    @Override
    public TypeData forComparisonExpressionOnly(ComparisonExpression that, TypeData left_result, TypeData right_result) {
        if (left_result == null || right_result == null) {
            return null;
        }
        if (!this.assertFound(left_result, that) || !this.assertFound(right_result, that)) {
            return null;
        }
        if (!left_result.getSymbolData().isNumberType(LanguageLevelConverter.OPT.javaVersion())) {
            ExpressionTypeChecker._addError("The left side of this expression is not a number.  Therefore, you cannot apply a Comparison Operator (<, >; <=, >=) to it", that);
        } else {
            this.assertInstanceType(left_result, "The left side of this expression is a type, not an instance", that);
        }
        if (!right_result.getSymbolData().isNumberType(LanguageLevelConverter.OPT.javaVersion())) {
            ExpressionTypeChecker._addError("The right side of this expression is not a number.  Therefore, you cannot apply a Comparison Operator (<, >; <=, >=) to it", that);
        } else {
            this.assertInstanceType(right_result, "The right side of this expression is a type, not an instance", that);
        }
        return SymbolData.BOOLEAN_TYPE.getInstanceData();
    }

    @Override
    public TypeData forShiftBinaryExpressionOnly(ShiftBinaryExpression that, TypeData left_result, TypeData right_result) {
        throw new RuntimeException("Internal Program Error: BinaryShifts are not supported.  This should have been caught before the TypeChecker.  Please report this bug.");
    }

    @Override
    public TypeData forPlusExpressionOnly(PlusExpression that, TypeData left_result, TypeData right_result) {
        if (left_result == null || right_result == null) {
            return null;
        }
        if (!this.assertFound(left_result, that) || !this.assertFound(right_result, that)) {
            return null;
        }
        SymbolData string = this.getSymbolData("java.lang.String", that, false, false);
        if (left_result.getSymbolData().isAssignableTo(string, LanguageLevelConverter.OPT.javaVersion()) || right_result.getSymbolData().isAssignableTo(string, LanguageLevelConverter.OPT.javaVersion())) {
            this.assertInstanceType(left_result, "The arguments to the Plus Operator (+) must both be instances, but you have specified a type name", that);
            this.assertInstanceType(right_result, "The arguments to the Plus Operator (+) must both be instances, but you have specified a type name", that);
            return string.getInstanceData();
        }
        if (!left_result.getSymbolData().isNumberType(LanguageLevelConverter.OPT.javaVersion()) || !right_result.getSymbolData().isNumberType(LanguageLevelConverter.OPT.javaVersion())) {
            ExpressionTypeChecker._addError("The arguments to the Plus Operator (+) must either include an instance of a String or both be numbers.  You have specified arguments of type " + left_result.getName() + " and " + right_result.getName(), that);
            return string.getInstanceData();
        }
        this.assertInstanceType(left_result, "The arguments to the Plus Operator (+) must both be instances, but you have specified a type name", that);
        this.assertInstanceType(right_result, "The arguments to the Plus Operator (+) must both be instances, but you have specified a type name", that);
        return this._getLeastRestrictiveType(left_result.getSymbolData(), right_result.getSymbolData()).getInstanceData();
    }

    @Override
    public TypeData forNumericBinaryExpressionOnly(NumericBinaryExpression that, TypeData left_result, TypeData right_result) {
        if (left_result == null || right_result == null) {
            return null;
        }
        if (!this.assertFound(left_result, that) || !this.assertFound(right_result, that)) {
            return null;
        }
        if (this.assertInstanceType(left_result, "The left side of this expression is a type, not an instance", that) && !left_result.getSymbolData().isNumberType(LanguageLevelConverter.OPT.javaVersion())) {
            ExpressionTypeChecker._addError("The left side of this expression is not a number.  Therefore, you cannot apply a Numeric Binary Operator (*, /, -, %) to it", that);
            return right_result.getInstanceData();
        }
        if (this.assertInstanceType(right_result, "The right side of this expression is a type, not an instance", that) && !right_result.getSymbolData().isNumberType(LanguageLevelConverter.OPT.javaVersion())) {
            ExpressionTypeChecker._addError("The right side of this expression is not a number.  Therefore, you cannot apply a Numeric Binary Operator (*, /, -, %) to it", that);
            return left_result.getInstanceData();
        }
        return this._getLeastRestrictiveType(left_result.getSymbolData(), right_result.getSymbolData()).getInstanceData();
    }

    @Override
    public TypeData forNoOpExpressionOnly(NoOpExpression that, TypeData left_result, TypeData right_result) {
        throw new RuntimeException("Internal Program Error: The student is missing an operator.  This should have been caught before the TypeChecker.  Please report this bug.");
    }

    public TypeData forIncrementExpression(IncrementExpression that) {
        TypeData value_result = that.getValue().visit(new LValueWithValueTypeChecker(this));
        return this.forIncrementExpressionOnly(that, value_result);
    }

    @Override
    public TypeData forPositivePrefixIncrementExpression(PositivePrefixIncrementExpression that) {
        return this.forIncrementExpression(that);
    }

    @Override
    public TypeData forNegativePrefixIncrementExpression(NegativePrefixIncrementExpression that) {
        return this.forIncrementExpression(that);
    }

    @Override
    public TypeData forPositivePostfixIncrementExpression(PositivePostfixIncrementExpression that) {
        return this.forIncrementExpression(that);
    }

    @Override
    public TypeData forNegativePostfixIncrementExpression(NegativePostfixIncrementExpression that) {
        return this.forIncrementExpression(that);
    }

    @Override
    public TypeData forIncrementExpressionOnly(IncrementExpression that, TypeData value_result) {
        if (value_result == null) {
            return null;
        }
        if (!this.assertFound(value_result, that)) {
            return null;
        }
        if (this.assertInstanceType(value_result, "You cannot increment or decrement " + value_result.getName() + ", because it is a class name not an instance", that) && !value_result.getSymbolData().isNumberType(LanguageLevelConverter.OPT.javaVersion())) {
            ExpressionTypeChecker._addError("You cannot increment or decrement something that is not a number type.  You have specified something of type " + value_result.getName(), that);
        }
        return value_result.getInstanceData();
    }

    @Override
    public TypeData forNumericUnaryExpressionOnly(NumericUnaryExpression that, TypeData value_result) {
        if (value_result == null) {
            return null;
        }
        if (!this.assertFound(value_result, that)) {
            return null;
        }
        if (this.assertInstanceType(value_result, "You cannot use a numeric unary operator (+, -) with " + value_result.getName() + ", because it is a class name, not an instance", that) && !value_result.getSymbolData().isNumberType(LanguageLevelConverter.OPT.javaVersion())) {
            ExpressionTypeChecker._addError("You cannot apply this unary operator to something of type " + value_result.getName() + ".  You can only apply it to a numeric type such as double, int, or char", that);
            return value_result;
        }
        return this._getLeastRestrictiveType(value_result.getSymbolData(), SymbolData.INT_TYPE).getInstanceData();
    }

    @Override
    public TypeData forBitwiseNotExpressionOnly(BitwiseNotExpression that, TypeData value_result) {
        throw new RuntimeException("Internal Program Error: BitwiseNot is not supported.  It should have been caught before getting to the TypeChecker.  Please report this bug.");
    }

    @Override
    public TypeData forNotExpressionOnly(NotExpression that, TypeData value_result) {
        if (value_result == null) {
            return null;
        }
        if (!this.assertFound(value_result, that)) {
            return null;
        }
        if (this.assertInstanceType(value_result, "You cannot use the not (!) operator with " + value_result.getName() + ", because it is a class name, not an instance", that) && !value_result.getSymbolData().isAssignableTo(SymbolData.BOOLEAN_TYPE, LanguageLevelConverter.OPT.javaVersion())) {
            ExpressionTypeChecker._addError("You cannot use the not (!) operator with something of type " + value_result.getName() + ". Instead, it should be used with an expression of boolean type", that);
        }
        return SymbolData.BOOLEAN_TYPE.getInstanceData();
    }

    @Override
    public TypeData forConditionalExpressionOnly(ConditionalExpression that, TypeData condition_result, TypeData forTrue_result, TypeData forFalse_result) {
        throw new RuntimeException("Internal Program Error: Conditional expressions are not supported.  This should have been caught before the TypeChecker.  Please report this bug.");
    }

    @Override
    public TypeData forInstanceofExpressionOnly(InstanceofExpression that, TypeData value_result, TypeData type_result) {
        throw new RuntimeException("Internal Program Error: instanceof is not currently supported.  This should have been caught before the Type Checker.  Please report this bug.");
    }

    @Override
    public TypeData forCastExpressionOnly(CastExpression that, TypeData type_result, TypeData value_result) {
        if (type_result == null || value_result == null) {
            return null;
        }
        if (!this.assertFound(value_result, that) || !this.assertFound(type_result, that)) {
            return null;
        }
        if (type_result.isInstanceType()) {
            ExpressionTypeChecker._addError("You are trying to cast to an instance of a type, which is not allowed.  Perhaps you meant to cast to the type itself, " + type_result.getName(), that);
        } else if (this.assertInstanceType(value_result, "You are trying to cast " + value_result.getName() + ", which is a class or interface type, not an instance", that) && !value_result.getSymbolData().isCastableTo(type_result.getSymbolData(), LanguageLevelConverter.OPT.javaVersion())) {
            ExpressionTypeChecker._addError("You cannot cast an expression of type " + value_result.getName() + " to type " + type_result.getName() + " because they are not related", that);
        }
        return type_result.getInstanceData();
    }

    @Override
    public TypeData forEmptyExpressionOnly(EmptyExpression that) {
        throw new RuntimeException("Internal Program Error: EmptyExpression encountered.  Student is missing something.  Should have been caught before TypeChecker.  Please report this bug.");
    }

    public InstanceData classInstantiationHelper(ClassInstantiation that, SymbolData classToInstantiate) {
        if (classToInstantiate == null) {
            return null;
        }
        Expression[] expr = that.getArguments().getExpressions();
        InstanceData[] args = new InstanceData[expr.length];
        for (int i = 0; i < expr.length; ++i) {
            Expression e = expr[i];
            TypeData type = e.visit(this);
            if (type == null || !this.assertFound(type, expr[i]) || !this.assertInstanceType(type, "Cannot pass a class or interface name as a constructor argument", e)) {
                return classToInstantiate.getInstanceData();
            }
            args[i] = type.getInstanceData();
        }
        MethodData md = this._lookupMethod(LanguageLevelVisitor.getUnqualifiedClassName(that.getType().getName()), classToInstantiate, args, that, "No constructor found in class " + Data.dollarSignsToDots(classToInstantiate.getName()) + " with signature: ", true, this._getData().getSymbolData());
        if (md == null) {
            return classToInstantiate.getInstanceData();
        }
        String[] thrown = md.getThrown();
        for (int i = 0; i < thrown.length; ++i) {
            this._thrown.addLast(new Pair<SymbolData, ClassInstantiation>(this.getSymbolData(thrown[i], this._getData(), that), that));
        }
        return classToInstantiate.getInstanceData();
    }

    @Override
    public TypeData forSimpleNamedClassInstantiation(SimpleNamedClassInstantiation that) {
        InstanceData result;
        SymbolData type = this.getSymbolData(that.getType().getName(), this._getData(), that);
        if (type == null) {
            return null;
        }
        String name = that.getType().getName();
        int lastIndexOfDot = name.lastIndexOf(".");
        if (!type.hasModifier("static") && type.getOuterData() != null && lastIndexOfDot != -1) {
            String firstPart = name.substring(0, lastIndexOfDot);
            String secondPart = name.substring(lastIndexOfDot + 1, name.length());
            ExpressionTypeChecker._addError(Data.dollarSignsToDots(type.getName()) + " is not a static inner class, and thus cannot be instantiated from this context.  Perhaps you meant to use an instantiation of the form new " + firstPart + "().new " + secondPart + "()", that);
        }
        if ((result = this.classInstantiationHelper(that, type)) != null && result.getSymbolData().hasModifier("abstract")) {
            ExpressionTypeChecker._addError(Data.dollarSignsToDots(type.getName()) + " is abstract and thus cannot be instantiated", that);
        }
        return result;
    }

    @Override
    public TypeData forComplexNamedClassInstantiation(ComplexNamedClassInstantiation that) {
        TypeData enclosingType = that.getEnclosing().visit(this);
        if (enclosingType == null || !this.assertFound(enclosingType, that.getEnclosing())) {
            return null;
        }
        ExpressionTypeChecker.checkAccessibility(that, enclosingType.getSymbolData().getMav(), enclosingType.getSymbolData().getName(), enclosingType.getSymbolData(), this._data.getSymbolData(), "class or interface", true);
        SymbolData innerClass = this.getSymbolData(that.getType().getName(), enclosingType.getSymbolData(), that.getType());
        if (innerClass == null) {
            return null;
        }
        ExpressionTypeChecker.checkAccessibility(that, innerClass.getMav(), innerClass.getName(), innerClass, this._data.getSymbolData(), "class or interface", true);
        InstanceData result = this.classInstantiationHelper(that, innerClass);
        if (result == null) {
            return null;
        }
        boolean resultIsStatic = result.getSymbolData().hasModifier("static");
        if (!enclosingType.isInstanceType() && !resultIsStatic) {
            ExpressionTypeChecker._addError("The constructor of a non-static inner class can only be called on an instance of its containing class (e.g. new " + Data.dollarSignsToDots(enclosingType.getName()) + "().new " + that.getType().getName() + "())", that);
        } else if (resultIsStatic) {
            ExpressionTypeChecker._addError("You cannot instantiate a static inner class or interface with this syntax.  Instead, try new " + Data.dollarSignsToDots(result.getName()) + "()", that);
        }
        if (result.getSymbolData().hasModifier("abstract")) {
            ExpressionTypeChecker._addError(Data.dollarSignsToDots(result.getName()) + " is abstract and thus cannot be instantiated", that);
        }
        return result;
    }

    public SymbolData handleAnonymousClassInstantiation(AnonymousClassInstantiation that, SymbolData superC) {
        SymbolData sd = this._data.getNextAnonymousInnerClass();
        if (sd == null) {
            throw new RuntimeException("Internal Program Error: Couldn't find the SymbolData for the anonymous inner class.  Please report this bug.");
        }
        if (sd.getSuperClass() == null) {
            if (superC.isInterface()) {
                sd.setSuperClass(symbolTable.get("java.lang.Object"));
                sd.addInterface(superC);
            } else {
                sd.setSuperClass(superC);
            }
        }
        LanguageLevelVisitor.createAccessors(sd, this._file);
        return sd;
    }

    @Override
    public TypeData forSimpleAnonymousClassInstantiation(SimpleAnonymousClassInstantiation that) {
        SymbolData superclass_result = this.getSymbolData(that.getType().getName(), this._data, that);
        SymbolData myData = this.handleAnonymousClassInstantiation(that, superclass_result);
        String name = that.getType().getName();
        int lastIndexOfDot = name.lastIndexOf(".");
        if (!superclass_result.hasModifier("static") && !superclass_result.isInterface() && superclass_result.getOuterData() != null && lastIndexOfDot != -1) {
            String firstPart = name.substring(0, lastIndexOfDot);
            String secondPart = name.substring(lastIndexOfDot + 1, name.length());
            ExpressionTypeChecker._addError(Data.dollarSignsToDots(superclass_result.getName()) + " is not a static inner class, and thus cannot be instantiated from this context.  Perhaps you meant to use an instantiation of the form new " + Data.dollarSignsToDots(firstPart) + "().new " + Data.dollarSignsToDots(secondPart) + "()", that);
        }
        if (superclass_result.isInterface()) {
            Expression[] expr = that.getArguments().getExpressions();
            if (expr.length > 0) {
                ExpressionTypeChecker._addError("You are creating an anonymous inner class that directly implements an interface, thus you should use the Object constructor which takes in no arguments.  However, you have specified " + expr.length + " arguments", that);
            }
        } else {
            this.classInstantiationHelper(that, superclass_result);
        }
        LinkedList<VariableData> vars = this.cloneVariableDataList(this._vars);
        vars.addAll(myData.getVars());
        TypeData body_result = that.getBody().visit(new ClassBodyTypeChecker(myData, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, vars, (LinkedList<Pair<SymbolData, JExpression>>)this._thrown));
        this._checkAbstractMethods(myData, that);
        return myData.getInstanceData();
    }

    @Override
    public TypeData forComplexAnonymousClassInstantiation(ComplexAnonymousClassInstantiation that) {
        boolean resultIsStatic;
        TypeData enclosingType = that.getEnclosing().visit(this);
        if (enclosingType == null || !this.assertFound(enclosingType, that.getEnclosing())) {
            return null;
        }
        ExpressionTypeChecker.checkAccessibility(that, enclosingType.getSymbolData().getMav(), enclosingType.getSymbolData().getName(), enclosingType.getSymbolData(), this._data.getSymbolData(), "class or interface", true);
        SymbolData superclass_result = this.getSymbolData(that.getType().getName(), enclosingType.getSymbolData(), that.getType());
        SymbolData myData = this.handleAnonymousClassInstantiation(that, superclass_result);
        if (superclass_result.isInterface()) {
            Expression[] expr = that.getArguments().getExpressions();
            if (expr.length > 0) {
                ExpressionTypeChecker._addError("You are creating an anonymous inner class that directly implements an interface, thus you should use the Object constructor which takes in no arguments.  However, you have specified " + expr.length + " arguments", that);
            }
            resultIsStatic = true;
        } else {
            InstanceData result = this.classInstantiationHelper(that, superclass_result);
            if (result == null) {
                return null;
            }
            resultIsStatic = result.getSymbolData().hasModifier("static");
        }
        if (!enclosingType.isInstanceType() && !resultIsStatic) {
            ExpressionTypeChecker._addError("The constructor of a non-static inner class can only be called on an instance of its containing class (e.g. new " + Data.dollarSignsToDots(enclosingType.getName()) + "().new " + that.getType().getName() + "())", that);
        } else if (enclosingType.isInstanceType() && resultIsStatic) {
            ExpressionTypeChecker._addError("You cannot instantiate a static inner class or interface with this syntax.  Instead, try new " + Data.dollarSignsToDots(superclass_result.getName()) + "()", that);
        }
        LinkedList<VariableData> vars = this.cloneVariableDataList(this._vars);
        vars.addAll(myData.getVars());
        TypeData body_result = that.getBody().visit(new ClassBodyTypeChecker(myData, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, vars, (LinkedList<Pair<SymbolData, JExpression>>)this._thrown));
        this._checkAbstractMethods(myData, that);
        return myData.getInstanceData();
    }

    @Override
    public TypeData forSimpleThisConstructorInvocation(SimpleThisConstructorInvocation that) {
        ExpressionTypeChecker._addError("This constructor invocations are only allowed as the first statement of a constructor body", that);
        return null;
    }

    @Override
    public TypeData forComplexThisConstructorInvocation(ComplexThisConstructorInvocation that) {
        ExpressionTypeChecker._addError("Constructor invocations of this form are never allowed", that);
        return null;
    }

    @Override
    public TypeData forSimpleNameReference(SimpleNameReference that) {
        Word myWord = that.getName();
        myWord.visit(this);
        VariableData reference = ExpressionTypeChecker.getFieldOrVariable(myWord.getText(), this._data, this._data.getSymbolData(), that, this._vars, true, true);
        if (reference != null) {
            if (!reference.hasValue()) {
                ExpressionTypeChecker._addError("You cannot use " + reference.getName() + " because it may not have been given a value", that.getName());
            }
            if (!reference.hasModifier("static") && this.inStaticMethod()) {
                ExpressionTypeChecker._addError("Non static field or variable " + reference.getName() + " cannot be referenced from a static context", that);
            }
            return reference.getType().getInstanceData();
        }
        SymbolData classR = this.findClassReference(null, myWord.getText(), that);
        if (classR != null && classR != SymbolData.AMBIGUOUS_REFERENCE && ExpressionTypeChecker.checkAccessibility(that, classR.getMav(), classR.getName(), classR, this._data.getSymbolData(), "class or interface", false)) {
            return classR;
        }
        if (classR == SymbolData.AMBIGUOUS_REFERENCE) {
            return null;
        }
        PackageData packageD = new PackageData(myWord.getText());
        return packageD;
    }

    @Override
    public TypeData forComplexNameReference(ComplexNameReference that) {
        TypeData lhs = that.getEnclosing().visit(this);
        Word myWord = that.getName();
        if (lhs instanceof PackageData) {
            SymbolData classRef = this.findClassReference(lhs, myWord.getText(), that);
            if (classRef != null) {
                return classRef;
            }
            return new PackageData((PackageData)lhs, myWord.getText());
        }
        ExpressionTypeChecker.checkAccessibility(that, lhs.getSymbolData().getMav(), lhs.getSymbolData().getName(), lhs.getSymbolData(), this._data.getSymbolData(), "class or interface", true);
        VariableData reference = ExpressionTypeChecker.getFieldOrVariable(myWord.getText(), lhs.getSymbolData(), this._data.getSymbolData(), that);
        if (reference != null) {
            if (lhs instanceof SymbolData && !reference.hasModifier("static")) {
                ExpressionTypeChecker._addError("Non-static variable " + reference.getName() + " cannot be accessed from the static context " + Data.dollarSignsToDots(lhs.getName()) + ".  Perhaps you meant to instantiate an instance of " + Data.dollarSignsToDots(lhs.getName()), that);
                return reference.getType().getInstanceData();
            }
            if (!reference.hasValue()) {
                ExpressionTypeChecker._addError("You cannot use " + reference.getName() + " here, because it may not have been given a value", that.getName());
            }
            return reference.getType().getInstanceData();
        }
        SymbolData sd = this.getSymbolData(true, myWord.getText(), lhs.getSymbolData(), that, false);
        if (sd != null && sd != SymbolData.AMBIGUOUS_REFERENCE) {
            if (!ExpressionTypeChecker.checkAccessibility(that, sd.getMav(), sd.getName(), sd, this._data.getSymbolData(), "class or interface")) {
                return null;
            }
            if (!sd.hasModifier("static")) {
                ExpressionTypeChecker._addError("Non-static inner class " + Data.dollarSignsToDots(sd.getName()) + " cannot be accessed from this context.  Perhaps you meant to instantiate it", that);
            } else if (lhs instanceof InstanceData) {
                ExpressionTypeChecker._addError("You cannot reference the static inner class " + Data.dollarSignsToDots(sd.getName()) + " from an instance of " + Data.dollarSignsToDots(lhs.getName()) + ".  Perhaps you meant to say " + Data.dollarSignsToDots(sd.getName()), that);
            }
            return sd;
        }
        if (sd != SymbolData.AMBIGUOUS_REFERENCE) {
            ExpressionTypeChecker._addError("Could not resolve " + myWord.getText() + " from the context of " + Data.dollarSignsToDots(lhs.getName()), that);
        }
        return null;
    }

    @Override
    public TypeData forSimpleThisReference(SimpleThisReference that) {
        if (this.inStaticMethod()) {
            ExpressionTypeChecker._addError("'this' cannot be referenced from within a static method", that);
        }
        return this._getData().getSymbolData().getInstanceData();
    }

    @Override
    public TypeData forComplexThisReferenceOnly(ComplexThisReference that, TypeData enclosing_result) {
        SymbolData myData;
        if (enclosing_result == null || !this.assertFound(enclosing_result, that.getEnclosing())) {
            return null;
        }
        if (this.inStaticMethod()) {
            ExpressionTypeChecker._addError("'this' cannot be referenced from within a static method", that);
        }
        if (enclosing_result.isInstanceType()) {
            ExpressionTypeChecker._addError("'this' can only be referenced from a type name, but you have specified an instance of that type.", that);
        }
        if (!(myData = this._getData().getSymbolData()).isInnerClassOf(enclosing_result.getSymbolData(), true)) {
            if (myData.isInnerClassOf(enclosing_result.getSymbolData(), false)) {
                ExpressionTypeChecker._addError("You cannot reference " + enclosing_result.getName() + ".this from here, because " + myData.getName() + " or one of its enclosing classes " + "is static.  Thus, an enclosing instance of " + enclosing_result.getName() + " does not exist", that);
            } else {
                ExpressionTypeChecker._addError("You cannot reference " + enclosing_result.getName() + ".this from here, because " + enclosing_result.getName() + " is not an outer class of " + myData.getName(), that);
            }
        }
        return enclosing_result.getInstanceData();
    }

    @Override
    public TypeData forSimpleSuperReference(SimpleSuperReference that) {
        SymbolData superClass;
        if (this.inStaticMethod()) {
            ExpressionTypeChecker._addError("'super' cannot be referenced from within a static method", that);
        }
        if ((superClass = this._getData().getSymbolData().getSuperClass()) == null) {
            ExpressionTypeChecker._addError("The class " + this._getData().getSymbolData().getName() + " does not have a super class", that);
            return null;
        }
        return superClass.getInstanceData();
    }

    @Override
    public TypeData forComplexSuperReferenceOnly(ComplexSuperReference that, TypeData enclosing_result) {
        SymbolData superClass;
        SymbolData myData;
        if (enclosing_result == null || !this.assertFound(enclosing_result, that.getEnclosing())) {
            return null;
        }
        if (this.inStaticMethod()) {
            ExpressionTypeChecker._addError("'super' cannot be referenced from within a static method", that);
        }
        if (enclosing_result.isInstanceType()) {
            ExpressionTypeChecker._addError("'super' can only be referenced from a type name, but you have specified an instance of that type.", that);
        }
        if (!(myData = this._getData().getSymbolData()).isInnerClassOf(enclosing_result.getSymbolData(), true)) {
            if (myData.isInnerClassOf(enclosing_result.getSymbolData(), false)) {
                ExpressionTypeChecker._addError("You cannot reference " + enclosing_result.getName() + ".super from here, because " + myData.getName() + " or one of its enclosing classes " + "is static.  Thus, an enclosing instance of " + enclosing_result.getName() + " does not exist", that);
            } else {
                ExpressionTypeChecker._addError("You cannot reference " + enclosing_result.getName() + ".super from here, because " + enclosing_result.getName() + " is not an outer class of " + myData.getName(), that);
            }
        }
        if ((superClass = enclosing_result.getSymbolData().getSuperClass()) == null) {
            ExpressionTypeChecker._addError("The class " + enclosing_result.getName() + " does not have a super class", that);
            return null;
        }
        return superClass.getInstanceData();
    }

    @Override
    public TypeData forArrayAccessOnly(ArrayAccess that, TypeData lhs, TypeData index) {
        if (lhs == null || index == null) {
            return null;
        }
        if (!this.assertFound(lhs, that) || !this.assertFound(index, that)) {
            return null;
        }
        if (this.assertInstanceType(lhs, "You cannot access an array element of a type name", that) && !(lhs.getSymbolData() instanceof ArrayData)) {
            ExpressionTypeChecker._addError("The variable referred to by this array access is a " + lhs.getSymbolData().getName() + ", not an array", that);
            return lhs.getInstanceData();
        }
        if (this.assertInstanceType(index, "You have used a type name in place of an array index", that) && !index.getSymbolData().isAssignableTo(SymbolData.INT_TYPE, LanguageLevelConverter.OPT.javaVersion())) {
            ExpressionTypeChecker._addError("You cannot reference an array element with an index of type " + index.getSymbolData().getName() + ".  Instead, you must use an int", that);
        }
        return ((ArrayData)lhs.getSymbolData()).getElementType().getInstanceData();
    }

    @Override
    public TypeData forStringLiteralOnly(StringLiteral that) {
        return symbolTable.get("java.lang.String").getInstanceData();
    }

    @Override
    public TypeData forIntegerLiteralOnly(IntegerLiteral that) {
        return SymbolData.INT_TYPE.getInstanceData();
    }

    @Override
    public TypeData forLongLiteralOnly(LongLiteral that) {
        return SymbolData.LONG_TYPE.getInstanceData();
    }

    @Override
    public TypeData forFloatLiteralOnly(FloatLiteral that) {
        return SymbolData.FLOAT_TYPE.getInstanceData();
    }

    @Override
    public TypeData forDoubleLiteralOnly(DoubleLiteral that) {
        return SymbolData.DOUBLE_TYPE.getInstanceData();
    }

    @Override
    public TypeData forCharLiteralOnly(CharLiteral that) {
        return SymbolData.CHAR_TYPE.getInstanceData();
    }

    @Override
    public TypeData forBooleanLiteralOnly(BooleanLiteral that) {
        return SymbolData.BOOLEAN_TYPE.getInstanceData();
    }

    @Override
    public TypeData forNullLiteralOnly(NullLiteral that) {
        return SymbolData.NULL_TYPE.getInstanceData();
    }

    public TypeData forClassLiteralOnly(ClassLiteral that) {
        return symbolTable.get("java.lang.Class").getInstanceData();
    }

    @Override
    public TypeData forParenthesizedOnly(Parenthesized that, TypeData value_result) {
        if (value_result == null) {
            return null;
        }
        if (!this.assertFound(value_result, that.getValue())) {
            return null;
        }
        this.assertInstanceType(value_result, "This class or interface name cannot appear in parentheses", that);
        return value_result.getInstanceData();
    }

    public TypeData methodInvocationHelper(MethodInvocation that, TypeData context) {
        Expression[] exprs = that.getArguments().getExpressions();
        TypeData[] args = new TypeData[exprs.length];
        InstanceData[] newArgs = new InstanceData[exprs.length];
        for (int i = 0; i < exprs.length; ++i) {
            args[i] = exprs[i].visit(this);
            if (args[i] == null) {
                return null;
            }
            if (!this.assertFound(args[i], that)) {
                return null;
            }
            if (!args[i].isInstanceType()) {
                ExpressionTypeChecker._addError("Cannot pass a class or interface name as an argument to a method.  Perhaps you meant to create an instance or use " + args[i].getName() + ".class", exprs[i]);
            }
            newArgs[i] = args[i].getInstanceData();
        }
        MethodData md = this._lookupMethod(that.getName().getText(), context.getSymbolData(), newArgs, that, "No method found in class " + context.getName() + " with signature: ", false, this._getData().getSymbolData());
        if (md == null) {
            return null;
        }
        if (!context.isInstanceType() && !md.hasModifier("static")) {
            ExpressionTypeChecker._addError("Cannot access the non-static method " + md.getName() + " from a static context", that);
        }
        String[] thrown = md.getThrown();
        for (int i = 0; i < thrown.length; ++i) {
            this._thrown.addLast(new Pair<SymbolData, MethodInvocation>(this.getSymbolData(thrown[i], this._getData(), that), that));
        }
        return md.getReturnType().getInstanceData();
    }

    @Override
    public TypeData forSimpleMethodInvocation(SimpleMethodInvocation that) {
        TypeData context = this._getData().getSymbolData().getInstanceData();
        if (this.inStaticMethod()) {
            context = ((TypeData)context).getSymbolData();
        }
        return this.methodInvocationHelper(that, context);
    }

    @Override
    public TypeData forComplexMethodInvocation(ComplexMethodInvocation that) {
        TypeData context = that.getEnclosing().visit(this);
        if (!this.assertFound(context, that.getEnclosing()) || context == null) {
            return null;
        }
        ExpressionTypeChecker.checkAccessibility(that, context.getSymbolData().getMav(), context.getSymbolData().getName(), context.getSymbolData(), this._data.getSymbolData(), "class or interface", true);
        if (this.inStaticMethod()) {
            context = context.getSymbolData();
        }
        return this.methodInvocationHelper(that, context);
    }

    @Override
    protected boolean canBeAssigned(VariableData vd) {
        return !vd.isFinal() || !vd.hasValue();
    }

    protected SymbolData _getLeastRestrictiveType(SymbolData sd1, SymbolData sd2) {
        if (sd1.isDoubleType(LanguageLevelConverter.OPT.javaVersion()) && sd2.isNumberType(LanguageLevelConverter.OPT.javaVersion()) || sd2.isDoubleType(LanguageLevelConverter.OPT.javaVersion()) && sd1.isNumberType(LanguageLevelConverter.OPT.javaVersion())) {
            return SymbolData.DOUBLE_TYPE;
        }
        if (sd1.isFloatType(LanguageLevelConverter.OPT.javaVersion()) && sd2.isNumberType(LanguageLevelConverter.OPT.javaVersion()) || sd2.isFloatType(LanguageLevelConverter.OPT.javaVersion()) && sd1.isNumberType(LanguageLevelConverter.OPT.javaVersion())) {
            return SymbolData.FLOAT_TYPE;
        }
        if (sd1.isLongType(LanguageLevelConverter.OPT.javaVersion()) && sd2.isNumberType(LanguageLevelConverter.OPT.javaVersion()) || sd2.isLongType(LanguageLevelConverter.OPT.javaVersion()) && sd1.isNumberType(LanguageLevelConverter.OPT.javaVersion())) {
            return SymbolData.LONG_TYPE;
        }
        if (sd1.isBooleanType(LanguageLevelConverter.OPT.javaVersion()) && sd2.isBooleanType(LanguageLevelConverter.OPT.javaVersion())) {
            return SymbolData.BOOLEAN_TYPE;
        }
        return SymbolData.INT_TYPE;
    }

    @Override
    public TypeData forConditionalExpression(ConditionalExpression that) {
        throw new RuntimeException("Internal Program Error: Conditional expressions are not supported.  This should have been caught before the Type Checker.  Please report this bug.");
    }

    @Override
    public TypeData forInstanceofExpression(InstanceofExpression that) {
        throw new RuntimeException("Internal Program Error: Instance of expressions are not supported.  This should have been caught before the Type Checker.  Please report this bug.");
    }

    @Override
    public TypeData forCastExpression(CastExpression that) {
        SymbolData type_result = this.getSymbolData(that.getType().getName(), this._data.getSymbolData(), that.getType(), false);
        TypeData value_result = that.getValue().visit(this);
        if (type_result == null) {
            ExpressionTypeChecker._addError(that.getType().getName() + " cannot appear as the type of a cast expression because it is not a valid type", that.getType());
            return null;
        }
        if (value_result == null || !this.assertFound(value_result, that.getValue())) {
            return type_result.getInstanceData();
        }
        return this.forCastExpressionOnly(that, type_result, value_result);
    }

    @Override
    public TypeData forUninitializedArrayInstantiationOnly(UninitializedArrayInstantiation that, TypeData type_result, TypeData[] dimensions_result) {
        int dim;
        Expression[] dims = that.getDimensionSizes().getExpressions();
        for (int i = 0; i < dimensions_result.length; ++i) {
            if (dimensions_result[i] == null || !this.assertFound(dimensions_result[i], dims[i])) continue;
            if (!dimensions_result[i].getSymbolData().isAssignableTo(SymbolData.INT_TYPE, LanguageLevelConverter.OPT.javaVersion())) {
                ExpressionTypeChecker._addError("The dimensions of an array instantiation must all be ints.  You have specified something of type " + dimensions_result[i].getName(), dims[i]);
                continue;
            }
            this.assertInstanceType(dimensions_result[i], "All dimensions of an array instantiation must be instances.  You have specified the type " + dimensions_result[i].getName(), dims[i]);
        }
        if (type_result instanceof ArrayData && dimensions_result.length > (dim = ((ArrayData)type_result).getDimensions())) {
            ExpressionTypeChecker._addError("You are trying to initialize an array of type " + type_result.getName() + " which requires " + dim + " dimensions, but you have specified " + dimensions_result.length + " dimensions--the wrong number", that);
        }
        if (type_result == null || !this.assertFound(type_result, that)) {
            return null;
        }
        return type_result.getInstanceData();
    }

    @Override
    public TypeData forSimpleUninitializedArrayInstantiation(SimpleUninitializedArrayInstantiation that) {
        SymbolData type_result = this.getSymbolData(that.getType().getName(), this._data.getSymbolData(), that.getType());
        TypeData[] dimensions_result = this.makeArrayOfRetType(that.getDimensionSizes().getExpressions().length);
        for (int i = 0; i < that.getDimensionSizes().getExpressions().length; ++i) {
            dimensions_result[i] = that.getDimensionSizes().getExpressions()[i].visit(this);
        }
        return this.forUninitializedArrayInstantiationOnly((UninitializedArrayInstantiation)that, type_result, dimensions_result);
    }

    @Override
    public TypeData forComplexUninitializedArrayInstantiation(ComplexUninitializedArrayInstantiation that) {
        throw new RuntimeException("Internal Program Error: Complex Uninitialized Array Instantiations are not legal Java.  This should have been caught before the Type Checker.  Please report this bug.");
    }

    @Override
    public TypeData forArrayInitializer(ArrayInitializer that) {
        throw new RuntimeException("Internal Program Error: forArrayInitializer should never be called, but it was.  Please report this bug.");
    }

    @Override
    public TypeData forSimpleInitializedArrayInstantiation(SimpleInitializedArrayInstantiation that) {
        SymbolData type_result = this.getSymbolData(that.getType().getName(), this._data, that.getType());
        TypeData elementResult = this.forArrayInitializerHelper(that.getInitializer(), type_result);
        if (type_result == null) {
            return null;
        }
        return type_result.getInstanceData();
    }

    @Override
    public TypeData forComplexInitializedArrayInstantiation(ComplexInitializedArrayInstantiation that) {
        throw new RuntimeException("Internal Program Error: Complex Initialized Array Instantiations are not legal Java.  This should have been caught before the Type Checker.  Please report this bug.");
    }

    @Override
    public TypeData forInnerClassDef(InnerClassDef that) {
        String className = that.getName().getText();
        SymbolData sd = this._data.getInnerClassOrInterface(className);
        if (this.checkForCyclicInheritance(sd, new LinkedList<SymbolData>(), that)) {
            return null;
        }
        TypeData mav_result = that.getMav().visit(this);
        TypeData name_result = that.getName().visit(this);
        TypeData[] typeParameters_result = this.makeArrayOfRetType(that.getTypeParameters().length);
        for (int i = 0; i < that.getTypeParameters().length; ++i) {
            typeParameters_result[i] = that.getTypeParameters()[i].visit(this);
        }
        TypeData superclass_result = that.getSuperclass().visit(this);
        TypeData[] interfaces_result = this.makeArrayOfRetType(that.getInterfaces().length);
        for (int i = 0; i < that.getInterfaces().length; ++i) {
            interfaces_result[i] = that.getInterfaces()[i].visit(this);
        }
        TypeData body_result = that.getBody().visit(new ClassBodyTypeChecker(sd, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, (LinkedList<VariableData>)this._vars, (LinkedList<Pair<SymbolData, JExpression>>)this._thrown));
        return null;
    }

    @Override
    void reassignVariableDatas(LinkedList<VariableData> l1, LinkedList<VariableData> l2) {
        for (int i = 0; i < l1.size(); ++i) {
            if (!l2.contains(l1.get(i))) continue;
            l1.get(i).gotValue();
        }
    }

    @Override
    void reassignLotsaVariableDatas(LinkedList<VariableData> tryBlock, LinkedList<LinkedList<VariableData>> catchBlocks) {
        for (int i = 0; i < tryBlock.size(); ++i) {
            boolean seenIt = true;
            int j = 0;
            while (j < catchBlocks.size()) {
                if (!catchBlocks.get(j).contains(tryBlock.get(i))) {
                    seenIt = false;
                }
                ++i;
            }
            if (!seenIt) continue;
            tryBlock.get(i).gotValue();
        }
    }

    @Override
    public void handleUncheckedException(SymbolData sd, JExpression j) {
        if (j instanceof MethodInvocation) {
            ExpressionTypeChecker._addError("The method " + ((MethodInvocation)j).getName().getText() + " is declared to throw the exception " + sd.getName() + " which needs to be caught or declared to be thrown", j);
        } else if (j instanceof ThrowStatement) {
            ExpressionTypeChecker._addError("This statement throws the exception " + sd.getName() + " which needs to be caught or declared to be thrown", j);
        } else if (j instanceof ClassInstantiation) {
            ExpressionTypeChecker._addError("The constructor for the class " + ((ClassInstantiation)j).getType().getName() + " is declared to throw the exception " + sd.getName() + " which needs to be caught or declared to be thrown.", j);
        } else {
            throw new RuntimeException("Internal Program Error: Something besides a method invocation or throw statement threw an exception.  Please report this bug.");
        }
    }

    @Override
    public boolean isCheckedException(SymbolData sd, JExpression that) {
        return sd.isSubClassOf(this.getSymbolData("java.lang.Throwable", this._data, that, false)) && !sd.isSubClassOf(this.getSymbolData("java.lang.RuntimeException", this._data, that, false)) && !sd.isSubClassOf(this.getSymbolData("java.lang.Error", this._data, that, false));
    }

    @Override
    public boolean isUncaughtCheckedException(SymbolData sd, JExpression that) {
        return this.isCheckedException(sd, that);
    }

    @Override
    public TypeData forBracedBody(BracedBody that) {
        TypeData[] items_result = this.makeArrayOfRetType(that.getStatements().length);
        for (int i = 0; i < that.getStatements().length; ++i) {
            items_result[i] = that.getStatements()[i].visit(this);
            for (int j = 0; j < this._thrown.size(); ++j) {
                if (!this.isUncaughtCheckedException((SymbolData)((Pair)this._thrown.get(j)).getFirst(), that)) continue;
                this.handleUncheckedException((SymbolData)((Pair)this._thrown.get(j)).getFirst(), (JExpression)((Pair)this._thrown.get(j)).getSecond());
            }
        }
        return this.forBracedBodyOnly(that, items_result);
    }

    @Override
    public TypeData forEmptyForCondition(EmptyForCondition that) {
        return SymbolData.BOOLEAN_TYPE.getInstanceData();
    }
}

