/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.ClassBodyIntermediateVisitor;
import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.InterfaceBodyIntermediateVisitor;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.Symboltable;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.AnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.ArrayType;
import edu.rice.cs.javalanglevels.tree.BreakStatement;
import edu.rice.cs.javalanglevels.tree.ClassDef;
import edu.rice.cs.javalanglevels.tree.ComplexAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.ConditionalExpression;
import edu.rice.cs.javalanglevels.tree.ContinueStatement;
import edu.rice.cs.javalanglevels.tree.DoStatement;
import edu.rice.cs.javalanglevels.tree.ForStatement;
import edu.rice.cs.javalanglevels.tree.FormalParameter;
import edu.rice.cs.javalanglevels.tree.InnerClassDef;
import edu.rice.cs.javalanglevels.tree.InnerInterfaceDef;
import edu.rice.cs.javalanglevels.tree.InstanceofExpression;
import edu.rice.cs.javalanglevels.tree.InterfaceDef;
import edu.rice.cs.javalanglevels.tree.JExpressionIF;
import edu.rice.cs.javalanglevels.tree.LabeledStatement;
import edu.rice.cs.javalanglevels.tree.ModifiersAndVisibility;
import edu.rice.cs.javalanglevels.tree.PackageStatement;
import edu.rice.cs.javalanglevels.tree.PrimitiveType;
import edu.rice.cs.javalanglevels.tree.SimpleAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.SourceFile;
import edu.rice.cs.javalanglevels.tree.StaticInitializer;
import edu.rice.cs.javalanglevels.tree.SwitchStatement;
import edu.rice.cs.javalanglevels.tree.SynchronizedStatement;
import edu.rice.cs.javalanglevels.tree.TryCatchStatement;
import edu.rice.cs.javalanglevels.tree.TypeParameter;
import edu.rice.cs.javalanglevels.tree.VariableDeclaration;
import edu.rice.cs.javalanglevels.tree.WhileStatement;
import java.io.File;
import java.util.Hashtable;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntermediateVisitor
extends LanguageLevelVisitor {
    public IntermediateVisitor(File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, LinkedList<String> classNamesInThisFile, Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>> continuations) {
        super(file, packageName, importedFiles, importedPackages, classNamesInThisFile, continuations);
    }

    public IntermediateVisitor(File file) {
        this(file, new LinkedList<Pair<String, JExpressionIF>>(), new Symboltable(), new Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>(), new LinkedList<Pair<LanguageLevelVisitor, SourceFile>>(), new Hashtable<SymbolData, LanguageLevelVisitor>());
    }

    public IntermediateVisitor(File file, LinkedList<Pair<String, JExpressionIF>> errors, Symboltable symbolTable, Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>> continuations, LinkedList<Pair<LanguageLevelVisitor, SourceFile>> visitedFiles, Hashtable<SymbolData, LanguageLevelVisitor> newSDs) {
        super(file, "", new LinkedList<String>(), new LinkedList<String>(), new LinkedList<String>(), continuations);
        IntermediateVisitor.errors = errors;
        IntermediateVisitor.symbolTable = symbolTable;
        IntermediateVisitor.visitedFiles = visitedFiles;
        _newSDs = newSDs;
        _hierarchy = new Hashtable();
        _classesToBeParsed = new Hashtable();
    }

    @Override
    public void forModifiersAndVisibilityDoFirst(ModifiersAndVisibility that) {
        String temp;
        String[] modifiersAndVisibility = that.getModifiers();
        StringBuffer sb = new StringBuffer();
        int count = 0;
        for (int i = 0; i < modifiersAndVisibility.length; ++i) {
            temp = modifiersAndVisibility[i];
            if (temp.equals("abstract") || temp.equals("public") || temp.equals("private") || temp.equals("protected") || temp.equals("static")) continue;
            sb.append(" \"" + temp + "\"");
            ++count;
        }
        temp = "The keyword";
        if (sb.length() > 0) {
            if (count > 1) {
                temp = temp + "s";
            }
            IntermediateVisitor._addAndIgnoreError(temp + sb.toString() + " cannot be used at the Intermediate level", that);
            return;
        }
        super.forModifiersAndVisibilityDoFirst(that);
    }

    @Override
    public void forPackageStatementDoFirst(PackageStatement that) {
        IntermediateVisitor._addError("Package statements cannot be used at the Intermediate level.  All Intermediate level classes and interfaces are assumed to be in the default package", that);
    }

    @Override
    public void forInnerClassDefDoFirst(InnerClassDef that) {
        IntermediateVisitor._addError("Inner classes cannot be used at the Intermediate level", that);
    }

    @Override
    public void forInnerInterfaceDefDoFirst(InnerInterfaceDef that) {
        IntermediateVisitor._addError("Nested interfaces cannot be used at the Intermediate level", that);
    }

    @Override
    public void forStaticInitializerDoFirst(StaticInitializer that) {
        IntermediateVisitor._addError("Static initializers cannot be used at the Intermediate level", that);
    }

    @Override
    public void forLabeledStatementDoFirst(LabeledStatement that) {
        IntermediateVisitor._addError("Labeled statements cannot be used at the Intermediate level", that);
    }

    @Override
    public void forSwitchStatementDoFirst(SwitchStatement that) {
        IntermediateVisitor._addError("Switch statements cannot be used at the Intermediate level", that);
    }

    @Override
    public void forWhileStatementDoFirst(WhileStatement that) {
        IntermediateVisitor._addError("While statements cannot be used at the Intermediate level", that);
    }

    @Override
    public void forDoStatementDoFirst(DoStatement that) {
        IntermediateVisitor._addError("Do statements cannot be used at the Intermediate level", that);
    }

    @Override
    public void forForStatementDoFirst(ForStatement that) {
        IntermediateVisitor._addError("For statements cannot be used at the Intermediate level", that);
    }

    @Override
    public void forBreakStatementDoFirst(BreakStatement that) {
        IntermediateVisitor._addError("Break statements cannot be used at the Intermediate level", that);
    }

    @Override
    public void forContinueStatementDoFirst(ContinueStatement that) {
        IntermediateVisitor._addError("Continue statements cannot be used at the Intermediate level", that);
    }

    @Override
    public void forSynchronizedStatementDoFirst(SynchronizedStatement that) {
        IntermediateVisitor._addError("Synchronized statements cannot be used at the Intermediate level", that);
    }

    @Override
    public void forTryCatchStatementDoFirst(TryCatchStatement that) {
        IntermediateVisitor._addAndIgnoreError("A try-catch statement cannot appear here", that);
    }

    @Override
    public void forFormalParameterDoFirst(FormalParameter that) {
        if (that.isIsFinal()) {
            IntermediateVisitor._addError("The keyword \"final\" cannot be used at the Intermediate level", that);
        } else {
            this.forJExpressionDoFirst(that);
        }
    }

    @Override
    public void forTypeParameterDoFirst(TypeParameter that) {
        IntermediateVisitor._addError("Type Parameters cannot be used at the Intermediate level", that);
    }

    @Override
    public void forPrimitiveTypeDoFirst(PrimitiveType that) {
        String name = that.getName();
        if (!(name.equals("int") || name.equals("double") || name.equals("boolean") || name.equals("char"))) {
            IntermediateVisitor._addError("Only the primitive types \"int\", \"double\", \"boolean\", and \"char\" can be used at the Intermediate level", that);
        } else {
            this.forTypeDoFirst(that);
        }
    }

    @Override
    public void forArrayTypeDoFirst(ArrayType that) {
        IntermediateVisitor._addError("Arrays cannot be used at the Intermediate level", that);
    }

    @Override
    public void forConditionalExpressionDoFirst(ConditionalExpression that) {
        IntermediateVisitor._addError("Conditional expressions cannot be used at the Intermediate level", that);
    }

    @Override
    public void forInstanceofExpressionDoFirst(InstanceofExpression that) {
        IntermediateVisitor._addError("Instanceof expressions cannot be used at the Intermediate level", that);
    }

    private boolean _isClassInCurrentFile(String className) {
        for (String s : this._classNamesInThisFile) {
            if (!s.equals(className) && !s.endsWith("." + className)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forClassDef(ClassDef that) {
        int i;
        this.forClassDefDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        String className = this.getQualifiedClassName(that.getName().getText());
        SymbolData sd = this.addSymbolData(that, className);
        that.getMav().visit(this);
        that.getName().visit(this);
        for (i = 0; i < that.getTypeParameters().length; ++i) {
            that.getTypeParameters()[i].visit(this);
        }
        for (i = 0; i < that.getInterfaces().length; ++i) {
            that.getInterfaces()[i].visit(this);
        }
        if (sd != null) {
            that.getBody().visit(new ClassBodyIntermediateVisitor(sd, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, this._classNamesInThisFile, (Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>)continuations));
            IntermediateVisitor.createAccessors(sd, this._file);
            this.createToString(sd);
            this.createHashCode(sd);
            this.createEquals(sd);
        }
        this.forClassDefOnly(that);
        _classesToBeParsed.remove(className);
    }

    @Override
    public void forInterfaceDef(InterfaceDef that) {
        this.forInterfaceDefDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        String className = that.getName().getText();
        that.getMav().visit(this);
        that.getName().visit(this);
        for (int i = 0; i < that.getTypeParameters().length; ++i) {
            that.getTypeParameters()[i].visit(this);
        }
        SymbolData sd = this.addSymbolData(that, this.getQualifiedClassName(className));
        if (sd != null) {
            sd.setInterface(true);
            that.getBody().visit(new InterfaceBodyIntermediateVisitor(sd, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, this._classNamesInThisFile, (Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>)continuations));
        }
        this.forInterfaceDefOnly(that);
        _classesToBeParsed.remove(this.getQualifiedClassName(className));
    }

    @Override
    protected VariableData[] _variableDeclaration2VariableData(VariableDeclaration vd, Data enclosingData) {
        VariableData[] vds = super._variableDeclaration2VariableData(vd, enclosingData);
        for (int i = 0; i < vds.length; ++i) {
            if (vds[i].hasModifier("static") && vds[i].getMav().getModifiers().length > 1 || !vds[i].hasModifier("static") && vds[i].getMav().getModifiers().length > 0) {
                StringBuffer s = new StringBuffer("the keyword(s) ");
                String[] modifiers = vds[i].getMav().getModifiers();
                for (int j = 0; j < modifiers.length; ++j) {
                    if (modifiers[j].equals("static")) continue;
                    s.append("\"" + modifiers[j] + "\" ");
                }
                IntermediateVisitor._addAndIgnoreError("You cannot use " + s.toString() + "to declare a field at the Intermediate level.  Only the keyword 'static' is allowed", vd);
            }
            if (vds[i].hasModifier("static")) {
                vds[i].addModifier("public");
            } else {
                vds[i].addModifier("private");
            }
            vds[i].setFinal();
        }
        return vds;
    }

    protected VariableData[] llVariableDeclaration2VariableData(VariableDeclaration vd, Data enclosingData) {
        return super._variableDeclaration2VariableData(vd, enclosingData);
    }

    public void anonymousClassInstantiationHelper(AnonymousClassInstantiation that, Data enclosing, SymbolData superC) {
        that.getArguments().visit(this);
        SymbolData sd = new SymbolData(this.getQualifiedClassName(enclosing.getSymbolData().getName()) + "$" + enclosing.getSymbolData().preincrementAnonymousInnerClassNum());
        enclosing.addInnerClass(sd);
        sd.setOuterData(enclosing);
        sd.setSuperClass(superC);
        sd.setPackage(this._package);
        this.createToString(sd);
        this.createHashCode(sd);
        this.createEquals(sd);
        that.getBody().visit(new ClassBodyIntermediateVisitor(sd, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, this._classNamesInThisFile, (Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>)continuations));
    }

    public void simpleAnonymousClassInstantiationHelper(SimpleAnonymousClassInstantiation that, Data data) {
        this.forSimpleAnonymousClassInstantiationDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        SymbolData superC = this.getSymbolData(that.getType().getName(), that.getSourceInfo());
        this.anonymousClassInstantiationHelper(that, data, superC);
        this.forSimpleAnonymousClassInstantiationOnly(that);
    }

    public void complexAnonymousClassInstantiationHelper(ComplexAnonymousClassInstantiation that, Data data) {
        this.forComplexAnonymousClassInstantiationDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        that.getEnclosing().visit(this);
        this.anonymousClassInstantiationHelper(that, data, null);
        this.forComplexAnonymousClassInstantiationOnly(that);
    }

    static /* synthetic */ boolean access$000(IntermediateVisitor x0, String x1) {
        return x0._isClassInCurrentFile(x1);
    }
}

