/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.AdvancedVisitor;
import edu.rice.cs.javalanglevels.ArrayData;
import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.ElementaryVisitor;
import edu.rice.cs.javalanglevels.IntermediateVisitor;
import edu.rice.cs.javalanglevels.JExpressionIFPrunableDepthFirstVisitor_void;
import edu.rice.cs.javalanglevels.LanguageLevelConverter;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.Options;
import edu.rice.cs.javalanglevels.PackageData;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.Symboltable;
import edu.rice.cs.javalanglevels.TypeChecker;
import edu.rice.cs.javalanglevels.TypeData;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.parser.JExprParser;
import edu.rice.cs.javalanglevels.parser.ParseException;
import edu.rice.cs.javalanglevels.tree.BitwiseAndExpression;
import edu.rice.cs.javalanglevels.tree.BitwiseAssignmentExpression;
import edu.rice.cs.javalanglevels.tree.BitwiseBinaryExpression;
import edu.rice.cs.javalanglevels.tree.BitwiseNotExpression;
import edu.rice.cs.javalanglevels.tree.BitwiseOrExpression;
import edu.rice.cs.javalanglevels.tree.BitwiseXorExpression;
import edu.rice.cs.javalanglevels.tree.ClassDef;
import edu.rice.cs.javalanglevels.tree.ClassImportStatement;
import edu.rice.cs.javalanglevels.tree.ComplexNameReference;
import edu.rice.cs.javalanglevels.tree.CompoundWord;
import edu.rice.cs.javalanglevels.tree.EmptyExpression;
import edu.rice.cs.javalanglevels.tree.FormalParameter;
import edu.rice.cs.javalanglevels.tree.InitializedVariableDeclarator;
import edu.rice.cs.javalanglevels.tree.InnerClassDef;
import edu.rice.cs.javalanglevels.tree.InnerInterfaceDef;
import edu.rice.cs.javalanglevels.tree.InterfaceDef;
import edu.rice.cs.javalanglevels.tree.JExpressionIF;
import edu.rice.cs.javalanglevels.tree.JExpressionIFAbstractVisitor;
import edu.rice.cs.javalanglevels.tree.MemberType;
import edu.rice.cs.javalanglevels.tree.MethodDef;
import edu.rice.cs.javalanglevels.tree.ModifiersAndVisibility;
import edu.rice.cs.javalanglevels.tree.NoOpExpression;
import edu.rice.cs.javalanglevels.tree.NullLiteral;
import edu.rice.cs.javalanglevels.tree.PackageImportStatement;
import edu.rice.cs.javalanglevels.tree.PackageStatement;
import edu.rice.cs.javalanglevels.tree.ReferenceType;
import edu.rice.cs.javalanglevels.tree.ShiftAssignmentExpression;
import edu.rice.cs.javalanglevels.tree.ShiftBinaryExpression;
import edu.rice.cs.javalanglevels.tree.SimpleNameReference;
import edu.rice.cs.javalanglevels.tree.SimpleNamedClassInstantiation;
import edu.rice.cs.javalanglevels.tree.SourceFile;
import edu.rice.cs.javalanglevels.tree.StringLiteral;
import edu.rice.cs.javalanglevels.tree.Type;
import edu.rice.cs.javalanglevels.tree.TypeDefBase;
import edu.rice.cs.javalanglevels.tree.TypeParameter;
import edu.rice.cs.javalanglevels.tree.VariableDeclaration;
import edu.rice.cs.javalanglevels.tree.VariableDeclarator;
import edu.rice.cs.javalanglevels.tree.Word;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.ComposedIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.reflect.EmptyClassLoader;
import edu.rice.cs.plt.reflect.PathClassLoader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageLevelVisitor
extends JExpressionIFPrunableDepthFirstVisitor_void {
    protected static LinkedList<Pair<String, JExpressionIF>> errors;
    static Symboltable symbolTable;
    static Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>> continuations;
    static Hashtable<SymbolData, LanguageLevelVisitor> _newSDs;
    static LinkedList<Pair<LanguageLevelVisitor, SourceFile>> visitedFiles;
    static boolean _errorAdded;
    File _file;
    String _package;
    LinkedList<String> _importedFiles;
    LinkedList<String> _importedPackages;
    LinkedList<String> _classNamesInThisFile;
    static Hashtable<String, TypeDefBase> _hierarchy;
    static Hashtable<String, Pair<TypeDefBase, LanguageLevelVisitor>> _classesToBeParsed;
    private static final Thunk<ClassLoader> RESOURCES;

    public LanguageLevelVisitor(File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, LinkedList<String> classNamesInThisFile, Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>> continuations) {
        this._file = file;
        this._package = packageName;
        this._importedFiles = importedFiles;
        this._importedPackages = importedPackages;
        this._classNamesInThisFile = classNamesInThisFile;
        LanguageLevelVisitor.continuations = continuations;
    }

    public LanguageLevelVisitor createANewInstanceOfMe(File file) {
        return new LanguageLevelVisitor(file, "", new LinkedList<String>(), new LinkedList<String>(), new LinkedList<String>(), continuations);
    }

    public LanguageLevelVisitor(File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, LinkedList<String> classNamesInThisFile, Hashtable<String, Pair<TypeDefBase, LanguageLevelVisitor>> classesToBeParsed, Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>> continuations) {
        this(file, packageName, importedFiles, importedPackages, classNamesInThisFile, continuations);
        _classesToBeParsed = classesToBeParsed;
    }

    protected void _resetNonStaticFields() {
        this._file = new File("");
        this._package = "";
        this._importedFiles = new LinkedList();
        this._importedPackages = new LinkedList();
        this._classNamesInThisFile = new LinkedList();
    }

    public static String getFieldAccessorName(String name) {
        return name;
    }

    public File getFile() {
        return this._file;
    }

    protected boolean isConstructor(Data d) {
        if (!(d instanceof MethodData)) {
            return false;
        }
        MethodData md = (MethodData)d;
        return md.getReturnType() != null && md.getSymbolData() != null && md.getReturnType().getName().indexOf(md.getName()) != -1 && md.getReturnType() == md.getSymbolData();
    }

    public static String getUnqualifiedClassName(String className) {
        int lastIndexOfDollar;
        int lastIndexOfDot = className.lastIndexOf(".");
        if (lastIndexOfDot != -1) {
            className = className.substring(lastIndexOfDot + 1);
        }
        if ((lastIndexOfDollar = className.lastIndexOf("$")) != -1) {
            className = className.substring(lastIndexOfDollar + 1);
        }
        while (className.length() > 0 && Character.isDigit(className.charAt(0))) {
            className = className.substring(1, className.length());
        }
        return className;
    }

    protected String[] referenceType2String(ReferenceType[] rts) {
        String[] throwStrings = new String[rts.length];
        for (int i = 0; i < throwStrings.length; ++i) {
            throwStrings[i] = rts[i].getName();
        }
        return throwStrings;
    }

    private SymbolData _classFile2SymbolData(String qualifiedClassName, String directoryName) {
        SymbolData sd;
        ClassReader reader = null;
        try {
            String fileName = qualifiedClassName.replace('.', '/') + ".class";
            InputStream stream = RESOURCES.value().getResourceAsStream(fileName);
            if (stream == null && directoryName != null) {
                stream = PathClassLoader.getResourceInPathAsStream(fileName, new File(directoryName));
            }
            if (stream == null) {
                return null;
            }
            reader = new ClassReader(IOUtil.toByteArray(stream));
        }
        catch (IOException e) {
            return null;
        }
        SymbolData sdLookup = symbolTable.get(qualifiedClassName);
        if (sdLookup == null) {
            sd = new SymbolData(qualifiedClassName);
            symbolTable.put(qualifiedClassName, sd);
        } else {
            sd = sdLookup;
        }
        sd.setIsContinuation(false);
        final SourceInfo lookupInfo = this._makeSourceInfo(qualifiedClassName);
        final String unqualifiedClassName = LanguageLevelVisitor.getUnqualifiedClassName(qualifiedClassName);
        ClassVisitor extractData = new ClassVisitor(){

            public void visit(int version, int access, String name, String sig, String sup, String[] interfaces) {
                sd.setMav(LanguageLevelVisitor.this._createMav(access));
                sd.setInterface(Modifier.isInterface(access));
                int slash = name.lastIndexOf(47);
                if (slash == -1) {
                    sd.setPackage("");
                } else {
                    sd.setPackage(name.substring(0, slash).replace('/', '.'));
                }
                if (sup == null) {
                    sd.setSuperClass(null);
                } else {
                    sd.setSuperClass(LanguageLevelVisitor.this.getSymbolDataForClassFile(sup.replace('/', '.'), lookupInfo));
                }
                if (interfaces != null) {
                    for (String iName : interfaces) {
                        SymbolData superInterface = LanguageLevelVisitor.this.getSymbolDataForClassFile(iName.replace('/', '.'), lookupInfo);
                        if (superInterface == null) continue;
                        sd.addInterface(superInterface);
                    }
                }
            }

            public FieldVisitor visitField(int access, String name, String desc, String sig, Object value) {
                String typeString = org.objectweb.asm.Type.getType(desc).getClassName();
                SymbolData type = LanguageLevelVisitor.this.getSymbolDataForClassFile(typeString, lookupInfo);
                if (type != null) {
                    sd.addVar(new VariableData(name, LanguageLevelVisitor.this._createMav(access), type, true, sd));
                }
                return null;
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String sig, String[] exceptions) {
                int i;
                SymbolData returnType;
                String methodName;
                boolean valid = true;
                if (name.equals("<init>")) {
                    methodName = unqualifiedClassName;
                    returnType = sd;
                } else {
                    methodName = name;
                    String returnString = org.objectweb.asm.Type.getReturnType(desc).getClassName();
                    returnType = LanguageLevelVisitor.this.getSymbolDataForClassFile(returnString, lookupInfo);
                    valid = valid && returnType != null;
                }
                org.objectweb.asm.Type[] argTypes = org.objectweb.asm.Type.getArgumentTypes(desc);
                VariableData[] args = new VariableData[argTypes.length];
                for (i = 0; i < argTypes.length; ++i) {
                    SymbolData argType = LanguageLevelVisitor.this.getSymbolDataForClassFile(argTypes[i].getClassName(), lookupInfo);
                    if (argType == null) {
                        valid = false;
                        continue;
                    }
                    args[i] = new VariableData(argType);
                }
                if (exceptions == null) {
                    exceptions = new String[]{};
                }
                for (i = 0; i < exceptions.length; ++i) {
                    exceptions[i] = exceptions[i].replace('/', '.');
                }
                if (valid) {
                    MethodData m = new MethodData(methodName, LanguageLevelVisitor.this._createMav(access), new TypeParameter[0], returnType, args, exceptions, sd, null);
                    for (VariableData arg : args) {
                        arg.setEnclosingData(m);
                    }
                    sd.addMethod(m, false, true);
                }
                return null;
            }

            public void visitSource(String source, String debug) {
            }

            public void visitOuterClass(String owner, String name, String desc) {
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                return null;
            }

            public void visitAttribute(Attribute attr) {
            }

            public void visitInnerClass(String name, String outerName, String innerName, int access) {
            }

            public void visitEnd() {
            }
        };
        reader.accept(extractData, 1);
        continuations.remove(qualifiedClassName);
        return sd;
    }

    protected SourceInfo _makeSourceInfo(String qualifiedClassName) {
        return new SourceInfo(new File(qualifiedClassName), -1, -1, -1, -1);
    }

    private SymbolData _lookupFromClassesToBeParsed(String qualifiedClassName, SourceInfo si, boolean resolve) {
        if (resolve) {
            Pair<TypeDefBase, LanguageLevelVisitor> p = _classesToBeParsed.get(qualifiedClassName);
            if (p == null) {
                return null;
            }
            TypeDefBase cd = p.getFirst();
            LanguageLevelVisitor llv = p.getSecond();
            cd.visit(llv);
            return symbolTable.get(qualifiedClassName);
        }
        continuations.put(qualifiedClassName, new Pair<SourceInfo, LanguageLevelVisitor>(si, this));
        SymbolData sd = new SymbolData(qualifiedClassName);
        symbolTable.put(qualifiedClassName, sd);
        return sd;
    }

    public static boolean isJavaLibraryClass(String className) {
        return className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("org.ietf.") || className.startsWith("org.omg.") || className.startsWith("org.w3c.") || className.startsWith("org.xml.") || className.startsWith("sun.") || className.startsWith("junit.framework.");
    }

    public static boolean isDuplicateVariableData(LinkedList<VariableData> vds, VariableData toInsert) {
        for (int i = 0; i < vds.size(); ++i) {
            VariableData temp = vds.get(i);
            if (!temp.getName().equals(toInsert.getName())) continue;
            return true;
        }
        return false;
    }

    protected SymbolData getSymbolDataForClassFile(String className, SourceInfo si) {
        SymbolData sd = this.getSymbolDataHelper(className, si, true, true, true, false);
        if (sd == null) {
            LanguageLevelVisitor._addAndIgnoreError("Class " + className + " not found.", new NullLiteral(si));
            return null;
        }
        sd.setIsContinuation(false);
        continuations.remove(sd.getName());
        return sd;
    }

    private SymbolData _getSymbolData_Primitive(String className) {
        if (className.equals("boolean")) {
            return SymbolData.BOOLEAN_TYPE;
        }
        if (className.equals("char")) {
            return SymbolData.CHAR_TYPE;
        }
        if (className.equals("byte")) {
            return SymbolData.BYTE_TYPE;
        }
        if (className.equals("short")) {
            return SymbolData.SHORT_TYPE;
        }
        if (className.equals("int")) {
            return SymbolData.INT_TYPE;
        }
        if (className.equals("long")) {
            return SymbolData.LONG_TYPE;
        }
        if (className.equals("float")) {
            return SymbolData.FLOAT_TYPE;
        }
        if (className.equals("double")) {
            return SymbolData.DOUBLE_TYPE;
        }
        if (className.equals("void")) {
            return SymbolData.VOID_TYPE;
        }
        if (className.equals("null")) {
            return SymbolData.NULL_TYPE;
        }
        return null;
    }

    private SymbolData _getSymbolData_IsQualified(String className, SourceInfo si, boolean resolve, boolean fromClassFile, boolean addError) {
        SymbolData sd = symbolTable.get(className);
        if (sd != null && (!sd.isContinuation() || fromClassFile)) {
            return sd;
        }
        if (LanguageLevelVisitor.isJavaLibraryClass(className)) {
            return this._classFile2SymbolData(className, null);
        }
        sd = this._getSymbolData_FromFileSystem(className, si, resolve, addError);
        if (sd != SymbolData.KEEP_GOING) {
            return sd;
        }
        if (addError) {
            LanguageLevelVisitor._addAndIgnoreError("The class " + className + " was not found.", new NullLiteral(si));
        }
        return null;
    }

    private SymbolData _getSymbolData_ArrayType(String className, SourceInfo si, boolean resolve, boolean fromClassFile, boolean addError, boolean checkImportedPackages) {
        SymbolData innerSd = this.getSymbolDataHelper(className.substring(0, className.length() - 2), si, resolve, fromClassFile, addError, checkImportedPackages);
        if (innerSd != null) {
            SymbolData sd = symbolTable.get(innerSd.getName() + "[]");
            if (sd != null) {
                return sd;
            }
            sd = new ArrayData(innerSd, this, si);
            symbolTable.put(sd.getName(), sd);
            return sd;
        }
        return null;
    }

    private SymbolData _getSymbolData_FromCurrFile(String qualifiedClassName, SourceInfo si, boolean resolve) {
        SymbolData sd = symbolTable.get(qualifiedClassName);
        if (sd == null || sd.isContinuation() && resolve) {
            return this._lookupFromClassesToBeParsed(qualifiedClassName, si, resolve);
        }
        return sd;
    }

    /*
     * WARNING - void declaration
     */
    private SymbolData _getSymbolData_FromFileSystem(String qualifiedClassName, SourceInfo si, boolean resolve, boolean addError) {
        SymbolData sd;
        String newPath;
        String path;
        Pair<TypeDefBase, LanguageLevelVisitor> pair = _classesToBeParsed.get(qualifiedClassName);
        if (pair != null) {
            return this._lookupFromClassesToBeParsed(qualifiedClassName, si, resolve);
        }
        File parent = this._file.getParentFile();
        String directoryName = "";
        if (parent != null) {
            directoryName = parent.getAbsolutePath();
        }
        String qualifiedClassNameWithSlashes = qualifiedClassName.replace('.', System.getProperty("file.separator").charAt(0));
        if (directoryName != null) {
            String newPackage = this._package.replace('.', System.getProperty("file.separator").charAt(0));
            int indexOfPackage = directoryName.length();
            if (newPackage.length() > 0) {
                indexOfPackage = directoryName.indexOf(newPackage) - 1;
            }
            if (indexOfPackage < 0) {
                indexOfPackage = directoryName.length();
            }
            directoryName = directoryName.substring(0, indexOfPackage);
            path = directoryName + System.getProperty("file.separator") + qualifiedClassNameWithSlashes;
        } else {
            path = qualifiedClassName;
        }
        String newPackage = "";
        int lastSlash = qualifiedClassNameWithSlashes.lastIndexOf(System.getProperty("file.separator"));
        if (lastSlash != -1) {
            newPackage = qualifiedClassNameWithSlashes.substring(0, lastSlash);
            newPath = directoryName + System.getProperty("file.separator") + newPackage;
            newPackage = newPackage.replace(System.getProperty("file.separator").charAt(0), '.');
        } else {
            int lastSlashInPath = path.lastIndexOf(System.getProperty("file.separator"));
            newPath = lastSlashInPath != -1 ? path.substring(0, lastSlashInPath) : "";
        }
        File classFile = new File(path + ".class");
        File[] sourceFiles = new File(newPath).listFiles(new FileFilter(){

            public boolean accept(File f) {
                try {
                    f = f.getCanonicalFile();
                    return new File(path + ".dj0").getCanonicalFile().equals(f) || new File(path + ".dj1").getCanonicalFile().equals(f) || new File(path + ".dj2").getCanonicalFile().equals(f);
                }
                catch (IOException e) {
                    return false;
                }
            }
        });
        File sourceFile = null;
        if (sourceFiles != null) {
            void var20_33;
            long mostRecentTime = 0L;
            File[] arr$ = sourceFiles;
            int len$ = arr$.length;
            boolean bl = false;
            while (var20_33 < len$) {
                File f = arr$[var20_33];
                long currentLastModified = f.lastModified();
                if (f.exists() && mostRecentTime < currentLastModified) {
                    mostRecentTime = currentLastModified;
                    sourceFile = f;
                }
                ++var20_33;
            }
        }
        if ((sd = symbolTable.get(qualifiedClassName)) != null && !sd.isContinuation()) {
            return sd;
        }
        if (sourceFile != null) {
            if (!resolve) {
                if (sd != null) {
                    return sd;
                }
                sd = new SymbolData(qualifiedClassName);
                continuations.put(qualifiedClassName, new Pair<SourceInfo, LanguageLevelVisitor>(si, this.createANewInstanceOfMe(sourceFile)));
                symbolTable.put(qualifiedClassName, sd);
                return sd;
            }
            if (sourceFile.lastModified() > classFile.lastModified()) {
                SourceFile sf;
                LanguageLevelVisitor lv;
                if (!sourceFile.canRead()) {
                    if (addError) {
                        LanguageLevelVisitor._addAndIgnoreError("The file " + sourceFile.getAbsolutePath() + " is present, but does not have proper read permissions", new NullLiteral(si));
                    }
                    return null;
                }
                if (!new File(newPath).canWrite()) {
                    if (addError) {
                        LanguageLevelVisitor._addAndIgnoreError("The file " + sourceFile.getAbsolutePath() + " needs to be recompiled, but its directory does not have proper write permissions", new NullLiteral(si));
                    }
                    return null;
                }
                try {
                    File canonicalSource = sourceFile.getCanonicalFile();
                    boolean alreadyVisited = false;
                    try {
                        alreadyVisited |= this._file.getCanonicalFile().equals(canonicalSource);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (!alreadyVisited) {
                        for (Pair pair2 : visitedFiles) {
                            try {
                                if (!(alreadyVisited |= ((LanguageLevelVisitor)pair2.getFirst())._file.getCanonicalFile().equals(canonicalSource))) continue;
                                break;
                            }
                            catch (IOException e) {
                            }
                        }
                    }
                    if (alreadyVisited) {
                        return SymbolData.KEEP_GOING;
                    }
                }
                catch (IOException e) {
                    if (addError) {
                        LanguageLevelVisitor._addAndIgnoreError("The file " + sourceFile.getAbsolutePath() + " is present, but its full path cannot be resolved (symbolic links may not have proper permissions)", new NullLiteral(si));
                    }
                    return null;
                }
                if (LanguageLevelConverter.isElementaryFile(sourceFile)) {
                    lv = new ElementaryVisitor(sourceFile, errors, symbolTable, continuations, visitedFiles, _newSDs);
                } else if (LanguageLevelConverter.isIntermediateFile(sourceFile)) {
                    lv = new IntermediateVisitor(sourceFile, errors, symbolTable, continuations, visitedFiles, _newSDs);
                } else if (LanguageLevelConverter.isAdvancedFile(sourceFile)) {
                    lv = new AdvancedVisitor(sourceFile, errors, symbolTable, continuations, visitedFiles, _newSDs);
                } else {
                    throw new RuntimeException("Internal Program Error: Invalid file format not caught initially" + sourceFile.getName() + ". Please report this bug");
                }
                try {
                    JExprParser jep = new JExprParser(sourceFile);
                    sf = jep.SourceFile();
                }
                catch (ParseException pe) {
                    if (addError) {
                        LanguageLevelVisitor._addAndIgnoreError(pe.getMessage(), new NullLiteral(new SourceInfo(sourceFile, pe.currentToken.beginLine, pe.currentToken.beginColumn, pe.currentToken.endLine, pe.currentToken.endColumn)));
                    }
                    return null;
                }
                catch (FileNotFoundException fnfe) {
                    if (addError) {
                        LanguageLevelVisitor._addAndIgnoreError("File " + sourceFile + " could not be found.", new NullLiteral(si));
                    }
                    return null;
                }
                int numErrors = errors.size();
                sf.visit(lv);
                if (numErrors != errors.size()) {
                    return null;
                }
                block14: while (true) {
                    if (continuations.isEmpty()) break;
                    Enumeration<String> enumeration = continuations.keys();
                    while (true) {
                        if (!enumeration.hasMoreElements()) continue block14;
                        String className = enumeration.nextElement();
                        Pair<SourceInfo, LanguageLevelVisitor> p = continuations.remove(className);
                        SymbolData returnedSd = p.getSecond().getSymbolData(className, p.getFirst(), true);
                    }
                    break;
                }
                block16: while (true) {
                    if (_newSDs.isEmpty()) break;
                    Enumeration<SymbolData> enumeration = _newSDs.keys();
                    while (true) {
                        if (!enumeration.hasMoreElements()) continue block16;
                        SymbolData first = enumeration.nextElement();
                        LanguageLevelVisitor sdlv = _newSDs.remove(first);
                        sdlv.createConstructor(first);
                    }
                    break;
                }
                sf.visit(new TypeChecker(sourceFile, newPackage, errors, symbolTable, lv._importedFiles, lv._importedPackages));
                sd = symbolTable.get(qualifiedClassName);
                if (sd == null || sd.isContinuation()) {
                    if (addError) {
                        LanguageLevelVisitor._addAndIgnoreError("File " + sourceFile + " does not contain class " + qualifiedClassName, sf);
                    }
                    return null;
                }
                visitedFiles.add(new Pair<ElementaryVisitor, SourceFile>((ElementaryVisitor)lv, sf));
                return sd;
            }
        }
        if (classFile.exists()) {
            sd = this._classFile2SymbolData(qualifiedClassName, directoryName);
            if (sd == null) {
                if (addError) {
                    LanguageLevelVisitor._addAndIgnoreError("File " + classFile + " is not a valid class file.", null);
                }
                return null;
            }
            if (sourceFile != null) {
                try {
                    SourceFile sf = new JExprParser(sourceFile).SourceFile();
                }
                catch (ParseException pe) {
                    if (addError) {
                        LanguageLevelVisitor._addAndIgnoreError(pe.getMessage(), new NullLiteral(new SourceInfo(sourceFile, pe.currentToken.beginLine, pe.currentToken.beginColumn, pe.currentToken.endLine, pe.currentToken.endColumn)));
                    }
                    return null;
                }
                catch (FileNotFoundException fnfe) {
                    if (addError) {
                        LanguageLevelVisitor._addAndIgnoreError("File " + sourceFile + " could not be found.", new NullLiteral(si));
                    }
                    return null;
                }
                LanguageLevelVisitor lv = this.createANewInstanceOfMe(sourceFile);
                lv._package = newPackage;
                visitedFiles.add(new Pair<LanguageLevelVisitor, Object>(lv, null));
            }
            return sd;
        }
        return SymbolData.KEEP_GOING;
    }

    protected SymbolData getSymbolData(String className, SourceInfo si) {
        return this.getSymbolData(className, si, false, false, true, true);
    }

    public SymbolData getSymbolData(String className, SourceInfo si, boolean resolve) {
        SymbolData sd = this.getSymbolData(className, si, resolve, false, true, true);
        if (resolve && sd != null) {
            if (sd.isContinuation()) {
                throw new RuntimeException("Internal Program Error: " + sd.getName() + " should not be a continuation.  Please report this bug.");
            }
            continuations.remove(sd.getName());
        }
        return sd;
    }

    protected SymbolData getSymbolData(String className, SourceInfo si, boolean resolve, boolean fromClassFile) {
        return this.getSymbolData(className, si, resolve, fromClassFile, true, true);
    }

    protected SymbolData getSymbolData(String className, SourceInfo si, boolean resolve, boolean fromClassFile, boolean addError) {
        return this.getSymbolData(className, si, resolve, fromClassFile, addError, true);
    }

    protected SymbolData getSymbolData(String className, SourceInfo si, boolean resolve, boolean fromClassFile, boolean addError, boolean checkImportedStuff) {
        int indexOfNextDot = className.indexOf(".");
        int indexOfNextDollar = className.indexOf("$");
        if (indexOfNextDot == -1 && indexOfNextDollar == -1) {
            return this.getSymbolDataHelper(className, si, resolve, fromClassFile, addError, checkImportedStuff);
        }
        indexOfNextDot = 0;
        int length = className.length();
        while (indexOfNextDot != length) {
            boolean newResolve;
            String s;
            SymbolData whatever;
            if ((indexOfNextDot = className.indexOf(".", indexOfNextDot + 1)) == -1) {
                indexOfNextDot = length;
            }
            if ((whatever = this.getSymbolDataHelper(s = className.substring(0, indexOfNextDot), si, newResolve = resolve || indexOfNextDot != length, fromClassFile, false, checkImportedStuff)) == null) continue;
            String innerClassName = "";
            SymbolData outerClass = whatever;
            if (whatever != null && indexOfNextDot != length) {
                outerClass = whatever;
                innerClassName = className.substring(indexOfNextDot + 1);
                whatever = outerClass.getInnerClassOrInterface(innerClassName);
            }
            if (whatever == SymbolData.AMBIGUOUS_REFERENCE) {
                LanguageLevelVisitor._addAndIgnoreError("Ambiguous reference to class or interface " + className, new NullLiteral(si));
                return null;
            }
            if (whatever != null) {
                return whatever;
            }
            if (className.endsWith("[]")) {
                SymbolData sd = this.getSymbolData(className.substring(0, className.length() - 2), si, resolve, fromClassFile, addError, checkImportedStuff);
                if (sd != null) {
                    ArrayData ad = new ArrayData(sd, this, si);
                    symbolTable.put(ad.getName(), ad);
                    return ad;
                }
                return sd;
            }
            if (addError) {
                LanguageLevelVisitor._addAndIgnoreError("Class " + innerClassName + " is not an inner class of the class " + outerClass.getName(), new NullLiteral(si));
            }
            return null;
        }
        if (!fromClassFile && addError) {
            String newName = className;
            int lastDollar = newName.lastIndexOf("$");
            newName = newName.substring(lastDollar + 1, newName.length());
            LanguageLevelVisitor._addAndIgnoreError("Invalid class name " + newName, new NullLiteral(si));
        }
        return null;
    }

    protected SymbolData getSymbolData(TypeData lhs, String name, SourceInfo si, boolean addError) {
        boolean resolve = false;
        boolean fromClassFile = false;
        boolean checkImportedStuff = false;
        if (lhs == null) {
            return null;
        }
        if (lhs instanceof PackageData) {
            String className = lhs.getName() + "." + name;
            return this.getSymbolDataHelper(className, si, resolve, fromClassFile, addError, checkImportedStuff);
        }
        SymbolData result = lhs.getInnerClassOrInterface(name);
        if (result == SymbolData.AMBIGUOUS_REFERENCE) {
            if (addError) {
                LanguageLevelVisitor._addAndIgnoreError("Ambiguous reference to class or interface " + name, new NullLiteral(si));
            }
            return null;
        }
        return result;
    }

    protected SymbolData getSymbolDataHelper(String className, SourceInfo si, boolean resolve, boolean fromClassFile, boolean addError, boolean checkImportedStuff) {
        SymbolData sd = this._getSymbolData_Primitive(className);
        if (sd != null) {
            return sd;
        }
        if (className.endsWith("[]")) {
            return this._getSymbolData_ArrayType(className, si, resolve, fromClassFile, addError, checkImportedStuff);
        }
        if (className.indexOf(".") != -1) {
            return this._getSymbolData_IsQualified(className, si, resolve, fromClassFile, addError);
        }
        Object name = null;
        String qualifiedClassName = this.getQualifiedClassName(className);
        if (this._classNamesInThisFile.contains(qualifiedClassName)) {
            return this._getSymbolData_FromCurrFile(qualifiedClassName, si, resolve);
        }
        Iterator iter = this._importedFiles.iterator();
        if (checkImportedStuff) {
            while (iter.hasNext()) {
                String s = (String)iter.next();
                if (!s.endsWith(className)) continue;
                SymbolData tempSd = symbolTable.get(s);
                if (resolve && tempSd.isContinuation()) {
                    return this.getSymbolData(s, si, resolve, fromClassFile, addError, false);
                }
                return tempSd;
            }
        }
        if (className.indexOf(".") == -1 || !this._package.equals("") && className.startsWith(this._package)) {
            sd = symbolTable.get(qualifiedClassName);
            if (sd == null || sd.isContinuation() && resolve) {
                sd = this._getSymbolData_FromFileSystem(qualifiedClassName, si, resolve, addError);
                if (sd != SymbolData.KEEP_GOING) {
                    return sd;
                }
            } else {
                return sd;
            }
        }
        SymbolData resultSd = null;
        if (checkImportedStuff) {
            iter = this._importedPackages.iterator();
            while (iter.hasNext()) {
                String s = (String)iter.next() + "." + className;
                SymbolData tempSd = s.indexOf("$") != -1 ? this.getSymbolData(s, si, resolve, fromClassFile, false, false) : this.getSymbolDataHelper(s, si, resolve, fromClassFile, false, false);
                if (tempSd == null) continue;
                if (resultSd == null) {
                    resultSd = tempSd;
                    continue;
                }
                if (!addError) continue;
                LanguageLevelVisitor._addAndIgnoreError("The class name " + className + " is ambiguous.  It could be " + resultSd.getName() + " or " + tempSd.getName(), new NullLiteral(si));
                return null;
            }
        }
        return resultSd;
    }

    private ModifiersAndVisibility _createMav(int flags) {
        LinkedList<String> strings = new LinkedList<String>();
        if (Modifier.isAbstract(flags)) {
            strings.addLast("abstract");
        }
        if (Modifier.isFinal(flags)) {
            strings.addLast("final");
        }
        if (Modifier.isNative(flags)) {
            strings.addLast("native");
        }
        if (Modifier.isPrivate(flags)) {
            strings.addLast("private");
        }
        if (Modifier.isProtected(flags)) {
            strings.addLast("protected");
        }
        if (Modifier.isPublic(flags)) {
            strings.addLast("public");
        }
        if (Modifier.isStatic(flags)) {
            strings.addLast("static");
        }
        if (Modifier.isStrict(flags)) {
            strings.addLast("strictfp");
        }
        if (Modifier.isSynchronized(flags)) {
            strings.addLast("synchronized");
        }
        if (Modifier.isTransient(flags)) {
            strings.addLast("transient");
        }
        if (Modifier.isVolatile(flags)) {
            strings.addLast("volatile");
        }
        return new ModifiersAndVisibility(JExprParser.NO_SOURCE_INFO, strings.toArray(new String[strings.size()]));
    }

    protected String getQualifiedClassName(String className) {
        if (!this._package.equals("") && !className.startsWith(this._package)) {
            return this._package + "." + className;
        }
        return className;
    }

    protected SymbolData addInnerSymbolData(TypeDefBase typeDefBase, String qualifiedClassName, String partialName, Data enclosing, boolean isClass) {
        SymbolData sd = symbolTable.get(qualifiedClassName);
        if (sd == null) {
            sd = enclosing.getInnerClassOrInterface(partialName);
        }
        if (sd != null && !sd.isContinuation()) {
            LanguageLevelVisitor._addAndIgnoreError("This class has already been defined.", typeDefBase);
            return null;
        }
        if (sd != null && sd.getOuterData() != enclosing) {
            sd = null;
        }
        if (sd == null) {
            sd = new SymbolData(qualifiedClassName);
            sd.setOuterData(enclosing);
            if (isClass) {
                enclosing.getSymbolData().addInnerClass(sd);
            } else {
                enclosing.getSymbolData().addInnerInterface(sd);
            }
        }
        LinkedList<SymbolData> interfaces = new LinkedList<SymbolData>();
        ReferenceType[] rts = typeDefBase.getInterfaces();
        for (int i = 0; i < rts.length; ++i) {
            SymbolData tempSd = this.getSymbolData(rts[i].getName(), rts[i].getSourceInfo(), false, false, false);
            if (tempSd != null) {
                interfaces.addLast(tempSd);
                continue;
            }
            if (enclosing instanceof SymbolData) {
                tempSd = enclosing.getInnerClassOrInterface(rts[i].getName());
                if (tempSd == null) {
                    String qualifyingPart = qualifiedClassName.substring(0, qualifiedClassName.lastIndexOf("$"));
                    tempSd = new SymbolData(qualifyingPart + "$" + rts[i].getName());
                    tempSd.setInterface(true);
                    enclosing.getSymbolData().addInnerInterface(tempSd);
                    tempSd.setOuterData(enclosing);
                    continuations.put(rts[i].getName(), new Pair<SourceInfo, LanguageLevelVisitor>(rts[i].getSourceInfo(), this));
                }
                interfaces.addLast(tempSd);
                continue;
            }
            LanguageLevelVisitor._addAndIgnoreError("Cannot resolve interface " + rts[i].getName(), rts[i]);
            return null;
        }
        sd.setPackage(this._package);
        SymbolData superClass = null;
        if (typeDefBase instanceof InterfaceDef) {
            superClass = this.getSymbolData("Object", typeDefBase.getSourceInfo(), false);
            sd.setInterface(true);
        } else if (typeDefBase instanceof ClassDef) {
            ClassDef cd = (ClassDef)typeDefBase;
            ReferenceType rt = cd.getSuperclass();
            String superClassName = rt.getName();
            superClass = this.getSymbolData(superClassName, rt.getSourceInfo(), false, false, false);
            if (superClass == null && (superClass = enclosing.getInnerClassOrInterface(superClassName)) == null) {
                String qualifyingPart = qualifiedClassName.substring(0, qualifiedClassName.lastIndexOf("$"));
                superClass = new SymbolData(qualifyingPart + "$" + superClassName);
                enclosing.addInnerClass(superClass);
                superClass.setOuterData(enclosing);
                continuations.put(superClassName, new Pair<SourceInfo, LanguageLevelVisitor>(rt.getSourceInfo(), this));
            }
            sd.setInterface(false);
        } else {
            throw new RuntimeException("Internal Program Error: typeDefBase was not a ClassDef or InterfaceDef.  Please report this bug.");
        }
        sd.setMav(typeDefBase.getMav());
        sd.setTypeParameters(typeDefBase.getTypeParameters());
        sd.setSuperClass(superClass);
        sd.setInterfaces(interfaces);
        sd.setIsContinuation(false);
        continuations.remove(sd.getName());
        if (sd != null && !sd.isInterface()) {
            _newSDs.put(sd, this);
        }
        return sd;
    }

    protected SymbolData addSymbolData(TypeDefBase typeDefBase, String qualifiedClassName) {
        String name = qualifiedClassName;
        SymbolData sd = symbolTable.get(name);
        if (sd != null && !sd.isContinuation()) {
            LanguageLevelVisitor._addAndIgnoreError("This class has already been defined.", typeDefBase);
            return null;
        }
        LinkedList<SymbolData> interfaces = new LinkedList<SymbolData>();
        ReferenceType[] rts = typeDefBase.getInterfaces();
        for (int i = 0; i < rts.length; ++i) {
            SymbolData tempSd = this.getSymbolData(rts[i].getName(), rts[i].getSourceInfo(), false, false, false);
            if (tempSd != null) {
                interfaces.addLast(tempSd);
                continue;
            }
            if (qualifiedClassName.indexOf("$") != -1) {
                String qualifyingPart = qualifiedClassName.substring(0, qualifiedClassName.lastIndexOf("$"));
                tempSd = this.getSymbolData(qualifyingPart + "$" + rts[i].getName(), rts[i].getSourceInfo(), false, false, false);
                if (tempSd == null) {
                    tempSd = new SymbolData(qualifyingPart + "$" + rts[i].getName());
                    tempSd.setInterface(true);
                    continuations.put(rts[i].getName(), new Pair<SourceInfo, LanguageLevelVisitor>(rts[i].getSourceInfo(), this));
                }
                interfaces.addLast(tempSd);
                continue;
            }
            if (tempSd != null) continue;
            LanguageLevelVisitor._addAndIgnoreError("Could not resolve " + rts[i].getName(), rts[i]);
            return null;
        }
        if (sd == null) {
            sd = new SymbolData(name);
            symbolTable.put(name, sd);
        }
        sd.setPackage(this._package);
        SymbolData superClass = null;
        if (typeDefBase instanceof InterfaceDef) {
            superClass = this.getSymbolData("Object", typeDefBase.getSourceInfo(), false);
            sd.setInterface(true);
        } else if (typeDefBase instanceof ClassDef) {
            ClassDef cd = (ClassDef)typeDefBase;
            ReferenceType rt = cd.getSuperclass();
            String superClassName = rt.getName();
            superClass = this.getSymbolData(superClassName, rt.getSourceInfo(), false);
            if (superClass == null) {
                superClass = this.getSymbolData("java.lang.Object", typeDefBase.getSourceInfo(), false);
            }
            sd.setInterface(false);
        } else {
            throw new RuntimeException("Internal Program Error: typeDefBase was not a ClassDef or InterfaceDef.  Please report this bug.");
        }
        sd.setMav(typeDefBase.getMav());
        sd.setTypeParameters(typeDefBase.getTypeParameters());
        sd.setSuperClass(superClass);
        sd.setInterfaces(interfaces);
        sd.setIsContinuation(false);
        continuations.remove(sd.getName());
        if (!sd.isInterface()) {
            _newSDs.put(sd, this);
        }
        return sd;
    }

    protected VariableData[] formalParameters2VariableData(FormalParameter[] fps, Data enclosing) {
        VariableData[] varData = new VariableData[fps.length];
        for (int i = 0; i < varData.length; ++i) {
            VariableDeclarator vd = fps[i].getDeclarator();
            String[] mav = new String[]{"final"};
            String name = vd.getName().getText();
            SymbolData type = this.getSymbolData(vd.getType().getName(), vd.getType().getSourceInfo());
            if (type != null) {
                varData[i] = new VariableData(name, new ModifiersAndVisibility(JExprParser.NO_SOURCE_INFO, mav), type, true, enclosing);
                varData[i].gotValue();
                continue;
            }
            LanguageLevelVisitor._addError("Class or Interface " + vd.getType().getName() + " not found", vd);
            varData[i] = null;
        }
        return varData;
    }

    protected MethodData createMethodData(MethodDef that, SymbolData sd) {
        that.getMav().visit(this);
        that.getName().visit(this);
        String[] throwStrings = this.referenceType2String(that.getThrows());
        String rtString = that.getResult().getName();
        SymbolData returnType = rtString.equals("void") ? SymbolData.VOID_TYPE : this.getSymbolData(rtString, that.getResult().getSourceInfo());
        MethodData md = new MethodData(that.getName().getText(), that.getMav(), that.getTypeParams(), returnType, new VariableData[0], throwStrings, sd, that);
        VariableData[] vds = this.formalParameters2VariableData(that.getParams(), md);
        if (LanguageLevelVisitor._checkError()) {
            return md;
        }
        md.setParams(vds);
        if (!md.addVars(vds)) {
            LanguageLevelVisitor._addAndIgnoreError("You cannot have two method parameters with the same name", that);
        }
        return md;
    }

    protected VariableData[] _variableDeclaration2VariableData(VariableDeclaration vd, Data enclosing) {
        LinkedList<VariableData> vds = new LinkedList<VariableData>();
        ModifiersAndVisibility mav = vd.getMav();
        VariableDeclarator[] declarators = vd.getDeclarators();
        for (int i = 0; i < declarators.length; ++i) {
            declarators[i].visit(this);
            Type type = declarators[i].getType();
            String name = declarators[i].getName().getText();
            SymbolData sd = this.getSymbolData(type.getName(), type.getSourceInfo());
            if (sd == null) {
                sd = enclosing.getInnerClassOrInterface(type.getName());
            }
            if (sd == null) {
                sd = new SymbolData(enclosing.getSymbolData().getName() + "$" + type.getName());
                enclosing.getSymbolData().addInnerClass(sd);
                sd.setOuterData(enclosing.getSymbolData());
                continuations.put(sd.getName(), new Pair<SourceInfo, LanguageLevelVisitor>(type.getSourceInfo(), this));
            }
            if (sd != null) {
                boolean initialized = declarators[i] instanceof InitializedVariableDeclarator;
                VariableData vdata = new VariableData(name, mav, sd, initialized, enclosing);
                vdata.setHasInitializer(initialized);
                vds.addLast(vdata);
                continue;
            }
            LanguageLevelVisitor._addAndIgnoreError("Class or Interface " + type.getName() + " not found", declarators[i].getType());
        }
        return vds.toArray(new VariableData[vds.size()]);
    }

    protected static void _addError(String message, JExpressionIF that) {
        _errorAdded = true;
        errors.addLast(new Pair<String, JExpressionIF>(message, that));
    }

    protected static void _addAndIgnoreError(String message, JExpressionIF that) {
        if (_errorAdded) {
            throw new RuntimeException("Internal Program Error: _addAndIgnoreError called while _errorAdded was true.  Please report this bug.");
        }
        _errorAdded = false;
        errors.addLast(new Pair<String, JExpressionIF>(message, that));
    }

    @Override
    protected boolean prune(JExpressionIF node) {
        return LanguageLevelVisitor._checkError();
    }

    protected static boolean _checkError() {
        if (_errorAdded) {
            _errorAdded = false;
            return true;
        }
        return false;
    }

    private void _badModifiers(String first, String second, ModifiersAndVisibility that) {
        LanguageLevelVisitor._addError("Illegal combination of modifiers. Can't use " + first + " and " + second + " together.", that);
    }

    @Override
    public void forModifiersAndVisibilityDoFirst(ModifiersAndVisibility that) {
        Object[] modifiersAndVisibility = that.getModifiers();
        Arrays.sort(modifiersAndVisibility);
        if (modifiersAndVisibility.length > 0) {
            Object s = modifiersAndVisibility[0];
            for (int i = 1; i < modifiersAndVisibility.length; ++i) {
                if (((String)s).equals(modifiersAndVisibility[i])) {
                    LanguageLevelVisitor._addError("Duplicate modifier: " + (String)s, that);
                }
                s = modifiersAndVisibility[i];
            }
            Object visibility = "package";
            boolean isAbstract = false;
            boolean isStatic = false;
            boolean isFinal = false;
            boolean isSynchronized = false;
            boolean isStrictfp = false;
            boolean isTransient = false;
            boolean isVolatile = false;
            boolean isNative = false;
            for (int i = 0; i < modifiersAndVisibility.length; ++i) {
                s = modifiersAndVisibility[i];
                if (((String)s).equals("public") || ((String)s).equals("protected") || ((String)s).equals("private")) {
                    if (!((String)visibility).equals("package")) {
                        this._badModifiers((String)visibility, (String)s, that);
                        continue;
                    }
                    if (((String)s).equals("private") && isAbstract) {
                        this._badModifiers("private", "abstract", that);
                        continue;
                    }
                    visibility = s;
                    continue;
                }
                if (((String)s).equals("abstract")) {
                    isAbstract = true;
                    continue;
                }
                if (((String)s).equals("final")) {
                    isFinal = true;
                    if (!isAbstract) continue;
                    this._badModifiers("final", "abstract", that);
                    continue;
                }
                if (((String)s).equals("static")) {
                    isStatic = true;
                    if (!isAbstract) continue;
                    this._badModifiers("static", "abstract", that);
                    continue;
                }
                if (((String)s).equals("native")) {
                    isNative = true;
                    if (!isAbstract) continue;
                    this._badModifiers("native", "abstract", that);
                    continue;
                }
                if (((String)s).equals("synchronized")) {
                    isSynchronized = true;
                    if (!isAbstract) continue;
                    this._badModifiers("synchronized", "abstract", that);
                    continue;
                }
                if (!((String)s).equals("volatile")) continue;
                isVolatile = true;
                if (!isFinal) continue;
                this._badModifiers("final", "volatile", that);
            }
            this.forJExpressionDoFirst(that);
        }
    }

    @Override
    public void forClassDefDoFirst(ClassDef that) {
        String name = that.getName().getText();
        for (String s : this._importedFiles) {
            if (!s.endsWith(name) || s.equals(this.getQualifiedClassName(name))) continue;
            LanguageLevelVisitor._addAndIgnoreError("The class " + name + " was already imported.", that);
        }
        String[] mavStrings = that.getMav().getModifiers();
        if (!(that instanceof InnerClassDef)) {
            for (int i = 0; i < mavStrings.length; ++i) {
                if (!mavStrings[i].equals("private")) continue;
                LanguageLevelVisitor._addAndIgnoreError("Top level classes cannot be private", that);
            }
        }
        this.forTypeDefBaseDoFirst(that);
    }

    @Override
    public void forInterfaceDefDoFirst(InterfaceDef that) {
        String[] mavStrings = that.getMav().getModifiers();
        for (int i = 0; i < mavStrings.length; ++i) {
            if (mavStrings[i].equals("private")) {
                LanguageLevelVisitor._addAndIgnoreError("Top level interfaces cannot be private", that);
            }
            if (!mavStrings[i].equals("final")) continue;
            LanguageLevelVisitor._addAndIgnoreError("Interfaces cannot be final", that);
        }
        this.forTypeDefBaseDoFirst(that);
    }

    @Override
    public void forInnerInterfaceDefDoFirst(InnerInterfaceDef that) {
        String[] mavStrings = that.getMav().getModifiers();
        for (int i = 0; i < mavStrings.length; ++i) {
            if (!mavStrings[i].equals("final")) continue;
            LanguageLevelVisitor._addAndIgnoreError("Interfaces cannot be final", that);
        }
        this.forTypeDefBaseDoFirst(that);
    }

    @Override
    public void forPackageStatementOnly(PackageStatement that) {
        CompoundWord cWord = that.getCWord();
        Word[] words = cWord.getWords();
        String separator = System.getProperty("file.separator");
        if (words.length > 0) {
            String newPackage = this._package = words[0].getText();
            for (int i = 1; i < words.length; ++i) {
                String temp = words[i].getText();
                newPackage = newPackage + separator + temp;
                this._package = this._package + "." + temp;
            }
            String directory = this._file.getParent();
            if (directory == null || !directory.endsWith(newPackage)) {
                LanguageLevelVisitor._addAndIgnoreError("The package name must mirror your file's directory.", that);
            }
        }
        this.getSymbolData(this._package, that.getSourceInfo(), false, false, false);
        this.forJExpressionOnly(that);
    }

    @Override
    public void forClassImportStatementOnly(ClassImportStatement that) {
        int indexOfLastDot;
        CompoundWord cWord = that.getCWord();
        Word[] words = cWord.getWords();
        for (int i = 0; i < this._importedFiles.size(); ++i) {
            String name = this._importedFiles.get(i);
            indexOfLastDot = name.lastIndexOf(".");
            if (indexOfLastDot == -1 || !words[words.length - 1].getText().equals(name.substring(indexOfLastDot + 1, name.length()))) continue;
            LanguageLevelVisitor._addAndIgnoreError("The class " + words[words.length - 1].getText() + " has already been imported.", that);
            return;
        }
        StringBuffer tempBuff = new StringBuffer(words[0].getText());
        for (int i = 1; i < words.length; ++i) {
            tempBuff.append("." + words[i].getText());
        }
        String temp = tempBuff.toString();
        indexOfLastDot = temp.lastIndexOf(".");
        if (indexOfLastDot != -1 && this._package.equals(temp.substring(0, indexOfLastDot))) {
            LanguageLevelVisitor._addAndIgnoreError("You do not need to import " + temp + ".  It is in your package so it is already visible", that);
            return;
        }
        this._importedFiles.addLast(temp);
        SymbolData sd = symbolTable.get(temp);
        if (sd == null) {
            sd = new SymbolData(temp);
            continuations.put(temp, new Pair<SourceInfo, LanguageLevelVisitor>(that.getSourceInfo(), this));
            symbolTable.put(temp, sd);
        }
        this.forImportStatementOnly(that);
    }

    @Override
    public void forPackageImportStatementOnly(PackageImportStatement that) {
        CompoundWord cWord = that.getCWord();
        Word[] words = cWord.getWords();
        StringBuffer tempBuff = new StringBuffer(words[0].getText());
        for (int i = 1; i < words.length; ++i) {
            tempBuff.append("." + words[i].getText());
        }
        String temp = tempBuff.toString();
        if (this._package.equals(temp)) {
            LanguageLevelVisitor._addAndIgnoreError("You do not need to import package " + temp + ". It is your package so all public classes in it are already visible.", that);
            return;
        }
        this._importedPackages.addLast(temp);
        this.forImportStatementOnly(that);
    }

    @Override
    public void forShiftAssignmentExpressionDoFirst(ShiftAssignmentExpression that) {
        LanguageLevelVisitor._addAndIgnoreError("Shift assignment operators cannot be used at any language level", that);
    }

    @Override
    public void forBitwiseAssignmentExpressionDoFirst(BitwiseAssignmentExpression that) {
        LanguageLevelVisitor._addAndIgnoreError("Bitwise operators cannot be used at any language level", that);
    }

    @Override
    public void forBitwiseBinaryExpressionDoFirst(BitwiseBinaryExpression that) {
        LanguageLevelVisitor._addAndIgnoreError("Bitwise binary expressions cannot be used at any language level", that);
    }

    @Override
    public void forBitwiseOrExpressionDoFirst(BitwiseOrExpression that) {
        LanguageLevelVisitor._addAndIgnoreError("Bitwise or expressions cannot be used at any language level.  Perhaps you meant to compare two values using regular or (||)", that);
    }

    @Override
    public void forBitwiseXorExpressionDoFirst(BitwiseXorExpression that) {
        LanguageLevelVisitor._addAndIgnoreError("Bitwise xor expressions cannot be used at any language level", that);
    }

    @Override
    public void forBitwiseAndExpressionDoFirst(BitwiseAndExpression that) {
        LanguageLevelVisitor._addAndIgnoreError("Bitwise and expressions cannot be used at any language level.  Perhaps you meant to compare two values using regular and (&&)", that);
    }

    @Override
    public void forBitwiseNotExpressionDoFirst(BitwiseNotExpression that) {
        LanguageLevelVisitor._addAndIgnoreError("Bitwise not expressions cannot be used at any language level.  Perhaps you meant to negate this value using regular not (!)", that);
    }

    @Override
    public void forShiftBinaryExpressionDoFirst(ShiftBinaryExpression that) {
        LanguageLevelVisitor._addAndIgnoreError("Bit shifting operators cannot be used at any language level", that);
    }

    public void forBitwiseNotExpressionDoFirst(ShiftBinaryExpression that) {
        LanguageLevelVisitor._addAndIgnoreError("Bitwise operators cannot be used at any language level", that);
    }

    @Override
    public void forEmptyExpressionDoFirst(EmptyExpression that) {
        LanguageLevelVisitor._addAndIgnoreError("You appear to be missing an expression here", that);
    }

    @Override
    public void forNoOpExpressionDoFirst(NoOpExpression that) {
        LanguageLevelVisitor._addAndIgnoreError("You are missing a binary operator here", that);
    }

    @Override
    public void forSourceFileDoFirst(SourceFile that) {
        for (int i = 0; i < that.getTypes().length; ++i) {
            ClassDef c;
            String superName;
            if (!(that.getTypes()[i] instanceof ClassDef) || !(superName = (c = (ClassDef)that.getTypes()[i]).getSuperclass().getName()).equals("TestCase") && !superName.equals("junit.framework.TestCase") || that.getTypes().length <= 1) continue;
            LanguageLevelVisitor._addAndIgnoreError("TestCases must appear in files by themselves at all language levels", c);
        }
    }

    @Override
    public void forSourceFile(SourceFile that) {
        String qualifiedClassName;
        int i;
        int i2;
        this.forSourceFileDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        for (i2 = 0; i2 < that.getPackageStatements().length; ++i2) {
            that.getPackageStatements()[i2].visit(this);
        }
        for (i2 = 0; i2 < that.getImportStatements().length; ++i2) {
            that.getImportStatements()[i2].visit(this);
        }
        if (!this._importedPackages.contains("java.lang")) {
            this._importedPackages.addFirst("java.lang");
        }
        TypeDefBase[] types = that.getTypes();
        this._classNamesInThisFile = new LinkedList();
        for (i = 0; i < types.length; ++i) {
            qualifiedClassName = this.getQualifiedClassName(types[i].getName().getText());
            this._classNamesInThisFile.addFirst(qualifiedClassName);
            _classesToBeParsed.put(qualifiedClassName, new Pair<TypeDefBase, LanguageLevelVisitor>(types[i], this));
        }
        for (i = 0; i < types.length; ++i) {
            qualifiedClassName = this.getQualifiedClassName(types[i].getName().getText());
            if (!_classesToBeParsed.containsKey(qualifiedClassName)) continue;
            types[i].visit(this);
        }
        this.forSourceFileOnly(that);
    }

    @Override
    public void forSimpleNameReference(SimpleNameReference that) {
        that.visit(new ResolveNameVisitor());
    }

    @Override
    public void forComplexNameReference(ComplexNameReference that) {
        that.visit(new ResolveNameVisitor());
    }

    @Override
    public void forVariableDeclaration(VariableDeclaration that) {
        this.forVariableDeclarationDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        that.getMav().visit(this);
        this.forVariableDeclarationOnly(that);
    }

    protected static void addGeneratedMethod(SymbolData sd, MethodData md) {
        MethodData rmd = SymbolData.repeatedSignature(sd.getMethods(), md);
        if (rmd == null) {
            sd.addMethod(md, true);
            md.setGenerated(true);
        } else if (!LanguageLevelVisitor.getUnqualifiedClassName(sd.getName()).equals(md.getName())) {
            LanguageLevelVisitor._addAndIgnoreError("The method " + md.getName() + " is automatically generated, and thus you cannot override it", rmd.getJExpression());
        }
    }

    public void createConstructor(SymbolData sd) {
        if (LanguageLevelConverter.isAdvancedFile(this._file)) {
            return;
        }
        SymbolData superSd = sd.getSuperClass();
        if (sd.isContinuation()) {
            return;
        }
        LinkedList<MethodData> superMethods = superSd.getMethods();
        String superUnqualifiedName = LanguageLevelVisitor.getUnqualifiedClassName(superSd.getName());
        LanguageLevelVisitor sslv = _newSDs.remove(superSd);
        if (sslv != null) {
            sslv.createConstructor(superSd);
        }
        MethodData superConstructor = null;
        for (MethodData superMd : superMethods) {
            if (!superMd.getName().equals(superUnqualifiedName) || superConstructor != null && superMd.getParams().length >= superConstructor.getParams().length) continue;
            superConstructor = superMd;
        }
        String name = LanguageLevelVisitor.getUnqualifiedClassName(sd.getName());
        MethodData md = new MethodData(name, new ModifiersAndVisibility(JExprParser.NO_SOURCE_INFO, new String[]{"public"}), new TypeParameter[0], sd, new VariableData[0], new String[0], sd, null);
        LinkedList<VariableData> params = new LinkedList<VariableData>();
        if (superConstructor != null) {
            for (VariableData superParam : superConstructor.getParams()) {
                String paramName = md.createUniqueName("super_" + superParam.getName());
                VariableData newParam = new VariableData(paramName, new ModifiersAndVisibility(JExprParser.NO_SOURCE_INFO, new String[0]), superParam.getType().getSymbolData(), true, md);
                newParam.setGenerated(true);
                params.add(newParam);
                md.addVar(newParam);
            }
        }
        boolean hasOtherConstructor = sd.hasMethod(name);
        for (VariableData field : sd.getVars()) {
            if (field.hasInitializer() || field.hasModifier("static")) continue;
            if (!hasOtherConstructor) {
                field.gotValue();
            }
            params.add(field);
        }
        md.setParams(params.toArray(new VariableData[params.size()]));
        md.setVars(params);
        LanguageLevelVisitor.addGeneratedMethod(sd, md);
        _newSDs.remove(sd);
    }

    protected static void createAccessors(SymbolData sd, File file) {
        if (LanguageLevelConverter.isAdvancedFile(file)) {
            return;
        }
        LinkedList<VariableData> fields = sd.getVars();
        for (VariableData vd : fields) {
            if (vd.hasModifier("static")) continue;
            String name = LanguageLevelVisitor.getFieldAccessorName(vd.getName());
            String[] mavStrings = new String[]{"public"};
            MethodData md = new MethodData(name, new ModifiersAndVisibility(JExprParser.NO_SOURCE_INFO, mavStrings), new TypeParameter[0], vd.getType().getSymbolData(), new VariableData[0], new String[0], sd, null);
            LanguageLevelVisitor.addGeneratedMethod(sd, md);
        }
    }

    protected void createToString(SymbolData sd) {
        String name = "toString";
        String[] mavStrings = new String[]{"public"};
        MethodData md = new MethodData(name, new ModifiersAndVisibility(JExprParser.NO_SOURCE_INFO, mavStrings), new TypeParameter[0], this.getSymbolData("String", this._makeSourceInfo("java.lang.String")), new VariableData[0], new String[0], sd, null);
        LanguageLevelVisitor.addGeneratedMethod(sd, md);
    }

    protected void createHashCode(SymbolData sd) {
        String name = "hashCode";
        String[] mavStrings = new String[]{"public"};
        MethodData md = new MethodData(name, new ModifiersAndVisibility(JExprParser.NO_SOURCE_INFO, mavStrings), new TypeParameter[0], SymbolData.INT_TYPE, new VariableData[0], new String[0], sd, null);
        LanguageLevelVisitor.addGeneratedMethod(sd, md);
    }

    protected void createEquals(SymbolData sd) {
        String name = "equals";
        String[] mavStrings = new String[]{"public"};
        SymbolData type = this.getSymbolData("java.lang.Object", this._makeSourceInfo("java.lang.Object"));
        VariableData param = new VariableData(type);
        MethodData md = new MethodData(name, new ModifiersAndVisibility(JExprParser.NO_SOURCE_INFO, mavStrings), new TypeParameter[0], SymbolData.BOOLEAN_TYPE, new VariableData[]{param}, new String[0], sd, null);
        param.setEnclosingData(md);
        LanguageLevelVisitor.addGeneratedMethod(sd, md);
    }

    @Override
    public void forMemberType(MemberType that) {
        this.forMemberTypeDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        this.forMemberTypeOnly(that);
    }

    @Override
    public void forStringLiteralOnly(StringLiteral that) {
        this.getSymbolData("String", that.getSourceInfo(), true);
    }

    @Override
    public void forSimpleNamedClassInstantiation(SimpleNamedClassInstantiation that) {
        this.forSimpleNamedClassInstantiationDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        that.getType().visit(this);
        that.getArguments().visit(this);
        this.getSymbolData(that.getType().getName(), that.getSourceInfo());
        this.forSimpleNamedClassInstantiationOnly(that);
    }

    public static boolean arrayEquals(Object[] array1, Object[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i].equals(array2[i])) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ SymbolData access$100(LanguageLevelVisitor x0, String x1, String x2) {
        return x0._classFile2SymbolData(x1, x2);
    }

    static /* synthetic */ SymbolData access$200(LanguageLevelVisitor x0, String x1, SourceInfo x2, boolean x3) {
        return x0._lookupFromClassesToBeParsed(x1, x2, x3);
    }

    static /* synthetic */ SymbolData access$300(LanguageLevelVisitor x0, String x1) {
        return x0._getSymbolData_Primitive(x1);
    }

    static /* synthetic */ SymbolData access$400(LanguageLevelVisitor x0, String x1, SourceInfo x2, boolean x3, boolean x4, boolean x5) {
        return x0._getSymbolData_IsQualified(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ SymbolData access$500(LanguageLevelVisitor x0, String x1, SourceInfo x2, boolean x3, boolean x4, boolean x5, boolean x6) {
        return x0._getSymbolData_ArrayType(x1, x2, x3, x4, x5, x6);
    }

    static /* synthetic */ SymbolData access$600(LanguageLevelVisitor x0, String x1, SourceInfo x2, boolean x3) {
        return x0._getSymbolData_FromCurrFile(x1, x2, x3);
    }

    static /* synthetic */ SymbolData access$700(LanguageLevelVisitor x0, String x1, SourceInfo x2, boolean x3, boolean x4) {
        return x0._getSymbolData_FromFileSystem(x1, x2, x3, x4);
    }

    static {
        RESOURCES = new Thunk<ClassLoader>(){
            private Options _cachedOptions = null;
            private ClassLoader _cachedResult = null;

            @Override
            public ClassLoader value() {
                if (LanguageLevelConverter.OPT != this._cachedOptions) {
                    this._cachedOptions = LanguageLevelConverter.OPT;
                    ComposedIterable<? extends File> searchPath = IterUtil.compose(LanguageLevelConverter.OPT.bootClassPath(), LanguageLevelConverter.OPT.classPath());
                    this._cachedResult = new PathClassLoader((ClassLoader)EmptyClassLoader.INSTANCE, searchPath);
                }
                return this._cachedResult;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResolveNameVisitor
    extends JExpressionIFAbstractVisitor<TypeData> {
        @Override
        public TypeData defaultCase(JExpressionIF that) {
            that.visit(LanguageLevelVisitor.this);
            return null;
        }

        @Override
        public TypeData forSimpleNameReference(SimpleNameReference that) {
            SymbolData result = LanguageLevelVisitor.this.getSymbolData(that.getName().getText(), that.getSourceInfo());
            if (result == SymbolData.KEEP_GOING) {
                return new PackageData(that.getName().getText());
            }
            return result;
        }

        @Override
        public TypeData forComplexNameReference(ComplexNameReference that) {
            TypeData lhs = that.getEnclosing().visit(this);
            SymbolData result = LanguageLevelVisitor.this.getSymbolData(lhs, that.getName().getText(), that.getSourceInfo(), true);
            if (result == SymbolData.KEEP_GOING) {
                if (lhs instanceof PackageData) {
                    return new PackageData((PackageData)lhs, that.getName().getText());
                }
                return null;
            }
            return result;
        }
    }
}

