/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.CartesianRelation;
import edu.rice.cs.plt.collect.ComplementRelation;
import edu.rice.cs.plt.collect.ComplementSet;
import edu.rice.cs.plt.collect.ComposedMap;
import edu.rice.cs.plt.collect.ComposedRelation;
import edu.rice.cs.plt.collect.ConsList;
import edu.rice.cs.plt.collect.DelegatingMap;
import edu.rice.cs.plt.collect.DelegatingSet;
import edu.rice.cs.plt.collect.DictionaryMap;
import edu.rice.cs.plt.collect.EmptyMap;
import edu.rice.cs.plt.collect.EmptyRelation;
import edu.rice.cs.plt.collect.EmptySet;
import edu.rice.cs.plt.collect.FilteredRelation;
import edu.rice.cs.plt.collect.FilteredSet;
import edu.rice.cs.plt.collect.ImmutableMap;
import edu.rice.cs.plt.collect.ImmutableRelation;
import edu.rice.cs.plt.collect.ImmutableSet;
import edu.rice.cs.plt.collect.IndexedRelation;
import edu.rice.cs.plt.collect.IntersectionRelation;
import edu.rice.cs.plt.collect.IntersectionSet;
import edu.rice.cs.plt.collect.IterableCollection;
import edu.rice.cs.plt.collect.IterableSet;
import edu.rice.cs.plt.collect.LambdaMap;
import edu.rice.cs.plt.collect.PredicateSet;
import edu.rice.cs.plt.collect.Relation;
import edu.rice.cs.plt.collect.SingletonMap;
import edu.rice.cs.plt.collect.SingletonRelation;
import edu.rice.cs.plt.collect.SingletonSet;
import edu.rice.cs.plt.collect.UnionMap;
import edu.rice.cs.plt.collect.UnionRelation;
import edu.rice.cs.plt.collect.UnionSet;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.lambda.Predicate2;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.object.ObjectUtil;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectUtil {
    public static final Predicate2<Set<?>, Object> SET_CONTENTS_PREDICATE = new SetContentsPredicate();

    private CollectUtil() {
    }

    public static <T> Thunk<Set<T>> hashSetFactory() {
        return DefaultHashSetFactory.INSTANCE;
    }

    public static <T> Thunk<Set<T>> hashSetFactory(int initialCapacity) {
        return new CustomHashSetFactory(initialCapacity);
    }

    public static <T> Thunk<Set<T>> linkedHashSetFactory() {
        return DefaultLinkedHashSetFactory.INSTANCE;
    }

    public static <T> Thunk<Set<T>> linkedHashSetFactory(int initialCapacity) {
        return new CustomLinkedHashSetFactory(initialCapacity);
    }

    public static <T extends Comparable<? super T>> Thunk<Set<T>> treeSetFactory() {
        return DefaultTreeSetFactory.INSTANCE;
    }

    public static <T> Thunk<Set<T>> treeSetFactory(Comparator<? super T> comparator) {
        return new CustomTreeSetFactory<T>(comparator);
    }

    public static <K, V> Thunk<Map<K, V>> hashMapFactory() {
        return DefaultHashMapFactory.INSTANCE;
    }

    public static <K, V> Thunk<Map<K, V>> hashMapFactory(int initialCapacity) {
        return new CustomHashMapFactory(initialCapacity);
    }

    public static <K, V> Thunk<Map<K, V>> linkedHashMapFactory() {
        return DefaultLinkedHashMapFactory.INSTANCE;
    }

    public static <K, V> Thunk<Map<K, V>> linkedHashMapFactory(int initialCapacity) {
        return new CustomLinkedHashMapFactory(initialCapacity);
    }

    public static <K extends Comparable<? super K>, V> Thunk<Map<K, V>> treeMapFactory() {
        return DefaultTreeMapFactory.INSTANCE;
    }

    public static <K, V> Thunk<Map<K, V>> treeMapFactory(Comparator<? super K> comparator) {
        return new CustomTreeMapFactory(comparator);
    }

    public static <T> Thunk<List<T>> arrayListFactory() {
        return DefaultArrayListFactory.INSTANCE;
    }

    public static <T> Thunk<List<T>> arrayListFactory(int initialCapacity) {
        return new CustomArrayListFactory(initialCapacity);
    }

    public static <T> Thunk<List<T>> linkedListFactory() {
        return DefaultLinkedListFactory.INSTANCE;
    }

    public static <T> PredicateSet<T> makeSet(T ... elements) {
        return CollectUtil.makeSet(IterUtil.asIterable(elements));
    }

    public static <T> PredicateSet<T> makeSet(Iterable<? extends T> elements) {
        if (IterUtil.isEmpty(elements)) {
            return EmptySet.make();
        }
        if (IterUtil.sizeOf(elements, 2) == 1) {
            return new SingletonSet<T>(IterUtil.first(elements));
        }
        HashSet<? extends T> result = new HashSet<T>(CollectUtil.asCollection(elements));
        return new ImmutableSet<T>(result){

            @Override
            public boolean hasFixedSize() {
                return true;
            }

            @Override
            public boolean isStatic() {
                return true;
            }
        };
    }

    public static <T> PredicateSet<T> makeSet(Option<? extends T> opt) {
        if (opt.isSome()) {
            return new SingletonSet<T>(opt.unwrap());
        }
        return EmptySet.make();
    }

    public static <T1, T2> Relation<T1, T2> makeRelation(Iterable<? extends Pair<? extends T1, ? extends T2>> pairs) {
        if (IterUtil.isEmpty(pairs)) {
            return EmptyRelation.make();
        }
        if (IterUtil.sizeOf(pairs, 2) == 1) {
            Pair<T1, T2> elt = IterUtil.first(pairs);
            return new SingletonRelation<T1, T2>(elt.first(), elt.second());
        }
        IndexedRelation<T1, T2> result = IndexedRelation.makeHashBased();
        for (Pair<T1, T2> elt : pairs) {
            result.add(elt.first(), elt.second());
        }
        return new ImmutableRelation<T1, T2>((Relation)result){

            @Override
            public boolean hasFixedSize() {
                return true;
            }

            @Override
            public boolean isStatic() {
                return true;
            }
        };
    }

    public static <T> List<T> makeList(Iterable<? extends T> iter) {
        return CollectUtil.makeArrayList(iter);
    }

    public static <T> ArrayList<T> makeArrayList(Iterable<? extends T> iter) {
        if (iter instanceof Collection) {
            Collection cast = (Collection)iter;
            return new ArrayList(cast);
        }
        if (iter instanceof SizedIterable) {
            ArrayList<T> result = new ArrayList<T>(((SizedIterable)iter).size());
            for (T e : iter) {
                result.add(e);
            }
            return result;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T e : iter) {
            result.add(e);
        }
        return result;
    }

    public static <T> LinkedList<T> makeLinkedList(Iterable<? extends T> iter) {
        if (iter instanceof Collection) {
            Collection cast = (Collection)iter;
            return new LinkedList(cast);
        }
        LinkedList<T> result = new LinkedList<T>();
        for (T e : iter) {
            result.add(e);
        }
        return result;
    }

    public static <T> ConsList<T> makeConsList(Iterable<? extends T> iter) {
        ConsList result = ConsList.empty();
        for (Object elt : IterUtil.reverse(iter)) {
            result = ConsList.cons(elt, result);
        }
        return result;
    }

    public static <T> List<T> emptyList() {
        return Collections.EMPTY_LIST;
    }

    public static <T> EmptySet<T> emptySet() {
        return EmptySet.INSTANCE;
    }

    public static <K, V> EmptyMap<K, V> emptyMap() {
        return EmptyMap.INSTANCE;
    }

    public static <T1, T2> EmptyRelation<T1, T2> emptyRelation() {
        return EmptyRelation.INSTANCE;
    }

    public static <T> SingletonSet<T> singleton(T elt) {
        return new SingletonSet<T>(elt);
    }

    public static <T1, T2> SingletonRelation<T1, T2> singleton(T1 first, T2 second) {
        return new SingletonRelation<T1, T2>(first, second);
    }

    public static <K, V> SingletonMap<K, V> singletonMap(K key, V value) {
        return new SingletonMap<K, V>(key, value);
    }

    public static <T> Set<T> asSet(Iterable<T> iter) {
        if (iter instanceof Set) {
            return (Set)iter;
        }
        return new IterableSet<T>(iter);
    }

    public static <T> PredicateSet<T> asPredicateSet(Iterable<T> iter) {
        if (iter instanceof PredicateSet) {
            return (PredicateSet)iter;
        }
        if (iter instanceof Set) {
            return new DelegatingSet((Set)iter);
        }
        return new IterableSet<T>(iter);
    }

    public static <T> Collection<T> asCollection(Iterable<T> iter) {
        if (iter instanceof Collection) {
            return (Collection)iter;
        }
        return new IterableCollection<T>(iter);
    }

    public static <K, V> LambdaMap<K, V> asLambdaMap(Map<K, V> m) {
        if (m instanceof LambdaMap) {
            return (LambdaMap)m;
        }
        return new DelegatingMap<K, V>(m);
    }

    public static <K, V> Map<K, V> asMap(Dictionary<K, V> d) {
        if (d instanceof Hashtable) {
            return (Hashtable)d;
        }
        return new DictionaryMap<K, V>(d);
    }

    public static <T> PredicateSet<T> immutable(Set<? extends T> set) {
        return new ImmutableSet<T>(set);
    }

    public static <K, V> Map<K, V> immutable(Map<? extends K, ? extends V> map) {
        return new ImmutableMap<K, V>(map);
    }

    public static <T1, T2> ImmutableRelation<T1, T2> immutable(Relation<T1, T2> r) {
        return new ImmutableRelation<T1, T2>(r);
    }

    public static <T> PredicateSet<T> snapshot(Set<? extends T> set) {
        return CollectUtil.makeSet(set);
    }

    public static <T> Iterable<T> conditionalSnapshot(Set<T> set, int threshold) {
        if (ObjectUtil.compositeSize(set) > threshold) {
            return CollectUtil.makeSet(set);
        }
        return set;
    }

    public static <T1, T2> Relation<T1, T2> snapshot(Relation<? extends T1, ? extends T2> relation) {
        return CollectUtil.makeRelation(relation);
    }

    public static <T1, T2> Relation<T1, T2> conditionalSnapshot(Relation<T1, T2> rel, int threshold) {
        if (ObjectUtil.compositeSize(rel) > threshold) {
            return CollectUtil.makeRelation(rel);
        }
        return rel;
    }

    public static <K, V> LambdaMap<K, V> snapshot(Map<? extends K, ? extends V> map) {
        return new DelegatingMap<K, V>(new HashMap<K, V>(map));
    }

    public static <K, V> Map<K, V> conditionalSnapshot(Map<K, V> map, int threshold) {
        if (ObjectUtil.compositeSize(map) > threshold) {
            return CollectUtil.snapshot(map);
        }
        return map;
    }

    public static <T> List<T> snapshot(List<? extends T> list) {
        return CollectUtil.makeArrayList(list);
    }

    public static <T> PredicateSet<T> union(Set<? extends T> s1, Set<? extends T> s2) {
        return new UnionSet<T>(s1, s2);
    }

    public static <T> PredicateSet<T> union(Set<? extends T> set, T elt) {
        return new UnionSet<T>(set, new SingletonSet<T>(elt));
    }

    public static <T> PredicateSet<T> intersection(Set<?> s1, Set<? extends T> s2) {
        return new IntersectionSet<T>(s1, s2);
    }

    public static <T> PredicateSet<T> complement(Set<? extends T> domain, Set<?> excluded) {
        return new ComplementSet<T>(domain, excluded);
    }

    public static <T> PredicateSet<T> complement(Set<? extends T> domain, T excluded) {
        return new ComplementSet<T>(domain, (Set<?>)new SingletonSet<T>(excluded));
    }

    public static <T> PredicateSet<T> filter(Set<? extends T> set, Predicate<? super T> predicate) {
        return new FilteredSet<T>(set, predicate);
    }

    public static <T1, T2> Relation<T1, T2> cross(Set<? extends T1> left, Set<? extends T2> right) {
        return new CartesianRelation<T1, T2>(left, right);
    }

    public static <T1, T2> Relation<T1, T2> union(Relation<T1, T2> r1, Relation<T1, T2> r2) {
        return new UnionRelation<T1, T2>(r1, r2);
    }

    public static <T1, T2> Relation<T1, T2> union(Relation<T1, T2> rel, T1 first, T2 second) {
        return new UnionRelation<T1, T2>(rel, new SingletonRelation<T1, T2>(first, second));
    }

    public static <T1, T2> Relation<T1, T2> intersection(Relation<T1, T2> r1, Relation<T1, T2> r2) {
        return new IntersectionRelation<T1, T2>(r1, r2);
    }

    public static <T1, T2> Relation<T1, T2> complement(Relation<T1, T2> domain, Relation<? super T1, ? super T2> excluded) {
        return new ComplementRelation<T1, T2>(domain, excluded);
    }

    public static <T1, T2> Relation<T1, T2> complement(Relation<T1, T2> domain, T1 first, T2 second) {
        return new ComplementRelation<T1, T2>(domain, new SingletonRelation<T1, T2>(first, second));
    }

    public static <T1, T2, T3> Relation<T1, T3> compose(Relation<T1, T2> left, Relation<T2, T3> right) {
        return new ComposedRelation<T1, T2, T3>(left, right);
    }

    public static <T1, T2> Relation<T1, T2> filter(Relation<T1, T2> relation, Predicate2<? super T1, ? super T2> pred) {
        return new FilteredRelation<T1, T2>(relation, pred);
    }

    public static <K, V> LambdaMap<K, V> union(Map<? extends K, ? extends V> parent, Map<? extends K, ? extends V> child) {
        return new UnionMap<K, V>(parent, child);
    }

    public static <K, X, V> LambdaMap<K, V> compose(Map<? extends K, ? extends X> left, Map<? super X, ? extends V> right) {
        return new ComposedMap<K, X, V>(left, right);
    }

    public static <T> Option<T> castIfContains(Collection<? extends T> c, Object obj) {
        if (c.contains(obj)) {
            return Option.some(obj);
        }
        return Option.none();
    }

    public static boolean containsAny(Collection<?> c, Iterable<?> candidates) {
        for (Object o : candidates) {
            if (!c.contains(o)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(Collection<?> c, Iterable<?> subset) {
        if (subset instanceof Collection) {
            return c.containsAll((Collection)subset);
        }
        for (Object o : subset) {
            if (c.contains(o)) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean addAll(Collection<E> c, Iterable<? extends E> elts) {
        if (elts instanceof Collection) {
            Collection eltsColl = (Collection)elts;
            return c.addAll(eltsColl);
        }
        boolean result = false;
        for (E elt : elts) {
            result |= c.add(elt);
        }
        return result;
    }

    public static boolean removeAll(Collection<?> c, Iterable<?> elts) {
        if (elts instanceof Collection) {
            return c.removeAll((Collection)elts);
        }
        boolean result = false;
        for (Object elt : elts) {
            result |= c.remove(elt);
        }
        return result;
    }

    public static <T> Set<T> functionClosure(T base, Lambda<? super T, ? extends T> function) {
        return CollectUtil.functionClosure(Collections.singleton(base), function);
    }

    public static <T> Set<T> functionClosure(Set<? extends T> base, final Lambda<? super T, ? extends T> function) {
        Lambda neighbors = new Lambda<T, Set<T>>(){

            @Override
            public Set<T> value(T node) {
                return Collections.singleton(function.value(node));
            }
        };
        return CollectUtil.graphClosure(base, neighbors);
    }

    public static <T> Set<T> partialFunctionClosure(T base, Lambda<? super T, ? extends Option<? extends T>> function) {
        return CollectUtil.partialFunctionClosure(Collections.singleton(base), function);
    }

    public static <T> Set<T> partialFunctionClosure(Set<? extends T> base, final Lambda<? super T, ? extends Option<? extends T>> function) {
        Lambda neighbors = new Lambda<T, Set<T>>(){

            @Override
            public Set<T> value(T node) {
                return CollectUtil.makeSet((Option)function.value(node));
            }
        };
        return CollectUtil.graphClosure(base, neighbors);
    }

    public static <T> Set<T> graphClosure(T base, Lambda<? super T, ? extends Iterable<? extends T>> neighbors) {
        return CollectUtil.graphClosure(Collections.singleton(base), neighbors);
    }

    public static <T> Set<T> graphClosure(Set<? extends T> base, Lambda<? super T, ? extends Iterable<? extends T>> neighbors) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(base);
        LinkedList<T> workList = new LinkedList<T>(base);
        while (!workList.isEmpty()) {
            for (T newElt : neighbors.value(workList.removeFirst())) {
                if (result.contains(newElt)) continue;
                result.add(newElt);
                workList.addLast(newElt);
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultLinkedListFactory<T>
    implements Thunk<List<T>>,
    Serializable {
        public static final DefaultLinkedListFactory<Object> INSTANCE = new DefaultLinkedListFactory();

        private DefaultLinkedListFactory() {
        }

        @Override
        public List<T> value() {
            return new LinkedList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CustomArrayListFactory<T>
    implements Thunk<List<T>>,
    Serializable {
        private final int _initialCapacity;

        public CustomArrayListFactory(int initialCapacity) {
            this._initialCapacity = initialCapacity;
        }

        @Override
        public List<T> value() {
            return new ArrayList(this._initialCapacity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultArrayListFactory<T>
    implements Thunk<List<T>>,
    Serializable {
        public static final DefaultArrayListFactory<Object> INSTANCE = new DefaultArrayListFactory();

        private DefaultArrayListFactory() {
        }

        @Override
        public List<T> value() {
            return new ArrayList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CustomTreeMapFactory<K, V>
    implements Thunk<Map<K, V>>,
    Serializable {
        private final Comparator<? super K> _comp;

        public CustomTreeMapFactory(Comparator<? super K> comp) {
            this._comp = comp;
        }

        @Override
        public Map<K, V> value() {
            return new TreeMap(this._comp);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultTreeMapFactory<K extends Comparable<? super K>, V>
    implements Thunk<Map<K, V>>,
    Serializable {
        public static final DefaultTreeMapFactory<String, Object> INSTANCE = new DefaultTreeMapFactory();

        private DefaultTreeMapFactory() {
        }

        @Override
        public Map<K, V> value() {
            return new TreeMap();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CustomLinkedHashMapFactory<K, V>
    implements Thunk<Map<K, V>>,
    Serializable {
        private final int _initialCapacity;

        public CustomLinkedHashMapFactory(int initialCapacity) {
            this._initialCapacity = initialCapacity;
        }

        @Override
        public Map<K, V> value() {
            return new LinkedHashMap(this._initialCapacity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultLinkedHashMapFactory<K, V>
    implements Thunk<Map<K, V>>,
    Serializable {
        public static final DefaultLinkedHashMapFactory<Object, Object> INSTANCE = new DefaultLinkedHashMapFactory();

        private DefaultLinkedHashMapFactory() {
        }

        @Override
        public Map<K, V> value() {
            return new LinkedHashMap();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CustomHashMapFactory<K, V>
    implements Thunk<Map<K, V>>,
    Serializable {
        private final int _initialCapacity;

        public CustomHashMapFactory(int initialCapacity) {
            this._initialCapacity = initialCapacity;
        }

        @Override
        public Map<K, V> value() {
            return new HashMap(this._initialCapacity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultHashMapFactory<K, V>
    implements Thunk<Map<K, V>>,
    Serializable {
        public static final DefaultHashMapFactory<Object, Object> INSTANCE = new DefaultHashMapFactory();

        private DefaultHashMapFactory() {
        }

        @Override
        public Map<K, V> value() {
            return new HashMap();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CustomTreeSetFactory<T>
    implements Thunk<Set<T>>,
    Serializable {
        private final Comparator<? super T> _comp;

        public CustomTreeSetFactory(Comparator<? super T> comp) {
            this._comp = comp;
        }

        @Override
        public Set<T> value() {
            return new TreeSet<T>(this._comp);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultTreeSetFactory<T extends Comparable<? super T>>
    implements Thunk<Set<T>>,
    Serializable {
        public static final DefaultTreeSetFactory<String> INSTANCE = new DefaultTreeSetFactory();

        private DefaultTreeSetFactory() {
        }

        @Override
        public Set<T> value() {
            return new TreeSet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CustomLinkedHashSetFactory<T>
    implements Thunk<Set<T>>,
    Serializable {
        private final int _initialCapacity;

        public CustomLinkedHashSetFactory(int initialCapacity) {
            this._initialCapacity = initialCapacity;
        }

        @Override
        public Set<T> value() {
            return new LinkedHashSet(this._initialCapacity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultLinkedHashSetFactory<T>
    implements Thunk<Set<T>>,
    Serializable {
        public static final DefaultLinkedHashSetFactory<Object> INSTANCE = new DefaultLinkedHashSetFactory();

        private DefaultLinkedHashSetFactory() {
        }

        @Override
        public Set<T> value() {
            return new LinkedHashSet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CustomHashSetFactory<T>
    implements Thunk<Set<T>>,
    Serializable {
        private final int _initialCapacity;

        public CustomHashSetFactory(int initialCapacity) {
            this._initialCapacity = initialCapacity;
        }

        @Override
        public Set<T> value() {
            return new HashSet(this._initialCapacity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultHashSetFactory<T>
    implements Thunk<Set<T>>,
    Serializable {
        public static final DefaultHashSetFactory<Object> INSTANCE = new DefaultHashSetFactory();

        private DefaultHashSetFactory() {
        }

        @Override
        public Set<T> value() {
            return new HashSet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SetContentsPredicate
    implements Predicate2<Set<?>, Object>,
    Serializable {
        private SetContentsPredicate() {
        }

        @Override
        public boolean contains(Set<?> set, Object val) {
            return set.contains(val);
        }
    }
}

