/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.concurrent;

public class CompletionMonitor {
    private volatile boolean _signal;

    public CompletionMonitor() {
        this._signal = false;
    }

    public CompletionMonitor(boolean signaled) {
        this._signal = signaled;
    }

    public boolean isSignalled() {
        return this._signal;
    }

    public void reset() {
        this._signal = false;
    }

    public synchronized void signal() {
        this._signal = true;
        this.notifyAll();
    }

    public synchronized void ensureSignalled() throws InterruptedException {
        while (!this._signal) {
            this.wait();
        }
    }

    public boolean attemptEnsureSignalled() {
        try {
            this.ensureSignalled();
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }
}

