/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.concurrent;

public class DelayedInterrupter {
    private final Thread _worker;
    private final Thread _interrupter;

    public DelayedInterrupter(int timeToInterrupt) {
        this(Thread.currentThread(), timeToInterrupt);
    }

    public DelayedInterrupter(Thread worker, final int timeToInterrupt) {
        this._worker = worker;
        this._interrupter = new Thread(){

            public void run() {
                try {
                    1.sleep(timeToInterrupt);
                    DelayedInterrupter.this._worker.interrupt();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        this._interrupter.setDaemon(true);
        this._interrupter.start();
    }

    public void abort() {
        this._interrupter.interrupt();
        if (Thread.currentThread() == this._worker) {
            Thread.interrupted();
        }
    }
}

