/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.concurrent;

import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.lambda.WrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TaskController<R>
implements Thunk<R> {
    protected volatile Status _status = Status.PAUSED;

    public Status status() {
        return this._status;
    }

    public void start() {
        switch (this._status) {
            case PAUSED: {
                this.doStart();
                break;
            }
            case CANCELED: {
                throw new IllegalStateException("Task is cancelled");
            }
        }
    }

    public void cancel() {
        if (this._status != Status.CANCELED) {
            this.doCancel();
        }
    }

    @Override
    public R value() {
        if (this._status != Status.CANCELED) {
            try {
                return this.getValue();
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }
        throw new IllegalStateException("Task is canceled");
    }

    public boolean hasValue() {
        return this._status == Status.FINISHED;
    }

    protected abstract void doStart();

    protected abstract void doCancel();

    protected abstract R getValue() throws Exception;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        PAUSED,
        RUNNING,
        FINISHED,
        CANCELED;

    }
}

