/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.debug;

import edu.rice.cs.plt.concurrent.CompletionMonitor;
import edu.rice.cs.plt.debug.LogSink;
import edu.rice.cs.plt.lambda.LazyRunnable;
import edu.rice.cs.plt.lambda.WrappedException;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class AsynchronousLogSink
implements LogSink {
    private final LogSink _delegate;
    private final Runnable _startThread;
    private final Queue<LogSink.Message> _queue;
    private final CompletionMonitor _emptyNotifier;
    private final CompletionMonitor _nonemptyNotifier;

    public AsynchronousLogSink(LogSink delegate) {
        this(delegate, true);
    }

    public AsynchronousLogSink(LogSink delegate, final boolean flushOnShutdown) {
        this._delegate = delegate;
        this._startThread = new LazyRunnable(new Runnable(){

            public void run() {
                if (flushOnShutdown) {
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        public void run() {
                            try {
                                AsynchronousLogSink.this.flush();
                            }
                            catch (InterruptedException e) {
                                throw new WrappedException(e);
                            }
                        }
                    });
                }
                new DequeueThread().start();
            }
        });
        this._queue = new ConcurrentLinkedQueue<LogSink.Message>();
        this._emptyNotifier = new CompletionMonitor(true);
        this._nonemptyNotifier = new CompletionMonitor(false);
    }

    public void close() throws IOException {
        this._delegate.close();
    }

    public void flush() throws InterruptedException {
        this._emptyNotifier.ensureSignalled();
    }

    public void log(LogSink.StandardMessage m) {
        this.handle(m);
    }

    public void logStart(LogSink.StartMessage m) {
        this.handle(m);
    }

    public void logEnd(LogSink.EndMessage m) {
        this.handle(m);
    }

    public void logError(LogSink.ErrorMessage m) {
        this.handle(m);
    }

    public void logStack(LogSink.StackMessage m) {
        this.handle(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(LogSink.Message m) {
        boolean wasEmpty = this._queue.isEmpty();
        this._queue.offer(m);
        if (wasEmpty) {
            AsynchronousLogSink asynchronousLogSink = this;
            synchronized (asynchronousLogSink) {
                if (!this._queue.isEmpty()) {
                    this._emptyNotifier.reset();
                    this._nonemptyNotifier.signal();
                }
            }
            this._startThread.run();
        }
    }

    private class DequeueThread
    extends Thread {
        public DequeueThread() {
            super(AsynchronousLogSink.this.toString());
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                AsynchronousLogSink.this._nonemptyNotifier.attemptEnsureSignalled();
                while (!AsynchronousLogSink.this._queue.isEmpty()) {
                    ((LogSink.Message)AsynchronousLogSink.this._queue.remove()).send(AsynchronousLogSink.this._delegate);
                }
                AsynchronousLogSink asynchronousLogSink = AsynchronousLogSink.this;
                synchronized (asynchronousLogSink) {
                    if (AsynchronousLogSink.this._queue.isEmpty()) {
                        AsynchronousLogSink.this._nonemptyNotifier.reset();
                        AsynchronousLogSink.this._emptyNotifier.signal();
                    }
                }
            }
        }
    }
}

