/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.iter;

import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.collect.ConsList;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.BinaryMappedIterable;
import edu.rice.cs.plt.iter.CartesianIterable;
import edu.rice.cs.plt.iter.CollapsedIterable;
import edu.rice.cs.plt.iter.ComposedIterable;
import edu.rice.cs.plt.iter.DiagonalCartesianIterable;
import edu.rice.cs.plt.iter.EmptyIterable;
import edu.rice.cs.plt.iter.FilteredIterable;
import edu.rice.cs.plt.iter.FiniteSequenceIterable;
import edu.rice.cs.plt.iter.ImmutableIterable;
import edu.rice.cs.plt.iter.ImmutableIterator;
import edu.rice.cs.plt.iter.IndexedIterator;
import edu.rice.cs.plt.iter.MappedIterable;
import edu.rice.cs.plt.iter.OptimizedLastIterable;
import edu.rice.cs.plt.iter.ReadOnlyIterator;
import edu.rice.cs.plt.iter.SequenceIterable;
import edu.rice.cs.plt.iter.SingletonIterable;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.iter.SkipFirstIterable;
import edu.rice.cs.plt.iter.SkipLastIterable;
import edu.rice.cs.plt.iter.SnapshotIterable;
import edu.rice.cs.plt.iter.TruncatedIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Lambda2;
import edu.rice.cs.plt.lambda.Lambda3;
import edu.rice.cs.plt.lambda.Lambda4;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.lambda.Predicate2;
import edu.rice.cs.plt.lambda.Predicate3;
import edu.rice.cs.plt.lambda.Predicate4;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.plt.lambda.Runnable2;
import edu.rice.cs.plt.lambda.Runnable3;
import edu.rice.cs.plt.lambda.Runnable4;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.object.ObjectUtil;
import edu.rice.cs.plt.recur.RecurUtil;
import edu.rice.cs.plt.text.TextUtil;
import edu.rice.cs.plt.tuple.Octet;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.OptionVisitor;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.plt.tuple.Quad;
import edu.rice.cs.plt.tuple.Quint;
import edu.rice.cs.plt.tuple.Septet;
import edu.rice.cs.plt.tuple.Sextet;
import edu.rice.cs.plt.tuple.Triple;
import edu.rice.cs.plt.tuple.Wrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.SortedSet;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IterUtil {
    private IterUtil() {
    }

    public static boolean isEmpty(Iterable<?> iter) {
        if (iter instanceof Collection) {
            return ((Collection)iter).isEmpty();
        }
        if (iter instanceof SizedIterable) {
            return ((SizedIterable)iter).isEmpty();
        }
        return !iter.iterator().hasNext();
    }

    public static int sizeOf(Iterable<?> iter) {
        if (iter instanceof SizedIterable) {
            return ((SizedIterable)iter).size();
        }
        if (iter instanceof Collection) {
            return ((Collection)iter).size();
        }
        int result = 0;
        for (Object o : iter) {
            if (++result != Integer.MAX_VALUE) continue;
            break;
        }
        return result;
    }

    public static int sizeOf(Iterable<?> iter, int bound) {
        if (iter instanceof SizedIterable) {
            return ((SizedIterable)iter).size(bound);
        }
        if (iter instanceof Collection) {
            int result = ((Collection)iter).size();
            return result <= bound ? result : bound;
        }
        int result = 0;
        for (Object o : iter) {
            if (++result != bound) continue;
            break;
        }
        return result;
    }

    public static boolean isInfinite(Iterable<?> iter) {
        if (iter instanceof SizedIterable) {
            return ((SizedIterable)iter).isInfinite();
        }
        return false;
    }

    public static boolean hasFixedSize(Iterable<?> iter) {
        if (iter instanceof SizedIterable) {
            return ((SizedIterable)iter).hasFixedSize();
        }
        if (iter instanceof Collection) {
            return IterUtil.isFixedSizeCollection((Collection)iter);
        }
        return false;
    }

    private static boolean isFixedSizeCollection(Collection<?> iter) {
        return iter == Collections.EMPTY_SET || iter == Collections.EMPTY_LIST;
    }

    public static boolean isStatic(Iterable<?> iter) {
        if (iter instanceof SizedIterable) {
            return ((SizedIterable)iter).isStatic();
        }
        if (iter instanceof Collection) {
            return IterUtil.isStaticCollection((Collection)iter);
        }
        return false;
    }

    private static boolean isStaticCollection(Collection<?> iter) {
        return iter == Collections.EMPTY_SET || iter == Collections.EMPTY_LIST;
    }

    public static boolean contains(Iterable<?> iter, Object o) {
        if (iter instanceof Collection) {
            return ((Collection)iter).contains(o);
        }
        return IterUtil.iteratedContains(iter, o);
    }

    public static boolean containsAll(Iterable<?> iter, Iterable<?> subset) {
        if (iter instanceof Collection) {
            return CollectUtil.containsAll((Collection)iter, subset);
        }
        for (Object o : subset) {
            if (IterUtil.iteratedContains(iter, o)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAny(Iterable<?> iter, Iterable<?> candidates) {
        if (iter instanceof Collection) {
            return CollectUtil.containsAny((Collection)iter, candidates);
        }
        for (Object o : candidates) {
            if (!IterUtil.iteratedContains(iter, o)) continue;
            return true;
        }
        return false;
    }

    private static boolean iteratedContains(Iterable<?> iter, Object o) {
        if (o == null) {
            for (Object elt : iter) {
                if (elt != null) continue;
                return true;
            }
            return false;
        }
        for (Object elt : iter) {
            if (!o.equals(elt)) continue;
            return true;
        }
        return false;
    }

    public static String toString(Iterable<?> iter) {
        return IterUtil.toString(iter, "[", ", ", "]");
    }

    public static String multilineToString(Iterable<?> iter) {
        return IterUtil.toString(iter, "", TextUtil.NEWLINE, "");
    }

    public static String toString(Iterable<?> iter, String prefix, String delimiter, String suffix) {
        if (IterUtil.isInfinite(iter)) {
            iter = IterUtil.compose(new TruncatedIterable(iter, 8), "...");
        }
        StringBuilder result = new StringBuilder();
        result.append(prefix);
        boolean first = true;
        for (Object obj : iter) {
            if (first) {
                first = false;
            } else {
                result.append(delimiter);
            }
            result.append(RecurUtil.safeToString(obj));
        }
        result.append(suffix);
        return result.toString();
    }

    public static boolean isEqual(Iterable<?> iter1, Iterable<?> iter2) {
        if (iter1 == iter2) {
            return true;
        }
        if (IterUtil.sizeOf(iter1) == IterUtil.sizeOf(iter2)) {
            return IterUtil.and(iter1, iter2, LambdaUtil.EQUAL);
        }
        return false;
    }

    public static int hashCode(Iterable<?> iter) {
        int result = Iterable.class.hashCode();
        int shift = 0;
        for (Object obj : iter) {
            result ^= RecurUtil.safeHashCode(obj) << (shift & 0xF);
            ++shift;
        }
        return result;
    }

    public static <T> ReadOnlyIterator<T> asIterator(final Enumeration<? extends T> en) {
        return new ReadOnlyIterator<T>(){

            @Override
            public boolean hasNext() {
                return en.hasMoreElements();
            }

            @Override
            public T next() {
                return en.nextElement();
            }
        };
    }

    public static ReadOnlyIterator<String> asIterator(final StringTokenizer s) {
        return new ReadOnlyIterator<String>(){

            @Override
            public boolean hasNext() {
                return s.hasMoreTokens();
            }

            @Override
            public String next() {
                return s.nextToken();
            }
        };
    }

    public static ReadOnlyIterator<Character> asIterator(final Reader in) {
        return new ReadOnlyIterator<Character>(){
            private int _lookahead = this.readNext();

            @Override
            public boolean hasNext() {
                return this._lookahead >= 0;
            }

            @Override
            public Character next() {
                if (this._lookahead < 0) {
                    throw new NoSuchElementException();
                }
                Character result = Character.valueOf((char)this._lookahead);
                this._lookahead = this.readNext();
                return result;
            }

            private int readNext() {
                try {
                    return in.read();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    public static ReadOnlyIterator<Byte> asIterator(final InputStream in) {
        return new ReadOnlyIterator<Byte>(){
            private int _lookahead = this.readNext();

            @Override
            public boolean hasNext() {
                return this._lookahead >= 0;
            }

            @Override
            public Byte next() {
                if (this._lookahead < 0) {
                    throw new NoSuchElementException();
                }
                Byte result = (byte)this._lookahead;
                this._lookahead = this.readNext();
                return result;
            }

            private int readNext() {
                try {
                    return in.read();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    public static <T> Enumeration<T> asEnumeration(final Iterator<? extends T> iter) {
        return new Enumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            @Override
            public T nextElement() {
                return iter.next();
            }
        };
    }

    public static <T> EmptyIterable<T> empty() {
        return EmptyIterable.INSTANCE;
    }

    public static <T> SingletonIterable<T> singleton(T value) {
        return new SingletonIterable<T>(value);
    }

    public static <T> ComposedIterable<T> compose(T first, Iterable<? extends T> rest) {
        return new ComposedIterable<T>(first, rest);
    }

    public static <T> Lambda2<T, Iterable<? extends T>, Iterable<T>> composeLeftLambda() {
        return ComposeLeftLambda.INSTANCE;
    }

    public static <T> ComposedIterable<T> compose(Iterable<? extends T> rest, T last) {
        return new ComposedIterable<T>(rest, last);
    }

    public static <T> Lambda2<Iterable<? extends T>, T, Iterable<T>> composeRightLambda() {
        return ComposeRightLambda.INSTANCE;
    }

    public static <T> ComposedIterable<T> compose(Iterable<? extends T> i1, Iterable<? extends T> i2) {
        return new ComposedIterable<Iterable<? extends T>>(i1, i2);
    }

    public static <T> Lambda2<Iterable<? extends T>, Iterable<? extends T>, Iterable<T>> composeLambda() {
        return ComposeLambda.INSTANCE;
    }

    public static <T> SnapshotIterable<T> snapshot(Iterable<? extends T> iter) {
        return new SnapshotIterable<T>(iter);
    }

    public static <T> SnapshotIterable<T> snapshot(Iterator<? extends T> iter) {
        return new SnapshotIterable<T>(iter);
    }

    public static <T> Iterable<T> conditionalSnapshot(Iterable<T> iter, int threshold) {
        if (ObjectUtil.compositeSize(iter) > threshold) {
            return new SnapshotIterable<T>(iter);
        }
        return iter;
    }

    public static <T> ImmutableIterable<T> immutable(Iterable<? extends T> iter) {
        return new ImmutableIterable<T>(iter);
    }

    public static <T> SizedIterable<T> relax(Iterable<? extends T> iter) {
        return new ImmutableIterable<T>(iter);
    }

    public static <T> Iterator<T> relax(Iterator<? extends T> iter) {
        return new ImmutableIterator<T>(iter);
    }

    public static <T> SizedIterable<T> make() {
        EmptyIterable<Object> result = EmptyIterable.INSTANCE;
        return result;
    }

    public static <T> SizedIterable<T> make(T v1) {
        return new SingletonIterable<T>(v1);
    }

    public static <T> SizedIterable<T> make(T v1, T v2) {
        Object[] values = new Object[]{v1, v2};
        return new ObjectArrayWrapper<Object>(values, false);
    }

    public static <T> SizedIterable<T> make(T v1, T v2, T v3) {
        Object[] values = new Object[]{v1, v2, v3};
        return new ObjectArrayWrapper<Object>(values, false);
    }

    public static <T> SizedIterable<T> make(T v1, T v2, T v3, T v4) {
        Object[] values = new Object[]{v1, v2, v3, v4};
        return new ObjectArrayWrapper<Object>(values, false);
    }

    public static <T> SizedIterable<T> make(T v1, T v2, T v3, T v4, T v5) {
        Object[] values = new Object[]{v1, v2, v3, v4, v5};
        return new ObjectArrayWrapper<Object>(values, false);
    }

    public static <T> SizedIterable<T> make(T v1, T v2, T v3, T v4, T v5, T v6) {
        Object[] values = new Object[]{v1, v2, v3, v4, v5, v6};
        return new ObjectArrayWrapper<Object>(values, false);
    }

    public static <T> SizedIterable<T> make(T v1, T v2, T v3, T v4, T v5, T v6, T v7) {
        Object[] values = new Object[]{v1, v2, v3, v4, v5, v6, v7};
        return new ObjectArrayWrapper<Object>(values, false);
    }

    public static <T> SizedIterable<T> make(T v1, T v2, T v3, T v4, T v5, T v6, T v7, T v8) {
        Object[] values = new Object[]{v1, v2, v3, v4, v5, v6, v7, v8};
        return new ObjectArrayWrapper<Object>(values, false);
    }

    public static <T> SizedIterable<T> make(T v1, T v2, T v3, T v4, T v5, T v6, T v7, T v8, T v9) {
        Object[] values = new Object[]{v1, v2, v3, v4, v5, v6, v7, v8, v9};
        return new ObjectArrayWrapper<Object>(values, false);
    }

    public static <T> SizedIterable<T> make(T v1, T v2, T v3, T v4, T v5, T v6, T v7, T v8, T v9, T v10) {
        Object[] values = new Object[]{v1, v2, v3, v4, v5, v6, v7, v8, v9, v10};
        return new ObjectArrayWrapper<Object>(values, false);
    }

    public static <T> SizedIterable<T> make(T ... vals) {
        return IterUtil.snapshot(new ObjectArrayWrapper<T>(vals));
    }

    public static <T> SizedIterable<T> make(T[] vals, int start) {
        return IterUtil.snapshot(new ObjectArrayWrapper<T>(vals, start));
    }

    public static <T> SizedIterable<T> make(T[] vals, int start, int end) {
        return IterUtil.snapshot(new ObjectArrayWrapper<T>(vals, start, end));
    }

    public static <T> SequenceIterable<T> infiniteSequence(T initial, Lambda<? super T, ? extends T> successor) {
        return new SequenceIterable<T>(initial, successor);
    }

    public static <T> FiniteSequenceIterable<T> finiteSequence(T initial, Lambda<? super T, ? extends T> successor, int size) {
        return new FiniteSequenceIterable<T>(initial, successor, size);
    }

    public static FiniteSequenceIterable<Integer> integerSequence(int start, int end) {
        return FiniteSequenceIterable.makeIntegerSequence(start, end);
    }

    public static <T> FiniteSequenceIterable<T> copy(T value, int copies) {
        return FiniteSequenceIterable.makeCopies(value, copies);
    }

    public static <T> SizedIterable<T> asIterable(T ... array) {
        return new ObjectArrayWrapper<T>(array);
    }

    public static <T> SizedIterable<T> arraySegment(T[] array, int start) {
        return new ObjectArrayWrapper<T>(array, start);
    }

    public static <T> SizedIterable<T> arraySegment(T[] array, int start, int end) {
        return new ObjectArrayWrapper<T>(array, start, end);
    }

    public static SizedIterable<Boolean> asIterable(boolean[] array) {
        return new BooleanArrayWrapper(array);
    }

    public static SizedIterable<Boolean> arraySegment(boolean[] array, int start) {
        return new BooleanArrayWrapper(array, start);
    }

    public static SizedIterable<Boolean> arraySegment(boolean[] array, int start, int end) {
        return new BooleanArrayWrapper(array, start, end);
    }

    public static SizedIterable<Character> asIterable(char[] array) {
        return new CharArrayWrapper(array);
    }

    public static SizedIterable<Character> arraySegment(char[] array, int start) {
        return new CharArrayWrapper(array, start);
    }

    public static SizedIterable<Character> arraySegment(char[] array, int start, int end) {
        return new CharArrayWrapper(array, start, end);
    }

    public static SizedIterable<Byte> asIterable(byte[] values) {
        return new ByteArrayWrapper(values);
    }

    public static SizedIterable<Byte> arraySegment(byte[] array, int start) {
        return new ByteArrayWrapper(array, start);
    }

    public static SizedIterable<Byte> arraySegment(byte[] array, int start, int end) {
        return new ByteArrayWrapper(array, start, end);
    }

    public static SizedIterable<Short> asIterable(short[] values) {
        return new ShortArrayWrapper(values);
    }

    public static SizedIterable<Short> arraySegment(short[] array, int start) {
        return new ShortArrayWrapper(array, start);
    }

    public static SizedIterable<Short> arraySegment(short[] array, int start, int end) {
        return new ShortArrayWrapper(array, start, end);
    }

    public static SizedIterable<Integer> asIterable(int[] values) {
        return new IntArrayWrapper(values);
    }

    public static SizedIterable<Integer> arraySegment(int[] array, int start) {
        return new IntArrayWrapper(array, start);
    }

    public static SizedIterable<Integer> arraySegment(int[] array, int start, int end) {
        return new IntArrayWrapper(array, start, end);
    }

    public static SizedIterable<Long> asIterable(long[] values) {
        return new LongArrayWrapper(values);
    }

    public static SizedIterable<Long> arraySegment(long[] array, int start) {
        return new LongArrayWrapper(array, start);
    }

    public static SizedIterable<Long> arraySegment(long[] array, int start, int end) {
        return new LongArrayWrapper(array, start, end);
    }

    public static SizedIterable<Float> asIterable(float[] values) {
        return new FloatArrayWrapper(values);
    }

    public static SizedIterable<Float> arraySegment(float[] array, int start) {
        return new FloatArrayWrapper(array, start);
    }

    public static SizedIterable<Float> arraySegment(float[] array, int start, int end) {
        return new FloatArrayWrapper(array, start, end);
    }

    public static SizedIterable<Double> asIterable(double[] values) {
        return new DoubleArrayWrapper(values);
    }

    public static SizedIterable<Double> arraySegment(double[] array, int start) {
        return new DoubleArrayWrapper(array, start);
    }

    public static SizedIterable<Double> arraySegment(double[] array, int start, int end) {
        return new DoubleArrayWrapper(array, start, end);
    }

    public static SizedIterable<?> arrayAsIterable(Object array) {
        if (array instanceof Object[]) {
            return new ObjectArrayWrapper<Object>((Object[])array);
        }
        if (array instanceof int[]) {
            return new IntArrayWrapper((int[])array);
        }
        if (array instanceof char[]) {
            return new CharArrayWrapper((char[])array);
        }
        if (array instanceof byte[]) {
            return new ByteArrayWrapper((byte[])array);
        }
        if (array instanceof double[]) {
            return new DoubleArrayWrapper((double[])array);
        }
        if (array instanceof boolean[]) {
            return new BooleanArrayWrapper((boolean[])array);
        }
        if (array instanceof short[]) {
            return new ShortArrayWrapper((short[])array);
        }
        if (array instanceof long[]) {
            return new LongArrayWrapper((long[])array);
        }
        if (array instanceof float[]) {
            return new FloatArrayWrapper((float[])array);
        }
        throw new IllegalArgumentException("Non-array argument");
    }

    public static <T> SizedIterable<T> asSizedIterable(Collection<T> coll) {
        if (coll instanceof SizedIterable) {
            return (SizedIterable)((Object)coll);
        }
        return new CollectionWrapper<T>(coll);
    }

    public static SizedIterable<Character> asIterable(CharSequence sequence) {
        return new CharSequenceWrapper(sequence, true);
    }

    public static SizedIterable<Character> asIterable(String sequence) {
        return new CharSequenceWrapper(sequence, false);
    }

    public static <T> SizedIterable<T> toIterable(Option<? extends T> option) {
        return (SizedIterable)option.apply(new OptionVisitor<T, SizedIterable<T>>(){

            @Override
            public SizedIterable<T> forSome(T val) {
                return new SingletonIterable(val);
            }

            @Override
            public SizedIterable<T> forNone() {
                return EmptyIterable.INSTANCE;
            }
        });
    }

    public static <T> SizedIterable<T> toIterable(Wrapper<? extends T> tuple) {
        return new SingletonIterable<T>(tuple.value());
    }

    public static <T> SizedIterable<T> toIterable(Pair<? extends T, ? extends T> tuple) {
        Object[] values = new Object[]{tuple.first(), tuple.second()};
        return new ObjectArrayWrapper<Object>(values, false);
    }

    public static <T> SizedIterable<T> toIterable(Triple<? extends T, ? extends T, ? extends T> tuple) {
        Object[] values = new Object[]{tuple.first(), tuple.second(), tuple.third()};
        return new ObjectArrayWrapper<Object>(values, false);
    }

    public static <T> SizedIterable<T> toIterable(Quad<? extends T, ? extends T, ? extends T, ? extends T> tuple) {
        Object[] values = new Object[]{tuple.first(), tuple.second(), tuple.third(), tuple.fourth()};
        return new ObjectArrayWrapper<Object>(values, false);
    }

    public static <T> SizedIterable<T> toIterable(Quint<? extends T, ? extends T, ? extends T, ? extends T, ? extends T> tuple) {
        Object[] values = new Object[]{tuple.first(), tuple.second(), tuple.third(), tuple.fourth(), tuple.fifth()};
        return new ObjectArrayWrapper<Object>(values, false);
    }

    public static <T> SizedIterable<T> toIterable(Sextet<? extends T, ? extends T, ? extends T, ? extends T, ? extends T, ? extends T> tuple) {
        Object[] values = new Object[]{tuple.first(), tuple.second(), tuple.third(), tuple.fourth(), tuple.fifth(), tuple.sixth()};
        return new ObjectArrayWrapper<Object>(values, false);
    }

    public static <T> SizedIterable<T> toIterable(Septet<? extends T, ? extends T, ? extends T, ? extends T, ? extends T, ? extends T, ? extends T> tuple) {
        Object[] values = new Object[]{tuple.first(), tuple.second(), tuple.third(), tuple.fourth(), tuple.fifth(), tuple.sixth(), tuple.seventh()};
        return new ObjectArrayWrapper<Object>(values, false);
    }

    public static <T> SizedIterable<T> toIterable(Octet<? extends T, ? extends T, ? extends T, ? extends T, ? extends T, ? extends T, ? extends T, ? extends T> tuple) {
        Object[] values = new Object[]{tuple.first(), tuple.second(), tuple.third(), tuple.fourth(), tuple.fifth(), tuple.sixth(), tuple.seventh(), tuple.eighth()};
        return new ObjectArrayWrapper<Object>(values, false);
    }

    public static <T> T[] toArray(Iterable<? extends T> iter, Class<T> type) {
        Object[] result = (Object[])Array.newInstance(type, IterUtil.sizeOf(iter));
        if (iter instanceof Collection) {
            Object[] newResult = ((Collection)iter).toArray(result);
            result = newResult;
        } else {
            int i = 0;
            for (T t : iter) {
                result[i++] = t;
                if (i >= 0) continue;
                break;
            }
        }
        return result;
    }

    public static <T> T first(Iterable<? extends T> iter) {
        return iter.iterator().next();
    }

    public static <T> SkipFirstIterable<T> skipFirst(Iterable<T> iter) {
        return new SkipFirstIterable<T>(iter);
    }

    public static <T> T last(Iterable<? extends T> iter) {
        if (iter instanceof OptimizedLastIterable) {
            OptimizedLastIterable o = (OptimizedLastIterable)iter;
            return o.last();
        }
        if (iter instanceof List) {
            List l = (List)iter;
            int size = l.size();
            if (size == 0) {
                throw new NoSuchElementException();
            }
            return (T)l.get(size - 1);
        }
        if (iter instanceof SortedSet) {
            SortedSet s = (SortedSet)iter;
            return (T)s.last();
        }
        Iterator<T> i = iter.iterator();
        T result = i.next();
        while (i.hasNext()) {
            result = i.next();
        }
        return result;
    }

    public static <T> SkipLastIterable<T> skipLast(Iterable<? extends T> iter) {
        return new SkipLastIterable<T>(iter);
    }

    public static <T> Option<T> makeOption(Iterable<? extends T> iter) {
        int size = IterUtil.sizeOf(iter);
        if (size == 0) {
            return Option.none();
        }
        if (size == 1) {
            return Option.some(IterUtil.first(iter));
        }
        throw new IllegalArgumentException("Iterable has more than 1 element: size == " + size);
    }

    public static <T> Wrapper<T> makeWrapper(Iterable<? extends T> iter) {
        int size = IterUtil.sizeOf(iter);
        if (size != 1) {
            throw new IllegalArgumentException("Iterable does not have 1 element: size == " + size);
        }
        Iterator<T> i = iter.iterator();
        return new Wrapper<T>(i.next());
    }

    public static <T> Pair<T, T> makePair(Iterable<? extends T> iter) {
        int size = IterUtil.sizeOf(iter);
        if (size != 2) {
            throw new IllegalArgumentException("Iterable does not have 2 elements: size == " + size);
        }
        Iterator<T> i = iter.iterator();
        return new Pair<T, T>(i.next(), i.next());
    }

    public static <T> Triple<T, T, T> makeTriple(Iterable<? extends T> iter) {
        int size = IterUtil.sizeOf(iter);
        if (size != 3) {
            throw new IllegalArgumentException("Iterable does not have 3 elements: size == " + size);
        }
        Iterator<T> i = iter.iterator();
        return new Triple<T, T, T>(i.next(), i.next(), i.next());
    }

    public static <T> Quad<T, T, T, T> makeQuad(Iterable<? extends T> iter) {
        int size = IterUtil.sizeOf(iter);
        if (size != 4) {
            throw new IllegalArgumentException("Iterable does not have 4 elements: size == " + size);
        }
        Iterator<T> i = iter.iterator();
        return new Quad<T, T, T, T>(i.next(), i.next(), i.next(), i.next());
    }

    public static <T> Quint<T, T, T, T, T> makeQuint(Iterable<? extends T> iter) {
        int size = IterUtil.sizeOf(iter);
        if (size != 5) {
            throw new IllegalArgumentException("Iterable does not have 5 elements: size == " + size);
        }
        Iterator<T> i = iter.iterator();
        return new Quint<T, T, T, T, T>(i.next(), i.next(), i.next(), i.next(), i.next());
    }

    public static <T> Sextet<T, T, T, T, T, T> makeSextet(Iterable<? extends T> iter) {
        int size = IterUtil.sizeOf(iter);
        if (size != 6) {
            throw new IllegalArgumentException("Iterable does not have 6 elements: size == " + size);
        }
        Iterator<T> i = iter.iterator();
        return new Sextet<T, T, T, T, T, T>(i.next(), i.next(), i.next(), i.next(), i.next(), i.next());
    }

    public static <T> Septet<T, T, T, T, T, T, T> makeSeptet(Iterable<? extends T> iter) {
        int size = IterUtil.sizeOf(iter);
        if (size != 7) {
            throw new IllegalArgumentException("Iterable does not have 7 elements: size == " + size);
        }
        Iterator<T> i = iter.iterator();
        return new Septet<T, T, T, T, T, T, T>(i.next(), i.next(), i.next(), i.next(), i.next(), i.next(), i.next());
    }

    public static <T> Octet<T, T, T, T, T, T, T, T> makeOctet(Iterable<? extends T> iter) {
        int size = IterUtil.sizeOf(iter);
        if (size != 8) {
            throw new IllegalArgumentException("Iterable does not have 8 elements: size == " + size);
        }
        Iterator<T> i = iter.iterator();
        return new Octet<T, T, T, T, T, T, T, T>(i.next(), i.next(), i.next(), i.next(), i.next(), i.next(), i.next(), i.next());
    }

    public static <T> SizedIterable<T> reverse(Iterable<? extends T> iter) {
        ConsList result = ConsList.empty();
        for (T elt : iter) {
            result = ConsList.cons(elt, result);
        }
        return result;
    }

    public static <T> SizedIterable<T> shuffle(Iterable<T> iter) {
        ArrayList<T> result = CollectUtil.makeArrayList(iter);
        Collections.shuffle(result);
        return IterUtil.asSizedIterable(result);
    }

    public static <T> SizedIterable<T> shuffle(Iterable<T> iter, Random random) {
        ArrayList<T> result = CollectUtil.makeArrayList(iter);
        Collections.shuffle(result, random);
        return IterUtil.asSizedIterable(result);
    }

    public static <T extends Comparable<? super T>> SizedIterable<T> sort(Iterable<T> iter) {
        ArrayList<T> result = CollectUtil.makeArrayList(iter);
        Collections.sort(result);
        return IterUtil.asSizedIterable(result);
    }

    public static <T> SizedIterable<T> sort(Iterable<T> iter, Comparator<? super T> comp) {
        ArrayList<T> result = CollectUtil.makeArrayList(iter);
        Collections.sort(result, comp);
        return IterUtil.asSizedIterable(result);
    }

    public static <T> Pair<SizedIterable<T>, SizedIterable<T>> split(Iterable<? extends T> iter, int index) {
        Iterator<T> iterator = iter.iterator();
        AbstractIterable left = EmptyIterable.INSTANCE;
        for (int i = 0; i < index && iterator.hasNext(); ++i) {
            left = new ComposedIterable<Object>(left, iterator.next());
        }
        return new Pair<SizedIterable<T>, SizedIterable<T>>(left, new SnapshotIterable<T>(iterator));
    }

    public static <T> TruncatedIterable<T> truncate(Iterable<? extends T> iter, int size) {
        return new TruncatedIterable<T>(iter, size);
    }

    public static <T> CollapsedIterable<T> collapse(Iterable<? extends Iterable<? extends T>> iters) {
        return new CollapsedIterable(iters);
    }

    public static <T> FilteredIterable<T> filter(Iterable<? extends T> iter, Predicate<? super T> pred) {
        return new FilteredIterable<T>(iter, pred);
    }

    public static <T> SnapshotIterable<T> filterSnapshot(Iterable<? extends T> iter, Predicate<? super T> pred) {
        return new SnapshotIterable<T>(new FilteredIterable<T>(iter, pred));
    }

    public static <T> FilteredIterable<T> filterInstances(Iterable<? super T> iter, final Class<? extends T> c) {
        SizedIterable cast = IterUtil.map(iter, new Lambda<Object, T>(){

            @Override
            public T value(Object obj) {
                if (c.isInstance(obj)) {
                    return c.cast(obj);
                }
                return null;
            }
        });
        return new FilteredIterable<Object>(cast, LambdaUtil.NOT_NULL);
    }

    public static <T, R> R fold(Iterable<? extends T> iter, R base, Lambda2<? super R, ? super T, ? extends R> combiner) {
        R result = base;
        for (T elt : iter) {
            result = combiner.value(result, elt);
        }
        return result;
    }

    public static <T> boolean and(Iterable<? extends T> iter, Predicate<? super T> pred) {
        for (T elt : iter) {
            if (pred.contains(elt)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean or(Iterable<? extends T> iter, Predicate<? super T> pred) {
        for (T elt : iter) {
            if (!pred.contains(elt)) continue;
            return true;
        }
        return false;
    }

    public static <T1, T2> boolean and(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Predicate2<? super T1, ? super T2> pred) {
        Iterator<T1> i1 = iter1.iterator();
        Iterator<T2> i2 = iter2.iterator();
        while (i1.hasNext()) {
            if (pred.contains(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    public static <T1, T2> boolean or(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Predicate2<? super T1, ? super T2> pred) {
        Iterator<T1> i1 = iter1.iterator();
        Iterator<T2> i2 = iter2.iterator();
        while (i1.hasNext()) {
            if (!pred.contains(i1.next(), i2.next())) continue;
            return true;
        }
        return false;
    }

    public static <T1, T2, T3> boolean and(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Iterable<? extends T3> iter3, Predicate3<? super T1, ? super T2, ? super T3> pred) {
        Iterator<T1> i1 = iter1.iterator();
        Iterator<T2> i2 = iter2.iterator();
        Iterator<T3> i3 = iter3.iterator();
        while (i1.hasNext()) {
            if (pred.contains(i1.next(), i2.next(), i3.next())) continue;
            return false;
        }
        return true;
    }

    public static <T1, T2, T3> boolean or(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Iterable<? extends T3> iter3, Predicate3<? super T1, ? super T2, ? super T3> pred) {
        Iterator<T1> i1 = iter1.iterator();
        Iterator<T2> i2 = iter2.iterator();
        Iterator<T3> i3 = iter3.iterator();
        while (i1.hasNext()) {
            if (!pred.contains(i1.next(), i2.next(), i3.next())) continue;
            return true;
        }
        return false;
    }

    public static <T1, T2, T3, T4> boolean and(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Iterable<? extends T3> iter3, Iterable<? extends T4> iter4, Predicate4<? super T1, ? super T2, ? super T3, ? super T4> pred) {
        Iterator<T1> i1 = iter1.iterator();
        Iterator<T2> i2 = iter2.iterator();
        Iterator<T3> i3 = iter3.iterator();
        Iterator<T4> i4 = iter4.iterator();
        while (i1.hasNext()) {
            if (pred.contains(i1.next(), i2.next(), i3.next(), i4.next())) continue;
            return false;
        }
        return true;
    }

    public static <T1, T2, T3, T4> boolean or(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Iterable<? extends T3> iter3, Iterable<? extends T4> iter4, Predicate4<? super T1, ? super T2, ? super T3, ? super T4> pred) {
        Iterator<T1> i1 = iter1.iterator();
        Iterator<T2> i2 = iter2.iterator();
        Iterator<T3> i3 = iter3.iterator();
        Iterator<T4> i4 = iter4.iterator();
        while (i1.hasNext()) {
            if (!pred.contains(i1.next(), i2.next(), i3.next(), i4.next())) continue;
            return true;
        }
        return false;
    }

    public static <T, R> SizedIterable<R> map(Iterable<? extends T> source, Lambda<? super T, ? extends R> map) {
        return new MappedIterable<T, R>(source, map);
    }

    public static <T, R> SnapshotIterable<R> mapSnapshot(Iterable<? extends T> source, Lambda<? super T, ? extends R> map) {
        return new SnapshotIterable(new MappedIterable<T, R>(source, map));
    }

    public static <T1, T2, R> SizedIterable<R> map(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Lambda2<? super T1, ? super T2, ? extends R> map) {
        return new BinaryMappedIterable<T1, T2, R>(iter1, iter2, map);
    }

    public static <T1, T2, R> SnapshotIterable<R> mapSnapshot(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Lambda2<? super T1, ? super T2, ? extends R> map) {
        return new SnapshotIterable(new BinaryMappedIterable<T1, T2, R>(iter1, iter2, map));
    }

    public static <T1, T2, T3, R> SizedIterable<R> map(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Iterable<? extends T3> iter3, Lambda3<? super T1, ? super T2, ? super T3, ? extends R> map) {
        SingletonIterable<Lambda<? super T1, Lambda<? super T2, Lambda<? super T3, ? extends R>>>> r0 = IterUtil.singleton(LambdaUtil.curry(map));
        SizedIterable r1 = IterUtil.cross(r0, iter1, LambdaUtil.applicationLambda());
        BinaryMappedIterable r2 = BinaryMappedIterable.make(r1, iter2, LambdaUtil.applicationLambda());
        return BinaryMappedIterable.make(r2, iter3, LambdaUtil.applicationLambda());
    }

    public static <T1, T2, T3, R> SnapshotIterable<R> mapSnapshot(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Iterable<? extends T3> iter3, Lambda3<? super T1, ? super T2, ? super T3, ? extends R> map) {
        return new SnapshotIterable<R>(IterUtil.map(iter1, iter2, iter3, map));
    }

    public static <T1, T2, T3, T4, R> SizedIterable<R> map(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Iterable<? extends T3> iter3, Iterable<? extends T4> iter4, Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> map) {
        SingletonIterable<Lambda<? super T1, Lambda<? super T2, Lambda<? super T3, Lambda<? super T4, ? extends R>>>>> r0 = IterUtil.singleton(LambdaUtil.curry(map));
        SizedIterable r1 = IterUtil.cross(r0, iter1, LambdaUtil.applicationLambda());
        BinaryMappedIterable r2 = BinaryMappedIterable.make(r1, iter2, LambdaUtil.applicationLambda());
        BinaryMappedIterable r3 = BinaryMappedIterable.make(r2, iter3, LambdaUtil.applicationLambda());
        return BinaryMappedIterable.make(r3, iter4, LambdaUtil.applicationLambda());
    }

    public static <T1, T2, T3, T4, R> SnapshotIterable<R> mapSnapshot(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Iterable<? extends T3> iter3, Iterable<? extends T4> iter4, Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> map) {
        return new SnapshotIterable<R>(IterUtil.map(iter1, iter2, iter3, iter4, map));
    }

    public static <T> void run(Iterable<? extends T> iter, Runnable1<? super T> runnable) {
        for (T elt : iter) {
            runnable.run(elt);
        }
    }

    public static <T1, T2> void run(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Runnable2<? super T1, ? super T2> runnable) {
        Iterator<T1> i1 = iter1.iterator();
        Iterator<T2> i2 = iter2.iterator();
        while (i1.hasNext()) {
            runnable.run(i1.next(), i2.next());
        }
    }

    public static <T1, T2, T3> void run(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Iterable<? extends T3> iter3, Runnable3<? super T1, ? super T2, ? super T3> runnable) {
        Iterator<T1> i1 = iter1.iterator();
        Iterator<T2> i2 = iter2.iterator();
        Iterator<T3> i3 = iter3.iterator();
        while (i1.hasNext()) {
            runnable.run(i1.next(), i2.next(), i3.next());
        }
    }

    public static <T1, T2, T3, T4> void run(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Iterable<? extends T3> iter3, Iterable<? extends T4> iter4, Runnable4<? super T1, ? super T2, ? super T3, ? super T4> runnable) {
        Iterator<T1> i1 = iter1.iterator();
        Iterator<T2> i2 = iter2.iterator();
        Iterator<T3> i3 = iter3.iterator();
        Iterator<T4> i4 = iter4.iterator();
        while (i1.hasNext()) {
            runnable.run(i1.next(), i2.next(), i3.next(), i4.next());
        }
    }

    public static <T1, T2, R> SizedIterable<R> cross(Iterable<? extends T1> left, Iterable<? extends T2> right, Lambda2<? super T1, ? super T2, ? extends R> combiner) {
        return new CartesianIterable<T1, T2, R>(left, right, combiner);
    }

    public static <T1, T2> SizedIterable<Pair<T1, T2>> cross(Iterable<? extends T1> left, Iterable<? extends T2> right) {
        return IterUtil.cross(left, right, Pair.factory());
    }

    public static <T1, T2, R> SizedIterable<R> diagonalCross(Iterable<? extends T1> left, Iterable<? extends T2> right, Lambda2<? super T1, ? super T2, ? extends R> combiner) {
        return new DiagonalCartesianIterable<T1, T2, R>(left, right, combiner);
    }

    public static <T1, T2> SizedIterable<Pair<T1, T2>> diagonalCross(Iterable<? extends T1> left, Iterable<? extends T2> right) {
        return IterUtil.diagonalCross(left, right, Pair.factory());
    }

    public static <T1, T2, T3, R> SizedIterable<R> cross(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Iterable<? extends T3> iter3, Lambda3<? super T1, ? super T2, ? super T3, ? extends R> combiner) {
        SingletonIterable<Lambda<? super T1, Lambda<? super T2, Lambda<? super T3, ? extends R>>>> r0 = IterUtil.singleton(LambdaUtil.curry(combiner));
        CartesianIterable r1 = CartesianIterable.make(r0, iter1, LambdaUtil.applicationLambda());
        CartesianIterable r2 = CartesianIterable.make(r1, iter2, LambdaUtil.applicationLambda());
        return CartesianIterable.make(r2, iter3, LambdaUtil.applicationLambda());
    }

    public static <T1, T2, T3> SizedIterable<Triple<T1, T2, T3>> cross(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Iterable<? extends T3> iter3) {
        return IterUtil.cross(iter1, iter2, iter3, Triple.factory());
    }

    public static <T1, T2, T3, R> SizedIterable<R> diagonalCross(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Iterable<? extends T3> iter3, Lambda3<? super T1, ? super T2, ? super T3, ? extends R> combiner) {
        SingletonIterable<Lambda<? super T1, Lambda<? super T2, Lambda<? super T3, ? extends R>>>> r0 = IterUtil.singleton(LambdaUtil.curry(combiner));
        DiagonalCartesianIterable r1 = DiagonalCartesianIterable.make(r0, iter1, LambdaUtil.applicationLambda());
        DiagonalCartesianIterable r2 = DiagonalCartesianIterable.make(r1, iter2, LambdaUtil.applicationLambda());
        return DiagonalCartesianIterable.make(r2, iter3, LambdaUtil.applicationLambda());
    }

    public static <T1, T2, T3> SizedIterable<Triple<T1, T2, T3>> diagonalCross(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Iterable<? extends T3> iter3) {
        return IterUtil.diagonalCross(iter1, iter2, iter3, Triple.factory());
    }

    public static <T1, T2, T3, T4, R> SizedIterable<R> cross(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Iterable<? extends T3> iter3, Iterable<? extends T4> iter4, Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> combiner) {
        SingletonIterable<Lambda<? super T1, Lambda<? super T2, Lambda<? super T3, Lambda<? super T4, ? extends R>>>>> r0 = IterUtil.singleton(LambdaUtil.curry(combiner));
        CartesianIterable r1 = CartesianIterable.make(r0, iter1, LambdaUtil.applicationLambda());
        CartesianIterable r2 = CartesianIterable.make(r1, iter2, LambdaUtil.applicationLambda());
        CartesianIterable r3 = CartesianIterable.make(r2, iter3, LambdaUtil.applicationLambda());
        return CartesianIterable.make(r3, iter4, LambdaUtil.applicationLambda());
    }

    public static <T1, T2, T3, T4> SizedIterable<Quad<T1, T2, T3, T4>> cross(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Iterable<? extends T3> iter3, Iterable<? extends T4> iter4) {
        return IterUtil.cross(iter1, iter2, iter3, iter4, Quad.factory());
    }

    public static <T1, T2, T3, T4, R> SizedIterable<R> diagonalCross(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Iterable<? extends T3> iter3, Iterable<? extends T4> iter4, Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> combiner) {
        SingletonIterable<Lambda<? super T1, Lambda<? super T2, Lambda<? super T3, Lambda<? super T4, ? extends R>>>>> r0 = IterUtil.singleton(LambdaUtil.curry(combiner));
        DiagonalCartesianIterable r1 = DiagonalCartesianIterable.make(r0, iter1, LambdaUtil.applicationLambda());
        DiagonalCartesianIterable r2 = DiagonalCartesianIterable.make(r1, iter2, LambdaUtil.applicationLambda());
        DiagonalCartesianIterable r3 = DiagonalCartesianIterable.make(r2, iter3, LambdaUtil.applicationLambda());
        return DiagonalCartesianIterable.make(r3, iter4, LambdaUtil.applicationLambda());
    }

    public static <T1, T2, T3, T4> SizedIterable<Quad<T1, T2, T3, T4>> diagonalCross(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Iterable<? extends T3> iter3, Iterable<? extends T4> iter4) {
        return IterUtil.diagonalCross(iter1, iter2, iter3, iter4, Quad.factory());
    }

    public static <T> SizedIterable<Iterable<T>> cross(Iterable<? extends Iterable<? extends T>> iters) {
        return IterUtil.crossFold(iters, IterUtil.<T>empty(), IterUtil.<T>composeRightLambda());
    }

    public static <T> SizedIterable<Iterable<T>> diagonalCross(Iterable<? extends Iterable<? extends T>> iters) {
        return IterUtil.diagonalCrossFold(iters, IterUtil.<T>empty(), IterUtil.<T>composeRightLambda());
    }

    public static <T, R> SizedIterable<R> crossFold(Iterable<? extends Iterable<? extends T>> iters, R base, Lambda2<? super R, ? super T, ? extends R> combiner) {
        AbstractIterable result = IterUtil.singleton(base);
        for (Iterable<T> iterable : iters) {
            result = new CartesianIterable<R, T, R>(result, iterable, combiner);
        }
        return result;
    }

    public static <T, R> SizedIterable<R> diagonalCrossFold(Iterable<? extends Iterable<? extends T>> iters, R base, Lambda2<? super R, ? super T, ? extends R> combiner) {
        AbstractIterable result = IterUtil.singleton(base);
        for (Iterable<T> iterable : iters) {
            result = new DiagonalCartesianIterable<R, T, R>(result, iterable, combiner);
        }
        return result;
    }

    public static <R> SizedIterable<R> valuesOf(Iterable<? extends Thunk<? extends R>> iter) {
        return new MappedIterable(iter, LambdaUtil.thunkValueLambda());
    }

    public static <T, R> Iterable<R> valuesOf(Iterable<? extends Lambda<? super T, ? extends R>> iter, T arg) {
        Lambda l = LambdaUtil.bindSecond(LambdaUtil.applicationLambda(), arg);
        return new MappedIterable(iter, l);
    }

    public static <T1, T2, R> SizedIterable<R> valuesOf(Iterable<? extends Lambda2<? super T1, ? super T2, ? extends R>> iter, T1 arg1, T2 arg2) {
        Lambda l = LambdaUtil.bindSecond(LambdaUtil.bindThird(LambdaUtil.binaryApplicationLambda(), arg2), arg1);
        return new MappedIterable(iter, l);
    }

    public static <T1, T2, T3, R> SizedIterable<R> valuesOf(Iterable<? extends Lambda3<? super T1, ? super T2, ? super T3, ? extends R>> iter, T1 arg1, T2 arg2, T3 arg3) {
        Lambda l = LambdaUtil.bindSecond(LambdaUtil.bindThird(LambdaUtil.bindFourth(LambdaUtil.ternaryApplicationLambda(), arg3), arg2), arg1);
        return new MappedIterable(iter, l);
    }

    public static <T> SizedIterable<T> pairFirsts(Iterable<? extends Pair<? extends T, ?>> iter) {
        return new MappedIterable(iter, Pair.firstGetter());
    }

    public static <T> SizedIterable<T> pairSeconds(Iterable<? extends Pair<?, ? extends T>> iter) {
        return new MappedIterable(iter, Pair.secondGetter());
    }

    public static <T> SizedIterable<T> tripleFirsts(Iterable<? extends Triple<? extends T, ?, ?>> iter) {
        return new MappedIterable(iter, Triple.firstGetter());
    }

    public static <T> SizedIterable<T> tripleSeconds(Iterable<? extends Triple<?, ? extends T, ?>> iter) {
        return new MappedIterable(iter, Triple.secondGetter());
    }

    public static <T> SizedIterable<T> tripleThirds(Iterable<? extends Triple<?, ?, ? extends T>> iter) {
        return new MappedIterable(iter, Triple.thirdGetter());
    }

    public static <T> SizedIterable<T> quadFirsts(Iterable<? extends Quad<? extends T, ?, ?, ?>> iter) {
        return new MappedIterable(iter, Quad.firstGetter());
    }

    public static <T> SizedIterable<T> quadSeconds(Iterable<? extends Quad<?, ? extends T, ?, ?>> iter) {
        return new MappedIterable(iter, Quad.secondGetter());
    }

    public static <T> SizedIterable<T> quadThirds(Iterable<? extends Quad<?, ?, ? extends T, ?>> iter) {
        return new MappedIterable(iter, Quad.thirdGetter());
    }

    public static <T> SizedIterable<T> quadFourths(Iterable<? extends Quad<?, ?, ?, ? extends T>> iter) {
        return new MappedIterable(iter, Quad.fourthGetter());
    }

    public static <T1, T2> SizedIterable<Pair<T1, T2>> zip(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2) {
        return new BinaryMappedIterable(iter1, iter2, Pair.factory());
    }

    public static <T1, T2, T3> SizedIterable<Triple<T1, T2, T3>> zip(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Iterable<? extends T3> iter3) {
        return IterUtil.map(iter1, iter2, iter3, Triple.factory());
    }

    public static <T1, T2, T3, T4> SizedIterable<Quad<T1, T2, T3, T4>> zip(Iterable<? extends T1> iter1, Iterable<? extends T2> iter2, Iterable<? extends T3> iter3, Iterable<? extends T4> iter4) {
        return IterUtil.map(iter1, iter2, iter3, iter4, Quad.factory());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CharSequenceWrapper
    extends AbstractIterable<Character>
    implements SizedIterable<Character>,
    OptimizedLastIterable<Character>,
    Serializable {
        private final CharSequence _s;
        private final boolean _mutable;

        public CharSequenceWrapper(CharSequence s, boolean mutable) {
            this._s = s;
            this._mutable = mutable;
        }

        @Override
        public boolean isEmpty() {
            return this._s.length() == 0;
        }

        @Override
        public int size() {
            return this._s.length();
        }

        @Override
        public int size(int bound) {
            int result = this._s.length();
            return result <= bound ? result : bound;
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean hasFixedSize() {
            return !this._mutable;
        }

        @Override
        public boolean isStatic() {
            return !this._mutable;
        }

        @Override
        public Character last() {
            return Character.valueOf(this._s.charAt(this._s.length() - 1));
        }

        @Override
        public Iterator<Character> iterator() {
            return new IndexedIterator<Character>(){

                @Override
                protected int size() {
                    return CharSequenceWrapper.this._s.length();
                }

                @Override
                protected Character get(int i) {
                    return Character.valueOf(CharSequenceWrapper.this._s.charAt(i));
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CollectionWrapper<T>
    extends AbstractIterable<T>
    implements SizedIterable<T>,
    OptimizedLastIterable<T>,
    Serializable {
        private final Collection<T> _c;

        public CollectionWrapper(Collection<T> c) {
            this._c = c;
        }

        @Override
        public Iterator<T> iterator() {
            return this._c.iterator();
        }

        @Override
        public boolean isEmpty() {
            return this._c.isEmpty();
        }

        @Override
        public int size() {
            return this._c.size();
        }

        @Override
        public int size(int bound) {
            int result = this._c.size();
            return result <= bound ? result : bound;
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean hasFixedSize() {
            return IterUtil.isFixedSizeCollection(this._c);
        }

        @Override
        public boolean isStatic() {
            return IterUtil.isStaticCollection(this._c);
        }

        @Override
        public T last() {
            return IterUtil.last(this._c);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DoubleArrayWrapper
    extends AbstractIterable<Double>
    implements SizedIterable<Double>,
    OptimizedLastIterable<Double>,
    Serializable {
        private final double[] _array;
        private final int _start;
        private final int _end;

        public DoubleArrayWrapper(double[] array) {
            this._array = array;
            this._start = 0;
            this._end = this._array.length;
        }

        public DoubleArrayWrapper(double[] array, int start) {
            if (start < 0 || start > array.length) {
                throw new IndexOutOfBoundsException();
            }
            this._array = array;
            this._start = start;
            this._end = array.length;
        }

        public DoubleArrayWrapper(double[] array, int start, int end) {
            if (start < 0 || start > end || end > array.length) {
                throw new IndexOutOfBoundsException();
            }
            this._array = array;
            this._start = start;
            this._end = end;
        }

        @Override
        public boolean isEmpty() {
            return this._start == this._end;
        }

        @Override
        public int size() {
            return this._end - this._start;
        }

        @Override
        public int size(int bound) {
            int result = this._end - this._start;
            return result <= bound ? result : bound;
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean hasFixedSize() {
            return true;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public Double last() {
            return this._array[this._end - 1];
        }

        @Override
        public Iterator<Double> iterator() {
            return new IndexedIterator<Double>(){

                @Override
                protected int size() {
                    return DoubleArrayWrapper.this._end - DoubleArrayWrapper.this._start;
                }

                @Override
                protected Double get(int i) {
                    return DoubleArrayWrapper.this._array[DoubleArrayWrapper.this._start + i];
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FloatArrayWrapper
    extends AbstractIterable<Float>
    implements SizedIterable<Float>,
    OptimizedLastIterable<Float>,
    Serializable {
        private final float[] _array;
        private final int _start;
        private final int _end;

        public FloatArrayWrapper(float[] array) {
            this._array = array;
            this._start = 0;
            this._end = this._array.length;
        }

        public FloatArrayWrapper(float[] array, int start) {
            if (start < 0 || start > array.length) {
                throw new IndexOutOfBoundsException();
            }
            this._array = array;
            this._start = start;
            this._end = array.length;
        }

        public FloatArrayWrapper(float[] array, int start, int end) {
            if (start < 0 || start > end || end > array.length) {
                throw new IndexOutOfBoundsException();
            }
            this._array = array;
            this._start = start;
            this._end = end;
        }

        @Override
        public boolean isEmpty() {
            return this._start == this._end;
        }

        @Override
        public int size() {
            return this._end - this._start;
        }

        @Override
        public int size(int bound) {
            int result = this._end - this._start;
            return result <= bound ? result : bound;
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean hasFixedSize() {
            return true;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public Float last() {
            return Float.valueOf(this._array[this._end - 1]);
        }

        @Override
        public Iterator<Float> iterator() {
            return new IndexedIterator<Float>(){

                @Override
                protected int size() {
                    return FloatArrayWrapper.this._end - FloatArrayWrapper.this._start;
                }

                @Override
                protected Float get(int i) {
                    return Float.valueOf(FloatArrayWrapper.this._array[FloatArrayWrapper.this._start + i]);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LongArrayWrapper
    extends AbstractIterable<Long>
    implements SizedIterable<Long>,
    OptimizedLastIterable<Long>,
    Serializable {
        private final long[] _array;
        private final int _start;
        private final int _end;

        public LongArrayWrapper(long[] array) {
            this._array = array;
            this._start = 0;
            this._end = this._array.length;
        }

        public LongArrayWrapper(long[] array, int start) {
            if (start < 0 || start > array.length) {
                throw new IndexOutOfBoundsException();
            }
            this._array = array;
            this._start = start;
            this._end = array.length;
        }

        public LongArrayWrapper(long[] array, int start, int end) {
            if (start < 0 || start > end || end > array.length) {
                throw new IndexOutOfBoundsException();
            }
            this._array = array;
            this._start = start;
            this._end = end;
        }

        @Override
        public boolean isEmpty() {
            return this._start == this._end;
        }

        @Override
        public int size() {
            return this._end - this._start;
        }

        @Override
        public int size(int bound) {
            int result = this._end - this._start;
            return result <= bound ? result : bound;
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean hasFixedSize() {
            return true;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public Long last() {
            return this._array[this._end - 1];
        }

        @Override
        public Iterator<Long> iterator() {
            return new IndexedIterator<Long>(){

                @Override
                protected int size() {
                    return LongArrayWrapper.this._end - LongArrayWrapper.this._start;
                }

                @Override
                protected Long get(int i) {
                    return LongArrayWrapper.this._array[LongArrayWrapper.this._start + i];
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IntArrayWrapper
    extends AbstractIterable<Integer>
    implements SizedIterable<Integer>,
    OptimizedLastIterable<Integer>,
    Serializable {
        private final int[] _array;
        private final int _start;
        private final int _end;

        public IntArrayWrapper(int[] array) {
            this._array = array;
            this._start = 0;
            this._end = this._array.length;
        }

        public IntArrayWrapper(int[] array, int start) {
            if (start < 0 || start > array.length) {
                throw new IndexOutOfBoundsException();
            }
            this._array = array;
            this._start = start;
            this._end = array.length;
        }

        public IntArrayWrapper(int[] array, int start, int end) {
            if (start < 0 || start > end || end > array.length) {
                throw new IndexOutOfBoundsException();
            }
            this._array = array;
            this._start = start;
            this._end = end;
        }

        @Override
        public boolean isEmpty() {
            return this._start == this._end;
        }

        @Override
        public int size() {
            return this._end - this._start;
        }

        @Override
        public int size(int bound) {
            int result = this._end - this._start;
            return result <= bound ? result : bound;
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean hasFixedSize() {
            return true;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public Integer last() {
            return this._array[this._end - 1];
        }

        @Override
        public Iterator<Integer> iterator() {
            return new IndexedIterator<Integer>(){

                @Override
                protected int size() {
                    return IntArrayWrapper.this._end - IntArrayWrapper.this._start;
                }

                @Override
                protected Integer get(int i) {
                    return IntArrayWrapper.this._array[IntArrayWrapper.this._start + i];
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ShortArrayWrapper
    extends AbstractIterable<Short>
    implements SizedIterable<Short>,
    OptimizedLastIterable<Short>,
    Serializable {
        private final short[] _array;
        private final int _start;
        private final int _end;

        public ShortArrayWrapper(short[] array) {
            this._array = array;
            this._start = 0;
            this._end = this._array.length;
        }

        public ShortArrayWrapper(short[] array, int start) {
            if (start < 0 || start > array.length) {
                throw new IndexOutOfBoundsException();
            }
            this._array = array;
            this._start = start;
            this._end = array.length;
        }

        public ShortArrayWrapper(short[] array, int start, int end) {
            if (start < 0 || start > end || end > array.length) {
                throw new IndexOutOfBoundsException();
            }
            this._array = array;
            this._start = start;
            this._end = end;
        }

        @Override
        public boolean isEmpty() {
            return this._start == this._end;
        }

        @Override
        public int size() {
            return this._end - this._start;
        }

        @Override
        public int size(int bound) {
            int result = this._end - this._start;
            return result <= bound ? result : bound;
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean hasFixedSize() {
            return true;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public Short last() {
            return this._array[this._end - 1];
        }

        @Override
        public Iterator<Short> iterator() {
            return new IndexedIterator<Short>(){

                @Override
                protected int size() {
                    return ShortArrayWrapper.this._end - ShortArrayWrapper.this._start;
                }

                @Override
                protected Short get(int i) {
                    return ShortArrayWrapper.this._array[ShortArrayWrapper.this._start + i];
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ByteArrayWrapper
    extends AbstractIterable<Byte>
    implements SizedIterable<Byte>,
    OptimizedLastIterable<Byte>,
    Serializable {
        private final byte[] _array;
        private final int _start;
        private final int _end;

        public ByteArrayWrapper(byte[] array) {
            this._array = array;
            this._start = 0;
            this._end = this._array.length;
        }

        public ByteArrayWrapper(byte[] array, int start) {
            if (start < 0 || start > array.length) {
                throw new IndexOutOfBoundsException();
            }
            this._array = array;
            this._start = start;
            this._end = array.length;
        }

        public ByteArrayWrapper(byte[] array, int start, int end) {
            if (start < 0 || start > end || end > array.length) {
                throw new IndexOutOfBoundsException();
            }
            this._array = array;
            this._start = start;
            this._end = end;
        }

        @Override
        public boolean isEmpty() {
            return this._start == this._end;
        }

        @Override
        public int size() {
            return this._end - this._start;
        }

        @Override
        public int size(int bound) {
            int result = this._end - this._start;
            return result <= bound ? result : bound;
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean hasFixedSize() {
            return true;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public Byte last() {
            return this._array[this._end - 1];
        }

        @Override
        public Iterator<Byte> iterator() {
            return new IndexedIterator<Byte>(){

                @Override
                protected int size() {
                    return ByteArrayWrapper.this._end - ByteArrayWrapper.this._start;
                }

                @Override
                protected Byte get(int i) {
                    return ByteArrayWrapper.this._array[ByteArrayWrapper.this._start + i];
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CharArrayWrapper
    extends AbstractIterable<Character>
    implements SizedIterable<Character>,
    OptimizedLastIterable<Character>,
    Serializable {
        private final char[] _array;
        private final int _start;
        private final int _end;

        public CharArrayWrapper(char[] array) {
            this._array = array;
            this._start = 0;
            this._end = this._array.length;
        }

        public CharArrayWrapper(char[] array, int start) {
            if (start < 0 || start > array.length) {
                throw new IndexOutOfBoundsException();
            }
            this._array = array;
            this._start = start;
            this._end = array.length;
        }

        public CharArrayWrapper(char[] array, int start, int end) {
            if (start < 0 || start > end || end > array.length) {
                throw new IndexOutOfBoundsException();
            }
            this._array = array;
            this._start = start;
            this._end = end;
        }

        @Override
        public boolean isEmpty() {
            return this._start == this._end;
        }

        @Override
        public int size() {
            return this._end - this._start;
        }

        @Override
        public int size(int bound) {
            int result = this._end - this._start;
            return result <= bound ? result : bound;
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean hasFixedSize() {
            return true;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public Character last() {
            return Character.valueOf(this._array[this._end - 1]);
        }

        @Override
        public Iterator<Character> iterator() {
            return new IndexedIterator<Character>(){

                @Override
                protected int size() {
                    return CharArrayWrapper.this._end - CharArrayWrapper.this._start;
                }

                @Override
                protected Character get(int i) {
                    return Character.valueOf(CharArrayWrapper.this._array[CharArrayWrapper.this._start + i]);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BooleanArrayWrapper
    extends AbstractIterable<Boolean>
    implements SizedIterable<Boolean>,
    OptimizedLastIterable<Boolean>,
    Serializable {
        private final boolean[] _array;
        private final int _start;
        private final int _end;

        public BooleanArrayWrapper(boolean[] array) {
            this._array = array;
            this._start = 0;
            this._end = this._array.length;
        }

        public BooleanArrayWrapper(boolean[] array, int start) {
            if (start < 0 || start > array.length) {
                throw new IndexOutOfBoundsException();
            }
            this._array = array;
            this._start = start;
            this._end = array.length;
        }

        public BooleanArrayWrapper(boolean[] array, int start, int end) {
            if (start < 0 || start > end || end > array.length) {
                throw new IndexOutOfBoundsException();
            }
            this._array = array;
            this._start = start;
            this._end = end;
        }

        @Override
        public boolean isEmpty() {
            return this._start == this._end;
        }

        @Override
        public int size() {
            return this._end - this._start;
        }

        @Override
        public int size(int bound) {
            int result = this._end - this._start;
            return result <= bound ? result : bound;
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean hasFixedSize() {
            return true;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public Boolean last() {
            return this._array[this._end - 1];
        }

        @Override
        public Iterator<Boolean> iterator() {
            return new IndexedIterator<Boolean>(){

                @Override
                protected int size() {
                    return BooleanArrayWrapper.this._end - BooleanArrayWrapper.this._start;
                }

                @Override
                protected Boolean get(int i) {
                    return BooleanArrayWrapper.this._array[BooleanArrayWrapper.this._start + i];
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ObjectArrayWrapper<T>
    extends AbstractIterable<T>
    implements SizedIterable<T>,
    OptimizedLastIterable<T>,
    Serializable {
        private final T[] _array;
        private final int _start;
        private final int _end;
        private final boolean _refs;

        public ObjectArrayWrapper(T[] array) {
            this(array, 0, array.length, true);
        }

        public ObjectArrayWrapper(T[] array, int start) {
            this(array, start, array.length, true);
            if (this._start < 0 || this._start > this._end) {
                throw new IndexOutOfBoundsException();
            }
        }

        public ObjectArrayWrapper(T[] array, int start, int end) {
            this(array, start, end, true);
            if (this._start < 0 || this._start > this._end || this._end > this._array.length) {
                throw new IndexOutOfBoundsException();
            }
        }

        public ObjectArrayWrapper(T[] array, boolean refs) {
            this(array, 0, array.length, refs);
        }

        public ObjectArrayWrapper(T[] array, int start, int end, boolean refs) {
            this._array = array;
            this._start = start;
            this._end = end;
            this._refs = refs;
        }

        @Override
        public boolean isEmpty() {
            return this._start == this._end;
        }

        @Override
        public int size() {
            return this._end - this._start;
        }

        @Override
        public int size(int bound) {
            int result = this._end - this._start;
            return result <= bound ? result : bound;
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean hasFixedSize() {
            return true;
        }

        @Override
        public boolean isStatic() {
            return !this._refs;
        }

        @Override
        public T last() {
            return this._array[this._end - 1];
        }

        @Override
        public Iterator<T> iterator() {
            return new IndexedIterator<T>(){

                @Override
                protected int size() {
                    return ObjectArrayWrapper.this._end - ObjectArrayWrapper.this._start;
                }

                @Override
                protected T get(int i) {
                    return ObjectArrayWrapper.this._array[ObjectArrayWrapper.this._start + i];
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComposeLambda<T>
    implements Lambda2<Iterable<? extends T>, Iterable<? extends T>, Iterable<T>>,
    Serializable {
        private static ComposeLambda<Object> INSTANCE = new ComposeLambda();

        private ComposeLambda() {
        }

        @Override
        public Iterable<T> value(Iterable<? extends T> i1, Iterable<? extends T> i2) {
            return new ComposedIterable<Iterable<? extends T>>(i1, i2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComposeRightLambda<T>
    implements Lambda2<Iterable<? extends T>, T, Iterable<T>>,
    Serializable {
        private static ComposeRightLambda<Object> INSTANCE = new ComposeRightLambda();

        private ComposeRightLambda() {
        }

        @Override
        public Iterable<T> value(Iterable<? extends T> rest, T last) {
            return new ComposedIterable<T>(rest, last);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComposeLeftLambda<T>
    implements Lambda2<T, Iterable<? extends T>, Iterable<T>>,
    Serializable {
        private static ComposeLeftLambda<Object> INSTANCE = new ComposeLeftLambda();

        private ComposeLeftLambda() {
        }

        @Override
        public Iterable<T> value(T first, Iterable<? extends T> rest) {
            return new ComposedIterable<T>(first, rest);
        }
    }
}

