/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.lambda;

import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.Condition;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Lambda2;
import edu.rice.cs.plt.lambda.Lambda3;
import edu.rice.cs.plt.lambda.Lambda4;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.lambda.Predicate2;
import edu.rice.cs.plt.lambda.Predicate3;
import edu.rice.cs.plt.lambda.Predicate4;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.plt.lambda.Runnable2;
import edu.rice.cs.plt.lambda.Runnable3;
import edu.rice.cs.plt.lambda.Runnable4;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.recur.RecurUtil;
import edu.rice.cs.plt.tuple.Null;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.plt.tuple.Quad;
import edu.rice.cs.plt.tuple.Triple;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LambdaUtil {
    public static final GeneralRunnable NO_OP = new NoOp();
    public static final GeneralPredicate TRUE = new True();
    public static final GeneralPredicate FALSE = new False();
    public static final Predicate<Object> IS_NULL = new IsNullPredicate();
    public static final Predicate<Object> NOT_NULL = new NotNullPredicate();
    public static final Predicate2<Object, Object> EQUAL = new EqualPredicate();
    public static final Predicate2<Object, Object> NOT_EQUAL = LambdaUtil.negate(EQUAL);
    public static final Predicate2<Object, Object> IDENTICAL = new IdenticalPredicate();
    public static final Predicate2<Object, Object> NOT_IDENTICAL = new NotIdenticalPredicate();
    public static final Predicate2<Object, Class<?>> INSTANCE_OF = new InstanceOfPredicate();
    public static final Lambda<Object, String> TO_STRING = new ToStringLambda();
    public static final Lambda2<Object, Object, String> STRING_CONCAT = new StringConcatLambda();
    public static final Lambda<Object, Integer> HASH_CODE = new HashCodeLambda();
    public static final Lambda<Integer, Integer> INCREMENT_INT = new IncrementIntLambda();
    public static final Lambda<Integer, Integer> DECREMENT_INT = new DecrementIntLambda();
    public static final Lambda2<Integer, Integer, Integer> ADD_INT = new AddIntLambda();
    public static final Lambda2<Integer, Integer, Integer> SUBTRACT_INT = new SubtractIntLambda();
    public static final Lambda2<Integer, Integer, Integer> MULTIPLY_INT = new MultiplyIntLambda();
    public static final Lambda2<Integer, Integer, Integer> DIVIDE_INT = new DivideIntLambda();

    private LambdaUtil() {
    }

    public static <T> Lambda<T, T> identity() {
        return IdentityLambda.INSTANCE;
    }

    public static <T> GeneralLambda<T> nullLambda() {
        return NullLambda.INSTANCE;
    }

    public static <T> GeneralLambda<T> exceptionLambda(RuntimeException e) {
        return new ExceptionLambda(e);
    }

    public static <T> GeneralLambda<T> valueLambda(T val) {
        return new ValueLambda<T>(val);
    }

    public static <R> Lambda<Thunk<? extends R>, R> thunkValueLambda() {
        return ThunkValueLambda.INSTANCE;
    }

    public static <T, R> Lambda2<Lambda<? super T, ? extends R>, T, R> applicationLambda() {
        return ApplicationLambda.INSTANCE;
    }

    public static <T1, T2, R> Lambda3<Lambda2<? super T1, ? super T2, ? extends R>, T1, T2, R> binaryApplicationLambda() {
        return BinaryApplicationLambda.INSTANCE;
    }

    public static <T1, T2, T3, R> Lambda4<Lambda3<? super T1, ? super T2, ? super T3, ? extends R>, T1, T2, T3, R> ternaryApplicationLambda() {
        return TernaryApplicationLambda.INSTANCE;
    }

    public static GeneralRunnable promote(Runnable r) {
        return new PromotedGeneralRunnable(r);
    }

    public static <T> Runnable2<T, Object> promote(Runnable1<? super T> r) {
        return new PromotedRunnable2<T>(r);
    }

    public static <T1, T2> Runnable3<T1, T2, Object> promote(Runnable2<? super T1, ? super T2> r) {
        return new PromotedRunnable3<T1, T2>(r);
    }

    public static <T1, T2, T3> Runnable4<T1, T2, T3, Object> promote(Runnable3<? super T1, ? super T2, ? super T3> r) {
        return new PromotedRunnable4<T1, T2, T3>(r);
    }

    public static <R> GeneralLambda<R> promote(Thunk<? extends R> thunk) {
        return new PromotedGeneralLambda<R>(thunk);
    }

    public static <T, R> Lambda2<T, Object, R> promote(Lambda<? super T, ? extends R> lambda) {
        return new PromotedLambda2<T, R>(lambda);
    }

    public static <T1, T2, R> Lambda3<T1, T2, Object, R> promote(Lambda2<? super T1, ? super T2, ? extends R> lambda) {
        return new PromotedLambda3<T1, T2, R>(lambda);
    }

    public static <T1, T2, T3, R> Lambda4<T1, T2, T3, Object, R> promote(Lambda3<? super T1, ? super T2, ? super T3, ? extends R> lambda) {
        return new PromotedLambda4<T1, T2, T3, R>(lambda);
    }

    public static GeneralPredicate promote(Condition cond) {
        return new PromotedGeneralPredicate(cond);
    }

    public static <T> Predicate2<T, Object> promote(Predicate<? super T> pred) {
        return new PromotedPredicate2<T>(pred);
    }

    public static <T1, T2> Predicate3<T1, T2, Object> promote(Predicate2<? super T1, ? super T2> pred) {
        return new PromotedPredicate3<T1, T2>(pred);
    }

    public static <T1, T2, T3> Predicate4<T1, T2, T3, Object> promote(Predicate3<? super T1, ? super T2, ? super T3> pred) {
        return new PromotedPredicate4<T1, T2, T3>(pred);
    }

    public static <T, U> Thunk<U> compose(Thunk<? extends T> thunk, Lambda<? super T, ? extends U> lambda) {
        return new ComposedThunk<T, U>(thunk, lambda);
    }

    public static <S, T, U> Lambda<S, U> compose(Lambda<? super S, ? extends T> l1, Lambda<? super T, ? extends U> l2) {
        return new ComposedLambda<S, T, U>(l1, l2);
    }

    public static <S1, S2, T, U> Lambda2<S1, S2, U> compose(Lambda2<? super S1, ? super S2, ? extends T> l1, Lambda<? super T, ? extends U> l2) {
        return new ComposedLambda2<S1, S2, T, U>(l1, l2);
    }

    public static <S1, S2, S3, T, U> Lambda3<S1, S2, S3, U> compose(Lambda3<? super S1, ? super S2, ? super S3, ? extends T> l1, Lambda<? super T, ? extends U> l2) {
        return new ComposedLambda3<S1, S2, S3, T, U>(l1, l2);
    }

    public static <S1, S2, S3, S4, T, U> Lambda4<S1, S2, S3, S4, U> compose(Lambda4<? super S1, ? super S2, ? super S3, ? super S4, ? extends T> l1, Lambda<? super T, ? extends U> l2) {
        return new ComposedLambda4<S1, S2, S3, S4, T, U>(l1, l2);
    }

    public static Runnable compose(Runnable ... runnables) {
        return new ComposedRunnable(IterUtil.asIterable(runnables));
    }

    public static Runnable compose(Iterable<? extends Runnable> runnables) {
        return new ComposedRunnable(runnables);
    }

    public static <T> Runnable1<T> compose(Runnable1<? super T> r1, Runnable1<? super T> r2) {
        return new ComposedRunnable1<T>(IterUtil.make(r1, r2));
    }

    public static <T> Runnable1<T> compose(Runnable1<? super T> r1, Runnable1<? super T> r2, Runnable1<? super T> r3) {
        return new ComposedRunnable1<T>(IterUtil.make(r1, r2, r3));
    }

    public static <T> Runnable1<T> compose1(Iterable<? extends Runnable1<? super T>> runnables) {
        return new ComposedRunnable1(runnables);
    }

    public static <T1, T2> Runnable2<T1, T2> compose(Runnable2<? super T1, ? super T2> r1, Runnable2<? super T1, ? super T2> r2) {
        return new ComposedRunnable2<T1, T2>(IterUtil.make(r1, r2));
    }

    public static <T1, T2> Runnable2<T1, T2> compose(Runnable2<? super T1, ? super T2> r1, Runnable2<? super T1, ? super T2> r2, Runnable2<? super T1, ? super T2> r3) {
        return new ComposedRunnable2<T1, T2>(IterUtil.make(r1, r2, r3));
    }

    public static <T1, T2> Runnable2<T1, T2> compose2(Iterable<? extends Runnable2<? super T1, ? super T2>> runnables) {
        return new ComposedRunnable2(runnables);
    }

    public static <T1, T2, T3> Runnable3<T1, T2, T3> compose(Runnable3<? super T1, ? super T2, ? super T3> r1, Runnable3<? super T1, ? super T2, ? super T3> r2) {
        return new ComposedRunnable3<T1, T2, T3>(IterUtil.make(r1, r2));
    }

    public static <T1, T2, T3> Runnable3<T1, T2, T3> compose(Runnable3<? super T1, ? super T2, ? super T3> r1, Runnable3<? super T1, ? super T2, ? super T3> r2, Runnable3<? super T1, ? super T2, ? super T3> r3) {
        return new ComposedRunnable3<T1, T2, T3>(IterUtil.make(r1, r2, r3));
    }

    public static <T1, T2, T3> Runnable3<T1, T2, T3> compose3(Iterable<? extends Runnable3<? super T1, ? super T2, ? super T3>> runnables) {
        return new ComposedRunnable3(runnables);
    }

    public static <T1, T2, T3, T4> Runnable4<T1, T2, T3, T4> compose(Runnable4<? super T1, ? super T2, ? super T3, ? super T4> r1, Runnable4<? super T1, ? super T2, ? super T3, ? super T4> r2) {
        return new ComposedRunnable4<T1, T2, T3, T4>(IterUtil.make(r1, r2));
    }

    public static <T1, T2, T3, T4> Runnable4<T1, T2, T3, T4> compose(Runnable4<? super T1, ? super T2, ? super T3, ? super T4> r1, Runnable4<? super T1, ? super T2, ? super T3, ? super T4> r2, Runnable4<? super T1, ? super T2, ? super T3, ? super T4> r3) {
        return new ComposedRunnable4<T1, T2, T3, T4>(IterUtil.make(r1, r2, r3));
    }

    public static <T1, T2, T3, T4> Runnable4<T1, T2, T3, T4> compose4(Iterable<? extends Runnable4<? super T1, ? super T2, ? super T3, ? super T4>> runnables) {
        return new ComposedRunnable4(runnables);
    }

    public static <T, R> Thunk<R> bindFirst(Lambda<? super T, ? extends R> lambda, T arg) {
        return new BindFirstThunk<T, R>(lambda, arg);
    }

    public static <T1, T2, R> Lambda<T2, R> bindFirst(Lambda2<? super T1, ? super T2, ? extends R> lambda, T1 arg1) {
        return new BindFirstLambda<T1, T2, R>(lambda, arg1);
    }

    public static <T1, T2, R> Lambda<T1, R> bindSecond(Lambda2<? super T1, ? super T2, ? extends R> lambda, T2 arg2) {
        return new BindSecondLambda<T1, T2, R>(lambda, arg2);
    }

    public static <T1, T2, T3, R> Lambda2<T2, T3, R> bindFirst(Lambda3<? super T1, ? super T2, ? super T3, ? extends R> lambda, T1 arg1) {
        return new BindFirstLambda2<T1, T2, T3, R>(lambda, arg1);
    }

    public static <T1, T2, T3, R> Lambda2<T1, T3, R> bindSecond(Lambda3<? super T1, ? super T2, ? super T3, ? extends R> lambda, T2 arg2) {
        return new BindSecondLambda2<T1, T2, T3, R>(lambda, arg2);
    }

    public static <T1, T2, T3, R> Lambda2<T1, T2, R> bindThird(Lambda3<? super T1, ? super T2, ? super T3, ? extends R> lambda, T3 arg3) {
        return new BindThirdLambda2<T1, T2, T3, R>(lambda, arg3);
    }

    public static <T1, T2, T3, T4, R> Lambda3<T2, T3, T4, R> bindFirst(Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> lambda, T1 arg1) {
        return new BindFirstLambda3<T1, T2, T3, T4, R>(lambda, arg1);
    }

    public static <T1, T2, T3, T4, R> Lambda3<T1, T3, T4, R> bindSecond(Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> lambda, T2 arg2) {
        return new BindSecondLambda3<T1, T2, T3, T4, R>(lambda, arg2);
    }

    public static <T1, T2, T3, T4, R> Lambda3<T1, T2, T4, R> bindThird(Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> lambda, T3 arg3) {
        return new BindThirdLambda3<T1, T2, T3, T4, R>(lambda, arg3);
    }

    public static <T1, T2, T3, T4, R> Lambda3<T1, T2, T3, R> bindFourth(Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> lambda, T4 arg4) {
        return new BindFourthLambda3<T1, T2, T3, T4, R>(lambda, arg4);
    }

    public static <T> Condition bindFirst(Predicate<? super T> pred, T arg) {
        return new BindFirstCondition<T>(pred, arg);
    }

    public static <T1, T2> Predicate<T2> bindFirst(Predicate2<? super T1, ? super T2> pred, T1 arg1) {
        return new BindFirstPredicate<T1, T2>(pred, arg1);
    }

    public static <T1, T2> Predicate<T1> bindSecond(Predicate2<? super T1, ? super T2> pred, T2 arg2) {
        return new BindSecondPredicate<T1, T2>(pred, arg2);
    }

    public static <T1, T2, T3> Predicate2<T2, T3> bindFirst(Predicate3<? super T1, ? super T2, ? super T3> pred, T1 arg1) {
        return new BindFirstPredicate2<T1, T2, T3>(pred, arg1);
    }

    public static <T1, T2, T3> Predicate2<T1, T3> bindSecond(Predicate3<? super T1, ? super T2, ? super T3> pred, T2 arg2) {
        return new BindSecondPredicate2<T1, T2, T3>(pred, arg2);
    }

    public static <T1, T2, T3> Predicate2<T1, T2> bindThird(Predicate3<? super T1, ? super T2, ? super T3> pred, T3 arg3) {
        return new BindThirdPredicate2<T1, T2, T3>(pred, arg3);
    }

    public static <T1, T2, T3, T4> Predicate3<T2, T3, T4> bindFirst(Predicate4<? super T1, ? super T2, ? super T3, ? super T4> pred, T1 arg1) {
        return new BindFirstPredicate3<T1, T2, T3, T4>(pred, arg1);
    }

    public static <T1, T2, T3, T4> Predicate3<T1, T3, T4> bindSecond(Predicate4<? super T1, ? super T2, ? super T3, ? super T4> pred, T2 arg2) {
        return new BindSecondPredicate3<T1, T2, T3, T4>(pred, arg2);
    }

    public static <T1, T2, T3, T4> Predicate3<T1, T2, T4> bindThird(Predicate4<? super T1, ? super T2, ? super T3, ? super T4> pred, T3 arg3) {
        return new BindThirdPredicate3<T1, T2, T3, T4>(pred, arg3);
    }

    public static <T1, T2, T3, T4> Predicate3<T1, T2, T3> bindFourth(Predicate4<? super T1, ? super T2, ? super T3, ? super T4> pred, T4 arg4) {
        return new BindFourthPredicate3<T1, T2, T3, T4>(pred, arg4);
    }

    public static <T> Runnable bindFirst(Runnable1<? super T> runnable, T arg) {
        return new BindFirstRunnable<T>(runnable, arg);
    }

    public static <T1, T2> Runnable1<T2> bindFirst(Runnable2<? super T1, ? super T2> runnable, T1 arg1) {
        return new BindFirstRunnable1<T1, T2>(runnable, arg1);
    }

    public static <T1, T2> Runnable1<T1> bindSecond(Runnable2<? super T1, ? super T2> runnable, T2 arg2) {
        return new BindSecondRunnable1<T1, T2>(runnable, arg2);
    }

    public static <T1, T2, T3> Runnable2<T2, T3> bindFirst(Runnable3<? super T1, ? super T2, ? super T3> runnable, T1 arg1) {
        return new BindFirstRunnable2<T1, T2, T3>(runnable, arg1);
    }

    public static <T1, T2, T3> Runnable2<T1, T3> bindSecond(Runnable3<? super T1, ? super T2, ? super T3> runnable, T2 arg2) {
        return new BindSecondRunnable2<T1, T2, T3>(runnable, arg2);
    }

    public static <T1, T2, T3> Runnable2<T1, T2> bindThird(Runnable3<? super T1, ? super T2, ? super T3> runnable, T3 arg3) {
        return new BindThirdRunnable2<T1, T2, T3>(runnable, arg3);
    }

    public static <T1, T2, T3, T4> Runnable3<T2, T3, T4> bindFirst(Runnable4<? super T1, ? super T2, ? super T3, ? super T4> runnable, T1 arg1) {
        return new BindFirstRunnable3<T1, T2, T3, T4>(runnable, arg1);
    }

    public static <T1, T2, T3, T4> Runnable3<T1, T3, T4> bindSecond(Runnable4<? super T1, ? super T2, ? super T3, ? super T4> runnable, T2 arg2) {
        return new BindSecondRunnable3<T1, T2, T3, T4>(runnable, arg2);
    }

    public static <T1, T2, T3, T4> Runnable3<T1, T2, T4> bindThird(Runnable4<? super T1, ? super T2, ? super T3, ? super T4> runnable, T3 arg3) {
        return new BindThirdRunnable3<T1, T2, T3, T4>(runnable, arg3);
    }

    public static <T1, T2, T3, T4> Runnable3<T1, T2, T3> bindFourth(Runnable4<? super T1, ? super T2, ? super T3, ? super T4> runnable, T4 arg4) {
        return new BindFourthRunnable3<T1, T2, T3, T4>(runnable, arg4);
    }

    public static <T1, T2, R> Lambda<T1, Lambda<T2, R>> curry(Lambda2<? super T1, ? super T2, ? extends R> lambda) {
        return new CurriedLambda2<T1, T2, R>(lambda);
    }

    public static <T1, T2, T3, R> Lambda<T1, Lambda<T2, Lambda<T3, R>>> curry(Lambda3<? super T1, ? super T2, ? super T3, ? extends R> lambda) {
        return new CurriedLambda3<T1, T2, T3, R>(lambda);
    }

    public static <T1, T2, T3, T4, R> Lambda<T1, Lambda<T2, Lambda<T3, Lambda<T4, R>>>> curry(Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> lambda) {
        return new CurriedLambda4<T1, T2, T3, T4, R>(lambda);
    }

    public static <T, R> Thunk<R> flatten0(Lambda<? super Null<T>, ? extends R> lambda) {
        return new BindFirstThunk(lambda, Null.make());
    }

    public static <T1, T2, R> Lambda2<T1, T2, R> flatten2(Lambda<? super Pair<T1, T2>, ? extends R> lambda) {
        return new FlattenedLambda2(lambda);
    }

    public static <T1, T2, T3, R> Lambda3<T1, T2, T3, R> flatten3(Lambda<? super Triple<T1, T2, T3>, ? extends R> lambda) {
        return new FlattenedLambda3(lambda);
    }

    public static <T1, T2, T3, T4, R> Lambda4<T1, T2, T3, T4, R> flatten4(Lambda<? super Quad<T1, T2, T3, T4>, ? extends R> lambda) {
        return new FlattenedLambda4(lambda);
    }

    public static <T> Condition flatten0(Predicate<? super Null<T>> pred) {
        return new BindFirstCondition(pred, Null.make());
    }

    public static <T1, T2> Predicate2<T1, T2> flatten2(Predicate<? super Pair<T1, T2>> pred) {
        return new FlattenedPredicate2(pred);
    }

    public static <T1, T2, T3> Predicate3<T1, T2, T3> flatten3(Predicate<? super Triple<T1, T2, T3>> pred) {
        return new FlattenedPredicate3(pred);
    }

    public static <T1, T2, T3, T4> Predicate4<T1, T2, T3, T4> flatten4(Predicate<? super Quad<T1, T2, T3, T4>> pred) {
        return new FlattenedPredicate4(pred);
    }

    public static <T> Runnable flatten0(Runnable1<? super Null<T>> runnable) {
        return new BindFirstRunnable(runnable, Null.make());
    }

    public static <T1, T2> Runnable2<T1, T2> flatten2(Runnable1<? super Pair<T1, T2>> runnable) {
        return new FlattenedRunnable2(runnable);
    }

    public static <T1, T2, T3> Runnable3<T1, T2, T3> flatten3(Runnable1<? super Triple<T1, T2, T3>> runnable) {
        return new FlattenedRunnable3(runnable);
    }

    public static <T1, T2, T3, T4> Runnable4<T1, T2, T3, T4> flatten4(Runnable1<? super Quad<T1, T2, T3, T4>> runnable) {
        return new FlattenedRunnable4(runnable);
    }

    public static <R> Lambda<Null<?>, R> unary(Thunk<? extends R> thunk) {
        return new UnaryThunk<R>(thunk);
    }

    public static <T1, T2, R> Lambda<Pair<T1, T2>, R> unary(Lambda2<? super T1, ? super T2, ? extends R> lambda) {
        return new UnaryLambda2<T1, T2, R>(lambda);
    }

    public static <T1, T2, T3, R> Lambda<Triple<T1, T2, T3>, R> unary(Lambda3<? super T1, ? super T2, ? super T3, ? extends R> lambda) {
        return new UnaryLambda3<T1, T2, T3, R>(lambda);
    }

    public static <T1, T2, T3, T4, R> Lambda<Quad<T1, T2, T3, T4>, R> unary(Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> lambda) {
        return new UnaryLambda4<T1, T2, T3, T4, R>(lambda);
    }

    public static Predicate<Null<?>> unary(Condition cond) {
        return new UnaryCondition(cond);
    }

    public static <T1, T2> Predicate<Pair<T1, T2>> unary(Predicate2<? super T1, ? super T2> pred) {
        return new UnaryPredicate2<T1, T2>(pred);
    }

    public static <T1, T2, T3> Predicate<Triple<T1, T2, T3>> unary(Predicate3<? super T1, ? super T2, ? super T3> pred) {
        return new UnaryPredicate3<T1, T2, T3>(pred);
    }

    public static <T1, T2, T3, T4> Predicate<Quad<T1, T2, T3, T4>> unary(Predicate4<? super T1, ? super T2, ? super T3, ? super T4> pred) {
        return new UnaryPredicate4<T1, T2, T3, T4>(pred);
    }

    public static Runnable1<Null<?>> unary(Runnable runnable) {
        return new UnaryRunnable(runnable);
    }

    public static <T1, T2> Runnable1<Pair<T1, T2>> unary(Runnable2<? super T1, ? super T2> runnable) {
        return new UnaryRunnable2<T1, T2>(runnable);
    }

    public static <T1, T2, T3> Runnable1<Triple<T1, T2, T3>> unary(Runnable3<? super T1, ? super T2, ? super T3> runnable) {
        return new UnaryRunnable3<T1, T2, T3>(runnable);
    }

    public static <T1, T2, T3, T4> Runnable1<Quad<T1, T2, T3, T4>> unary(Runnable4<? super T1, ? super T2, ? super T3, ? super T4> runnable) {
        return new UnaryRunnable4<T1, T2, T3, T4>(runnable);
    }

    public static <T, R> LiftedLambda<T, R> lift(Lambda<? super T, ? extends R> lambda) {
        return new WrappedLiftedLambda<T, R>(lambda);
    }

    public static <T1, T2, R> LiftedLambda2<T1, T2, R> lift(Lambda2<? super T1, ? super T2, ? extends R> lambda) {
        return new WrappedLiftedLambda2<T1, T2, R>(lambda);
    }

    public static <T1, T2, T3, R> LiftedLambda3<T1, T2, T3, R> lift(Lambda3<? super T1, ? super T2, ? super T3, ? extends R> lambda) {
        return new WrappedLiftedLambda3<T1, T2, T3, R>(lambda);
    }

    public static <T1, T2, T3, T4, R> LiftedLambda4<T1, T2, T3, T4, R> lift(Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> lambda) {
        return new WrappedLiftedLambda4<T1, T2, T3, T4, R>(lambda);
    }

    public static Condition negate(Condition cond) {
        return new NegationCondition(cond);
    }

    public static <T> Predicate<T> negate(Predicate<? super T> pred) {
        return new NegationPredicate<T>(pred);
    }

    public static <T1, T2> Predicate2<T1, T2> negate(Predicate2<? super T1, ? super T2> pred) {
        return new NegationPredicate2<T1, T2>(pred);
    }

    public static <T1, T2, T3> Predicate3<T1, T2, T3> negate(Predicate3<? super T1, ? super T2, ? super T3> pred) {
        return new NegationPredicate3<T1, T2, T3>(pred);
    }

    public static <T1, T2, T3, T4> Predicate4<T1, T2, T3, T4> negate(Predicate4<? super T1, ? super T2, ? super T3, ? super T4> pred) {
        return new NegationPredicate4<T1, T2, T3, T4>(pred);
    }

    public static Condition and(Condition c1, Condition c2) {
        return new AndCondition(IterUtil.make(c1, c2));
    }

    public static Condition and(Condition c1, Condition c2, Condition c3) {
        return new AndCondition(IterUtil.make(c1, c2, c3));
    }

    public static Condition and(Iterable<? extends Condition> conds) {
        return new AndCondition(conds);
    }

    public static <T> Predicate<T> and(Predicate<? super T> p1, Predicate<? super T> p2) {
        return new AndPredicate<T>(IterUtil.make(p1, p2));
    }

    public static <T> Predicate<T> and(Predicate<? super T> p1, Predicate<? super T> p2, Predicate<? super T> p3) {
        return new AndPredicate<T>(IterUtil.make(p1, p2, p3));
    }

    public static <T> Predicate<T> and(Iterable<? extends Predicate<? super T>> preds) {
        return new AndPredicate(preds);
    }

    public static <T1, T2> Predicate2<T1, T2> and(Predicate2<? super T1, ? super T2> p1, Predicate2<? super T1, ? super T2> p2) {
        return new AndPredicate2<T1, T2>(IterUtil.make(p1, p2));
    }

    public static <T1, T2> Predicate2<T1, T2> and(Predicate2<? super T1, ? super T2> p1, Predicate2<? super T1, ? super T2> p2, Predicate2<? super T1, ? super T2> p3) {
        return new AndPredicate2<T1, T2>(IterUtil.make(p1, p2, p3));
    }

    public static <T1, T2> Predicate2<T1, T2> and2(Iterable<? extends Predicate2<? super T1, ? super T2>> preds) {
        return new AndPredicate2(preds);
    }

    public static <T1, T2, T3> Predicate3<T1, T2, T3> and(Predicate3<? super T1, ? super T2, ? super T3> p1, Predicate3<? super T1, ? super T2, ? super T3> p2) {
        return new AndPredicate3<T1, T2, T3>(IterUtil.make(p1, p2));
    }

    public static <T1, T2, T3> Predicate3<T1, T2, T3> and(Predicate3<? super T1, ? super T2, ? super T3> p1, Predicate3<? super T1, ? super T2, ? super T3> p2, Predicate3<? super T1, ? super T2, ? super T3> p3) {
        return new AndPredicate3<T1, T2, T3>(IterUtil.make(p1, p2, p3));
    }

    public static <T1, T2, T3> Predicate3<T1, T2, T3> and3(Iterable<? extends Predicate3<? super T1, ? super T2, ? super T3>> preds) {
        return new AndPredicate3(preds);
    }

    public static <T1, T2, T3, T4> Predicate4<T1, T2, T3, T4> and(Predicate4<? super T1, ? super T2, ? super T3, ? super T4> p1, Predicate4<? super T1, ? super T2, ? super T3, ? super T4> p2) {
        return new AndPredicate4<T1, T2, T3, T4>(IterUtil.make(p1, p2));
    }

    public static <T1, T2, T3, T4> Predicate4<T1, T2, T3, T4> and(Predicate4<? super T1, ? super T2, ? super T3, ? super T4> p1, Predicate4<? super T1, ? super T2, ? super T3, ? super T4> p2, Predicate4<? super T1, ? super T2, ? super T3, ? super T4> p3) {
        return new AndPredicate4<T1, T2, T3, T4>(IterUtil.make(p1, p2, p3));
    }

    public static <T1, T2, T3, T4> Predicate4<T1, T2, T3, T4> and4(Iterable<? extends Predicate4<? super T1, ? super T2, ? super T3, ? super T4>> preds) {
        return new AndPredicate4(preds);
    }

    public static Condition or(Condition c1, Condition c2) {
        return new OrCondition(IterUtil.make(c1, c2));
    }

    public static Condition or(Condition c1, Condition c2, Condition c3) {
        return new OrCondition(IterUtil.make(c1, c2, c3));
    }

    public static Condition or(Iterable<? extends Condition> conds) {
        return new OrCondition(conds);
    }

    public static <T> Predicate<T> or(Predicate<? super T> p1, Predicate<? super T> p2) {
        return new OrPredicate<T>(IterUtil.make(p1, p2));
    }

    public static <T> Predicate<T> or(Predicate<? super T> p1, Predicate<? super T> p2, Predicate<? super T> p3) {
        return new OrPredicate<T>(IterUtil.make(p1, p2, p3));
    }

    public static <T> Predicate<T> or(Iterable<? extends Predicate<? super T>> preds) {
        return new OrPredicate(preds);
    }

    public static <T1, T2> Predicate2<T1, T2> or(Predicate2<? super T1, ? super T2> p1, Predicate2<? super T1, ? super T2> p2) {
        return new OrPredicate2<T1, T2>(IterUtil.make(p1, p2));
    }

    public static <T1, T2> Predicate2<T1, T2> or(Predicate2<? super T1, ? super T2> p1, Predicate2<? super T1, ? super T2> p2, Predicate2<? super T1, ? super T2> p3) {
        return new OrPredicate2<T1, T2>(IterUtil.make(p1, p2, p3));
    }

    public static <T1, T2> Predicate2<T1, T2> or2(Iterable<? extends Predicate2<? super T1, ? super T2>> preds) {
        return new OrPredicate2(preds);
    }

    public static <T1, T2, T3> Predicate3<T1, T2, T3> or(Predicate3<? super T1, ? super T2, ? super T3> p1, Predicate3<? super T1, ? super T2, ? super T3> p2) {
        return new OrPredicate3<T1, T2, T3>(IterUtil.make(p1, p2));
    }

    public static <T1, T2, T3> Predicate3<T1, T2, T3> or(Predicate3<? super T1, ? super T2, ? super T3> p1, Predicate3<? super T1, ? super T2, ? super T3> p2, Predicate3<? super T1, ? super T2, ? super T3> p3) {
        return new OrPredicate3<T1, T2, T3>(IterUtil.make(p1, p2, p3));
    }

    public static <T1, T2, T3> Predicate3<T1, T2, T3> or3(Iterable<? extends Predicate3<? super T1, ? super T2, ? super T3>> preds) {
        return new OrPredicate3(preds);
    }

    public static <T1, T2, T3, T4> Predicate4<T1, T2, T3, T4> or(Predicate4<? super T1, ? super T2, ? super T3, ? super T4> p1, Predicate4<? super T1, ? super T2, ? super T3, ? super T4> p2) {
        return new OrPredicate4<T1, T2, T3, T4>(IterUtil.make(p1, p2));
    }

    public static <T1, T2, T3, T4> Predicate4<T1, T2, T3, T4> or(Predicate4<? super T1, ? super T2, ? super T3, ? super T4> p1, Predicate4<? super T1, ? super T2, ? super T3, ? super T4> p2, Predicate4<? super T1, ? super T2, ? super T3, ? super T4> p3) {
        return new OrPredicate4<T1, T2, T3, T4>(IterUtil.make(p1, p2, p3));
    }

    public static <T1, T2, T3, T4> Predicate4<T1, T2, T3, T4> or4(Iterable<? extends Predicate4<? super T1, ? super T2, ? super T3, ? super T4>> preds) {
        return new OrPredicate4(preds);
    }

    public static Runnable asRunnable(Thunk<?> thunk) {
        return new ThunkRunnable(thunk);
    }

    public static <T> Runnable1<T> asRunnable(Lambda<? super T, ?> lambda) {
        return new LambdaRunnable1<T>(lambda);
    }

    public static <T1, T2> Runnable2<T1, T2> asRunnable(Lambda2<? super T1, ? super T2, ?> lambda) {
        return new LambdaRunnable2<T1, T2>(lambda);
    }

    public static <T1, T2, T3> Runnable3<T1, T2, T3> asRunnable(Lambda3<? super T1, ? super T2, ? super T3, ?> lambda) {
        return new LambdaRunnable3<T1, T2, T3>(lambda);
    }

    public static <T1, T2, T3, T4> Runnable4<T1, T2, T3, T4> asRunnable(Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ?> lambda) {
        return new LambdaRunnable4<T1, T2, T3, T4>(lambda);
    }

    public static Thunk<Void> asThunk(Runnable r) {
        return new RunnableThunk<Object>(r, null);
    }

    public static <R> Thunk<R> asThunk(Runnable r, R result) {
        return new RunnableThunk<R>(r, result);
    }

    public static <T> Lambda<T, Void> asLambda(Runnable1<? super T> r) {
        return new RunnableLambda<T, Object>(r, null);
    }

    public static <T, R> Lambda<T, R> asLambda(Runnable1<? super T> r, R result) {
        return new RunnableLambda<T, R>(r, result);
    }

    public static <T1, T2> Lambda2<T1, T2, Void> asLambda(Runnable2<? super T1, ? super T2> r) {
        return new RunnableLambda2<T1, T2, Object>(r, null);
    }

    public static <T1, T2, R> Lambda2<T1, T2, R> asLambda(Runnable2<? super T1, ? super T2> r, R result) {
        return new RunnableLambda2<T1, T2, R>(r, result);
    }

    public static <T1, T2, T3> Lambda3<T1, T2, T3, Void> asLambda(Runnable3<? super T1, ? super T2, ? super T3> r) {
        return new RunnableLambda3<T1, T2, T3, Object>(r, null);
    }

    public static <T1, T2, T3, R> Lambda3<T1, T2, T3, R> asLambda(Runnable3<? super T1, ? super T2, ? super T3> r, R result) {
        return new RunnableLambda3<T1, T2, T3, R>(r, result);
    }

    public static <T1, T2, T3, T4> Lambda4<T1, T2, T3, T4, Void> asLambda(Runnable4<? super T1, ? super T2, ? super T3, ? super T4> r) {
        return new RunnableLambda4<T1, T2, T3, T4, Object>(r, null);
    }

    public static <T1, T2, T3, T4, R> Lambda4<T1, T2, T3, T4, R> asLambda(Runnable4<? super T1, ? super T2, ? super T3, ? super T4> r, R result) {
        return new RunnableLambda4<T1, T2, T3, T4, R>(r, result);
    }

    public static Condition asCondition(Thunk<? extends Boolean> thunk) {
        return new ThunkCondition(thunk);
    }

    public static <T> Predicate<T> asPredicate(Lambda<? super T, ? extends Boolean> lambda) {
        return new LambdaPredicate<T>(lambda);
    }

    public static <T1, T2> Predicate2<T1, T2> asPredicate(Lambda2<? super T1, ? super T2, ? extends Boolean> lambda) {
        return new LambdaPredicate2<T1, T2>(lambda);
    }

    public static <T1, T2, T3> Predicate3<T1, T2, T3> asPredicate(Lambda3<? super T1, ? super T2, ? super T3, ? extends Boolean> lambda) {
        return new LambdaPredicate3<T1, T2, T3>(lambda);
    }

    public static <T1, T2, T3, T4> Predicate4<T1, T2, T3, T4> asPredicate(Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends Boolean> lambda) {
        return new LambdaPredicate4<T1, T2, T3, T4>(lambda);
    }

    public static Thunk<Boolean> asThunk(Condition cond) {
        return new ConditionThunk(cond);
    }

    public static <T> Lambda<T, Boolean> asLambda(Predicate<? super T> predicate) {
        return new PredicateLambda<T>(predicate);
    }

    public static <T1, T2> Lambda2<T1, T2, Boolean> asLambda(Predicate2<? super T1, ? super T2> predicate) {
        return new PredicateLambda2<T1, T2>(predicate);
    }

    public static <T1, T2, T3> Lambda3<T1, T2, T3, Boolean> asLambda(Predicate3<? super T1, ? super T2, ? super T3> predicate) {
        return new PredicateLambda3<T1, T2, T3>(predicate);
    }

    public static <T1, T2, T3, T4> Lambda4<T1, T2, T3, T4, Boolean> asLambda(Predicate4<? super T1, ? super T2, ? super T3, ? super T4> predicate) {
        return new PredicateLambda4<T1, T2, T3, T4>(predicate);
    }

    public static <R> Thunk<Option<R>> wrapPartial(Thunk<? extends R> thunk, boolean filterNull, Predicate<? super RuntimeException> filterException) {
        return new PartialThunk<R>(thunk, filterNull, filterException);
    }

    public static <T, R> Lambda<T, Option<R>> wrapPartial(Lambda<? super T, ? extends R> lambda, boolean filterNull, Predicate<? super RuntimeException> filterException) {
        return new PartialLambda<T, R>(lambda, filterNull, filterException);
    }

    public static <T1, T2, R> Lambda2<T1, T2, Option<R>> wrapPartial(Lambda2<? super T1, ? super T2, ? extends R> lambda, boolean filterNull, Predicate<? super RuntimeException> filterException) {
        return new PartialLambda2<T1, T2, R>(lambda, filterNull, filterException);
    }

    public static <T1, T2, T3, R> Lambda3<T1, T2, T3, Option<R>> wrapPartial(Lambda3<? super T1, ? super T2, ? super T3, ? extends R> lambda, boolean filterNull, Predicate<? super RuntimeException> filterException) {
        return new PartialLambda3<T1, T2, T3, R>(lambda, filterNull, filterException);
    }

    public static <T1, T2, T3, T4, R> Lambda4<T1, T2, T3, T4, Option<R>> wrapPartial(Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> lambda, boolean filterNull, Predicate<? super RuntimeException> filterException) {
        return new PartialLambda4<T1, T2, T3, T4, R>(lambda, filterNull, filterException);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PartialLambda4<T1, T2, T3, T4, R>
    implements Lambda4<T1, T2, T3, T4, Option<R>>,
    Serializable {
        private final Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> _lambda;
        private final boolean _filterNull;
        private final Predicate<? super RuntimeException> _filterException;

        public PartialLambda4(Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> lambda, boolean filterNull, Predicate<? super RuntimeException> filterException) {
            this._lambda = lambda;
            this._filterNull = filterNull;
            this._filterException = filterException;
        }

        @Override
        public Option<R> value(T1 arg1, T2 arg2, T3 arg3, T4 arg4) {
            try {
                if (this._filterNull) {
                    return Option.wrap(this._lambda.value(arg1, arg2, arg3, arg4));
                }
                return Option.some(this._lambda.value(arg1, arg2, arg3, arg4));
            }
            catch (RuntimeException e) {
                if (this._filterException.contains(e)) {
                    return Option.none();
                }
                throw e;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PartialLambda3<T1, T2, T3, R>
    implements Lambda3<T1, T2, T3, Option<R>>,
    Serializable {
        private final Lambda3<? super T1, ? super T2, ? super T3, ? extends R> _lambda;
        private final boolean _filterNull;
        private final Predicate<? super RuntimeException> _filterException;

        public PartialLambda3(Lambda3<? super T1, ? super T2, ? super T3, ? extends R> lambda, boolean filterNull, Predicate<? super RuntimeException> filterException) {
            this._lambda = lambda;
            this._filterNull = filterNull;
            this._filterException = filterException;
        }

        @Override
        public Option<R> value(T1 arg1, T2 arg2, T3 arg3) {
            try {
                if (this._filterNull) {
                    return Option.wrap(this._lambda.value(arg1, arg2, arg3));
                }
                return Option.some(this._lambda.value(arg1, arg2, arg3));
            }
            catch (RuntimeException e) {
                if (this._filterException.contains(e)) {
                    return Option.none();
                }
                throw e;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PartialLambda2<T1, T2, R>
    implements Lambda2<T1, T2, Option<R>>,
    Serializable {
        private final Lambda2<? super T1, ? super T2, ? extends R> _lambda;
        private final boolean _filterNull;
        private final Predicate<? super RuntimeException> _filterException;

        public PartialLambda2(Lambda2<? super T1, ? super T2, ? extends R> lambda, boolean filterNull, Predicate<? super RuntimeException> filterException) {
            this._lambda = lambda;
            this._filterNull = filterNull;
            this._filterException = filterException;
        }

        @Override
        public Option<R> value(T1 arg1, T2 arg2) {
            try {
                if (this._filterNull) {
                    return Option.wrap(this._lambda.value(arg1, arg2));
                }
                return Option.some(this._lambda.value(arg1, arg2));
            }
            catch (RuntimeException e) {
                if (this._filterException.contains(e)) {
                    return Option.none();
                }
                throw e;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PartialLambda<T, R>
    implements Lambda<T, Option<R>>,
    Serializable {
        private final Lambda<? super T, ? extends R> _lambda;
        private final boolean _filterNull;
        private final Predicate<? super RuntimeException> _filterException;

        public PartialLambda(Lambda<? super T, ? extends R> lambda, boolean filterNull, Predicate<? super RuntimeException> filterException) {
            this._lambda = lambda;
            this._filterNull = filterNull;
            this._filterException = filterException;
        }

        @Override
        public Option<R> value(T arg) {
            try {
                if (this._filterNull) {
                    return Option.wrap(this._lambda.value(arg));
                }
                return Option.some(this._lambda.value(arg));
            }
            catch (RuntimeException e) {
                if (this._filterException.contains(e)) {
                    return Option.none();
                }
                throw e;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PartialThunk<R>
    implements Thunk<Option<R>>,
    Serializable {
        private final Thunk<? extends R> _thunk;
        private final boolean _filterNull;
        private final Predicate<? super RuntimeException> _filterException;

        public PartialThunk(Thunk<? extends R> thunk, boolean filterNull, Predicate<? super RuntimeException> filterException) {
            this._thunk = thunk;
            this._filterNull = filterNull;
            this._filterException = filterException;
        }

        @Override
        public Option<R> value() {
            try {
                if (this._filterNull) {
                    return Option.wrap(this._thunk.value());
                }
                return Option.some(this._thunk.value());
            }
            catch (RuntimeException e) {
                if (this._filterException.contains(e)) {
                    return Option.none();
                }
                throw e;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PredicateLambda4<T1, T2, T3, T4>
    implements Lambda4<T1, T2, T3, T4, Boolean>,
    Serializable {
        private final Predicate4<? super T1, ? super T2, ? super T3, ? super T4> _p;

        public PredicateLambda4(Predicate4<? super T1, ? super T2, ? super T3, ? super T4> p) {
            this._p = p;
        }

        @Override
        public Boolean value(T1 arg1, T2 arg2, T3 arg3, T4 arg4) {
            return this._p.contains(arg1, arg2, arg3, arg4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PredicateLambda3<T1, T2, T3>
    implements Lambda3<T1, T2, T3, Boolean>,
    Serializable {
        private final Predicate3<? super T1, ? super T2, ? super T3> _p;

        public PredicateLambda3(Predicate3<? super T1, ? super T2, ? super T3> p) {
            this._p = p;
        }

        @Override
        public Boolean value(T1 arg1, T2 arg2, T3 arg3) {
            return this._p.contains(arg1, arg2, arg3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PredicateLambda2<T1, T2>
    implements Lambda2<T1, T2, Boolean>,
    Serializable {
        private final Predicate2<? super T1, ? super T2> _p;

        public PredicateLambda2(Predicate2<? super T1, ? super T2> p) {
            this._p = p;
        }

        @Override
        public Boolean value(T1 arg1, T2 arg2) {
            return this._p.contains(arg1, arg2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PredicateLambda<T>
    implements Lambda<T, Boolean>,
    Serializable {
        private final Predicate<? super T> _p;

        public PredicateLambda(Predicate<? super T> p) {
            this._p = p;
        }

        @Override
        public Boolean value(T arg) {
            return this._p.contains(arg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConditionThunk
    implements Thunk<Boolean>,
    Serializable {
        private final Condition _c;

        public ConditionThunk(Condition c) {
            this._c = c;
        }

        @Override
        public Boolean value() {
            return this._c.isTrue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LambdaPredicate4<T1, T2, T3, T4>
    implements Predicate4<T1, T2, T3, T4>,
    Serializable {
        private final Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends Boolean> _l;

        public LambdaPredicate4(Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends Boolean> l) {
            this._l = l;
        }

        @Override
        public boolean contains(T1 arg1, T2 arg2, T3 arg3, T4 arg4) {
            return this._l.value(arg1, arg2, arg3, arg4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LambdaPredicate3<T1, T2, T3>
    implements Predicate3<T1, T2, T3>,
    Serializable {
        private final Lambda3<? super T1, ? super T2, ? super T3, ? extends Boolean> _l;

        public LambdaPredicate3(Lambda3<? super T1, ? super T2, ? super T3, ? extends Boolean> l) {
            this._l = l;
        }

        @Override
        public boolean contains(T1 arg1, T2 arg2, T3 arg3) {
            return this._l.value(arg1, arg2, arg3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LambdaPredicate2<T1, T2>
    implements Predicate2<T1, T2>,
    Serializable {
        private final Lambda2<? super T1, ? super T2, ? extends Boolean> _l;

        public LambdaPredicate2(Lambda2<? super T1, ? super T2, ? extends Boolean> l) {
            this._l = l;
        }

        @Override
        public boolean contains(T1 arg1, T2 arg2) {
            return this._l.value(arg1, arg2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LambdaPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final Lambda<? super T, ? extends Boolean> _l;

        public LambdaPredicate(Lambda<? super T, ? extends Boolean> l) {
            this._l = l;
        }

        @Override
        public boolean contains(T arg) {
            return this._l.value(arg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ThunkCondition
    implements Condition,
    Serializable {
        private final Thunk<? extends Boolean> _thunk;

        public ThunkCondition(Thunk<? extends Boolean> thunk) {
            this._thunk = thunk;
        }

        @Override
        public boolean isTrue() {
            return this._thunk.value();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RunnableLambda4<T1, T2, T3, T4, R>
    implements Lambda4<T1, T2, T3, T4, R>,
    Serializable {
        private final Runnable4<? super T1, ? super T2, ? super T3, ? super T4> _r;
        private final R _result;

        public RunnableLambda4(Runnable4<? super T1, ? super T2, ? super T3, ? super T4> r, R result) {
            this._r = r;
            this._result = result;
        }

        @Override
        public R value(T1 arg1, T2 arg2, T3 arg3, T4 arg4) {
            this._r.run(arg1, arg2, arg3, arg4);
            return this._result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RunnableLambda3<T1, T2, T3, R>
    implements Lambda3<T1, T2, T3, R>,
    Serializable {
        private final Runnable3<? super T1, ? super T2, ? super T3> _r;
        private final R _result;

        public RunnableLambda3(Runnable3<? super T1, ? super T2, ? super T3> r, R result) {
            this._r = r;
            this._result = result;
        }

        @Override
        public R value(T1 arg1, T2 arg2, T3 arg3) {
            this._r.run(arg1, arg2, arg3);
            return this._result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RunnableLambda2<T1, T2, R>
    implements Lambda2<T1, T2, R>,
    Serializable {
        private final Runnable2<? super T1, ? super T2> _r;
        private final R _result;

        public RunnableLambda2(Runnable2<? super T1, ? super T2> r, R result) {
            this._r = r;
            this._result = result;
        }

        @Override
        public R value(T1 arg1, T2 arg2) {
            this._r.run(arg1, arg2);
            return this._result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RunnableLambda<T, R>
    implements Lambda<T, R>,
    Serializable {
        private final Runnable1<? super T> _r;
        private final R _result;

        public RunnableLambda(Runnable1<? super T> r, R result) {
            this._r = r;
            this._result = result;
        }

        @Override
        public R value(T arg) {
            this._r.run(arg);
            return this._result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RunnableThunk<R>
    implements Thunk<R>,
    Serializable {
        private final Runnable _r;
        private final R _result;

        public RunnableThunk(Runnable r, R result) {
            this._r = r;
            this._result = result;
        }

        @Override
        public R value() {
            this._r.run();
            return this._result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LambdaRunnable4<T1, T2, T3, T4>
    implements Runnable4<T1, T2, T3, T4>,
    Serializable {
        private final Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ?> _l;

        public LambdaRunnable4(Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ?> l) {
            this._l = l;
        }

        @Override
        public void run(T1 arg1, T2 arg2, T3 arg3, T4 arg4) {
            this._l.value(arg1, arg2, arg3, arg4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LambdaRunnable3<T1, T2, T3>
    implements Runnable3<T1, T2, T3>,
    Serializable {
        private final Lambda3<? super T1, ? super T2, ? super T3, ?> _l;

        public LambdaRunnable3(Lambda3<? super T1, ? super T2, ? super T3, ?> l) {
            this._l = l;
        }

        @Override
        public void run(T1 arg1, T2 arg2, T3 arg3) {
            this._l.value(arg1, arg2, arg3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LambdaRunnable2<T1, T2>
    implements Runnable2<T1, T2>,
    Serializable {
        private final Lambda2<? super T1, ? super T2, ?> _l;

        public LambdaRunnable2(Lambda2<? super T1, ? super T2, ?> l) {
            this._l = l;
        }

        @Override
        public void run(T1 arg1, T2 arg2) {
            this._l.value(arg1, arg2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LambdaRunnable1<T>
    implements Runnable1<T>,
    Serializable {
        private final Lambda<? super T, ?> _l;

        public LambdaRunnable1(Lambda<? super T, ?> l) {
            this._l = l;
        }

        @Override
        public void run(T arg) {
            this._l.value(arg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ThunkRunnable
    implements Runnable,
    Serializable {
        private final Thunk<?> _t;

        public ThunkRunnable(Thunk<?> t) {
            this._t = t;
        }

        @Override
        public void run() {
            this._t.value();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OrPredicate4<T1, T2, T3, T4>
    implements Predicate4<T1, T2, T3, T4>,
    Serializable {
        private final Iterable<? extends Predicate4<? super T1, ? super T2, ? super T3, ? super T4>> _preds;

        public OrPredicate4(Iterable<? extends Predicate4<? super T1, ? super T2, ? super T3, ? super T4>> preds) {
            this._preds = preds;
        }

        @Override
        public boolean contains(T1 arg1, T2 arg2, T3 arg3, T4 arg4) {
            for (Predicate4<T1, T2, T3, T4> p : this._preds) {
                if (!p.contains(arg1, arg2, arg3, arg4)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OrPredicate3<T1, T2, T3>
    implements Predicate3<T1, T2, T3>,
    Serializable {
        private final Iterable<? extends Predicate3<? super T1, ? super T2, ? super T3>> _preds;

        public OrPredicate3(Iterable<? extends Predicate3<? super T1, ? super T2, ? super T3>> preds) {
            this._preds = preds;
        }

        @Override
        public boolean contains(T1 arg1, T2 arg2, T3 arg3) {
            for (Predicate3<T1, T2, T3> p : this._preds) {
                if (!p.contains(arg1, arg2, arg3)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OrPredicate2<T1, T2>
    implements Predicate2<T1, T2>,
    Serializable {
        private final Iterable<? extends Predicate2<? super T1, ? super T2>> _preds;

        public OrPredicate2(Iterable<? extends Predicate2<? super T1, ? super T2>> preds) {
            this._preds = preds;
        }

        @Override
        public boolean contains(T1 arg1, T2 arg2) {
            for (Predicate2<T1, T2> p : this._preds) {
                if (!p.contains(arg1, arg2)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OrPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final Iterable<? extends Predicate<? super T>> _preds;

        public OrPredicate(Iterable<? extends Predicate<? super T>> preds) {
            this._preds = preds;
        }

        @Override
        public boolean contains(T arg) {
            for (Predicate<T> p : this._preds) {
                if (!p.contains(arg)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OrCondition
    implements Condition,
    Serializable {
        private final Iterable<? extends Condition> _conds;

        public OrCondition(Iterable<? extends Condition> conds) {
            this._conds = conds;
        }

        @Override
        public boolean isTrue() {
            for (Condition condition : this._conds) {
                if (!condition.isTrue()) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AndPredicate4<T1, T2, T3, T4>
    implements Predicate4<T1, T2, T3, T4>,
    Serializable {
        private final Iterable<? extends Predicate4<? super T1, ? super T2, ? super T3, ? super T4>> _preds;

        public AndPredicate4(Iterable<? extends Predicate4<? super T1, ? super T2, ? super T3, ? super T4>> preds) {
            this._preds = preds;
        }

        @Override
        public boolean contains(T1 arg1, T2 arg2, T3 arg3, T4 arg4) {
            for (Predicate4<T1, T2, T3, T4> p : this._preds) {
                if (p.contains(arg1, arg2, arg3, arg4)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AndPredicate3<T1, T2, T3>
    implements Predicate3<T1, T2, T3>,
    Serializable {
        private final Iterable<? extends Predicate3<? super T1, ? super T2, ? super T3>> _preds;

        public AndPredicate3(Iterable<? extends Predicate3<? super T1, ? super T2, ? super T3>> preds) {
            this._preds = preds;
        }

        @Override
        public boolean contains(T1 arg1, T2 arg2, T3 arg3) {
            for (Predicate3<T1, T2, T3> p : this._preds) {
                if (p.contains(arg1, arg2, arg3)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AndPredicate2<T1, T2>
    implements Predicate2<T1, T2>,
    Serializable {
        private final Iterable<? extends Predicate2<? super T1, ? super T2>> _preds;

        public AndPredicate2(Iterable<? extends Predicate2<? super T1, ? super T2>> preds) {
            this._preds = preds;
        }

        @Override
        public boolean contains(T1 arg1, T2 arg2) {
            for (Predicate2<T1, T2> p : this._preds) {
                if (p.contains(arg1, arg2)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AndPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final Iterable<? extends Predicate<? super T>> _preds;

        public AndPredicate(Iterable<? extends Predicate<? super T>> preds) {
            this._preds = preds;
        }

        @Override
        public boolean contains(T arg) {
            for (Predicate<T> p : this._preds) {
                if (p.contains(arg)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AndCondition
    implements Condition,
    Serializable {
        private final Iterable<? extends Condition> _conds;

        public AndCondition(Iterable<? extends Condition> conds) {
            this._conds = conds;
        }

        @Override
        public boolean isTrue() {
            for (Condition condition : this._conds) {
                if (condition.isTrue()) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NegationPredicate4<T1, T2, T3, T4>
    implements Predicate4<T1, T2, T3, T4>,
    Serializable {
        private final Predicate4<? super T1, ? super T2, ? super T3, ? super T4> _p;

        public NegationPredicate4(Predicate4<? super T1, ? super T2, ? super T3, ? super T4> p) {
            this._p = p;
        }

        @Override
        public boolean contains(T1 arg1, T2 arg2, T3 arg3, T4 arg4) {
            return !this._p.contains(arg1, arg2, arg3, arg4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NegationPredicate3<T1, T2, T3>
    implements Predicate3<T1, T2, T3>,
    Serializable {
        private final Predicate3<? super T1, ? super T2, ? super T3> _p;

        public NegationPredicate3(Predicate3<? super T1, ? super T2, ? super T3> p) {
            this._p = p;
        }

        @Override
        public boolean contains(T1 arg1, T2 arg2, T3 arg3) {
            return !this._p.contains(arg1, arg2, arg3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NegationPredicate2<T1, T2>
    implements Predicate2<T1, T2>,
    Serializable {
        private final Predicate2<? super T1, ? super T2> _p;

        public NegationPredicate2(Predicate2<? super T1, ? super T2> p) {
            this._p = p;
        }

        @Override
        public boolean contains(T1 arg1, T2 arg2) {
            return !this._p.contains(arg1, arg2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NegationPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final Predicate<? super T> _p;

        public NegationPredicate(Predicate<? super T> p) {
            this._p = p;
        }

        @Override
        public boolean contains(T arg) {
            return !this._p.contains(arg);
        }
    }

    private static final class NegationCondition
    implements Condition,
    Serializable {
        private final Condition _c;

        public NegationCondition(Condition c) {
            this._c = c;
        }

        public boolean isTrue() {
            return !this._c.isTrue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WrappedLiftedLambda4<T1, T2, T3, T4, R>
    implements LiftedLambda4<T1, T2, T3, T4, R>,
    Serializable {
        private final Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> _lambda;

        public WrappedLiftedLambda4(Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> lambda) {
            this._lambda = lambda;
        }

        @Override
        public Option<R> value(Option<? extends T1> arg1, Option<? extends T2> arg2, Option<? extends T3> arg3, Option<? extends T4> arg4) {
            if (arg1.isSome() && arg2.isSome() && arg3.isSome() && arg4.isSome()) {
                return Option.some(this._lambda.value(arg1.unwrap(), arg2.unwrap(), arg3.unwrap(), arg4.unwrap()));
            }
            return Option.none();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface LiftedLambda4<T1, T2, T3, T4, R>
    extends Lambda4<Option<? extends T1>, Option<? extends T2>, Option<? extends T3>, Option<? extends T4>, Option<R>> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WrappedLiftedLambda3<T1, T2, T3, R>
    implements LiftedLambda3<T1, T2, T3, R>,
    Serializable {
        private final Lambda3<? super T1, ? super T2, ? super T3, ? extends R> _lambda;

        public WrappedLiftedLambda3(Lambda3<? super T1, ? super T2, ? super T3, ? extends R> lambda) {
            this._lambda = lambda;
        }

        @Override
        public Option<R> value(Option<? extends T1> arg1, Option<? extends T2> arg2, Option<? extends T3> arg3) {
            if (arg1.isSome() && arg2.isSome() && arg3.isSome()) {
                return Option.some(this._lambda.value(arg1.unwrap(), arg2.unwrap(), arg3.unwrap()));
            }
            return Option.none();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface LiftedLambda3<T1, T2, T3, R>
    extends Lambda3<Option<? extends T1>, Option<? extends T2>, Option<? extends T3>, Option<R>> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WrappedLiftedLambda2<T1, T2, R>
    implements LiftedLambda2<T1, T2, R>,
    Serializable {
        private final Lambda2<? super T1, ? super T2, ? extends R> _lambda;

        public WrappedLiftedLambda2(Lambda2<? super T1, ? super T2, ? extends R> lambda) {
            this._lambda = lambda;
        }

        @Override
        public Option<R> value(Option<? extends T1> arg1, Option<? extends T2> arg2) {
            if (arg1.isSome() && arg2.isSome()) {
                return Option.some(this._lambda.value(arg1.unwrap(), arg2.unwrap()));
            }
            return Option.none();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface LiftedLambda2<T1, T2, R>
    extends Lambda2<Option<? extends T1>, Option<? extends T2>, Option<R>> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WrappedLiftedLambda<T, R>
    implements LiftedLambda<T, R>,
    Serializable {
        private final Lambda<? super T, ? extends R> _lambda;

        public WrappedLiftedLambda(Lambda<? super T, ? extends R> lambda) {
            this._lambda = lambda;
        }

        @Override
        public Option<R> value(Option<? extends T> arg) {
            if (arg.isSome()) {
                return Option.some(this._lambda.value(arg.unwrap()));
            }
            return Option.none();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface LiftedLambda<T, R>
    extends Lambda<Option<? extends T>, Option<R>> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnaryRunnable4<T1, T2, T3, T4>
    implements Runnable1<Quad<T1, T2, T3, T4>>,
    Serializable {
        private final Runnable4<? super T1, ? super T2, ? super T3, ? super T4> _runnable;

        public UnaryRunnable4(Runnable4<? super T1, ? super T2, ? super T3, ? super T4> runnable) {
            this._runnable = runnable;
        }

        @Override
        public void run(Quad<T1, T2, T3, T4> arg) {
            this._runnable.run(arg.first(), arg.second(), arg.third(), arg.fourth());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnaryRunnable3<T1, T2, T3>
    implements Runnable1<Triple<T1, T2, T3>>,
    Serializable {
        private final Runnable3<? super T1, ? super T2, ? super T3> _runnable;

        public UnaryRunnable3(Runnable3<? super T1, ? super T2, ? super T3> runnable) {
            this._runnable = runnable;
        }

        @Override
        public void run(Triple<T1, T2, T3> arg) {
            this._runnable.run(arg.first(), arg.second(), arg.third());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnaryRunnable2<T1, T2>
    implements Runnable1<Pair<T1, T2>>,
    Serializable {
        private final Runnable2<? super T1, ? super T2> _runnable;

        public UnaryRunnable2(Runnable2<? super T1, ? super T2> runnable) {
            this._runnable = runnable;
        }

        @Override
        public void run(Pair<T1, T2> arg) {
            this._runnable.run(arg.first(), arg.second());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnaryRunnable
    implements Runnable1<Null<?>>,
    Serializable {
        private final Runnable _runnable;

        public UnaryRunnable(Runnable runnable) {
            this._runnable = runnable;
        }

        @Override
        public void run(Null<?> arg) {
            this._runnable.run();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnaryPredicate4<T1, T2, T3, T4>
    implements Predicate<Quad<T1, T2, T3, T4>>,
    Serializable {
        private final Predicate4<? super T1, ? super T2, ? super T3, ? super T4> _pred;

        public UnaryPredicate4(Predicate4<? super T1, ? super T2, ? super T3, ? super T4> pred) {
            this._pred = pred;
        }

        @Override
        public boolean contains(Quad<T1, T2, T3, T4> arg) {
            return this._pred.contains(arg.first(), arg.second(), arg.third(), arg.fourth());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnaryPredicate3<T1, T2, T3>
    implements Predicate<Triple<T1, T2, T3>>,
    Serializable {
        private final Predicate3<? super T1, ? super T2, ? super T3> _pred;

        public UnaryPredicate3(Predicate3<? super T1, ? super T2, ? super T3> pred) {
            this._pred = pred;
        }

        @Override
        public boolean contains(Triple<T1, T2, T3> arg) {
            return this._pred.contains(arg.first(), arg.second(), arg.third());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnaryPredicate2<T1, T2>
    implements Predicate<Pair<T1, T2>>,
    Serializable {
        private final Predicate2<? super T1, ? super T2> _pred;

        public UnaryPredicate2(Predicate2<? super T1, ? super T2> pred) {
            this._pred = pred;
        }

        @Override
        public boolean contains(Pair<T1, T2> arg) {
            return this._pred.contains(arg.first(), arg.second());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnaryCondition
    implements Predicate<Null<?>>,
    Serializable {
        private final Condition _cond;

        public UnaryCondition(Condition cond) {
            this._cond = cond;
        }

        @Override
        public boolean contains(Null<?> arg) {
            return this._cond.isTrue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnaryLambda4<T1, T2, T3, T4, R>
    implements Lambda<Quad<T1, T2, T3, T4>, R>,
    Serializable {
        private final Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> _lambda;

        public UnaryLambda4(Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> lambda) {
            this._lambda = lambda;
        }

        @Override
        public R value(Quad<T1, T2, T3, T4> arg) {
            return this._lambda.value(arg.first(), arg.second(), arg.third(), arg.fourth());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnaryLambda3<T1, T2, T3, R>
    implements Lambda<Triple<T1, T2, T3>, R>,
    Serializable {
        private final Lambda3<? super T1, ? super T2, ? super T3, ? extends R> _lambda;

        public UnaryLambda3(Lambda3<? super T1, ? super T2, ? super T3, ? extends R> lambda) {
            this._lambda = lambda;
        }

        @Override
        public R value(Triple<T1, T2, T3> arg) {
            return this._lambda.value(arg.first(), arg.second(), arg.third());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnaryLambda2<T1, T2, R>
    implements Lambda<Pair<T1, T2>, R>,
    Serializable {
        private final Lambda2<? super T1, ? super T2, ? extends R> _lambda;

        public UnaryLambda2(Lambda2<? super T1, ? super T2, ? extends R> lambda) {
            this._lambda = lambda;
        }

        @Override
        public R value(Pair<T1, T2> arg) {
            return this._lambda.value(arg.first(), arg.second());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnaryThunk<R>
    implements Lambda<Null<?>, R>,
    Serializable {
        private final Thunk<? extends R> _thunk;

        public UnaryThunk(Thunk<? extends R> thunk) {
            this._thunk = thunk;
        }

        @Override
        public R value(Null<?> arg) {
            return this._thunk.value();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FlattenedRunnable4<T1, T2, T3, T4>
    implements Runnable4<T1, T2, T3, T4>,
    Serializable {
        private final Runnable1<? super Quad<T1, T2, T3, T4>> _runnable;

        public FlattenedRunnable4(Runnable1<? super Quad<T1, T2, T3, T4>> runnable) {
            this._runnable = runnable;
        }

        @Override
        public void run(T1 arg1, T2 arg2, T3 arg3, T4 arg4) {
            this._runnable.run(new Quad<T1, T2, T3, T4>(arg1, arg2, arg3, arg4));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FlattenedRunnable3<T1, T2, T3>
    implements Runnable3<T1, T2, T3>,
    Serializable {
        private final Runnable1<? super Triple<T1, T2, T3>> _runnable;

        public FlattenedRunnable3(Runnable1<? super Triple<T1, T2, T3>> runnable) {
            this._runnable = runnable;
        }

        @Override
        public void run(T1 arg1, T2 arg2, T3 arg3) {
            this._runnable.run(new Triple<T1, T2, T3>(arg1, arg2, arg3));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FlattenedRunnable2<T1, T2>
    implements Runnable2<T1, T2>,
    Serializable {
        private final Runnable1<? super Pair<T1, T2>> _runnable;

        public FlattenedRunnable2(Runnable1<? super Pair<T1, T2>> runnable) {
            this._runnable = runnable;
        }

        @Override
        public void run(T1 arg1, T2 arg2) {
            this._runnable.run(new Pair<T1, T2>(arg1, arg2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FlattenedPredicate4<T1, T2, T3, T4>
    implements Predicate4<T1, T2, T3, T4>,
    Serializable {
        private final Predicate<? super Quad<T1, T2, T3, T4>> _pred;

        public FlattenedPredicate4(Predicate<? super Quad<T1, T2, T3, T4>> pred) {
            this._pred = pred;
        }

        @Override
        public boolean contains(T1 arg1, T2 arg2, T3 arg3, T4 arg4) {
            return this._pred.contains(new Quad<T1, T2, T3, T4>(arg1, arg2, arg3, arg4));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FlattenedPredicate3<T1, T2, T3>
    implements Predicate3<T1, T2, T3>,
    Serializable {
        private final Predicate<? super Triple<T1, T2, T3>> _pred;

        public FlattenedPredicate3(Predicate<? super Triple<T1, T2, T3>> pred) {
            this._pred = pred;
        }

        @Override
        public boolean contains(T1 arg1, T2 arg2, T3 arg3) {
            return this._pred.contains(new Triple<T1, T2, T3>(arg1, arg2, arg3));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FlattenedPredicate2<T1, T2>
    implements Predicate2<T1, T2>,
    Serializable {
        private final Predicate<? super Pair<T1, T2>> _pred;

        public FlattenedPredicate2(Predicate<? super Pair<T1, T2>> pred) {
            this._pred = pred;
        }

        @Override
        public boolean contains(T1 arg1, T2 arg2) {
            return this._pred.contains(new Pair<T1, T2>(arg1, arg2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FlattenedLambda4<T1, T2, T3, T4, R>
    implements Lambda4<T1, T2, T3, T4, R>,
    Serializable {
        private final Lambda<? super Quad<T1, T2, T3, T4>, ? extends R> _lambda;

        public FlattenedLambda4(Lambda<? super Quad<T1, T2, T3, T4>, ? extends R> lambda) {
            this._lambda = lambda;
        }

        @Override
        public R value(T1 arg1, T2 arg2, T3 arg3, T4 arg4) {
            return this._lambda.value(new Quad<T1, T2, T3, T4>(arg1, arg2, arg3, arg4));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FlattenedLambda3<T1, T2, T3, R>
    implements Lambda3<T1, T2, T3, R>,
    Serializable {
        private final Lambda<? super Triple<T1, T2, T3>, ? extends R> _lambda;

        public FlattenedLambda3(Lambda<? super Triple<T1, T2, T3>, ? extends R> lambda) {
            this._lambda = lambda;
        }

        @Override
        public R value(T1 arg1, T2 arg2, T3 arg3) {
            return this._lambda.value(new Triple<T1, T2, T3>(arg1, arg2, arg3));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FlattenedLambda2<T1, T2, R>
    implements Lambda2<T1, T2, R>,
    Serializable {
        private final Lambda<? super Pair<T1, T2>, ? extends R> _lambda;

        public FlattenedLambda2(Lambda<? super Pair<T1, T2>, ? extends R> lambda) {
            this._lambda = lambda;
        }

        @Override
        public R value(T1 arg1, T2 arg2) {
            return this._lambda.value(new Pair<T1, T2>(arg1, arg2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CurriedLambda4<T1, T2, T3, T4, R>
    implements Lambda<T1, Lambda<T2, Lambda<T3, Lambda<T4, R>>>>,
    Serializable {
        private final Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> _lambda;

        public CurriedLambda4(Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> lambda) {
            this._lambda = lambda;
        }

        @Override
        public Lambda<T2, Lambda<T3, Lambda<T4, R>>> value(T1 arg) {
            return new CurriedLambda3(new BindFirstLambda3<T1, T2, T3, T4, R>(this._lambda, arg));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CurriedLambda3<T1, T2, T3, R>
    implements Lambda<T1, Lambda<T2, Lambda<T3, R>>>,
    Serializable {
        private final Lambda3<? super T1, ? super T2, ? super T3, ? extends R> _lambda;

        public CurriedLambda3(Lambda3<? super T1, ? super T2, ? super T3, ? extends R> lambda) {
            this._lambda = lambda;
        }

        @Override
        public Lambda<T2, Lambda<T3, R>> value(T1 arg) {
            return new CurriedLambda2(new BindFirstLambda2<T1, T2, T3, R>(this._lambda, arg));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CurriedLambda2<T1, T2, R>
    implements Lambda<T1, Lambda<T2, R>>,
    Serializable {
        private final Lambda2<? super T1, ? super T2, ? extends R> _lambda;

        public CurriedLambda2(Lambda2<? super T1, ? super T2, ? extends R> lambda) {
            this._lambda = lambda;
        }

        @Override
        public Lambda<T2, R> value(T1 arg) {
            return new BindFirstLambda<T1, T2, R>(this._lambda, arg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindFourthRunnable3<T1, T2, T3, T4>
    implements Runnable3<T1, T2, T3>,
    Serializable {
        private final Runnable4<? super T1, ? super T2, ? super T3, ? super T4> _runnable;
        private final T4 _arg4;

        public BindFourthRunnable3(Runnable4<? super T1, ? super T2, ? super T3, ? super T4> runnable, T4 arg4) {
            this._runnable = runnable;
            this._arg4 = arg4;
        }

        @Override
        public void run(T1 arg1, T2 arg2, T3 arg3) {
            this._runnable.run(arg1, arg2, arg3, this._arg4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindThirdRunnable3<T1, T2, T3, T4>
    implements Runnable3<T1, T2, T4>,
    Serializable {
        private final Runnable4<? super T1, ? super T2, ? super T3, ? super T4> _runnable;
        private final T3 _arg3;

        public BindThirdRunnable3(Runnable4<? super T1, ? super T2, ? super T3, ? super T4> runnable, T3 arg3) {
            this._runnable = runnable;
            this._arg3 = arg3;
        }

        @Override
        public void run(T1 arg1, T2 arg2, T4 arg4) {
            this._runnable.run(arg1, arg2, this._arg3, arg4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindSecondRunnable3<T1, T2, T3, T4>
    implements Runnable3<T1, T3, T4>,
    Serializable {
        private final Runnable4<? super T1, ? super T2, ? super T3, ? super T4> _runnable;
        private final T2 _arg2;

        public BindSecondRunnable3(Runnable4<? super T1, ? super T2, ? super T3, ? super T4> runnable, T2 arg2) {
            this._runnable = runnable;
            this._arg2 = arg2;
        }

        @Override
        public void run(T1 arg1, T3 arg3, T4 arg4) {
            this._runnable.run(arg1, this._arg2, arg3, arg4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindFirstRunnable3<T1, T2, T3, T4>
    implements Runnable3<T2, T3, T4>,
    Serializable {
        private final Runnable4<? super T1, ? super T2, ? super T3, ? super T4> _runnable;
        private final T1 _arg1;

        public BindFirstRunnable3(Runnable4<? super T1, ? super T2, ? super T3, ? super T4> runnable, T1 arg1) {
            this._runnable = runnable;
            this._arg1 = arg1;
        }

        @Override
        public void run(T2 arg2, T3 arg3, T4 arg4) {
            this._runnable.run(this._arg1, arg2, arg3, arg4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindThirdRunnable2<T1, T2, T3>
    implements Runnable2<T1, T2>,
    Serializable {
        private final Runnable3<? super T1, ? super T2, ? super T3> _runnable;
        private final T3 _arg3;

        public BindThirdRunnable2(Runnable3<? super T1, ? super T2, ? super T3> runnable, T3 arg3) {
            this._runnable = runnable;
            this._arg3 = arg3;
        }

        @Override
        public void run(T1 arg1, T2 arg2) {
            this._runnable.run(arg1, arg2, this._arg3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindSecondRunnable2<T1, T2, T3>
    implements Runnable2<T1, T3>,
    Serializable {
        private final Runnable3<? super T1, ? super T2, ? super T3> _runnable;
        private final T2 _arg2;

        public BindSecondRunnable2(Runnable3<? super T1, ? super T2, ? super T3> runnable, T2 arg2) {
            this._runnable = runnable;
            this._arg2 = arg2;
        }

        @Override
        public void run(T1 arg1, T3 arg3) {
            this._runnable.run(arg1, this._arg2, arg3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindFirstRunnable2<T1, T2, T3>
    implements Runnable2<T2, T3>,
    Serializable {
        private final Runnable3<? super T1, ? super T2, ? super T3> _runnable;
        private final T1 _arg1;

        public BindFirstRunnable2(Runnable3<? super T1, ? super T2, ? super T3> runnable, T1 arg1) {
            this._runnable = runnable;
            this._arg1 = arg1;
        }

        @Override
        public void run(T2 arg2, T3 arg3) {
            this._runnable.run(this._arg1, arg2, arg3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindSecondRunnable1<T1, T2>
    implements Runnable1<T1>,
    Serializable {
        private final Runnable2<? super T1, ? super T2> _runnable;
        private final T2 _arg2;

        public BindSecondRunnable1(Runnable2<? super T1, ? super T2> runnable, T2 arg2) {
            this._runnable = runnable;
            this._arg2 = arg2;
        }

        @Override
        public void run(T1 arg1) {
            this._runnable.run(arg1, this._arg2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindFirstRunnable1<T1, T2>
    implements Runnable1<T2>,
    Serializable {
        private final Runnable2<? super T1, ? super T2> _runnable;
        private final T1 _arg1;

        public BindFirstRunnable1(Runnable2<? super T1, ? super T2> runnable, T1 arg1) {
            this._runnable = runnable;
            this._arg1 = arg1;
        }

        @Override
        public void run(T2 arg2) {
            this._runnable.run(this._arg1, arg2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindFirstRunnable<T>
    implements Runnable,
    Serializable {
        private final Runnable1<? super T> _runnable;
        private final T _arg;

        public BindFirstRunnable(Runnable1<? super T> runnable, T arg) {
            this._runnable = runnable;
            this._arg = arg;
        }

        @Override
        public void run() {
            this._runnable.run(this._arg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindFourthPredicate3<T1, T2, T3, T4>
    implements Predicate3<T1, T2, T3>,
    Serializable {
        private final Predicate4<? super T1, ? super T2, ? super T3, ? super T4> _pred;
        private final T4 _arg4;

        public BindFourthPredicate3(Predicate4<? super T1, ? super T2, ? super T3, ? super T4> pred, T4 arg4) {
            this._pred = pred;
            this._arg4 = arg4;
        }

        @Override
        public boolean contains(T1 arg1, T2 arg2, T3 arg3) {
            return this._pred.contains(arg1, arg2, arg3, this._arg4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindThirdPredicate3<T1, T2, T3, T4>
    implements Predicate3<T1, T2, T4>,
    Serializable {
        private final Predicate4<? super T1, ? super T2, ? super T3, ? super T4> _pred;
        private final T3 _arg3;

        public BindThirdPredicate3(Predicate4<? super T1, ? super T2, ? super T3, ? super T4> pred, T3 arg3) {
            this._pred = pred;
            this._arg3 = arg3;
        }

        @Override
        public boolean contains(T1 arg1, T2 arg2, T4 arg4) {
            return this._pred.contains(arg1, arg2, this._arg3, arg4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindSecondPredicate3<T1, T2, T3, T4>
    implements Predicate3<T1, T3, T4>,
    Serializable {
        private final Predicate4<? super T1, ? super T2, ? super T3, ? super T4> _pred;
        private final T2 _arg2;

        public BindSecondPredicate3(Predicate4<? super T1, ? super T2, ? super T3, ? super T4> pred, T2 arg2) {
            this._pred = pred;
            this._arg2 = arg2;
        }

        @Override
        public boolean contains(T1 arg1, T3 arg3, T4 arg4) {
            return this._pred.contains(arg1, this._arg2, arg3, arg4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindFirstPredicate3<T1, T2, T3, T4>
    implements Predicate3<T2, T3, T4>,
    Serializable {
        private final Predicate4<? super T1, ? super T2, ? super T3, ? super T4> _pred;
        private final T1 _arg1;

        public BindFirstPredicate3(Predicate4<? super T1, ? super T2, ? super T3, ? super T4> pred, T1 arg1) {
            this._pred = pred;
            this._arg1 = arg1;
        }

        @Override
        public boolean contains(T2 arg2, T3 arg3, T4 arg4) {
            return this._pred.contains(this._arg1, arg2, arg3, arg4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindThirdPredicate2<T1, T2, T3>
    implements Predicate2<T1, T2>,
    Serializable {
        private final Predicate3<? super T1, ? super T2, ? super T3> _pred;
        private final T3 _arg3;

        public BindThirdPredicate2(Predicate3<? super T1, ? super T2, ? super T3> pred, T3 arg3) {
            this._pred = pred;
            this._arg3 = arg3;
        }

        @Override
        public boolean contains(T1 arg1, T2 arg2) {
            return this._pred.contains(arg1, arg2, this._arg3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindSecondPredicate2<T1, T2, T3>
    implements Predicate2<T1, T3>,
    Serializable {
        private final Predicate3<? super T1, ? super T2, ? super T3> _pred;
        private final T2 _arg2;

        public BindSecondPredicate2(Predicate3<? super T1, ? super T2, ? super T3> pred, T2 arg2) {
            this._pred = pred;
            this._arg2 = arg2;
        }

        @Override
        public boolean contains(T1 arg1, T3 arg3) {
            return this._pred.contains(arg1, this._arg2, arg3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindFirstPredicate2<T1, T2, T3>
    implements Predicate2<T2, T3>,
    Serializable {
        private final Predicate3<? super T1, ? super T2, ? super T3> _pred;
        private final T1 _arg1;

        public BindFirstPredicate2(Predicate3<? super T1, ? super T2, ? super T3> pred, T1 arg1) {
            this._pred = pred;
            this._arg1 = arg1;
        }

        @Override
        public boolean contains(T2 arg2, T3 arg3) {
            return this._pred.contains(this._arg1, arg2, arg3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindSecondPredicate<T1, T2>
    implements Predicate<T1>,
    Serializable {
        private final Predicate2<? super T1, ? super T2> _pred;
        private final T2 _arg2;

        public BindSecondPredicate(Predicate2<? super T1, ? super T2> pred, T2 arg2) {
            this._pred = pred;
            this._arg2 = arg2;
        }

        @Override
        public boolean contains(T1 arg1) {
            return this._pred.contains(arg1, this._arg2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindFirstPredicate<T1, T2>
    implements Predicate<T2>,
    Serializable {
        private final Predicate2<? super T1, ? super T2> _pred;
        private final T1 _arg1;

        public BindFirstPredicate(Predicate2<? super T1, ? super T2> pred, T1 arg1) {
            this._pred = pred;
            this._arg1 = arg1;
        }

        @Override
        public boolean contains(T2 arg2) {
            return this._pred.contains(this._arg1, arg2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindFirstCondition<T>
    implements Condition,
    Serializable {
        private final Predicate<? super T> _pred;
        private final T _arg;

        public BindFirstCondition(Predicate<? super T> pred, T arg) {
            this._pred = pred;
            this._arg = arg;
        }

        @Override
        public boolean isTrue() {
            return this._pred.contains(this._arg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindFourthLambda3<T1, T2, T3, T4, R>
    implements Lambda3<T1, T2, T3, R>,
    Serializable {
        private final Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> _lambda;
        private final T4 _arg4;

        public BindFourthLambda3(Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> lambda, T4 arg4) {
            this._lambda = lambda;
            this._arg4 = arg4;
        }

        @Override
        public R value(T1 arg1, T2 arg2, T3 arg3) {
            return this._lambda.value(arg1, arg2, arg3, this._arg4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindThirdLambda3<T1, T2, T3, T4, R>
    implements Lambda3<T1, T2, T4, R>,
    Serializable {
        private final Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> _lambda;
        private final T3 _arg3;

        public BindThirdLambda3(Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> lambda, T3 arg3) {
            this._lambda = lambda;
            this._arg3 = arg3;
        }

        @Override
        public R value(T1 arg1, T2 arg2, T4 arg4) {
            return this._lambda.value(arg1, arg2, this._arg3, arg4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindSecondLambda3<T1, T2, T3, T4, R>
    implements Lambda3<T1, T3, T4, R>,
    Serializable {
        private final Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> _lambda;
        private final T2 _arg2;

        public BindSecondLambda3(Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> lambda, T2 arg2) {
            this._lambda = lambda;
            this._arg2 = arg2;
        }

        @Override
        public R value(T1 arg1, T3 arg3, T4 arg4) {
            return this._lambda.value(arg1, this._arg2, arg3, arg4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindFirstLambda3<T1, T2, T3, T4, R>
    implements Lambda3<T2, T3, T4, R>,
    Serializable {
        private final Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> _lambda;
        private final T1 _arg1;

        public BindFirstLambda3(Lambda4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> lambda, T1 arg1) {
            this._lambda = lambda;
            this._arg1 = arg1;
        }

        @Override
        public R value(T2 arg2, T3 arg3, T4 arg4) {
            return this._lambda.value(this._arg1, arg2, arg3, arg4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindThirdLambda2<T1, T2, T3, R>
    implements Lambda2<T1, T2, R>,
    Serializable {
        private final Lambda3<? super T1, ? super T2, ? super T3, ? extends R> _lambda;
        private final T3 _arg3;

        public BindThirdLambda2(Lambda3<? super T1, ? super T2, ? super T3, ? extends R> lambda, T3 arg3) {
            this._lambda = lambda;
            this._arg3 = arg3;
        }

        @Override
        public R value(T1 arg1, T2 arg2) {
            return this._lambda.value(arg1, arg2, this._arg3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindSecondLambda2<T1, T2, T3, R>
    implements Lambda2<T1, T3, R>,
    Serializable {
        private final Lambda3<? super T1, ? super T2, ? super T3, ? extends R> _lambda;
        private final T2 _arg2;

        public BindSecondLambda2(Lambda3<? super T1, ? super T2, ? super T3, ? extends R> lambda, T2 arg2) {
            this._lambda = lambda;
            this._arg2 = arg2;
        }

        @Override
        public R value(T1 arg1, T3 arg3) {
            return this._lambda.value(arg1, this._arg2, arg3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindFirstLambda2<T1, T2, T3, R>
    implements Lambda2<T2, T3, R>,
    Serializable {
        private final Lambda3<? super T1, ? super T2, ? super T3, ? extends R> _lambda;
        private final T1 _arg1;

        public BindFirstLambda2(Lambda3<? super T1, ? super T2, ? super T3, ? extends R> lambda, T1 arg1) {
            this._lambda = lambda;
            this._arg1 = arg1;
        }

        @Override
        public R value(T2 arg2, T3 arg3) {
            return this._lambda.value(this._arg1, arg2, arg3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindSecondLambda<T1, T2, R>
    implements Lambda<T1, R>,
    Serializable {
        private final Lambda2<? super T1, ? super T2, ? extends R> _lambda;
        private final T2 _arg2;

        public BindSecondLambda(Lambda2<? super T1, ? super T2, ? extends R> lambda, T2 arg2) {
            this._lambda = lambda;
            this._arg2 = arg2;
        }

        @Override
        public R value(T1 arg1) {
            return this._lambda.value(arg1, this._arg2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindFirstLambda<T1, T2, R>
    implements Lambda<T2, R>,
    Serializable {
        private final Lambda2<? super T1, ? super T2, ? extends R> _lambda;
        private final T1 _arg1;

        public BindFirstLambda(Lambda2<? super T1, ? super T2, ? extends R> lambda, T1 arg1) {
            this._lambda = lambda;
            this._arg1 = arg1;
        }

        @Override
        public R value(T2 arg2) {
            return this._lambda.value(this._arg1, arg2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindFirstThunk<T, R>
    implements Thunk<R>,
    Serializable {
        private final Lambda<? super T, ? extends R> _lambda;
        private final T _arg;

        public BindFirstThunk(Lambda<? super T, ? extends R> lambda, T arg) {
            this._lambda = lambda;
            this._arg = arg;
        }

        @Override
        public R value() {
            return this._lambda.value(this._arg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComposedRunnable4<T1, T2, T3, T4>
    implements Runnable4<T1, T2, T3, T4>,
    Serializable {
        private final Iterable<? extends Runnable4<? super T1, ? super T2, ? super T3, ? super T4>> _runnables;

        public ComposedRunnable4(Iterable<? extends Runnable4<? super T1, ? super T2, ? super T3, ? super T4>> runnables) {
            this._runnables = runnables;
        }

        @Override
        public void run(T1 arg1, T2 arg2, T3 arg3, T4 arg4) {
            for (Runnable4<T1, T2, T3, T4> r : this._runnables) {
                r.run(arg1, arg2, arg3, arg4);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComposedRunnable3<T1, T2, T3>
    implements Runnable3<T1, T2, T3>,
    Serializable {
        private final Iterable<? extends Runnable3<? super T1, ? super T2, ? super T3>> _runnables;

        public ComposedRunnable3(Iterable<? extends Runnable3<? super T1, ? super T2, ? super T3>> runnables) {
            this._runnables = runnables;
        }

        @Override
        public void run(T1 arg1, T2 arg2, T3 arg3) {
            for (Runnable3<T1, T2, T3> r : this._runnables) {
                r.run(arg1, arg2, arg3);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComposedRunnable2<T1, T2>
    implements Runnable2<T1, T2>,
    Serializable {
        private final Iterable<? extends Runnable2<? super T1, ? super T2>> _runnables;

        public ComposedRunnable2(Iterable<? extends Runnable2<? super T1, ? super T2>> runnables) {
            this._runnables = runnables;
        }

        @Override
        public void run(T1 arg1, T2 arg2) {
            for (Runnable2<T1, T2> r : this._runnables) {
                r.run(arg1, arg2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComposedRunnable1<T>
    implements Runnable1<T>,
    Serializable {
        private final Iterable<? extends Runnable1<? super T>> _runnables;

        public ComposedRunnable1(Iterable<? extends Runnable1<? super T>> runnables) {
            this._runnables = runnables;
        }

        @Override
        public void run(T arg) {
            for (Runnable1<T> r : this._runnables) {
                r.run(arg);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComposedRunnable
    implements Runnable,
    Serializable {
        private final Iterable<? extends Runnable> _runnables;

        public ComposedRunnable(Iterable<? extends Runnable> runnables) {
            this._runnables = runnables;
        }

        @Override
        public void run() {
            for (Runnable runnable : this._runnables) {
                runnable.run();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComposedLambda4<S1, S2, S3, S4, T, U>
    implements Lambda4<S1, S2, S3, S4, U>,
    Serializable {
        private final Lambda4<? super S1, ? super S2, ? super S3, ? super S4, ? extends T> _l1;
        private final Lambda<? super T, ? extends U> _l2;

        public ComposedLambda4(Lambda4<? super S1, ? super S2, ? super S3, ? super S4, ? extends T> l1, Lambda<? super T, ? extends U> l2) {
            this._l1 = l1;
            this._l2 = l2;
        }

        @Override
        public U value(S1 arg1, S2 arg2, S3 arg3, S4 arg4) {
            return this._l2.value(this._l1.value(arg1, arg2, arg3, arg4));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComposedLambda3<S1, S2, S3, T, U>
    implements Lambda3<S1, S2, S3, U>,
    Serializable {
        private final Lambda3<? super S1, ? super S2, ? super S3, ? extends T> _l1;
        private final Lambda<? super T, ? extends U> _l2;

        public ComposedLambda3(Lambda3<? super S1, ? super S2, ? super S3, ? extends T> l1, Lambda<? super T, ? extends U> l2) {
            this._l1 = l1;
            this._l2 = l2;
        }

        @Override
        public U value(S1 arg1, S2 arg2, S3 arg3) {
            return this._l2.value(this._l1.value(arg1, arg2, arg3));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComposedLambda2<S1, S2, T, U>
    implements Lambda2<S1, S2, U>,
    Serializable {
        private final Lambda2<? super S1, ? super S2, ? extends T> _l1;
        private final Lambda<? super T, ? extends U> _l2;

        public ComposedLambda2(Lambda2<? super S1, ? super S2, ? extends T> l1, Lambda<? super T, ? extends U> l2) {
            this._l1 = l1;
            this._l2 = l2;
        }

        @Override
        public U value(S1 arg1, S2 arg2) {
            return this._l2.value(this._l1.value(arg1, arg2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComposedLambda<S, T, U>
    implements Lambda<S, U>,
    Serializable {
        private final Lambda<? super S, ? extends T> _l1;
        private final Lambda<? super T, ? extends U> _l2;

        public ComposedLambda(Lambda<? super S, ? extends T> l1, Lambda<? super T, ? extends U> l2) {
            this._l1 = l1;
            this._l2 = l2;
        }

        @Override
        public U value(S arg) {
            return this._l2.value(this._l1.value(arg));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComposedThunk<T, U>
    implements Thunk<U>,
    Serializable {
        private final Thunk<? extends T> _l1;
        private final Lambda<? super T, ? extends U> _l2;

        public ComposedThunk(Thunk<? extends T> l1, Lambda<? super T, ? extends U> l2) {
            this._l1 = l1;
            this._l2 = l2;
        }

        @Override
        public U value() {
            return this._l2.value(this._l1.value());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PromotedPredicate4<T1, T2, T3>
    implements Predicate4<T1, T2, T3, Object>,
    Serializable {
        private final Predicate3<? super T1, ? super T2, ? super T3> _p;

        public PromotedPredicate4(Predicate3<? super T1, ? super T2, ? super T3> p) {
            this._p = p;
        }

        @Override
        public boolean contains(T1 arg1, T2 arg2, T3 arg3, Object arg4) {
            return this._p.contains(arg1, arg2, arg3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PromotedPredicate3<T1, T2>
    implements Predicate3<T1, T2, Object>,
    Serializable {
        private final Predicate2<? super T1, ? super T2> _p;

        public PromotedPredicate3(Predicate2<? super T1, ? super T2> p) {
            this._p = p;
        }

        @Override
        public boolean contains(T1 arg1, T2 arg2, Object arg3) {
            return this._p.contains(arg1, arg2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PromotedPredicate2<T>
    implements Predicate2<T, Object>,
    Serializable {
        private final Predicate<? super T> _p;

        public PromotedPredicate2(Predicate<? super T> p) {
            this._p = p;
        }

        @Override
        public boolean contains(T arg1, Object arg2) {
            return this._p.contains(arg1);
        }
    }

    private static final class PromotedGeneralPredicate
    implements GeneralPredicate,
    Serializable {
        private final Condition _c;

        public PromotedGeneralPredicate(Condition c) {
            this._c = c;
        }

        public boolean isTrue() {
            return this._c.isTrue();
        }

        public boolean contains(Object arg) {
            return this._c.isTrue();
        }

        public boolean contains(Object arg1, Object arg2) {
            return this._c.isTrue();
        }

        public boolean contains(Object arg1, Object arg2, Object arg3) {
            return this._c.isTrue();
        }

        public boolean contains(Object arg1, Object arg2, Object arg3, Object arg4) {
            return this._c.isTrue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PromotedLambda4<T1, T2, T3, R>
    implements Lambda4<T1, T2, T3, Object, R>,
    Serializable {
        private final Lambda3<? super T1, ? super T2, ? super T3, ? extends R> _l;

        public PromotedLambda4(Lambda3<? super T1, ? super T2, ? super T3, ? extends R> l) {
            this._l = l;
        }

        @Override
        public R value(T1 arg1, T2 arg2, T3 arg3, Object arg4) {
            return this._l.value(arg1, arg2, arg3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PromotedLambda3<T1, T2, R>
    implements Lambda3<T1, T2, Object, R>,
    Serializable {
        private final Lambda2<? super T1, ? super T2, ? extends R> _l;

        public PromotedLambda3(Lambda2<? super T1, ? super T2, ? extends R> l) {
            this._l = l;
        }

        @Override
        public R value(T1 arg1, T2 arg2, Object arg3) {
            return this._l.value(arg1, arg2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PromotedLambda2<T, R>
    implements Lambda2<T, Object, R>,
    Serializable {
        private final Lambda<? super T, ? extends R> _l;

        public PromotedLambda2(Lambda<? super T, ? extends R> l) {
            this._l = l;
        }

        @Override
        public R value(T arg1, Object arg2) {
            return this._l.value(arg1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PromotedGeneralLambda<R>
    implements GeneralLambda<R>,
    Serializable {
        private final Thunk<? extends R> _l;

        public PromotedGeneralLambda(Thunk<? extends R> l) {
            this._l = l;
        }

        @Override
        public R value() {
            return this._l.value();
        }

        @Override
        public R value(Object arg) {
            return this._l.value();
        }

        @Override
        public R value(Object arg1, Object arg2) {
            return this._l.value();
        }

        @Override
        public R value(Object arg, Object arg2, Object arg3) {
            return this._l.value();
        }

        @Override
        public R value(Object arg, Object arg2, Object arg3, Object arg4) {
            return this._l.value();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PromotedRunnable4<T1, T2, T3>
    implements Runnable4<T1, T2, T3, Object>,
    Serializable {
        private final Runnable3<? super T1, ? super T2, ? super T3> _r;

        public PromotedRunnable4(Runnable3<? super T1, ? super T2, ? super T3> r) {
            this._r = r;
        }

        @Override
        public void run(T1 arg1, T2 arg2, T3 arg3, Object arg4) {
            this._r.run(arg1, arg2, arg3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PromotedRunnable3<T1, T2>
    implements Runnable3<T1, T2, Object>,
    Serializable {
        private final Runnable2<? super T1, ? super T2> _r;

        public PromotedRunnable3(Runnable2<? super T1, ? super T2> r) {
            this._r = r;
        }

        @Override
        public void run(T1 arg1, T2 arg2, Object arg3) {
            this._r.run(arg1, arg2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PromotedRunnable2<T>
    implements Runnable2<T, Object>,
    Serializable {
        private final Runnable1<? super T> _r;

        public PromotedRunnable2(Runnable1<? super T> r) {
            this._r = r;
        }

        @Override
        public void run(T arg1, Object arg2) {
            this._r.run(arg1);
        }
    }

    private static final class PromotedGeneralRunnable
    implements GeneralRunnable,
    Serializable {
        private final Runnable _r;

        public PromotedGeneralRunnable(Runnable r) {
            this._r = r;
        }

        public void run() {
            this._r.run();
        }

        public void run(Object arg) {
            this._r.run();
        }

        public void run(Object arg1, Object arg2) {
            this._r.run();
        }

        public void run(Object arg1, Object arg2, Object arg3) {
            this._r.run();
        }

        public void run(Object arg1, Object arg2, Object arg3, Object arg4) {
            this._r.run();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TernaryApplicationLambda<T1, T2, T3, R>
    implements Lambda4<Lambda3<? super T1, ? super T2, ? super T3, ? extends R>, T1, T2, T3, R>,
    Serializable {
        private static final TernaryApplicationLambda<Object, Object, Object, Void> INSTANCE = new TernaryApplicationLambda();

        private TernaryApplicationLambda() {
        }

        @Override
        public R value(Lambda3<? super T1, ? super T2, ? super T3, ? extends R> lambda, T1 a1, T2 a2, T3 a3) {
            return lambda.value(a1, a2, a3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BinaryApplicationLambda<T1, T2, R>
    implements Lambda3<Lambda2<? super T1, ? super T2, ? extends R>, T1, T2, R>,
    Serializable {
        private static final BinaryApplicationLambda<Object, Object, Void> INSTANCE = new BinaryApplicationLambda();

        private BinaryApplicationLambda() {
        }

        @Override
        public R value(Lambda2<? super T1, ? super T2, ? extends R> lambda, T1 a1, T2 a2) {
            return lambda.value(a1, a2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ApplicationLambda<T, R>
    implements Lambda2<Lambda<? super T, ? extends R>, T, R>,
    Serializable {
        private static final ApplicationLambda<Object, Void> INSTANCE = new ApplicationLambda();

        private ApplicationLambda() {
        }

        @Override
        public R value(Lambda<? super T, ? extends R> lambda, T arg) {
            return lambda.value(arg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ThunkValueLambda<R>
    implements Lambda<Thunk<? extends R>, R>,
    Serializable {
        public static final ThunkValueLambda<Void> INSTANCE = new ThunkValueLambda();

        private ThunkValueLambda() {
        }

        @Override
        public R value(Thunk<? extends R> t) {
            return t.value();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ValueLambda<T>
    implements GeneralLambda<T>,
    Serializable {
        private final T _val;

        public ValueLambda(T val) {
            this._val = val;
        }

        @Override
        public T value() {
            return this._val;
        }

        @Override
        public T value(Object arg) {
            return this._val;
        }

        @Override
        public T value(Object arg1, Object arg2) {
            return this._val;
        }

        @Override
        public T value(Object arg1, Object arg2, Object arg3) {
            return this._val;
        }

        @Override
        public T value(Object arg1, Object arg2, Object arg3, Object arg4) {
            return this._val;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ExceptionLambda<R>
    implements GeneralLambda<R>,
    Serializable {
        private final RuntimeException _e;

        public ExceptionLambda(RuntimeException e) {
            this._e = e;
        }

        @Override
        public R value() {
            this._e.fillInStackTrace();
            throw this._e;
        }

        @Override
        public R value(Object arg) {
            this._e.fillInStackTrace();
            throw this._e;
        }

        @Override
        public R value(Object arg1, Object arg2) {
            this._e.fillInStackTrace();
            throw this._e;
        }

        @Override
        public R value(Object arg1, Object arg2, Object arg3) {
            this._e.fillInStackTrace();
            throw this._e;
        }

        @Override
        public R value(Object arg1, Object arg2, Object arg3, Object arg4) {
            this._e.fillInStackTrace();
            throw this._e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NullLambda
    implements GeneralLambda<Void>,
    Serializable {
        private static final NullLambda INSTANCE = new NullLambda();

        private NullLambda() {
        }

        @Override
        public Void value() {
            return null;
        }

        @Override
        public Void value(Object arg) {
            return null;
        }

        @Override
        public Void value(Object arg1, Object arg2) {
            return null;
        }

        @Override
        public Void value(Object arg1, Object arg2, Object arg3) {
            return null;
        }

        @Override
        public Void value(Object arg1, Object arg2, Object arg3, Object arg4) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IdentityLambda
    implements Lambda<Object, Object>,
    Serializable {
        private static final IdentityLambda INSTANCE = new IdentityLambda();

        private IdentityLambda() {
        }

        @Override
        public Object value(Object arg) {
            return arg;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DivideIntLambda
    implements Lambda2<Integer, Integer, Integer>,
    Serializable {
        private DivideIntLambda() {
        }

        @Override
        public Integer value(Integer x, Integer y) {
            return x / y;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MultiplyIntLambda
    implements Lambda2<Integer, Integer, Integer>,
    Serializable {
        private MultiplyIntLambda() {
        }

        @Override
        public Integer value(Integer x, Integer y) {
            return x * y;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SubtractIntLambda
    implements Lambda2<Integer, Integer, Integer>,
    Serializable {
        private SubtractIntLambda() {
        }

        @Override
        public Integer value(Integer x, Integer y) {
            return x - y;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AddIntLambda
    implements Lambda2<Integer, Integer, Integer>,
    Serializable {
        private AddIntLambda() {
        }

        @Override
        public Integer value(Integer x, Integer y) {
            return x + y;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DecrementIntLambda
    implements Lambda<Integer, Integer>,
    Serializable {
        private DecrementIntLambda() {
        }

        @Override
        public Integer value(Integer i) {
            return i - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IncrementIntLambda
    implements Lambda<Integer, Integer>,
    Serializable {
        private IncrementIntLambda() {
        }

        @Override
        public Integer value(Integer i) {
            return i + 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HashCodeLambda
    implements Lambda<Object, Integer>,
    Serializable {
        private HashCodeLambda() {
        }

        @Override
        public Integer value(Object obj) {
            return RecurUtil.safeHashCode(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StringConcatLambda
    implements Lambda2<Object, Object, String>,
    Serializable {
        private StringConcatLambda() {
        }

        @Override
        public String value(Object o1, Object o2) {
            return RecurUtil.safeToString(o1) + RecurUtil.safeToString(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ToStringLambda
    implements Lambda<Object, String>,
    Serializable {
        private ToStringLambda() {
        }

        @Override
        public String value(Object obj) {
            return RecurUtil.safeToString(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InstanceOfPredicate
    implements Predicate2<Object, Class<?>>,
    Serializable {
        private InstanceOfPredicate() {
        }

        @Override
        public boolean contains(Object val, Class<?> c) {
            return c.isInstance(val);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NotIdenticalPredicate
    implements Predicate2<Object, Object>,
    Serializable {
        private NotIdenticalPredicate() {
        }

        @Override
        public boolean contains(Object arg1, Object arg2) {
            return arg1 != arg2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IdenticalPredicate
    implements Predicate2<Object, Object>,
    Serializable {
        private IdenticalPredicate() {
        }

        @Override
        public boolean contains(Object arg1, Object arg2) {
            return arg1 == arg2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EqualPredicate
    implements Predicate2<Object, Object>,
    Serializable {
        private EqualPredicate() {
        }

        @Override
        public boolean contains(Object arg1, Object arg2) {
            return RecurUtil.safeEquals(arg1, arg2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NotNullPredicate
    implements Predicate<Object>,
    Serializable {
        private NotNullPredicate() {
        }

        @Override
        public boolean contains(Object arg) {
            return arg != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IsNullPredicate
    implements Predicate<Object>,
    Serializable {
        private IsNullPredicate() {
        }

        @Override
        public boolean contains(Object arg) {
            return arg == null;
        }
    }

    private static final class False
    implements GeneralPredicate,
    Serializable {
        private False() {
        }

        public boolean isTrue() {
            return true;
        }

        public boolean contains(Object o) {
            return false;
        }

        public boolean contains(Object o1, Object o2) {
            return false;
        }

        public boolean contains(Object o1, Object o2, Object o3) {
            return false;
        }

        public boolean contains(Object o1, Object o2, Object o3, Object o4) {
            return false;
        }
    }

    private static final class True
    implements GeneralPredicate,
    Serializable {
        private True() {
        }

        public boolean isTrue() {
            return true;
        }

        public boolean contains(Object o) {
            return true;
        }

        public boolean contains(Object o1, Object o2) {
            return true;
        }

        public boolean contains(Object o1, Object o2, Object o3) {
            return true;
        }

        public boolean contains(Object o1, Object o2, Object o3, Object o4) {
            return true;
        }
    }

    private static final class NoOp
    implements GeneralRunnable,
    Serializable {
        private NoOp() {
        }

        public void run() {
        }

        public void run(Object o) {
        }

        public void run(Object o1, Object o2) {
        }

        public void run(Object o1, Object o2, Object o3) {
        }

        public void run(Object o1, Object o2, Object o3, Object o4) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface GeneralPredicate
    extends Condition,
    Predicate<Object>,
    Predicate2<Object, Object>,
    Predicate3<Object, Object, Object>,
    Predicate4<Object, Object, Object, Object> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface GeneralLambda<R>
    extends Thunk<R>,
    Lambda<Object, R>,
    Lambda2<Object, Object, R>,
    Lambda3<Object, Object, Object, R>,
    Lambda4<Object, Object, Object, Object, R> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface GeneralRunnable
    extends Runnable,
    Runnable1<Object>,
    Runnable2<Object, Object>,
    Runnable3<Object, Object, Object>,
    Runnable4<Object, Object, Object, Object> {
    }
}

