/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.swing;

import edu.rice.cs.plt.concurrent.ConcurrentUtil;
import edu.rice.cs.plt.concurrent.TaskController;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.lambda.WrappedException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SwingWorker<T> {
    private final TaskController<T> _controller;
    private volatile boolean _cancelled;

    public SwingWorker() {
        Thunk task = new Thunk<T>(){

            @Override
            public T value() {
                Object t;
                try {
                    t = SwingWorker.this.doInBackground();
                }
                catch (Throwable t2) {
                    try {
                        throw new WrappedException(t2);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                SwingWorker.this.done();
                            }
                        });
                        throw throwable;
                    }
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                return t;
            }
        };
        this._controller = ConcurrentUtil.computeInProcess(task, false);
        this._cancelled = false;
    }

    protected abstract T doInBackground() throws Exception;

    protected void done() {
    }

    public final void execute() {
        this._controller.start();
    }

    public final void cancel() {
        this._cancelled = true;
        this._controller.cancel();
    }

    public final boolean isCancelled() {
        return this._cancelled;
    }

    public final boolean isDone() {
        TaskController.Status status = this._controller.status();
        return status.equals((Object)TaskController.Status.CANCELED) || status.equals((Object)TaskController.Status.FINISHED);
    }

    public final T get() throws InterruptedException, InvocationTargetException {
        if (this._cancelled) {
            throw new IllegalStateException("Task was cancelled");
        }
        try {
            return this._controller.value();
        }
        catch (WrappedException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            if (cause instanceof InvocationTargetException && cause.getCause() != null) {
                throw new InvocationTargetException(cause.getCause());
            }
            throw e;
        }
    }
}

