/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.tuple;

import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Lambda2;
import edu.rice.cs.plt.tuple.Tuple;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pair<T1, T2>
extends Tuple {
    protected final T1 _first;
    protected final T2 _second;

    public Pair(T1 first, T2 second) {
        this._first = first;
        this._second = second;
    }

    public T1 first() {
        return this._first;
    }

    public T2 second() {
        return this._second;
    }

    public Pair<T2, T1> inverse() {
        return new Pair<T2, T1>(this._second, this._first);
    }

    public String toString() {
        return "(" + this._first + ", " + this._second + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        Pair cast = (Pair)o;
        return (this._first == null ? cast._first == null : this._first.equals(cast._first)) && (this._second == null ? cast._second == null : this._second.equals(cast._second));
    }

    @Override
    protected int generateHashCode() {
        return (this._first == null ? 0 : this._first.hashCode()) ^ (this._second == null ? 0 : this._second.hashCode() << 1) ^ this.getClass().hashCode();
    }

    public static <T1, T2> Pair<T1, T2> make(T1 first, T2 second) {
        return new Pair<T1, T2>(first, second);
    }

    public static <T1, T2> Lambda2<T1, T2, Pair<T1, T2>> factory() {
        return Factory.INSTANCE;
    }

    public static <T1, T2> Lambda<Pair<T1, T2>, Pair<T2, T1>> inverter() {
        return Inverter.INSTANCE;
    }

    public static <T> Lambda<Pair<? extends T, ?>, T> firstGetter() {
        return GetFirst.INSTANCE;
    }

    public static <T> Lambda<Pair<?, ? extends T>, T> secondGetter() {
        return GetSecond.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetSecond<T>
    implements Lambda<Pair<?, ? extends T>, T>,
    Serializable {
        public static final GetSecond<Void> INSTANCE = new GetSecond();

        private GetSecond() {
        }

        @Override
        public T value(Pair<?, ? extends T> arg) {
            return arg.second();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetFirst<T>
    implements Lambda<Pair<? extends T, ?>, T>,
    Serializable {
        public static final GetFirst<Void> INSTANCE = new GetFirst();

        private GetFirst() {
        }

        @Override
        public T value(Pair<? extends T, ?> arg) {
            return arg.first();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Inverter<T1, T2>
    implements Lambda<Pair<T1, T2>, Pair<T2, T1>>,
    Serializable {
        public static final Inverter<Void, Void> INSTANCE = new Inverter();

        private Inverter() {
        }

        @Override
        public Pair<T2, T1> value(Pair<T1, T2> arg) {
            return arg.inverse();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Factory<T1, T2>
    implements Lambda2<T1, T2, Pair<T1, T2>>,
    Serializable {
        public static final Factory<Object, Object> INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        public Pair<T1, T2> value(T1 first, T2 second) {
            return new Pair<T1, T2>(first, second);
        }
    }
}

