/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.newjvm;

import edu.rice.cs.plt.concurrent.ConcurrentUtil;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.newjvm.ExecJVM;
import edu.rice.cs.util.newjvm.MasterRemote;
import edu.rice.cs.util.newjvm.SlaveJVMRunner;
import edu.rice.cs.util.newjvm.SlaveRemote;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.swing.JOptionPane;

public abstract class AbstractMasterJVM
implements MasterRemote {
    public static final Log _log = new Log("MasterSlave.txt", false);
    protected volatile String _waitForQuitThreadName = "Wait for SlaveJVM Exit Thread";
    protected final Object _masterJVMLock = new Object();
    private static final String RUNNER = SlaveJVMRunner.class.getName();
    protected volatile SlaveRemote _slave;
    private volatile boolean _startupInProgress = false;
    private volatile boolean _quitOnStartup = false;
    private volatile MasterRemote _masterStub = null;
    private volatile File _masterStubFile;
    private final String _slaveClassName;
    private volatile Thread _monitorThread;

    protected AbstractMasterJVM(String slaveClassName) throws RemoteException {
        this._slaveClassName = slaveClassName;
        this._slave = null;
        this._monitorThread = null;
        _log.log(this + " CREATED");
        System.setProperty("java.rmi.server.hostname", "127.0.0.1");
    }

    protected abstract void handleSlaveConnected();

    protected abstract void handleSlaveQuit(int var1);

    protected final void invokeSlave() throws IOException, RemoteException {
        this.invokeSlave(new String[0], FileOps.NULL_FILE);
    }

    protected final void invokeSlave(String[] jvmArgs, File workDir) throws IOException, RemoteException {
        this.invokeSlave(jvmArgs, System.getProperty("java.class.path"), workDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void invokeSlave(String[] jvmArgs, final String cp, final File workDir) throws IOException, RemoteException {
        Object object = this._masterJVMLock;
        synchronized (object) {
            try {
                while (this._startupInProgress || this._monitorThread != null) {
                    this._masterJVMLock.wait();
                }
            }
            catch (InterruptedException e) {
                throw new UnexpectedException(e);
            }
            this._startupInProgress = true;
        }
        _log.log(this + ".invokeSlave(...) called");
        if (this._masterStub == null) {
            try {
                this._masterStub = (MasterRemote)UnicastRemoteObject.exportObject((Remote)this, 0);
            }
            catch (RemoteException re) {
                JOptionPane.showMessageDialog(null, StringOps.getStackTrace(re));
                _log.log(this + " threw " + re);
                throw new UnexpectedException(re);
            }
            _log.log(this + " EXPORTed Master JVM");
            this._masterStubFile = File.createTempFile("DrJava-remote-stub", ".tmp");
            this._masterStubFile.deleteOnExit();
            FileOutputStream fstream = new FileOutputStream(this._masterStubFile);
            ObjectOutputStream ostream = new ObjectOutputStream(fstream);
            ostream.writeObject(this._masterStub);
            ostream.flush();
            fstream.close();
            ostream.close();
        }
        final String[] args = new String[]{this._masterStubFile.getAbsolutePath(), this._slaveClassName};
        LinkedList<String> fullJVMArgs = new LinkedList<String>(Arrays.asList(jvmArgs));
        Properties propagate = ConcurrentUtil.getProperties("plt.", "drjava.", "edu.rice.cs.");
        if (!propagate.containsKey("plt.log.working.dir") && (propagate.containsKey("plt.debug.log") || propagate.containsKey("plt.error.log") || propagate.containsKey("plt.log.factory"))) {
            propagate.put("plt.log.working.dir", System.getProperty("user.dir", ""));
        }
        for (Map.Entry<Object, Object> entry : propagate.entrySet()) {
            fullJVMArgs.addFirst("-D" + entry.getKey() + "=" + entry.getValue());
        }
        final String[] jvmArgsArray = fullJVMArgs.toArray(new String[0]);
        this._monitorThread = new Thread(this._waitForQuitThreadName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    DebugUtil.debug.logValues("Starting slave JVM", new String[]{"RUNNER", "args", "cp", "jvmArgsArray", "workDir"}, RUNNER, args, cp, jvmArgsArray, workDir);
                    _log.log(AbstractMasterJVM.this + " is STARTING a Slave JVM with args " + Arrays.asList(args));
                    Process process = ExecJVM.runJVM(RUNNER, args, cp, jvmArgsArray, workDir);
                    _log.log(AbstractMasterJVM.this + " CREATED Slave JVM process " + process + " with " + this.asString());
                    int status = process.waitFor();
                    Object object = AbstractMasterJVM.this._masterJVMLock;
                    synchronized (object) {
                        if (AbstractMasterJVM.this._startupInProgress) {
                            DebugUtil.error.log("Slave process died without registering");
                            AbstractMasterJVM.this.slaveQuitDuringStartup(status);
                        }
                        if (AbstractMasterJVM.this._slave != null) {
                            AbstractMasterJVM.this._slave = null;
                        }
                        AbstractMasterJVM.this._monitorThread = null;
                        AbstractMasterJVM.this._masterJVMLock.notifyAll();
                    }
                    AbstractMasterJVM.this.handleSlaveQuit(status);
                }
                catch (NoSuchObjectException e) {
                    throw new UnexpectedException(e);
                }
                catch (InterruptedException e) {
                    throw new UnexpectedException(e);
                }
                catch (IOException e) {
                    throw new UnexpectedException(e);
                }
            }

            private String asString() {
                return "MonitorThread@" + Integer.toHexString(this.hashCode());
            }
        };
        this._monitorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitSlaveDone() {
        try {
            Object object = this._masterJVMLock;
            synchronized (object) {
                while (this._monitorThread != null) {
                    this._masterJVMLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            throw new UnexpectedException(e);
        }
    }

    protected void slaveQuitDuringStartup(int status) {
        this._startupInProgress = false;
        this._quitOnStartup = false;
        this._monitorThread = null;
    }

    public abstract void errorStartingSlave(Throwable var1) throws RemoteException;

    public void checkStillAlive() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSlave(SlaveRemote slave) throws RemoteException {
        boolean quitSlavePending;
        _log.log(this + " registering Slave " + slave);
        Object object = this._masterJVMLock;
        synchronized (object) {
            this._slave = slave;
            this._startupInProgress = false;
            _log.log(this + " calling handleSlaveConnected()");
            this.handleSlaveConnected();
            quitSlavePending = this._quitOnStartup;
            if (this._quitOnStartup) {
                this._quitOnStartup = false;
            }
        }
        if (quitSlavePending) {
            _log.log(this + " Executing deferred quitSlave() that was called during startUp");
            this.quitSlave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws RemoteException {
        SlaveRemote dyingSlave;
        _log.log(this + ".dispose() called; slaveRemote is " + this._slave);
        if (this._startupInProgress) {
            _log.log(this + ".dispose() is KILLing startUp in process; dying slave reference does not yet exist");
        }
        Object object = this._masterJVMLock;
        synchronized (object) {
            this._masterStub = null;
            if (this._monitorThread != null) {
                this._monitorThread = null;
            }
            dyingSlave = this._slave;
            this._slave = null;
            _log.log(this + ".dispose() UNEXPORTing " + this);
            UnicastRemoteObject.unexportObject(this, true);
        }
        if (dyingSlave != null) {
            _log.log(this + ".dispose() QUITing " + dyingSlave);
            dyingSlave.quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void quitSlave() throws RemoteException {
        SlaveRemote dyingSlave;
        Object object = this._masterJVMLock;
        synchronized (object) {
            if (this.isStartupInProgress()) {
                this._quitOnStartup = true;
                return;
            }
            if (this._slave == null) {
                _log.log(this + " called quitSlave() when no slave was running");
                return;
            }
            dyingSlave = this._slave;
            this._slave = null;
        }
        dyingSlave.quit();
    }

    protected final SlaveRemote getSlave() {
        return this._slave;
    }

    protected boolean isStartupInProgress() {
        return this._startupInProgress;
    }
}

