/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.newjvm;

import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.newjvm.AbstractSlaveJVM;
import edu.rice.cs.util.newjvm.MasterRemote;
import edu.rice.cs.util.newjvm.SlaveRemote;
import edu.rice.cs.util.swing.Utilities;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SlaveJVMRunner {
    public static final boolean SHOW_DEBUG_DIALOGS = false;
    protected static final Log _log = new Log("MasterSlave.txt", false);

    private SlaveJVMRunner() {
    }

    private static AbstractSlaveJVM _getInstance(Class<?> clazz) throws Exception {
        try {
            return (AbstractSlaveJVM)clazz.getField("ONLY").get(null);
        }
        catch (Throwable t) {
            _log.log("SlaveRemote class does not have an ONLY field!");
            return (AbstractSlaveJVM)clazz.newInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void main(String[] args) {
        DebugUtil.debug.logStart();
        try {
            System.setProperty("java.rmi.server.hostname", "127.0.0.1");
            assert (args.length == 3 || args.length == 2);
            FileInputStream fstream = new FileInputStream(args[0]);
            ObjectInputStream ostream = new ObjectInputStream(new BufferedInputStream(fstream));
            _log.log("Slave JVM reading master remote stub from file " + args[0] + " with " + fstream.getChannel().size() + " bytes");
            MasterRemote masterRemote = (MasterRemote)ostream.readObject();
            _log.log("SlaveJVMRunner completed reading " + masterRemote);
            DebugUtil.debug.logValue("masterRemote", masterRemote);
            fstream.close();
            ostream.close();
            AbstractSlaveJVM slave = null;
            DebugUtil.debug.log();
            try {
                Class<?> slaveClass = Class.forName(args[1]);
                slave = SlaveJVMRunner._getInstance(slaveClass);
                DebugUtil.debug.logValue("slave", slave);
                SlaveRemote slaveRemote = (SlaveRemote)UnicastRemoteObject.exportObject((Remote)slave, 0);
                DebugUtil.debug.logValue("slaveRemote", slaveRemote);
                slave.start(masterRemote);
                DebugUtil.debug.logStart("invoking masterRemote.registerSlave");
                masterRemote.registerSlave(slave);
                DebugUtil.debug.logEnd("Slave is registered");
            }
            catch (Throwable e) {
                DebugUtil.debug.log(e);
                _log.log("SlaveJVMRunner could not instantiate and start slave class '" + slave + "'.  Threw exception: " + e);
                try {
                    masterRemote.errorStartingSlave(e);
                }
                catch (RemoteException re) {
                    String msg = "SlaveJVMRunner could not instantiate and register the slave.\n  Also failed to display error through master JVM, because:\n" + StringOps.getStackTrace(re) + "\n";
                    SlaveJVMRunner._showErrorMessage(msg, e);
                }
                System.exit(3);
            }
        }
        catch (Throwable e) {
            SlaveJVMRunner._showErrorMessage("SlaveJVMRunner could not set up the Slave JVM.", e);
            _log.log("SlaveJVMRunner could not set up the Slave JVM. Calling System.exit(2) in response to: " + e);
            System.exit(2);
        }
        finally {
            DebugUtil.debug.logEnd();
        }
    }

    private static void _showErrorMessage(String cause, Throwable t) {
        String msg = "An error occurred in SlaveJVMRunner while starting the slave JVM:\n  " + cause + "\n\nOriginal error:\n" + StringOps.getStackTrace(t);
        _log.log("ERROR in SlaveJVMRunner: " + cause + "; threw " + t);
        if (!Utilities.TEST_MODE) {
            System.out.println(msg);
        }
    }
}

