/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import edu.rice.cs.drjava.ui.MainFrame;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontChooser
extends JDialog {
    private static final String[] STYLES = new String[]{"Plain", "Bold", "Italic", "Bold Italic"};
    private static final String[] SIZES = new String[]{"3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "22", "24", "27", "30", "34", "39", "45", "51", "60"};
    private NwList _styleList;
    private NwList _fontList;
    private NwList _sizeList;
    private JButton _okButton;
    private JButton _cancelButton;
    private JLabel _sampleText = new JLabel();
    private boolean _clickedOK = false;

    private FontChooser(Frame parent, Font font) {
        super(parent, true);
        this.initAll();
        if (font == null) {
            font = this._sampleText.getFont();
        }
        this._fontList.setSelectedItem(font.getName());
        this._sizeList.setSelectedItem(font.getSize() + "");
        this._styleList.setSelectedItem(STYLES[font.getStyle()]);
        this.resize();
    }

    public static Font showDialog(Frame parent, String title, Font font) {
        FontChooser fd = new FontChooser(parent, font);
        fd.setTitle(title);
        MainFrame.setPopupLoc(fd, parent);
        fd.setVisible(true);
        Font chosenFont = null;
        if (fd.clickedOK()) {
            chosenFont = fd.getFont();
        }
        fd.dispose();
        return chosenFont;
    }

    public static Font showDialog(Frame parent, Font font) {
        return FontChooser.showDialog(parent, "Font Chooser", font);
    }

    private void initAll() {
        this.getContentPane().setLayout(null);
        this.setBounds(50, 50, 425, 400);
        this._sampleText = new JLabel();
        this.addLists();
        this.addButtons();
        this._sampleText.setForeground(Color.black);
        this.getContentPane().add(this._sampleText);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FontChooser.this.setVisible(false);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                FontChooser.this.resize();
            }
        });
    }

    private void resize() {
        int w = this.getWidth();
        int h = this.getHeight();
        double wf = (double)w / 425.0;
        int w2 = (int)(80.0 * wf);
        int w3 = (int)(50.0 * wf);
        if (w3 < 30) {
            w3 = 30;
        }
        int w1 = w - w2 - w3 - 25;
        this._fontList.setBounds(5, 5, w1, h - 91);
        this._styleList.setBounds(w1 + 10, 5, w2, h - 91);
        this._sizeList.setBounds(w1 + w2 + 15, 5, w3, h - 91);
        this._sampleText.setBounds(10, h - 78, w - 20, 45);
        this._okButton.setBounds(w - 165, h - 55, 70, 20);
        this._cancelButton.setBounds(w - 81, h - 55, 70, 20);
        this.validate();
    }

    private void addLists() {
        this._fontList = new NwList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        this._styleList = new NwList(STYLES);
        this._sizeList = new NwList(SIZES);
        this.getContentPane().add(this._fontList);
        this.getContentPane().add(this._styleList);
        this.getContentPane().add(this._sizeList);
    }

    private void addButtons() {
        this._okButton = new JButton("OK");
        this._okButton.setMargin(new Insets(0, 0, 0, 0));
        this._cancelButton = new JButton("Cancel");
        this._cancelButton.setMargin(new Insets(0, 0, 0, 0));
        this._okButton.setFont(new Font(" ", 1, 11));
        this._cancelButton.setFont(new Font(" ", 1, 12));
        this.getContentPane().add(this._okButton);
        this.getContentPane().add(this._cancelButton);
        this._okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontChooser.this.setVisible(false);
                FontChooser.this._clickedOK = true;
            }
        });
        this._cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontChooser.this.setVisible(false);
                FontChooser.this._clickedOK = false;
            }
        });
    }

    private void showSample() {
        int g = 0;
        try {
            g = Integer.parseInt(this._sizeList.getSelectedValue());
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        String st = this._styleList.getSelectedValue();
        int s = 0;
        if (st.equalsIgnoreCase("Bold")) {
            s = 1;
        }
        if (st.equalsIgnoreCase("Italic")) {
            s = 2;
        }
        if (st.equalsIgnoreCase("Bold Italic")) {
            s = 3;
        }
        this._sampleText.setFont(new Font(this._fontList.getSelectedValue(), s, g));
        this._sampleText.setText("The quick brown fox jumped over the lazy dog.");
        this._sampleText.setVerticalAlignment(1);
    }

    public boolean clickedOK() {
        return this._clickedOK;
    }

    public Font getFont() {
        return this._sampleText.getFont();
    }

    public class NwList
    extends JPanel {
        JList jl;
        JScrollPane sp;
        JLabel jt;
        String si = " ";

        public NwList(String[] values) {
            this.setLayout(null);
            this.jl = new JList<String>(values);
            this.sp = new JScrollPane(this.jl);
            this.jt = new JLabel();
            this.jt.setBackground(Color.white);
            this.jt.setForeground(Color.black);
            this.jt.setOpaque(true);
            this.jt.setBorder(new JTextField().getBorder());
            this.jt.setFont(this.getFont());
            this.jl.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    NwList.this.jt.setText((String)NwList.this.jl.getSelectedValue());
                    NwList.this.si = (String)NwList.this.jl.getSelectedValue();
                    FontChooser.this.showSample();
                }
            });
            this.add(this.sp);
            this.add(this.jt);
        }

        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, y, w, h);
            this.sp.setBounds(0, y + 16, w, h - 23);
            this.sp.revalidate();
            this.jt.setBounds(0, 0, w, 20);
        }

        public String getSelectedValue() {
            return this.si;
        }

        public void setSelectedItem(String s) {
            this.jl.setSelectedValue(s, true);
        }
    }
}

