/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.util.swing.BorderlessScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class ScrollableDialog {
    public static final int DEFAULT_WIDTH = 500;
    public static final int DEFAULT_HEIGHT = 400;
    protected JDialog _dialog;
    protected JTextArea _textArea;
    protected JPanel _buttonPanel;
    protected JScrollPane _textScroll;
    private Action _okAction = new AbstractAction("OK"){

        public void actionPerformed(ActionEvent e) {
            ScrollableDialog.this._dialog.dispose();
        }
    };

    public ScrollableDialog(JFrame parent, String title, String header, String text) {
        this(parent, title, header, text, 500, 400, false);
    }

    public ScrollableDialog(JFrame parent, String title, String header, String text, int width, int height) {
        this(parent, title, header, text, width, height, false);
    }

    public ScrollableDialog(JFrame parent, String title, String header, String text, boolean wrap) {
        this(parent, title, header, text, 500, 400, wrap);
    }

    public ScrollableDialog(JFrame parent, String title, String header, String text, int width, int height, boolean wrap) {
        this._dialog = new JDialog(parent, title, true);
        Container content = this._dialog.getContentPane();
        content.setLayout(new BorderLayout());
        this._textArea = new JTextArea();
        this._textArea.setEditable(false);
        this._textArea.setText(text);
        this._textArea.setLineWrap(wrap);
        this._textArea.setWrapStyleWord(true);
        this._dialog.setSize(width, height);
        this._textScroll = new BorderlessScrollPane(this._textArea, 22, wrap ? 31 : 30);
        JPanel scrollWrapper = new JPanel(new BorderLayout(0, 5));
        scrollWrapper.setBorder(new EmptyBorder(5, 5, 0, 5));
        scrollWrapper.add((Component)new JLabel(header), "North");
        scrollWrapper.add((Component)this._textScroll, "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        this._buttonPanel = new JPanel(new GridLayout(1, 0, 5, 5));
        bottomPanel.add((Component)this._buttonPanel, "East");
        bottomPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this._addButtons();
        content.add((Component)scrollWrapper, "Center");
        content.add((Component)bottomPanel, "South");
    }

    protected void _addButtons() {
        this._buttonPanel.add(new JButton(this._okAction));
    }

    public void setTextFont(Font f) {
        this._textArea.setFont(f);
    }

    public void show() {
        MainFrame.setPopupLoc(this._dialog, this._dialog.getOwner());
        this._textArea.setCaretPosition(0);
        this._textScroll.getHorizontalScrollBar().setValue(this._textScroll.getHorizontalScrollBar().getMinimum());
        this._textScroll.getVerticalScrollBar().setValue(this._textScroll.getVerticalScrollBar().getMinimum());
        this._dialog.setVisible(true);
    }
}

