/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import edu.rice.cs.util.swing.CheckBoxJList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScrollableListDialog<T>
extends JDialog {
    private static final int DEFAULT_WIDTH = 400;
    private static final int DEFAULT_HEIGHT = 450;
    private static final double WIDTH_RATIO = 0.75;
    private static final double HEIGHT_RATIO = 0.5;
    protected final JList list;
    protected int _buttonPressed = -1;
    protected List<T> listItems;

    private ScrollableListDialog(Frame owner, String dialogTitle, String leaderText, List<T> listItems, List<T> selItems, int messageType, int width, int height, Icon icon, boolean fitToScreen, List<JButton> buttons, boolean selectable) {
        super(owner, dialogTitle, true);
        this.listItems = listItems;
        if (!this._isknownMessageType(messageType)) {
            throw new IllegalArgumentException("The message type \"" + messageType + "\" is unknown");
        }
        if (listItems == null) {
            throw new IllegalArgumentException("listItems cannot be null");
        }
        JLabel dialogIconLabel = null;
        if (icon != null) {
            dialogIconLabel = new JLabel(icon);
        } else {
            Icon messageIcon = this._getIcon(messageType);
            if (messageIcon != null) {
                dialogIconLabel = new JLabel(messageIcon);
            }
        }
        JLabel leaderLabel = new JLabel(leaderText);
        JPanel leaderPanel = new JPanel();
        leaderPanel.setLayout(new FlowLayout(0));
        if (dialogIconLabel != null) {
            leaderPanel.add(dialogIconLabel);
        }
        leaderPanel.add(leaderLabel);
        Vector<String> dataAsStrings = new Vector<String>(listItems.size());
        String longestString = "";
        for (T obj : listItems) {
            if (obj == null) continue;
            String objAsString = obj.toString();
            if (objAsString.length() > longestString.length()) {
                longestString = objAsString;
            }
            dataAsStrings.add(objAsString);
        }
        if (selectable) {
            Vector<String> selAsStrings = new Vector<String>(selItems.size());
            for (T obj : selItems) {
                if (obj == null) continue;
                String objAsString = obj.toString();
                selAsStrings.add(objAsString);
            }
            this.list = new CheckBoxJList(dataAsStrings, selAsStrings);
            this.list.setSelectionMode(2);
        } else {
            this.list = new JList(dataAsStrings);
            this.list.setSelectionMode(0);
        }
        this.list.setPrototypeCellValue(longestString);
        JScrollPane scrollPane = new JScrollPane(this.list);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1));
        this._addButtons(buttonPanel, buttons);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout(10, 5));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        contentPanel.add((Component)leaderPanel, "North");
        contentPanel.add((Component)scrollPane, "Center");
        contentPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add(contentPanel);
        Dimension dialogSize = new Dimension();
        if (fitToScreen) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int screenBasedWidth = (int)(0.75 * screenSize.getWidth());
            int screenBasedHeight = (int)(0.5 * screenSize.getHeight());
            dialogSize.setSize(Math.max(400, screenBasedWidth), Math.max(450, screenBasedHeight));
        } else {
            dialogSize.setSize(width, height);
        }
        this.setSize(dialogSize);
    }

    private boolean _isknownMessageType(int messageType) {
        return messageType == 0 || messageType == 1 || messageType == 2 || messageType == 3 || messageType == -1;
    }

    private Icon _getIcon(int messageType) {
        assert (this._isknownMessageType(messageType));
        if (messageType == 0) {
            return UIManager.getIcon("OptionPane.errorIcon");
        }
        if (messageType == 1) {
            return UIManager.getIcon("OptionPane.informationIcon");
        }
        if (messageType == 2) {
            return UIManager.getIcon("OptionPane.warningIcon");
        }
        if (messageType == 3) {
            return UIManager.getIcon("OptionPane.questionIcon");
        }
        if (messageType == -1) {
            return null;
        }
        assert (false);
        return null;
    }

    protected void _addButtons(JPanel buttonPanel, List<JButton> buttons) {
        int i = 0;
        for (JButton b : buttons) {
            final int j = i++;
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent notUsed) {
                    ScrollableListDialog.this._buttonPressed = j;
                    ScrollableListDialog.this.closeDialog();
                }
            });
            buttonPanel.add(b);
        }
        this.getRootPane().setDefaultButton(buttons.get(0));
    }

    public void showDialog() {
        this.pack();
        this.setVisible(true);
    }

    protected void closeDialog() {
        this.setVisible(false);
    }

    public int getButtonPressed() {
        return this._buttonPressed;
    }

    public List<T> getSelectedItems() {
        ArrayList<T> l = new ArrayList<T>();
        for (int i : this.list.getSelectedIndices()) {
            l.add(this.listItems.get(i));
        }
        return l;
    }

    public static void main(String[] args) {
        final ArrayList<String> data = new ArrayList<String>();
        data.add("how");
        data.add("now");
        data.add("brown");
        data.add("cow");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ScrollableListDialog ld = new Builder().setOwner(null).setTitle("TITLE").setText("LEADER").setItems(data).setMessageType(0).build();
                ld.pack();
                ld.setVisible(true);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<T> {
        protected Frame _owner;
        protected String _dialogTitle;
        protected String _leaderText;
        protected List<T> _listItems = new ArrayList<T>();
        protected List<T> _selectedItems = new ArrayList<T>();
        protected int _messageType = -1;
        protected int _width = 400;
        protected int _height = 450;
        protected Icon _icon = null;
        protected boolean _fitToScreen = true;
        protected List<JButton> _buttons = new ArrayList<JButton>();
        protected boolean _selectable = false;

        public Builder() {
            this.addOkButton();
        }

        public Builder<T> setOwner(Frame owner) {
            this._owner = owner;
            return this;
        }

        public Builder<T> setTitle(String dialogTitle) {
            this._dialogTitle = dialogTitle;
            return this;
        }

        public Builder<T> setText(String leaderText) {
            this._leaderText = leaderText;
            return this;
        }

        public Builder<T> setItems(List<T> listItems) {
            this._listItems = listItems;
            return this;
        }

        public Builder<T> setSelectedItems(List<T> selItems) {
            this._selectedItems = selItems;
            return this;
        }

        public Builder<T> setMessageType(int messageType) {
            this._messageType = messageType;
            return this;
        }

        public Builder<T> setWidth(int width) {
            this._width = width;
            return this;
        }

        public Builder<T> setHeight(int height) {
            this._height = height;
            return this;
        }

        public Builder<T> setIcon(Icon icon) {
            this._icon = icon;
            return this;
        }

        public Builder<T> setFitToScreen(boolean fts) {
            this._fitToScreen = fts;
            return this;
        }

        public Builder<T> clearButtons() {
            this._buttons.clear();
            return this;
        }

        public Builder<T> addOkButton() {
            this._buttons.add(new JButton("OK"));
            return this;
        }

        public Builder<T> addButton(JButton b) {
            this._buttons.add(b);
            return this;
        }

        public Builder<T> setSelectable(boolean b) {
            this._selectable = b;
            return this;
        }

        public ScrollableListDialog<T> build() {
            return new ScrollableListDialog(this._owner, this._dialogTitle, this._leaderText, this._listItems, this._selectedItems, this._messageType, this._width, this._height, this._icon, this._fitToScreen, this._buttons, this._selectable);
        }
    }
}

