/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.math.BigInteger;
import koala.dynamicjava.tree.Literal;

public class IntegerLiteral
extends Literal {
    public IntegerLiteral(String rep) {
        this(rep, null, 0, 0, 0, 0);
    }

    public IntegerLiteral(String rep, String fn, int bl, int bc, int el, int ec) {
        super(rep, IntegerLiteral.parse(rep), Integer.TYPE, fn, bl, bc, el, ec);
    }

    private static Integer parse(String s) {
        int radix = 10;
        int start = 0;
        boolean negate = false;
        if (s.startsWith("0x")) {
            radix = 16;
            start += 2;
        } else if (s.startsWith("0") && s.length() > 1) {
            radix = 8;
            ++start;
        } else if (s.startsWith("-")) {
            ++start;
            negate = true;
        }
        BigInteger val = new BigInteger(s.substring(start), radix);
        if (negate) {
            val = val.negate();
        }
        int result = val.intValue();
        if (val.bitLength() > 32 || radix == 10 && !val.equals(BigInteger.valueOf(result))) {
            throw new NumberFormatException("Literal is out of range");
        }
        return result;
    }
}

