/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.math.BigInteger;
import koala.dynamicjava.tree.Literal;

public class LongLiteral
extends Literal {
    public LongLiteral(String rep) {
        this(rep, null, 0, 0, 0, 0);
    }

    public LongLiteral(String rep, String fn, int bl, int bc, int el, int ec) {
        super(rep, LongLiteral.parse(rep.substring(0, rep.length())), Long.TYPE, fn, bl, bc, el, ec);
    }

    private static Long parse(String s) {
        int radix = 10;
        int start = 0;
        boolean negate = false;
        int end = s.length();
        if (s.endsWith("l") || s.endsWith("L")) {
            --end;
        }
        if (s.startsWith("0x")) {
            radix = 16;
            start += 2;
        } else if (s.startsWith("0") && s.length() > 1) {
            radix = 8;
            ++start;
        } else if (s.startsWith("-")) {
            ++start;
            negate = true;
        }
        BigInteger val = new BigInteger(s.substring(start, end), radix);
        if (negate) {
            val = val.negate();
        }
        long result = val.longValue();
        if (val.bitLength() > 64 || radix == 10 && !val.equals(BigInteger.valueOf(result))) {
            throw new NumberFormatException("Literal is out of range");
        }
        return result;
    }
}

