/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayTypeName;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.TypeName;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableDeclaration
extends Node {
    public static final String FINAL = "final";
    public static final String TYPE = "type";
    public static final String NAME = "name";
    public static final String INITIALIZER = "initializer";
    private boolean finalVariable;
    private TypeName type;
    private String name;
    private Expression initializer;

    public VariableDeclaration(boolean fin, TypeName type, String name, Expression init) {
        this(fin, type, name, init, null, 0, 0, 0, 0);
    }

    public VariableDeclaration(boolean fin, TypeName type, String name, Expression init, String fn, int bl, int bc, int el, int ec) {
        super(fn, bl, bc, el, ec);
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        this.finalVariable = fin;
        this.type = type;
        this.name = name;
        this.initializer = init;
        if (type instanceof ArrayTypeName && this.initializer instanceof ArrayInitializer) {
            ((ArrayInitializer)this.initializer).setElementType(((ArrayTypeName)type).getElementType());
        }
    }

    public boolean isFinal() {
        return this.finalVariable;
    }

    public void setFinal(boolean b) {
        this.finalVariable = b;
        this.firePropertyChange(FINAL, this.finalVariable, this.finalVariable);
    }

    public TypeName getType() {
        return this.type;
    }

    public void setType(TypeName t) {
        if (t == null) {
            throw new IllegalArgumentException("t == null");
        }
        this.type = t;
        this.firePropertyChange(TYPE, this.type, this.type);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s == null");
        }
        this.name = s;
        this.firePropertyChange(NAME, this.name, this.name);
    }

    public Expression getInitializer() {
        return this.initializer;
    }

    public void setInitializer(Expression e) {
        this.initializer = e;
        this.firePropertyChange(INITIALIZER, this.initializer, this.initializer);
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "(" + this.getClass().getName() + ": " + this.isFinal() + " " + this.getType() + " " + this.getName() + " " + this.getInitializer() + ")";
    }
}

